<?php
/*

Plugin Name: Church Admin
Plugin URI: http://www.churchadminplugin.com/
Description: Manage church life with address book, schedule, classes, small groups, and advanced communication tools - bulk email and sms. 
Version: 3.7.28
Tags: sermons, sermons, prayer, membership, SMS, schedule, rota, Bible, events, calendar, email, small groups, contact form, giving, administration, management
Author: Andy Moyle
Text Domain: church-admin


Author URI: http://www.themoyles.co.uk
License:
----------------------------------------


Copyright (C) 2010-2022 Andy Moyle



    This program is free software: you can redistribute it and/or modify

    it under the terms of the GNU General Public License as published by

    the Free Software Foundation, either version 3 of the License, or

    (at your option) any later version.



    This program is distributed in the hope that it will be useful,

    but WITHOUT ANY WARRANTY; without even the implied warranty of

    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

    GNU General Public License for more details.



	http://www.gnu.org/licenses/

----------------------------------------
  ___ _   _             _ _         _                 _         _
 |_ _| |_( )___    __ _| | |   __ _| |__   ___  _   _| |_      | | ___  ___ _   _ ___
  | || __|// __|  / _` | | |  / _` | '_ \ / _ \| | | | __|  _  | |/ _ \/ __| | | / __|
  | || |_  \__ \ | (_| | | | | (_| | |_) | (_) | |_| | |_  | |_| |  __/\__ \ |_| \__ \
 |___|\__| |___/  \__,_|_|_|  \__,_|_.__/ \___/ \__,_|\__|  \___/ \___||___/\__,_|___/


*/
if ( ! defined( 'ABSPATH' ) ) exit('You need Jesus!'); // Exit if accessed directly
require_once( plugin_dir_path( __FILE__ ) .'includes/functions.php');
    //sandbox
    //define('CA_PAYPAL',"https://www.sandbox.paypal.com/cgi-bin/webscr");
    //live
    define('CA_PAYPAL',"https://www.paypal.com/cgi-bin/webscr");
    require_once( plugin_dir_path( __FILE__ ).'includes/enqueue.php');
    
	$church_admin_version = "3.7.28";
    $church_admin_url='admin.php?page=church_admin/index.php';
	$people_type=get_option('church_admin_people_type');
    
	$level=get_option('church_admin_levels');
    $church_admin_spiritual_gifts=array(
        1=>__('Mercy','church-admin'),
        2=>__('Prophecy','church-admin'),
        3=>__('Administration','church-admin'),
        4=>__('Encouragement','church-admin'),
        5=>__('Counselling','church-admin'),
        6=>__('Evangelism','church-admin'),
        7 =>__('Giving','church-admin') ,
        8=> __('Helps','church-admin') ,
        9=>__('Intercession','church-admin') ,
        10=>__('Hospitality','church-admin'),
        11=>__('Pastoring','church-admin') ,
        12=>__('Teaching','church-admin'),
        13 =>__('Healing','church-admin'),
        14 =>__('Leadership','church-admin'),

);
    define('CA_ICON','data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhRE9DVFlQRSBzdmcgUFVCTElDICItLy9XM0MvL0RURCBTVkcgMS4xLy9FTiIgImh0dHA6Ly93d3cudzMub3JnL0dyYXBoaWNzL1NWRy8xLjEvRFREL3N2ZzExLmR0ZCI+Cjxzdmcgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgdmlld0JveD0iMCAwIDM2IDM2IiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiIHhtbDpzcGFjZT0icHJlc2VydmUiIHhtbG5zOnNlcmlmPSJodHRwOi8vd3d3LnNlcmlmLmNvbS8iIHN0eWxlPSJmaWxsLXJ1bGU6ZXZlbm9kZDtjbGlwLXJ1bGU6ZXZlbm9kZDtzdHJva2UtbGluZWpvaW46cm91bmQ7c3Ryb2tlLW1pdGVybGltaXQ6MjsiPgogICAgPGcgdHJhbnNmb3JtPSJtYXRyaXgoMC4wNzEwMTc4LDAsMCwwLjA2NjYyMzcsLTAuMjI4NzM4LDAuOTkyMTg4KSI+CiAgICAgICAgPHBhdGggZD0iTTI1NiwwTDIzOC4zLDIyTDE0Ny43LDEzNS4zTDE0Mi43LDE0MS43TDE0Mi43LDI4NEwxNy4zLDM2Mi42TDQxLjQsNDAwLjhMNTIsMzk0LjRMNTIsNTEyTDIzMy4zLDUxMkwyMzMuMyw0MjEuNEMyMzMuMyw0MDguNiAyNDMuMSwzOTguNyAyNTYsMzk4LjdDMjY4LjgsMzk4LjcgMjc4LjcsNDA4LjUgMjc4LjcsNDIxLjRMMjc4LjcsNTEyTDQ2MCw1MTJMNDYwLDM5NC40TDQ3MC42LDQwMC44TDQ5NC43LDM2Mi42TDM2OS4zLDI4NEwzNjkuMywxNDEuNkwzNjQuMywxMzUuMkwyNzMuNywyMkwyNTYsMFpNMjU2LDcyLjJMMzI0LDE1Ny4yTDMyNCwyNTUuNkwyNjgsMjIwLjlMMjU2LDIxMy4xTDI0NCwyMjAuOUwxODgsMjU1LjZMMTg4LDE1Ny4yTDI1Niw3Mi4yWk0yNTYsMTQ5LjRDMjQzLjUsMTQ5LjQgMjMzLjMsMTU5LjYgMjMzLjMsMTcyLjFDMjMzLjMsMTg0LjYgMjQzLjUsMTk0LjggMjU2LDE5NC44QzI2OC41LDE5NC44IDI3OC43LDE4NC42IDI3OC43LDE3Mi4xQzI3OC43LDE1OS42IDI2OC41LDE0OS40IDI1NiwxNDkuNFpNMjU2LDI2N0w0MTQuNiwzNjYuMUw0MTQuNiw0NjYuN0wzMjQsNDY2LjdMMzI0LDQyMS40QzMyNCwzODQuMSAyOTMuMywzNTMuNCAyNTYsMzUzLjRDMjE4LjcsMzUzLjQgMTg4LDM4NC4xIDE4OCw0MjEuNEwxODgsNDY2LjdMOTcuNCw0NjYuN0w5Ny40LDM2Ni4xTDI1NiwyNjdaIiBzdHlsZT0iZmlsbDpyZ2IoMTU2LDE2MiwxNjcpO2ZpbGwtcnVsZTpub256ZXJvO3N0cm9rZTpyZ2IoMTU2LDE2MiwxNjcpO3N0cm9rZS13aWR0aDoxNC41MnB4OyIvPgogICAgPC9nPgo8L3N2Zz4K');
/***************************
*
*   Export ical
*
****************************/
add_action('wp_loaded','church_admin_ical_download');
function church_admin_ical_download()
{
   
    if(!empty( $_GET['action'] )&&$_GET['action']=='export-ics')
    {
        if(!church_admin_level_check('Calendar') )exit('No download permission');
        require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
        church_admin_export_ical();
        exit();
    }
    if(!empty( $_GET['action'] )&&$_GET['action']=='user-email-settings')
    {
        require_once( plugin_dir_path( __FILE__ ).'includes/user-profile.php');
        church_admin_profile();
        exit();
    }
}



/***************************
*
*   Debug Mode
*
****************************/
if(!empty( $_GET['action'] )&&$_GET['action']=='toggle-debug-mode')
{
    $debug=get_option('church_admin_debug_mode');
    if ( empty( $debug ) )
    {
        update_option('church_admin_debug_mode',TRUE);

        setcookie('ca_debug_mode', 'DEBUG MODE ON', time()+31556926);
        if(!defined('CA_DEBUG')){define('CA_DEBUG',TRUE);}
    }
    else
    {
            
        unset( $_COOKIE['ca_debug_mode'] );
        setcookie('ca_debug_mode', "", time() - 3600);
        delete_option('church_admin_debug_mode',FALSE);
    }
}	
add_action('wp_loaded','ca_debug_mode');
function ca_debug_mode()
{
    global $church_admin_url;
    /**************************
     * Turn off APP
     **************************/
    if(!empty( $_GET['app_turn_off'] ) )
    {
        $app_id=get_option('church_admin_app_id');
        

        if(md5( $app_id)==$_GET['app_turn_off'] )
        {
            delete_option('church_admin_app_new_licence');
            delete_option('church_admin_app_id');
            delete_option('church_admin_app_church_id');
        }
    }
    if(!empty( $_COOKIE['ca_debug_mode'] ) )
    {
        if(!(defined('CA_DEBUG') ))define('CA_DEBUG',TRUE);
    }
    /*
    $debug_mode=get_option('church_admin_debug_mode');
    if(!empty( $debug_mode) )
    {
        if(!(defined('CA_DEBUG') ))define('CA_DEBUG',TRUE);
    }
    */
}




/******************************************
*
* Blur Cookies set/unset
*
*******************************************/
add_action('admin_init','church_admin_admin_init');
function church_admin_admin_init()  {
    global $church_admin_url,$church_admin_menu;
    /*****************************************************************************
    *
    * New save functionality on init so redirect to list page can happen
    *
    ******************************************************************************/
    if(!empty( $_POST['church-admin-save'] ) )
    {
        require_once( plugin_dir_path( __FILE__ ).'includes/church_admin_save.php');
        church_admin_save();
        //church_admin_debug('ServiceSaved');
        exit();
    }
	if(!empty( $_GET['page'] )&&( $_GET['page']=='church_admin/index.php')&&!empty( $_GET['action'] )&& $_GET['action']=='blur')
	{
		if(!is_user_logged_in() )return;
		setcookie('churchAdminBlur', 'Blurred', time()+24*60*60,'/' );
		
		 
		 //wp_redirect(admin_url('admin.php?page=church_admin/index.php&action=settings&section=settings') );
		//exit();
	}
	if(!empty( $_GET['page'] )&&( $_GET['page']=='church_admin/index.php')&&!empty( $_GET['action'] )&& $_GET['action']=='unblur')
	{
        if(!is_user_logged_in() )return;
		unset( $_COOKIE['churchAdminBlur'] );
    	setcookie( 'churchAdminBlur', FALSE, time() - ( 15 * 60 ),'/' );
		//wp_redirect(admin_url('admin.php?page=church_admin/index.php&action=settings&section=settings') );
		
	}
    $church_admin_menu=array(
        'people'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('People','church-admin'),
                    'link'=>$church_admin_url.'&amp;action=people&section=people',
                    "dashicon"=>'dashicons-id',
                    "font-awesome"=>'<span class="dashicons dashicons-admin-users ca-dashicons"></span>',
                    "background"=>"ca-red",
                    "callback"=>'church_admin_people_callback'
                ),
        'check-directory-issues'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Check for Directory issues','church-admin'),
                    'link'=>$church_admin_url.'&action=check-directory-issues&amp;section=people'
                ),
        'import-from-users'=>array(
            'module'=>'People',
            'parent'=>'people',
            'level'=>'Directory',
            'section'=>'people',
            'title'=>__('Import users into directory','church-admin'),
            'link'=>$church_admin_url.'&action=import-from-users&amp;section=people'
        ),
        'people-map'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('People Map','church-admin'),
                    'link'=>$church_admin_url.'&action=people-map&amp;section=people'
                ),
        'view-address-list'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('View address list','church-admin'),
                    'link'=>$church_admin_url.'&action=view-address-list&amp;section=people'
                ),
        'add-household'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Add household','church-admin'),
                    'link'=>$church_admin_url.'&action=add-household&amp;section=people'
                ),
        'import-csv'=>array(
                     'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Import CSV','church-admin'),
                    'link'=>$church_admin_url.'&action=import-csv&amp;section=people'
                ),
        'directory-pdf'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Directory PDF','church-admin'),
                    'link'=>$church_admin_url.'&action=export-pdf&amp;section=people'
                ),
        'member-types'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Member types','church-admin'),
                    'link'=>$church_admin_url.'&action=member-types&amp;section=people'
                ),
        'add-member-type'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Add member type','church-admin'),
                    'link'=>$church_admin_url.'&action=add-member-type&amp;section=people'
                ),
        'custom-fields'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Custom fields','church-admin'),
                    'link'=>$church_admin_url.'&action=custom-fields&amp;section=people'
                ),
        'create-users'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Create users ','church-admin').' &raquo;',
                    'link'=>$church_admin_url.'&action=create-users&amp;section=people'
                ),
        'bulk-geocode'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Bulk geocode ','church-admin'),
                    'link'=>$church_admin_url.'&action=bulk-geocode&amp;section=people'
                ),
        'download-csv'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Download CSV/labels ','church-admin').' &raquo;',
                    'link'=>$church_admin_url.'&action=download-csv&amp;section=people'
                ),
        'recent-activity'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Recent people activity ','church-admin'),
                    'link'=>$church_admin_url.'&action=recent-people&amp;section=people'
                ),
        'check-duplicates'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Check duplicates','church-admin'),
                    'link'=>$church_admin_url.'&action=check-duplicates&amp;section=people'
                ),
        'birthdays'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Birthdays','church-admin'),
                    'link'=>$church_admin_url.'&action=birthdays&amp;section=people'
                ),
        'photo-permissions'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Photo Permissions','church-admin'),
                    'link'=>$church_admin_url.'&action=photo-permissions&amp;section=people'
                ),
        'everyone-visible'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'title'=>__('Everyone visible','church-admin'),
                    'link'=>$church_admin_url.'&action=everyone-visible&amp;section=people'
                ),
        'delete-all'=>array(
                    'module'=>'People',
                    'parent'=>'people',
                    'level'=>'Directory',
                    'section'=>'people',
                    'confirm'=>TRUE,
                    'title'=>__('Delete all','church-admin'),
                    'link'=>$church_admin_url.'&action=delete-all&amp;section=people'
                ),
        'contact-form'=>array(
                    'module'=>'Contact',
                    'parent'=>'contact-form',
                    'level'=>'Directory',
                    'section'=>'contact-form',
                    'title'=>__('Contact form','church-admin'),
                    'link'=>$church_admin_url.'&action=contact-form&amp;section=contact-form',
                    "dashicon"=>'dashicons-money-alt',
                    "font-awesome"=>'<span class="dashicons dashicons-email ca-dashicons"></span>',
                    "background"=>"ca-blue",
                    "callback"=>'church_admin_contact_callback'
                ),  
        'contact-form-settings'=>array(
                    'module'=>'Contact',
                    'parent'=>'contact-form',
                    'level'=>'Directory',
                    'section'=>'contact-form',
                    'title'=>__('Contact form settings','church-admin'),
                    'link'=>$church_admin_url.'&action=contact-form-settings&amp;section=contact-form' 
                ), 
        'giving'=>array(
                    'module'=>'Giving',
                    'parent'=>'giving',
                    'level'=>'Giving',
                    'section'=>'giving',
                    'title'=>__('Giving','church-admin'),
                    'link'=>$church_admin_url.'&action=giving&amp;section=giving',
                    "dashicon"=>'dashicons-email',
                    "font-awesome"=>'<span class="dashicons dashicons-money-alt ca-dashicons"></span>',
                    "background"=>"ca-darkorange",
                    "callback"=>'church_admin_giving_callback'
                ),
        'edit-gift'=>array(
                    'module'=>'Giving',
                    'parent'=>'giving',
                    'level'=>'Giving',
                    'section'=>'giving',
                    'title'=>__('Add gift','church-admin'),
                    'link'=>$church_admin_url.'&action=edit-gift&amp;section=giving'
                ),
        'funds'=>array(
                    'module'=>'Giving',
                    'parent'=>'giving',
                    'level'=>'Giving',
                    'section'=>'giving',
                    'title'=>__('Funds','church-admin'),
                    'link'=>wp_nonce_url( $church_admin_url.'&action=funds&amp;section=giving','funds')
                ),
        'edit-fund'=>array(
                    'module'=>'Giving',
                    'parent'=>'giving',
                    'level'=>'Giving',
                    'section'=>'giving',
                    'title'=>__('Add fund','church-admin'),
                    'link'=>$church_admin_url.'&action=edit-fund&amp;section=giving'
                ),
        'giving-csv'=>array(
                    'module'=>'Giving',
                    'parent'=>'giving',
                    'level'=>'Giving',
                    'section'=>'giving',
                    'title'=>__('Giving CSV','church-admin'),
                    'link'=>$church_admin_url.'&action=giving-csv&amp;section=giving'
                ),
        'gift-aid-csv'=>array(
                    'module'=>'Giving',
                    'parent'=>'giving',
                    'level'=>'Giving',
                    'section'=>'giving',
                    'title'=>__('Gift Aid report CSV','church-admin'),
                    'link'=>$church_admin_url.'&action=gift-aid-csv&amp;section=giving'
                ),
        'giving-paypal-setup'=>array(
                    'module'=>'Giving',
                    'parent'=>'giving',
                    'level'=>'Giving',
                    'section'=>'giving',
                    'title'=>__('Paypal Setup','church-admin'),
                    'link'=>$church_admin_url.'&action=paypal-setup&amp;section=settings'
                ),        
                /*
        'giving-receipts'=>array(
            'module'=>'Giving',
            'parent'=>'giving',
            'level'=>'Giving',
            'section'=>'giving',
            'title'=>__('Giving Receipts','church-admin'),
            'link'=>$church_admin_url.'&action=giving-receipts&amp;section=giving'
        ),*/
       
        'childrens-work'=>array(
                    'module'=>'Children',
                    'parent'=>'childrens-work',
                    'level'=>'Kidswork',
                    'section'=>'childrens-work',
                    'title'=>__('Childrens work','church-admin'),
                    'link'=>$church_admin_url.'&action=childrens-work&amp;section=childrens-work',
                    "dashicon"=>'dashicons-admin-users',
                    "font-awesome"=>'<span class="dashicons dashicons-universal-access ca-dashicons"></span>',
                    "background"=>"ca-blue",
                    "callback"=>'church_admin_children_callback'
                ),
        'kidswork-pdf'=>array(
                    'module'=>'Children',
                    'parent'=>'childrens-work',
                    'level'=>'Kidswork',
                    'section'=>'childrens-work',
                    'title'=>__('Childrens groups PDF','church-admin'),
                    'link'=>$church_admin_url.'&action=childrens-work-pdf&amp;section=childrens-work'
                ),
        'kidswork-checkin-pdf'=>array(
                    'module'=>'Children',
                    'parent'=>'childrens-work',
                    'level'=>'Kidswork',
                    'section'=>'childrens-work',
                    'title'=>__('Childrens checkin PDF','church-admin'),
                    'link'=>$church_admin_url.'&action=childrens-work-checkin-pdf&amp;section=childrens-work'
                ), 
        'safeguarding'=>array(
                    'module'=>'Children',
                    'parent'=>'childrens-work',
                    'level'=>'Kidswork',
                    'section'=>'childrens-work',
                    'title'=>__('Safeguarding','church-admin'),
                    'link'=>$church_admin_url.'&action=safeguarding&amp;section=childrens-work'
                ),
        'classes'=>array(
                    'module'=>'Classes',
                    'parent'=>'classes',
                    'level'=>'Kidswork',
                    'section'=>'classes',
                    'title'=>__('Classes','church-admin'),
                    'link'=>$church_admin_url.'&action=classes&amp;section=classes',
                    "dashicon"=>'dashicons-awards',
                    "font-awesome"=>'<span class="dashicons dashicons-groups ca-dashicons"></span>',
                    "background"=>"ca-lightgreen",
                    "callback"=>'church_admin_classes_callback'
                ),
        'add-class'=>array(
                    'module'=>'Classes',
                    'parent'=>'classes',
                    'level'=>'Kidswork',
                    'section'=>'classes',
                    'title'=>__('Add a class','church-admin'),
                    'link'=>$church_admin_url.'&action=edit-class&amp;section=classes'
                ),
        'events'=>array(
                    'module'=>'Events',
                    'parent'=>'events',
                    'level'=>'Events',
                    'section'=>'events',
                    'title'=>__('Events','church-admin'),
                    'link'=>$church_admin_url.'&action=events&amp;section=events',
                    "dashicon"=>'dashicons-tickets-alt',
                    "font-awesome"=>'<span class="dashicons dashicons-tickets-alt ca-dashicons"></span>',
                    "background"=>"ca-red",
                    "callback"=>'church_admin_events_callback'
                ),
        'add-event'=>array(
                    'module'=>'Events',
                    'parent'=>'events',
                    'level'=>'Events',
                    'section'=>'events',
                    'title'=>__('Add an event','church-admin'),
                    'link'=>$church_admin_url.'&action=add-event&amp;section=events'
                ),
        'attendance'=>array(
                    'module'=>'Attendance',
                    'parent'=>'attendance',
                    'level'=>'Attendance',
                    'section'=>'attendance',
                    'title'=>__('Attendance','church-admin'),
                    'link'=>$church_admin_url.'&action=attendance&amp;section=attendance',
                    "dashicon"=>'dashicons-editor-ol',
                    "font-awesome"=>'<span class="dashicons dashicons-chart-line ca-dashicons"></span>',
                    "background"=>"ca-darkpink",
                    "callback"=>'church_admin_attendance_callback'
                ),
        'weeks-attendance'=>array(
            'module'=>'Attendance',
            'parent'=>'attendance',
            'level'=>'Attendance',
            'section'=>'attendance',
            'title'=>__("This week's attendance",'church-admin'),
            'link'=>$church_admin_url.'&action=weeks-attendance&amp;section=attendance'
        ),
        'add-attendance'=>array(
                    'module'=>'Attendance',
                    'parent'=>'attendance',
                    'level'=>'Attendance',
                    'section'=>'attendance',
                    'title'=>__('Add attendance','church-admin'),
                    'link'=>$church_admin_url.'&action=add-attendance&amp;section=attendance'
                ),
        'individual-attendance-list'=>array(
            'module'=>'Attendance',
            'parent'=>'attendance',
            'level'=>'Attendance',
            'section'=>'attendance',
            'title'=>__('Show individual attendance dates','church-admin'),
            'link'=>$church_admin_url.'&action=individual-attendance-list&amp;section=attendance'
        ),
        'individual-attendance'=>array(
                    'module'=>'Attendance',
                    'parent'=>'attendance',
                    'level'=>'Attendance',
                    'section'=>'attendance',
                    'title'=>__('Add individual attendance','church-admin'),
                    'link'=>$church_admin_url.'&action=individual-attendance&amp;section=attendance'
                ),
        'individual-attendance-csv'=>array(
                    'module'=>'Attendance',
                    'parent'=>'attendance',
                    'level'=>'Attendance',
                    'section'=>'attendance',
                    'title'=>__('Individual attendance CSV','church-admin'),
                    'link'=>$church_admin_url.'&action=individual-attendance-csv&amp;section=attendance'
                ),  
        'follow-up'=>array(
                    'module'=>'Attendance',
                    'parent'=>'follow-up',
                    'level'=>'Attendance',
                    'section'=>'follow-up',
                    'title'=>__('Follow up','church-admin'),
                    'link'=>$church_admin_url.'&action=funnel&amp;section=follow-up',
                    "dashicon"=>'dashicons-editor-ol',
                    "font-awesome"=>'<span class="dashicons dashicons-update ca-dashicons"></span>',
                    "background"=>"ca-gold",
                    "callback"=>'church_admin_followup_callback'
                ),
        'add-funnel'=>array(
                    'module'=>'Attendance',
                    'parent'=>'follow-up',
                    'level'=>'Attendance',
                    'section'=>'follow-up',
                    'title'=>__('Add funnel','church-admin'),
                    'link'=>$church_admin_url.'&action=add-funnel&amp;section=follow-up'
                ),
        'units'=>array(
                    'module'=>'Units',
                    'parent'=>'units',
                    'level'=>'Units',
                    'section'=>'units',
                    'title'=>__('Units','church-admin'),
                    'link'=>$church_admin_url.'&action=units&amp;section=units',
                    "dashicon"=>'dashicons-networking',
                    "font-awesome"=>'<span class="dashicons dashicons-networking ca-dashicons"></span>',
                    "background"=>"ca-gray",
                    "callback"=>'church_admin_units_callback'
                ),
        'add-unit'=>array(
                    'module'=>'Units',
                    'parent'=>'units',
                    'level'=>'Units',
                    'section'=>'units',
                    'title'=>__('Add unit','church-admin'),
                    'link'=>$church_admin_url.'&action=add-unit&amp;section=units',
                    "dashicon"=>'dashicons-networking'
                ),
        'groups'=>array(
                    'module'=>'Groups',
                    'parent'=>'groups',
                    'level'=>'Small Groups',
                    'section'=>'groups',
                    'title'=>__('Small groups','church-admin'),
                    'link'=>$church_admin_url.'&action=groups&amp;section=groups',
                    "dashicon"=>'dashicons-networking',
                    "font-awesome"=>'<span class="dashicons dashicons-groups ca-dashicons"></span>',
                    "background"=>"ca-indigo",
                    "callback"=>'church_admin_groups_callback'
                ),
        'spiritual-gifts'=>array(
                    'module'=>'Spiritual gifts',
                    'parent'=>'spiritual-gifts',
                    'level'=>'Spiritual gifts',
                    'section'=>'spiritual-gifts',
                    'title'=>__('Spiritual gifts','church-admin'),
                    'link'=>$church_admin_url.'&action=spiritual-gifts&amp;section=spiritual-gifts',
                    "font-awesome"=>'<span class="dashicons dashicons-buddicons-community ca-dashicons"></span>',
                    "background"=>"ca-yellow",
                    "callback"=>'church_admin_gifts_callback'
        ),
        'smallgroup-structure'=>array(
                    'module'=>'Groups',
                    'parent'=>'groups',
                    'level'=>'Small Groups',
                    'section'=>'groups',
                    'title'=>__('Small group structure','church-admin'),
                    'link'=>$church_admin_url.'&action=small-group-structure&amp;section=groups'
                ),
        'smallgroup-metrics'=>array(
                    'module'=>'Groups',
                    'parent'=>'groups',
                    'level'=>'Small Groups',
                    'section'=>'groups',
                    'title'=>__('Small group metrics','church-admin'),
                    'link'=>$church_admin_url.'&action=small-group-metrics&amp;section=groups'
                ),
        'smallgroup-show-pdf-form'=>array(
            'module'=>'Groups',
            'parent'=>'groups',
            'level'=>'Small Groups',
            'section'=>'groups',
            'title'=>__('Small group PDF form','church-admin'),
            'link'=>$church_admin_url.'&action=smallgroup-show-pdf-form&amp;section=groups'
        ),        
        'oversight-list'=>array(
                    'module'=>'Groups',
                    'parent'=>'groups',
                    'level'=>'Small Groups',
                    'section'=>'groups',
                    'title'=>__('Oversight list','church-admin'),
                    'link'=>$church_admin_url.'&action=oversight-list&amp;section=groups'
                ),
        'smallgroups-map'=>array(
                    'module'=>'Groups',
                    'parent'=>'groups',
                    'level'=>'Small Groups',
                    'section'=>'groups',
                    'title'=>__('Smallgroups map','church-admin'),
                    'link'=>$church_admin_url.'&action=smallgroups-map&amp;section=groups'
                ),
        'add-group'=>array(
                    'module'=>'Groups',
                    'parent'=>'groups',
                    'level'=>'Small Groups',
                    'section'=>'groups',
                    'title'=>__('Add a group','church-admin'),
                    'link'=>$church_admin_url.'&action=edit-group&amp;section=groups'
                ),
        'show-groups'=>array(
                    'module'=>'Groups',
                    'parent'=>'groups',
                    'level'=>'Small Groups',
                    'section'=>'groups',
                    'title'=>__('Show groups','church-admin'),
                    'link'=>$church_admin_url.'&action=show-groups&amp;section=groups'
                ),
        'cleanup-groups'=>array(
                    'module'=>'Groups',
                    'parent'=>'groups',
                    'level'=>'Small Groups',
                    'section'=>'groups',
                    'title'=>__('Cleanup groups','church-admin'),
                    'link'=>$church_admin_url.'&action=smallgroups-cleanup&amp;section=groups'
                ),
            'delete-groups'=>array(
                    'module'=>'Groups',
                    'parent'=>'groups',
                    'confirm'=>TRUE,
                    'level'=>'Small Groups',
                    'section'=>'groups',
                    'title'=>__('Delete all groups','church-admin'),
                    'link'=>$church_admin_url.'&action=delete-all-groups&amp;section=groups'
                ),
                'unattached'=>array(
                    'module'=>'Groups',
                    'parent'=>'groups',
                    'level'=>'Small Groups',
                    'section'=>'groups',
                    'title'=>__('Unattached to group list','church-admin'),
                    'link'=>$church_admin_url.'&action=unattached&amp;section=groups'
                ),
            'services'=>array(
                    'module'=>'Services',
                    'parent'=>'services',
                    'level'=>'Service',
                    'section'=>'services',
                    'title'=>__('Sites & Services','church-admin'),
                    'link'=>$church_admin_url.'&action=services-list&amp;section=services',
                    "dashicon"=>'dashicons-groups',
                    "font-awesome"=>'<span class="dashicons dashicons-location-alt ca-dashicons"></span>',
                    "background"=>"ca-brown",
                    "callback"=>'church_admin_services_callback'
                ),
            'add-service'=>array(
                    'module'=>'Services',
                    'parent'=>'services',
                    'level'=>'Service',
                    'section'=>'services',
                    'title'=>__('Add service','church-admin'),
                    'link'=>$church_admin_url.'&action=edit-service&amp;section=services'
                ),
            'service-prebooking'=>array(
                    'module'=>'Services',
                    'parent'=>'services',
                    'level'=>'Service',
                    'section'=>'services',
                    'title'=>__('Service pre-bookings','church-admin'),
                    'link'=>$church_admin_url.'&action=service-prebooking&amp;section=services'
                ),
            'sites'=>array(
                    'module'=>'Services',
                    'parent'=>'services',
                    'level'=>'Service',
                    'section'=>'services',
                    'title'=>__('Sites','church-admin'),
                    'link'=>$church_admin_url.'&action=site-list&amp;section=services'
                ),
            'edit-site'=>array(
                    'module'=>'Services',
                    'parent'=>'services',
                    'level'=>'Service',
                    'section'=>'services',
                    'title'=>__('Add site','church-admin'),
                    'link'=>$church_admin_url.'&action=site-list&amp;section=edit-site'
                ),
            
        'comms'=>array(
                    'module'=>'Comms',
                    'parent'=>'comms',
                    'level'=>'Bulk Email',
                    'section'=>'comms',
                    'title'=>__('Communications','church-admin'),
                    'link'=>$church_admin_url.'&action=comms&amp;section=comms',
                    "dashicon"=>'dashicons-megaphone',
                    "font-awesome"=>'<span class="dashicons dashicons-email ca-dashicons"></span>',
                    "background"=>"ca-lightgreen",
                    "callback"=>'church_admin_comms_callback'
                ),
        'push-message'=>array(
                    'module'=>'Comms',
                    'parent'=>'comms',
                    'level'=>'Bulk Email',
                    'section'=>'comms',
                    'title'=>__('Push message','church-admin'),
                    'link'=>$church_admin_url.'&action=push&amp;section=comms'
                ),
        
        'sms-settings'=>array(
                    'module'=>'Comms',
                    'parent'=>'comms',
                    'level'=>'Bulk Email',
                    'section'=>'comms',
                    'title'=>__('SMS settings','church-admin'),
                    'link'=>$church_admin_url.'&action=sms-settings&amp;section=comms'
                ),
        'send-sms'=>array(
                    'module'=>'Comms',
                    'parent'=>'comms',
                    'level'=>'Bulk Email',
                    'section'=>'comms',
                    'title'=>__('Send SMS','church-admin'),
                    'link'=>$church_admin_url.'&action=send-sms&amp;section=comms'
                ),
        'twilio-replies'=>array(
                    'module'=>'Comms',
                    'parent'=>'comms',
                    'level'=>'Bulk Email',
                    'section'=>'comms',
                    'title'=>__('SMS Replies','church-admin'),
                    'link'=>$church_admin_url.'&action=twilio-replies&amp;section=comms'
                ),
        'testemail'=>array(
                    'module'=>'Comms',
                    'parent'=>'comms',
                    'level'=>'Bulk Email',
                    'section'=>'comms',
                    'title'=>__('Send test email','church-admin'),
                    'link'=>$church_admin_url.'&action=test-email&amp;section=comms'
                ),
        'smtp-settings'=>array(
                    'module'=>'Comms',
                    'parent'=>'comms',
                    'level'=>'Bulk Email',
                    'section'=>'comms',
                    'title'=>__('SMTP settings','church-admin'),
                    'link'=>$church_admin_url.'&action=smtp-settings&amp;section=comms'
                ),
        'email-settings'=>array(
            'module'=>'Comms',
            'parent'=>'comms',
            'level'=>'Bulk Email',
            'section'=>'comms',
            'title'=>__('Email settings','church-admin'),
            'link'=>$church_admin_url.'&action=email-settings&amp;section=comms'
        ),
        'email-list'=>array(
                    'module'=>'Comms',
                    'parent'=>'comms',
                    'level'=>'Bulk Email',
                    'section'=>'comms',
                    'title'=>__('Sent Emails','church-admin'),
                    'link'=>$church_admin_url.'&action=email-list&amp;section=comms'
                ),
        'send-email'=>array(
                    'module'=>'Comms',
                    'parent'=>'comms',
                    'level'=>'Bulk Email',
                    'section'=>'comms',
                    'title'=>__('Send email','church-admin'),
                    'link'=>$church_admin_url.'&action=send-email&amp;section=comms'
                ),
        'email-settings'=>array(
                    'module'=>'Comms',
                    'parent'=>'comms',
                    'level'=>'Bulk Email',
                    'section'=>'comms',
                    'title'=>__('Email settings','church-admin'),
                    'link'=>$church_admin_url.'&action=email-settings&amp;section=comms'
                ),
        'sync-mailchimp'=>array(
                    'module'=>'Comms',
                    'parent'=>'comms',
                    'level'=>'Bulk Email',
                    'section'=>'comms',
                    'title'=>__('Sync MailChimp','church-admin'),
                    'link'=>$church_admin_url.'&action=sync-mailchimp&amp;section=comms'
                ),
        'send-mailchimp'=>array(
                    'module'=>'Comms',
                    'parent'=>'comms',
                    'level'=>'Bulk Email',
                    'section'=>'comms',
                    'title'=>__('Send MailChimp','church-admin'),
                    'link'=>$church_admin_url.'&action=send-mailchimp&amp;section=comms'
                ),
        'rota'=>array(
                    'module'=>'Rota',
                    'parent'=>'rota',
                    'level'=>'Rota',
                    'section'=>'rota',
                    'title'=>__('Schedule','church-admin'),
                    'link'=>$church_admin_url.'&action=view-rota&amp;section=rota',
                    "dashicon"=>'dashicons-editor-ol',
                    "font-awesome"=>'<span class="dashicons dashicons-clipboard ca-dashicons"></span>',
                    "background"=>"ca-yellow",
                    "callback"=>'church_admin_rota_callback'
                ),
        'not-available'=>array(
            'module'=>'Rota',
            'parent'=>'rota',
            'level'=>'Rota',
            'section'=>'rota',
            'title'=>__('Non availability','church-admin'),
            'link'=>$church_admin_url.'&action=not-available&amp;section=rota'
        ),
        'rota-settings'=>array(
                    'module'=>'Rota',
                    'parent'=>'rota',
                    'level'=>'Rota',
                    'section'=>'rota',
                    'title'=>__('Schedule jobs','church-admin'),
                    'link'=>$church_admin_url.'&action=rota-settings&amp;section=rota'
                ),
        'add-three-months'=>array(
                    'module'=>'Rota',
                    'parent'=>'rota',
                    'level'=>'Rota',
                    'section'=>'rota',
                    'title'=>__('Add 3 months of schedule dates','church-admin'),
                    'link'=>$church_admin_url.'&action=add-three-months&amp;section=rota'
                ),
        'edit-rota-job'=>array(
                    'module'=>'Rota',
                    'parent'=>'rota',
                    'level'=>'Rota',
                    'section'=>'rota',
                    'title'=>__('Add a schedule job','church-admin'),
                    'link'=>$church_admin_url.'&action=edit-rota-job&amp;section=rota'
                ),
        'auto-email-rota'=>array(
                    'module'=>'Rota',
                    'parent'=>'rota',
                    'level'=>'Rota',
                    'section'=>'rota',
                    'title'=>__('Auto email schedule','church-admin'),
                    'link'=>$church_admin_url.'&action=rota-auto-email&amp;section=rota'
                ),
        'auto-sms-rota'=>array(
                    'module'=>'Rota',
                    'parent'=>'rota',
                    'level'=>'Rota',
                    'section'=>'rota',
                    'title'=>__('Auto SMS schedule','church-admin'),
                    'link'=>$church_admin_url.'&action=auto-sms-rota&amp;section=rota'
                ),
        'show-cron'=>array(
                    'module'=>'Rota',
                    'parent'=>'rota',
                    'level'=>'Rota',
                    'section'=>'rota',
                    'title'=>__('Show schedule cron jobs','church-admin'),
                    'link'=>$church_admin_url.'&action=show-cron&amp;section=rota'
                ),
        'email-rota'=>array(
                    'module'=>'Rota',
                    'parent'=>'rota',
                    'level'=>'Rota',
                    'section'=>'rota',
                    'title'=>__('Email schedule','church-admin'),
                    'link'=>$church_admin_url.'&action=email-rota&amp;section=rota'
                ),
        'sms-rota'=>array(
                    'module'=>'Rota',
                    'parent'=>'rota',
                    'level'=>'Rota',
                    'section'=>'rota',
                    'title'=>__('SMS schedule','church-admin'),
                    'link'=>$church_admin_url.'&action=sms-rota&amp;section=rota'
                ),
        'pdf-rota'=>array(
                    'module'=>'Rota',
                    'parent'=>'rota',
                    'level'=>'Rota',
                    'section'=>'rota',
                    'title'=>__('PDF schedule','church-admin'),
                    'link'=>$church_admin_url.'&action=pdf-rota&amp;section=rota'
                ),
        'csv-rota'=>array(
                    'module'=>'Rota',
                    'parent'=>'rota',
                    'level'=>'Rota',
                    'section'=>'rota',
                    'title'=>__('CSV schedule','church-admin'),
                    'link'=>$church_admin_url.'&action=csv-rota&amp;section=rota'
                ),
        'calendar'=>array(
                    'module'=>'Calendar',
                    'parent'=>'calendar',
                    'level'=>'Calendar',
                    'section'=>'calender',
                    'title'=>__('Calendar','church-admin'),
                    'link'=>$church_admin_url.'&action=calendar&amp;section=calendar',
                    "dashicon"=>'dashicons-calendar-alt',
                    "font-awesome"=>'<span class="dashicons dashicons-calendar-alt ca-dashicons"></span>',
                    "background"=>"ca-lime",
                    "callback"=>'church_admin_calendar_callback'
                ),
            'add-calendar'=>array(
                    'module'=>'Calendar',
                    'parent'=>'calendar',
                    'level'=>'Calendar',
                    'section'=>'calender',
                    'title'=>__('Add to calendar','church-admin'),
                    'link'=>$church_admin_url.'&action=add-calendar&amp;section=calendar'
                ),
        'view-categories'=>array(
                    'module'=>'Calendar',
                    'parent'=>'calendar',
                    'level'=>'Calendar',
                    'section'=>'calender',
                    'title'=>__('View categories','church-admin'),
                    'link'=>$church_admin_url.'&action=categories&amp;section=calendar'
                ),
        'edit-category'=>array(
                    'module'=>'Calendar',
                    'parent'=>'calendar',
                    'level'=>'Calendar',
                    'section'=>'calender',
                    'title'=>__('Edit category','church-admin'),
                    'link'=>$church_admin_url.'&action=edit-category&amp;section=calendar'
                ),
            'import-ics'=>array(
                'module'=>'Calendar',
                'parent'=>'calendar',
                'level'=>'Calendar',
                'section'=>'calender',
                'title'=>__('Import ICS calendar','church-admin'),
                'link'=>$church_admin_url.'&action=import-ics&amp;section=calendar'
            ),
            'export-ics'=>array(
                'module'=>'Calendar',
                'parent'=>'calendar',
                'level'=>'Calendar',
                'section'=>'calender',
                'title'=>__('Export ICS calendar','church-admin'),
                'link'=>$church_admin_url.'&action=export-ics&amp;section=calendar'
            ),
            'facilities'=>array(
                    'module'=>'Facilities',
                    'parent'=>'facilities',
                    'level'=>'Calendar',
                    'section'=>'facilities',
                    'title'=>__('Facilities','church-admin'),
                    'link'=>$church_admin_url.'&action=facilities&amp;section=facilities',
                    "dashicon"=>'dashicons-calendar-alt',
                    "font-awesome"=>'<span class="dashicons dashicons-layout ca-dashicons"></span>',
                    "background"=>"ca-grape",
                    "callback"=>'church_admin_facilities_callback'
                ),
            'facility-bookings'=>array(
                    'module'=>'Facilities',
                    'parent'=>'facilities',
                    'level'=>'Calendar',
                    'section'=>'facilities',
                    'title'=>__('Facility bookings','church-admin'),
                    'link'=>$church_admin_url.'&action=facility-bookings&amp;section=facilities'
                ),
        'ministries'=>array(
                    'module'=>'Ministries',
                    'parent'=>'ministries',
                    'level'=>'Directory',
                    'section'=>'ministries',
                    'title'=>__('Ministries','church-admin'),
                    'link'=>$church_admin_url.'&action=ministries-list&amp;section=ministries',
                    "dashicon"=>'dashicons-networking',
                    "font-awesome"=>'<span class="dashicons dashicons-admin-tools ca-dashicons"></span>',
                    "background"=>"ca-cyan",
                    "callback"=>'church_admin_ministries_callback'
                ),
        'edit-ministry'=>array(
                    'module'=>'Ministries',
                    'parent'=>'ministries',
                    'level'=>'Directory',
                    'section'=>'ministries',
                    'title'=>__('Add a ministry','church-admin'),
                    'link'=>$church_admin_url.'&action=edit-ministry&amp;section=ministries'
                ),
        'volunteers'=>array(
                    'module'=>'Ministries',
                    'parent'=>'ministries',
                    'level'=>'Directory',
                    'section'=>'ministries',
                    'title'=>__('Volunteers','church-admin'),
                    'link'=>$church_admin_url.'&action=volunteers&amp;section=ministries'
                ),
        'media'=>array(
                    'module'=>'Media',
                    'parent'=>'media',
                    'level'=>'Sermons',
                    'section'=>'media',
                    'title'=>__('Media','church-admin'),
                    'link'=>$church_admin_url.'&action=media&amp;section=media',
                    "dashicon"=>'dashicons-controls-volumeon',
                    "font-awesome"=>'<span class="dashicons dashicons-media-audio ca-dashicons"></span>',
                    "background"=>"ca-red",
                    "callback"=>'church_admin_media_callback'
                ),
        'upload-mp3'=>array(
                    'module'=>'Media',
                    'parent'=>'media',
                    'level'=>'Sermons',
                    'section'=>'media',
                    'title'=>__('Upload media','church-admin'),
                    'link'=>$church_admin_url.'&action=upload-mp3&amp;section=media'
                ),
        'check-files'=>array(
                    'module'=>'Media',
                    'parent'=>'media',
                    'level'=>'Sermons',
                    'section'=>'media',
                    'title'=>__('Add uploaded file','church-admin'),
                    'link'=>$church_admin_url.'&action=check-files&amp;section=media'
                ),
        'sermon-series'=>array(
                    'module'=>'Media',
                    'parent'=>'media',
                    'level'=>'Sermons',
                    'section'=>'media',
                    'title'=>__('Sermon series','church-admin'),
                    'link'=>$church_admin_url.'&action=sermon-series&amp;section=media'
                ),
        'set-sermon-page'=>array(
                    'module'=>'Media',
                    'parent'=>'media',
                    'level'=>'Sermons',
                    'section'=>'media',
                    'title'=>__('Set sermon page','church-admin'),
                    'link'=>$church_admin_url.'&action=set-sermon-page&amp;section=media'
                ),        
        'edit-series'=>array(
                    'module'=>'Media',
                    'parent'=>'media',
                    'level'=>'Sermons',
                    'section'=>'media',
                    'title'=>__('Edit series','church-admin'),
                    'link'=>$church_admin_url.'&action=edit-series&amp;section=media'
                ),
        'podcast-settings'=>array(
                    'module'=>'Media',
                    'parent'=>'media',
                    'level'=>'Sermons',
                    'section'=>'media',
                    'title'=>__('Podcast settings','church-admin'),
                    'link'=>$church_admin_url.'&action=podcast-settings&amp;section=media'
                ),
        'refresh-podcast'=>array(
                    'module'=>'Media',
                    'parent'=>'media',
                    'level'=>'Sermons',
                    'section'=>'media',
                    'title'=>__('Refresh podcast','church-admin'),
                    'link'=>$church_admin_url.'&action=refresh-podcast&amp;section=media'
                ),
        'set-sermon-page'=>array(
                    'module'=>'Media',
                    'parent'=>'media',
                    'level'=>'Sermons',
                    'section'=>'media',
                    'title'=>__('Set sermon page','church-admin'),
                    'link'=>$church_admin_url.'&action=set-sermon-page&amp;section=media'
                ),        
        'app'=>array(
                    'module'=>'App',
                    'parent'=>'app',
                    'level'=>'Directory',
                    'section'=>'app',
                    'title'=>__('App','church-admin'),
                    'link'=>$church_admin_url.'&action=app&amp;section=app',
                    "dashicon"=>'dashicons-smartphone'
                    ,
                    "font-awesome"=>'<span class="dashicons dashicons-tablet ca-dashicons"></span>',
                    "background"=>"ca-darkgreen",
                    "callback"=>'church_admin_app_callback'
                ),
        'app-content'=>array(
                    'module'=>'App',
                    'parent'=>'app',
                    'level'=>'Directory',
                    'section'=>'app',
                    'title'=>__('App content','church-admin'),
                    'link'=>admin_url().'edit.php?post_type=app-content'
                ),
         'app-menu'=>array(
                    'module'=>'App',
                    'parent'=>'app',
                    'level'=>'Directory',
                    'section'=>'app',
                    'title'=>__('App menu','church-admin'),
                    'link'=>$church_admin_url.'&action=app-menu&amp;section=app'
                ), 
        'app-settings'=>array(
                    'module'=>'App',
                    'parent'=>'app',
                    'level'=>'Directory',
                    'section'=>'app',
                    'title'=>__('App settings','church-admin'),
                    'link'=>$church_admin_url.'&action=app-settings&amp;section=app'
                ), 
        'app-users'=>array(
                    'module'=>'App',
                    'parent'=>'app',
                    'level'=>'Directory',
                    'section'=>'app',
                    'title'=>__('App users','church-admin'),
                    'link'=>$church_admin_url.'&action=app-logins&amp;section=app'
                ),
        'app-settings'=>array(
                    'module'=>'App',
                    'parent'=>'app',
                    'level'=>'Directory',
                    'section'=>'app',
                    'title'=>__('App settings','church-admin'),
                    'link'=>$church_admin_url.'&action=app-settings&amp;section=app'
                ),
        'push'=>array(
                    'module'=>'App',
                    'parent'=>'app',
                    'level'=>'Directory',
                    'section'=>'app',
                    'title'=>__('Push message','church-admin'),
                    'link'=>$church_admin_url.'&action=push&amp;section=app'
                ),
        'app-logout'=>array(
                    'module'=>'App',
                    'confirm'=>TRUE,
                    'parent'=>'app',
                    'level'=>'Directory',
                    'section'=>'app',
                    'title'=>__('Logout everyone','church-admin'),
                    'link'=>$church_admin_url.'&action=app-settings&amp;section=app'
                ),
        'bible-version'=>array(
                    'module'=>'App',
                    'parent'=>'app',
                    'level'=>'Directory',
                    'section'=>'app',
                    'title'=>__('Bible version','church-admin'),
                    'link'=>$church_admin_url.'&action=bible-version&amp;section=app'
                ),
        'bible-reading-plan'=>array(
                    'module'=>'App',
                    'parent'=>'app',
                    'level'=>'Directory',
                    'section'=>'app',
                    'title'=>__('Bible reading plan','church-admin'),
                    'link'=>$church_admin_url.'&action=bible-reading-plan&amp;section=app'
                ),
        'churchwide-my-prayer'=>array(
                    'module'=>'App',
                    'parent'=>'app',
                    'level'=>'Directory',
                    'section'=>'app',
                    'title'=>__('Churchwide prayer','church-admin'),
                    'link'=>$church_admin_url.'&action=churchwide-my-prayer&amp;section=app'
                ),
        'sessions'=>array(
            'module'=>'Sessions',
            'parent'=>'sessions',
            'level'=>'Sessions',
            'section'=>'sessions',
            'title'=>__('Sessions','church-admin'),
            'link'=>$church_admin_url.'&action=sessions&amp;section=sessions',
            "dashicon"=>'dashicons-groups',
            "font-awesome"=>'<span class="dashicons dashicons-groups ca-dashicons"></span>',
            "background"=>"ca-teal",
            "callback"=>'church_admin_sessions_callback'
        ),
        'inventory'=>array(
            'module'=>'Inventory',
            'parent'=>'inventory',
            'level'=>'Inventory',
            'section'=>'inventory',
            'title'=>__('Inventory','church-admin'),
            'link'=>$church_admin_url.'&action=inventory&amp;section=inventory',
            "dashicon"=>'dashicons-admin-generic',
            "font-awesome"=>'<span class="dashicons dashicons-editor-ol ca-dashicons"></span>',
            "background"=>"ca-yellow",
            "callback"=>'church_admin_inventory_callback'
        ),
        'settings'=>array(
                    'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Directory',
                    'section'=>'settings',
                    'title'=>__('Settings','church-admin'),
                    'link'=>$church_admin_url.'&action=settings&amp;section=settings',
                    "dashicon"=>'dashicons-admin-generic',
                    "font-awesome"=>'<span class="dashicons dashicons-admin-settings ca-dashicons"></span>',
                    "background"=>"ca-gray",
                    "callback"=>'church_admin_settings_callback'
                ),

                'global-communications-settings'=>array(
                    'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Directory',
                    'section'=>'settings',
                    'title'=>__('Global Communications settings','church-admin'),
                    'link'=>$church_admin_url.'&action=modules&amp;section=global-communications-settings'
                ),

        'bulk-bible-readings'=>array(
            'module'=>'Settings',
            'parent'=>'settings',
            'level'=>'Directory',
            'section'=>'settings',
            'title'=>__('Bulk Bible reading publish','church-admin'),
            'link'=>$church_admin_url.'&action=bulk-bible-readings&amp;section=settings'
        ),        
        'choose-modules'=>array(
                    'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Directory',
                    'section'=>'settings',
                    'title'=>__('Choose modules','church-admin'),
                    'link'=>$church_admin_url.'&action=modules&amp;section=settings'
                ),
        'choose-filters'=>array(
                    'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Directory',
                    'section'=>'settings',
                    'title'=>__('Choose filters','church-admin'),
                    'link'=>$church_admin_url.'&action=choose-filters&amp;section=settings'
                ),
        'restrict-access'=>array(
                    'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Directory',
                    'section'=>'settings',
                    'title'=>__('Restrict access','church-admin'),
                    'link'=>$church_admin_url.'&action=restrict-access&amp;section=settings'
                ),
        'people-types'=>array(
                    'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Directory',
                    'section'=>'settings',
                    'title'=>__('People types','church-admin'),
                    'link'=>$church_admin_url.'&action=people-types&amp;section=settings'
                ),
        'marital-status'=>array(
                     'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Directory',
                    'section'=>'settings',
                    'title'=>__('Marital status','church-admin'),
                    'link'=>$church_admin_url.'&action=marital-status&amp;section=settings'
                ),
        'debug-log'=>array(
                    'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Directory',
                    'section'=>'settings',
                    'title'=>__('Debug Log','church-admin'),
                    'link'=>$church_admin_url.'&action=debug-log&amp;section=settings'
                ),
        'installation-errors'=>array(
                    'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Directory',
                    'section'=>'settings',
                    'title'=>__('Installation errors','church-admin'),
                    'link'=>$church_admin_url.'&action=installation-errors&amp;section=settings'
                ),
       
        'permissions'=>array(
                    'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Directory',
                    'section'=>'settings',
                    'title'=>__('Permissions','church-admin'),
                    'link'=>$church_admin_url.'&action=permissions&amp;section=settings'
                ),
        'paypal-setup'=>array(
                    'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Giving',
                    'section'=>'giving',
                    'title'=>__('Paypal Setup','church-admin'),
                    'link'=>$church_admin_url.'&action=paypal-setup&amp;section=settings'
                ),
        'roles'=>array(
                    'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Directory',
                    'section'=>'settings',
                    'title'=>__('Roles','church-admin'),
                    'link'=>$church_admin_url.'&action=roles&amp;section=settings'
                ),
        'replicate-roles'=>array(
                    'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Directory',
                    'section'=>'settings',
                    'title'=>__('Replicate roles','church-admin'),
                    'link'=>$church_admin_url.'&action=replicate-roles&amp;section=settings'
                ),
        'reset-version'=>array(
                    'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Directory',
                    'section'=>'settings',
                    'title'=>__('Reset version','church-admin'),
                    'link'=>$church_admin_url.'&action=reset-version&amp;section=settings'
                ),
        'shortcode-generator'=>array(
                    'module'=>'Settings',
                    'parent'=>'settings',
                    'level'=>'Directory',
                    'section'=>'settings',
                    'title'=>__('Shortcode generator','church-admin'),
                    'link'=>$church_admin_url.'&action=shortcode-generator&amp;section=settings'
                )
        
    );
   
}
/* initialise plugin */

//add_action( 'plugins_loaded', 'church_admin_initialise' );
add_action( 'init', 'church_admin_initialise' );
function church_admin_initialise() {
	global $church_admin_url,$level,$church_admin_version,$wpdb,$current_user,$church_admin_prayer_request_success,$member_type;
	if(defined('CA_DEBUG') )$wpdb->show_errors();
	define('CA_PATH',plugin_dir_path( __FILE__) );
 
    
	wp_get_current_user();
	church_admin_constants();//setup constants first





	//Version Number
	define('OLD_CHURCH_ADMIN_VERSION',get_option('church_admin_version') );
	if(version_compare(OLD_CHURCH_ADMIN_VERSION,$church_admin_version)<0)
	{
		church_admin_debug('Firing install');
      
		require_once(plugin_dir_path( __FILE__) .'/includes/install.php');
		church_admin_install();
	}

    /******************************************
     * initialise variables
     ******************************************/
    $services = church_admin_services_array();
    $sites = church_admin_sites_array();
    $member_types=church_admin_member_type_array();
    $units = church_admin_units_array();


	if(!empty( $_GET['ca_refresh'] ) )
	{
		delete_option('church-admin-directory-output');
		
	}
	/******************************************
     * handle move household to member type
     *****************************************/
	if(!empty( $_POST['move_household_id'] ) )
	{
        //update sanitize, validate,escape v 3.7.25 2023-05-08
        //sanitize
        $move_id = !empty($_POST['move_household_id'])?sanitize_text_field($_POST['move_household_id']):null;
        $member_type_id = !empty($_POST['member_type_id'])?sanitize_text_field($_POST['member_type_id']):null;

        //validate
        $validated = TRUE;
        if(empty($move_household_id)){$validated = FALSE;}
        if(empty($member_type_id) || empty($member_types[$member_type_id])){$validated = FALSE;}
        if(!ctype_digit($member_type_id)){$validated = FALSE;}

		if(!empty($validated) )
		{
			$wpdb->query('UPDATE '.CA_PEO_TBL.' SET member_type_id="'.(int)$member_type_id.'" WHERE household_id="'.(int)$move_household_id.'"');
		}
	}
    /************************************
     * handle move household to site
     ************************************/
	if(!empty( $_POST['move_site_id'] ) )
	{
        //update sanitize, validate,escape v 3.7.25 2023-05-08
        //sanitize
        $move_site_id = !empty($_POST['move_site_id'])?sanitize_text_field($_POST['move_site_id']):null;
        $site_id = !empty($_POST['site_id'])?sanitize_text_field($_POST['site_id']):null;
        //validate
        $validated = TRUE;
        if(empty($move_site_id) || !ctype_digit($site_id) ||  empty($sites[$move_site_id])){$validated = FALSE;}
        if(empty($site_id) || !ctype_digit($site_id) || empty($sites[$site_id])){$validated = FALSE;}
		
        if(!empty($validated) )
		{
			 $wpdb->query('UPDATE '.CA_PEO_TBL.' SET site_id="'.(int)$site_id.'" WHERE household_id="'.(int)$move_site_id.'"');

		}
	}
    /*****************************
     * handle unit save
     *****************************/
    if(!empty( $_POST['save-unit'] ) )
    {
        //update sanitize, validate,escape v 3.7.25 2023-05-08
        //sanitize
        $unit_id     = !empty( $_REQUEST['unit_id'] )? sanitize_text_field($_REQUEST['unit_id']) :null;
        $name        = !empty($_POST['unit_name']) ? sanitize_text_field( $_POST['unit_name'] ) :null;
        $description = !empty($_POST['unit_description']) ? sanitize_textarea_field( $_POST['unit_description'] ) :null;
        
        //validate
        $validated = TRUE;
        if(!empty($unit_id)){
            //check it exists
            if(empty($units[$unit_id])){
                $unit_id = FALSE; //non existent unit_id, so needs to be an insery
            }
        }
        if(empty($name)){$validated = FALSE;}
        if(empty($description)){$validated = FALSE;}
        if(!empty($validated)){
            if ( empty( $unit_id) )  {
                $wpdb->query('INSERT INTO '.CA_UNI_TBL.' (name,description)VALUES("'.esc_sql($name).'","'.esc_sql($description).'")');
            }
            else{
                $wpdb->query('UPDATE '.CA_UNI_TBL.' SET name="'.esc_sql($name).'",description="'.esc_sql($description).'" WHERE unit_id="'.(int)$unit_id.'"');
            }
        }
    }
    if(!empty( $_POST['save-subunit'] ) )
    {
         //update sanitize, validate,escape v 3.7.25 2023-05-08
        //sanitize
        $unit_id     = !empty( $_REQUEST['unit_id'] )? sanitize_text_field($_REQUEST['unit_id']) :null;
        $subunit_id     = !empty( $_REQUEST['subunit_id'] )? sanitize_text_field($_REQUEST['subunit_id']) :null;
        $name        = !empty($_POST['unit_name']) ? sanitize_text_field( $_POST['unit_name'] ) :null;
        $description = !empty($_POST['unit_description']) ? sanitize_textarea_field( $_POST['unit_description'] ) :null;
        $people = !empty($_POST['people']) ? sanitize_text_field( $_POST['people'] ) :null;

        //validate
        $validated = TRUE;
        if(!empty($unit_id)){
             //check it exists
             if(empty($units[$unit_id])){
                 $unit_id = FALSE; //non existent unit_id, so needs to be an insery
             }
        }
        if(!empty($subunit_id)||!ctype_digit($subunit_id)){$validated = FALSE;}
        if(empty($name)){$validated = FALSE;}
        if(empty($description)){$validated = FALSE;}
        
        if(!empty($validated))
        {

            if ( empty( $subunit_id) )$subunit_id=$wpdb->get_var('SELECT subunit_id FROM '.CA_SUBU_TBL.' WHERE name="'.esc_sql($name).'" AND description="'.esc_sql($description).'"');
        
        
        
            if ( empty( $subunit_id) ){
                $wpdb->query('INSERT INTO '.CA_SUBU_TBL.' (name,description,unit_id,active)VALUES("'.esc_sql($name).'","'.esc_sql($description).'","'.(int)$unit_id.'",1)');
                $subunit_id=(int)$wpdb->insert_id;
                church_admin_debug( $wpdb->last_query);
            }
            else{
                $wpdb->query('UPDATE '.CA_SUBU_TBL.' SET name="'.esc_sql($name).'",description="'.esc_sql($description).'" WHERE subunit_id="'.(int)$subunit_id.'"');
            }
            //handle people
            $wpdb->query('DELETE FROM '.CA_MET_TBL.' WHERE meta_type="unit" AND ID="'.(int)$subunit_id.'"'); 
            $autocompleted= maybe_unserialize(church_admin_get_people_id(trim($people )) );
            foreach( $autocompleted AS $x=>$name)
            {
                $p_id=church_admin_get_one_id(trim( $name) );//get the people_id
                if(!empty( $p_id) )
                {
                    church_admin_update_people_meta( $subunit_id,$p_id,'unit');//update person 
                }
            }
        }
       
    }

    //handle unconfirm GDPR
	if(!empty( $_GET['action'] )&&$_GET['action']=='ca_unconfirm_GDPR')
	{
		if(!is_user_logged_in() )return;
		if(current_user_can('manage_options') )
		{
			$wpdb->query('UPDATE '.CA_PEO_TBL.' SET gdpr_reason=NULL');
			
		}	
	}	
	/**************************************
     * handle unsubscribe link from email
     * ************************************/
	if(!empty( $_GET['ca_unsub'] ) )
	{
        //update sanitize, validate,escape v 3.7.25 2023-05-08
        //sanitize
        
        $unsub = !empty($_GET['ca_unsub'])?sanitize_text_field($_GET['ca_unsub']):null;
        //validate
        $validMD5 = FALSE;
        if(!empty($unsub)){
            $validMD5 = preg_match('/^[a-f0-9]{32}$/', $unsub);
        }
        
        if(!empty($validMD5)){
            $details=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE md5(people_id)="'.esc_sql( $unsub ).'"');
			$wpdb->query('UPDATE '.CA_PEO_TBL.' SET email_send=0 WHERE md5(people_id)="'.esc_sql( $unsub ).'"');
			require_once( plugin_dir_path( __FILE__ ).'includes/unsubscribe.php');
			exit();
        }
	}
	/***************************
     * handle re-subscribe
     ***************************/
	if(!empty( $_GET['ca_sub'] ) )
	{
        //update sanitize, validate,escape v 3.7.25 2023-05-08
        //sanitize
        
        $resub = !empty($_GET['ca_unsub'])?sanitize_text_field($_GET['ca_sub']):null;
        //validate
        $validMD5 = FALSE;
        if(!empty($resub)){
            $validMD5 = preg_match('/^[a-f0-9]{32}$/', $resub);
        }
        
        if(!empty($validMD5)){
		    $details=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE md5(people_id)="'.esc_sql( $resub ).'"');
			$wpdb->query('UPDATE '.CA_PEO_TBL.' SET email_send=1 WHERE md5(people_id)="'.esc_sql( $resub ).'"');
			require_once( plugin_dir_path( __FILE__ ).'includes/resubscribe.php');
			exit();
        }
	}

    /**************************************
     * handle confirm email 
     *************************************/
    if(!empty( $_GET['confirm_email'] )&&!empty( $_GET['people_id'] ) )
	{
        church_admin_debug("**********************\r\n CONFIRM EMAIL");
        //update sanitize, validate,escape v 3.7.25 2023-05-08
        //sanitize
        $md5email = !empty($_GET['confirm_email'])? sanitize_text_field($_GET['confirm_email']):null;
        $md5peopleID = !empty($_GET['people_id'])? sanitize_text_field($_GET['people_id']):null;
        //validate
        $validated = FALSE;
        if(!empty($md5email)){$validMD5email = preg_match('/^[a-f0-9]{32}$/', $md5email);}
        if(!empty($md5peopleID)){$validMD5peopleID = preg_match('/^[a-f0-9]{32}$/', $md5peopleID);}
        if(!empty($validMD5email ) && !empty($validMD5peopleID)){$validated = TRUE;}

        if(!empty($validated))
        {
            $person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE md5(email)="'.esc_sql($md5email).'" AND md5(people_id)="'.esc_sql($md5peopleID ).'"');
            church_admin_debug( $wpdb->last_query);
            church_admin_debug(print_r( $person,TRUE) );
            
            if(!empty( $person) )
            {
        
        
                /*************************
                *   MailChimp
                **************************/
                $mailChimpSettings=get_option('church_admin_mailchimp');
                if(!empty( $mailChimpSettings['api_key'] )&& !empty( $person->email_send) )
                {

                        church_admin_debug("Adding to mailChimp");
                        require_once( plugin_dir_path( __FILE__ ).'includes/mailchimp.inc.php');
                        require_once( plugin_dir_path( __FILE__ ).'includes/mailchimp.php');
                        $MailChimp = new MailChimp( $mailChimpSettings['api_key'] );
                        $MailChimp->verify_ssl = 'false';
                        $subscriber_hash=md5( $person->email);
                        $args=array('status'=>'subscribed','email_address'=>$person->email,'merge_fields'=>array('FNAME'=>$person->first_name,'LNAME'=>$person->last_name) );
                        $response=$MailChimp->put("/lists/{$mailChimpSettings['listID']}/members/{$subscriber_hash}",$args);
                        church_admin_debug("MailChimp add response\r\n".print_r( $response,TRUE) );
                        $tags=church_admin_mailchimp_person_tags( $person->people_id);
                        if(!empty( $tags) )
                        {

                            $response=$MailChimp->post("/lists/{$mailChimpSettings['listID']}/members/{$subscriber_hash}/tags",array('tags'=>$tags) );
                            church_admin_debug("MailChimp tags response\r\n".print_r( $response,TRUE) );
                        }
                }
                //update GDPR reason
                $wpdb->query('UPDATE '.CA_PEO_TBL.' SET gdpr_reason="'.__('User confirmed from confirmation email','church-admin').'" WHERE people_id="'.(int)$person->people_id.'"');
                if(defined('CA_DEBUG') )  {church_admin_debug( $wpdb->last_query);}
                $adminApproval=get_option('church_admin_admin_approval_required');
                if ( empty( $adminApproval) )
                {
                    //no admin approval required!
                    require_once( plugin_dir_path( __FILE__ ).'includes/directory.php');
                    if ( empty( $person->user_id) )church_admin_create_user( $person->people_id,$person->household_id);
                    $CAUSER=TRUE;
                }else
                {
                    $adminmessage='<p>'.sprintf(__('A new household has confirmed their email. Please %1$s check them %2$s out and give user account if happy.','church-admin'),'<a href="'.site_url().'/wp-admin/admin.php?page=church_admin/index.php&action=display_household&household_id='.(int)$person->household_id.'&section=people">','</a>').'</p>';
                    
                    add_filter( 'wp_mail_from_name','church_admin_from_name' );
                    add_filter( 'wp_mail_from', 'church_admin_from_email');
                    add_filter('wp_mail_content_type','church_admin_email_type');
                    //$headers=array('Reply To:'.esc_html(church_admin_formatted_name( $person) ).'<'.esc_html( $person->email).'>');
                    
                    wp_mail(get_option('admin_email'),sprintf(__('New household registration on %1$s','church-admin'),site_url() ),$adminmessage);//,$headers);
                    remove_filter('wp_mail_content_type','church_admin_email_type');
                    remove_filter( 'wp_mail_from_name','church_admin_from_name' );
                    remove_filter( 'wp_mail_from', 'church_admin_from_email');
                    
                }
                require_once( plugin_dir_path( __FILE__ ).'includes/confirmed.php');
                exit();
            }
        }
    }
	//temp fix fo bug in app
	if(isset( $_GET['action'] )&&$_GET['action']=='ca_classes')  {
        require_once( plugin_dir_path( __FILE__ ).'app/app-admin.php');
        ca_classes();exit();
    }


	
	//remove cron auto email rotas
	if(isset( $_GET['action'] )&&$_GET['action']=="delete-cron")
	{
        if(!is_user_logged_in() )return;
		check_admin_referer('delete-cron');
		
        //update sanitize, validate,escape v 3.7.25 2023-05-08
        //sanitize
        $ts=!empty($_GET['ts'])?sanitize_text_field($_GET['ts']):null;
        $key=!empty($_GET['key'])?sanitize_text_field($_GET['key']):null;
        $which=!empty($_GET['which'])?sanitize_text_field($_GET['which']):null;
        //validate
        $validated = TRUE;
        if(empty($ts)){$validated = FALSE;}
        if(!ctype_digit($ts)){$validated = FALSE;}
        if(empty($which) || ($which!='email' && $which!='sms')){$validated = FALSE;}
        
        if(!empty($validated))
        {
            require_once( plugin_dir_path( __FILE__ ).'includes/rota.new.php');
            church_admin_delete_cron( $ts,$key,$which );
            $url=admin_url().'admin.php?page=church_admin%2Findex.php&action=show-cron&section=rota';
            wp_redirect( $url );
        }
	}
	if(!empty( $_POST['ind_att_csv'] ) )  {
        require_once( plugin_dir_path( __FILE__ ).'includes/individual_attendance.php');
        church_admin_output_ind_att_csv();
        exit();
    }
	//load_plugin_textdomain( 'church-admin', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    load_plugin_textdomain( 'church-admin');
    $level=get_option('church_admin_levels');
    if(empty($level))
    {
        if ( empty( $level['Units'] ) )$level['Units']='administrator';
        if ( empty( $level['Ministries'] ) )$level['Ministries']='administrator';
        if ( empty( $level['Giving'] ) )$level['Giving']='administrator';
        if ( empty( $level['Directory'] ) )$level['Directory']='administrator';
        if ( empty( $level['Kidswork'] ) )$level['Kidswork']='administrator';
        if ( empty( $level['Small Groups'] ) )$level['Small Groups']='administrator';
        if ( empty( $level['Rota'] ) )$level['Rota']='administrator';
        if ( empty( $level['Funnel'] ) ) $level['Funnel']='administrator';
        if ( empty( $level['Bulk Email'] ) )$level['Bulk Email']='administrator';
        if ( empty( $level['Sermons'] ) )$level['Sermons']='administrator';
        if ( empty( $level['Bulk SMS'] ) )$level['Bulk SMS']='administrator';
        if ( empty( $level['Calendar'] ) )$level['Calendar']='administrator';
        if ( empty( $level['Attendance'] ) )$level['Attendance']='administrator';
        if ( empty( $level['Member Type'] ) )$level['Member Type']='administrator';
        if ( empty( $level['Service'] ) )$level['Service']='administrator';
        if ( empty( $level['Sessions'] ) )$level['Sessions']='administrator';
       
        if ( empty( $level['Sessions'] ) )$level['Sessions']='administrator';
        if ( empty( $level['App'] ) )$level['App']='administrator';
        if ( empty( $level['Prayer Requests'] ) )$level['Prayer Requests']='administrator';
        if ( empty( $level['Events'] ) )$level['Events']='administrator';
        if ( empty( $level['Ministries'] ) )$level['Ministries']='administrator';
        if ( empty( $level['Classes'] ) )$level['Classes']='administrator';
        if ( empty( $level['Contact form'] ) )$level['Contact form']='administrator';
        update_option('church_admin_levels',$level);
    }
    if(!empty( $_POST['one_site'] ) ){
        //update sanitize, validate,escape v 3.7.25 2023-05-08
        //sanitize
        $site_id=!empty($_POST['site_id'])?sanitize_text_field($_POST['site_id']):null;
        //validate
        $sites = church_admin_sites_array();
        if(!empty($sites[$site_id]))
        {
            $wpdb->query('UPDATE '.CA_PEO_TBL.' SET site_id="'.(int)$site_id.'"');
        }
    }
    //church admin app initialisation

	if(!empty( $_GET['ca-app'] ) )
	{
		require_once( plugin_dir_path( __FILE__ ).'app/app-admin.php');
		switch( $_GET['ca-app'] )
		{
			case'latest_media': 
                header("Content-Type: application/json"); 
                echo church_admin_json_latest_media();
                exit();
            break;

		}
	}

	/******************************
    * copy rota and then redirect
    *******************************/
	 if(!empty( $_GET['page'] )&&( $_GET['page']=='church_admin/index.php')&&!empty( $_GET['action'] )&& $_GET['action']=='copy_rota_data' &&church_admin_level_check('Rota') )
	{
        church_admin_debug('Copying rota');
		//update sanitize, validate,escape v 3.7.25 2023-05-08
        //sanitize//sanitize
        church_admin_debug('Sanitizing');
        $rota_date1 = !empty($_GET['rotaDate1'])?sanitize_text_field($_GET['rotaDate1']):null;
        church_admin_debug('Rota date 1: '.$rota_date1);
        $rota_date2 = !empty($_GET['rotaDate2'])?sanitize_text_field($_GET['rotaDate2']):null;
        church_admin_debug('Rota date 2: '.$rota_date2);
        $service_id = !empty($_GET['service_id'])?sanitize_text_field($_GET['service_id']):null;
        church_admin_debug('Service id: '.$service_id);
        $mtg_type   = !empty($_GET['mtg_type'])?sanitize_text_field($_GET['mtg_type']):'service';
        church_admin_debug('Mtg Type: '.$mtg_type);
        //validate
        church_admin_debug('Validating');
        $validated = TRUE;

        if( empty( $rota_date1 ) || !church_admin_checkdate($rota_date1)) { 
            $validated = FALSE; 
            church_admin_debug('Rota date 1 fail');
        }
        if( empty( $rota_date2 ) || !church_admin_checkdate($rota_date2)) { 
            $validated = FALSE; 
            church_admin_debug('Rota date 2 fail');
        }
        if(  empty( $services) || empty( $service_id ) || empty($services[$service_id])){ 
            $validated = FALSE; 
            church_admin_debug('Service id  fail');
        }
        if($mtg_type!='service'){ 
            $validated = FALSE; 
            church_admin_debug('Mtg type fail');
        }

        if(!empty($validated))
        {
            church_admin_debug('Passed validation');
            require_once( plugin_dir_path( __FILE__ ).'includes/rota.new.php');
            $message=church_admin_copy_rota( $rota_date1,$rota_date2, $service_id,$mtg_type );
            //MICK WALL – redirect back to the list for current service.
            
            $url=admin_url().'admin.php?page=church_admin%2Findex.php&action=church_admin_rota_list&section=rota&service_id='.(int)$service_id.'&message='.urlencode($message);
            wp_redirect( $url );

            exit();
        } 
	}
    //reset version
	if(!empty( $_GET['page'] )&&( $_GET['page']=='church_admin/index.php')&&!empty( $_GET['action'] )&& $_GET['action']=='reset-version')
	{
		//check_admin_referer('reset-version');

		delete_option("church_admin_version");
		$url=admin_url().'admin.php?page=church_admin%2Findex.php&message=Church+Admin+Version+Reset';
		wp_redirect( $url );
		exit;
	}
	//reset version
	//upgrade rota for 1.095
	 if(!empty( $_GET['page'] )&&( $_GET['page']=='church_admin/index.php')&&!empty( $_GET['action'] )&& $_GET['action']=='upgrade_rota')
	{
		check_admin_referer('upgrade_rota');

		delete_option("church_admin_version");
		$wpdb->query('TRUNCATE TABLE '.CA_ROTA_TBL);
		$url=admin_url().'admin.php?page=church_admin%2Findex.php&message=Rota+Table+Reset';
		wp_redirect( $url );
		exit;
	}
		//upgrade rota for 1.095
	 if(!empty( $_GET['page'] )&&( $_GET['page']=='church_admin/index.php')&&!empty( $_GET['action'] )&& $_GET['action']=='clear_debug')
	{
		check_admin_referer('clear_debug');

		$upload_dir = wp_upload_dir();
		$debug_path=$upload_dir['basedir'].'/church-admin-cache/debug_log.php';
		if(file_exists( $debug_path) )unlink( $debug_path);
		$url=admin_url().'admin.php?page=church_admin%2Findex.php&action=settings&section=general-settings&message=Church+Admin+Debug+Log+has+been+deleted.';
		wp_redirect( $url );
		exit;
	}
    //save the church admin note before any display happens

	if(!empty( $_POST['save-ca-comment'] ) )
 	{
 		church_admin_debug('******************************'."\r\n Save Comment ".date('Y-m-d H:i:s')."\r\n");
 		//update sanitize, validate,escape v 3.7.25 2023-05-08
        //sanitize
        $parent_id = !empty( $_POST['parent_id'] )?sanitize_text_field( $_POST['parent_id'] ) : null;
        $comment_id = !empty( $_POST['comment_id'] )?sanitize_text_field( $_POST['comment_id'] ) : null;
        $comment = !empty($_POST['comment'])?sanitize_textarea_field($_POST['comment']):null;
        $comment_type = !empty( $_POST['comment_type'] )?sanitize_text_field( $_POST['comment_type'] ) : null;
        $ID = !empty( $_POST['ID'] )?sanitize_text_field( $_POST['ID'] ) : null;

 		foreach( $_POST AS $key=>$value)$sqlsafe[$key]=esc_sql(stripslashes( $value) );
 		if(!empty( $_POST['comment_id'] ) )
 		{
 			$sql='UPDATE '.CA_COM_TBL.' SET comment="'.esc_sql($comment).'",comment_type="'.esc_sql($comment_type).'",parent_id="'.(int)$parent_id.'",author_id="'.(int)$current_user->ID.'",timestamp="'.date('Y-m-d h:i:s').'" comment_id="'.(int)$comment_id.'"';
 		}
 		else
 		{

 			$sql='INSERT INTO '.CA_COM_TBL.' (comment,comment_type,parent_id,author_id,timestamp,ID)VALUES("'.esc_sql($comment).'","'.esc_sql($comment_type).'","'.(int)$parent_id.'","'.(int)$current_user->ID.'","'.date('Y-m-d h:i:s').'","'.(int)$ID.'")';
 		}
 		church_admin_debug('******************************'."\r\n $sql \r\n");
 		$wpdb->query( $sql);
 		if ( empty( $comment_id ) )$comment_id=$wpdb->insert_id;

 		$comment=$wpdb->get_row('SELECT * FROM '.CA_COM_TBL.' WHERE comment_id="'.(int)$comment_id.'"');

 	}

}


require_once( plugin_dir_path( __FILE__ ).'app/app-setup.php');
require_once( plugin_dir_path( __FILE__ ).'app/app-old.php');
require_once( plugin_dir_path( __FILE__ ).'app/app-admin.php');
require_once( plugin_dir_path( __FILE__ ).'includes/new-style-callbacks.php');
require_once( plugin_dir_path( __FILE__ ).'includes/custom_fields.php');
require_once( plugin_dir_path( __FILE__ ).'includes/widgets.php');
if(function_exists('register_block_type') )require_once( plugin_dir_path( __FILE__ ) .'gutenberg/php-blocks.php');
add_action( 'delete_user', 'church_admin_delete_user' );//make sure user account disconnected from directory


function church_admin_delete_user( $user_id)
{
	global $wpdb;
    //sanitize 
    $sanitizedUserID = (!empty($user_id) && ctype_digit($user_id) ) ? (int)$user_id: null;
    //validate - check actual user with that ID
    if(!empty($sanitizedUserID)){
        $user = get_user_by('ID',$sanitizedUserID);
    }
    if(!empty($user)){
        $wpdb->query('UPDATE '.CA_PEO_TBL.' SET user_id="NULL" WHERE user_id="'.(int)$user->ID.'"');
    }
	
}

add_action('activated_plugin','church_admin_save_error');
function church_admin_save_error()  {
    update_option('church_admin_plugin_error',  ob_get_contents() );
}
add_action('load-church-admin', 'church_admin_add_screen_meta_boxes');




 /**
     *
     * Sets up constants for plugin
     *
     * @author  Andy Moyle
     * @param    null
     * @return
     * @version  0.1
     *
     */
function church_admin_constants()
{
   
    global $wpdb;

    // DB
    define('CA_INV_TBL',$wpdb->prefix.'church_admin_inventory');
    define('CA_PRA_TBL',$wpdb->prefix.'church_admin_my_prayer');
    define('CA_PLE_TBL',$wpdb->prefix.'church_admin_pledge');
    define('CA_GIV_TBL',$wpdb->prefix.'church_admin_giving');
    define('CA_GMET_TBL',$wpdb->prefix.'church_admin_giving_meta');
    define('CA_COV_TBL',$wpdb->prefix.'church_admin_covid_attendance');
    define('CA_VIS_TBL',$wpdb->prefix.'church_admin_plan_visit');
    define('CA_ATT_TBL',$wpdb->prefix.'church_admin_attendance');
    define('CA_BRP_TBL',$wpdb->prefix.'church_admin_brplan');
    if(!defined('CA_APP_TBL') )define('CA_APP_TBL',$wpdb->prefix.'church_admin_app');
    //define('CA_APV_TBL',$wpdb->prefix.'church_admin_app_visits');
    define('CA_CP_TBL',$wpdb->prefix.'church_admin_safeguarding');
    define ('CA_BIB_TBL',$wpdb->prefix.'church_admin_bible_books');
    define ('CA_CAT_TBL',$wpdb->prefix.'church_admin_calendar_category');
    define('CA_CEL_TBL',$wpdb->prefix.'church_admin_cell_structure');
    define('CA_CLA_TBL',$wpdb->prefix.'church_admin_classes');
    define('CA_COM_TBL',$wpdb->prefix.'church_admin_comments');
    define('CA_CONT_TBL',$wpdb->prefix.'church_admin_contact_form');
    define('CA_CUST_TBL',$wpdb->prefix.'church_admin_custom_fields');
    define('CA_CUST_MET_TBL',$wpdb->prefix.'church_admin_custom_fields_meta');
    define('CA_DATE_TBL',$wpdb->prefix.'church_admin_calendar_date');
    define('CA_EVE_TBL',$wpdb->prefix.'church_admin_events');
    define('CA_BOO_TBL',$wpdb->prefix.'church_admin_bookings');
    define('CA_TIK_TBL',$wpdb->prefix.'church_admin_tickets');
    define ('CA_FIL_TBL',$wpdb->prefix.'church_admin_sermon_files');

    define('CA_EMA_TBL',$wpdb->prefix.'church_admin_email');
    define('CA_EBU_TBL',$wpdb->prefix.'church_admin_email_build');
    define('CA_FBK_TBL',$wpdb->prefix.'church_admin_facilities_bookings');
    define ('CA_FAC_TBL',$wpdb->prefix.'church_admin_facilities');
    define('CA_FUN_TBL',$wpdb->prefix.'church_admin_funnels');
    define('CA_FP_TBL',$wpdb->prefix.'church_admin_follow_up');
    define('CA_HOU_TBL',$wpdb->prefix.'church_admin_household');
    define('CA_HOP_TBL',$wpdb->prefix.'church_admin_hope_team');
    define('CA_IND_TBL',$wpdb->prefix.'church_admin_individual_attendance');
    define('CA_KID_TBL',$wpdb->prefix.'church_admin_kidswork');
    define('CA_NOT_TBL',$wpdb->prefix.'church_admin_not_available');
    define('CA_MET_TBL',$wpdb->prefix.'church_admin_people_meta');
    define('CA_METRICS_TBL',$wpdb->prefix.'church_admin_metrics');
    define('CA_METRICS_META_TBL',$wpdb->prefix.'church_admin_metrics_meta');
    define('CA_MTY_TBL',$wpdb->prefix.'church_admin_member_types');
    define('CA_MIN_TBL',$wpdb->prefix.'church_admin_ministries');
    define('CA_PAY_TBL',$wpdb->prefix.'church_admin_event_payments');
    define('CA_PEO_TBL',$wpdb->prefix.'church_admin_people');
    define('CA_REC_TBL',$wpdb->prefix.'church_admin_donor_receipts');
    define('CA_ROTA_TBL',$wpdb->prefix.'church_admin_new_rota');
    define('CA_ROT_TBL',$wpdb->prefix.'church_admin_rotas');
    define('CA_RST_TBL',$wpdb->prefix.'church_admin_rota_settings');
    define('CA_SMG_TBL',$wpdb->prefix.'church_admin_smallgroup');
    define('CA_SER_TBL',$wpdb->prefix.'church_admin_services');
    define('CA_SES_TBL',$wpdb->prefix.'church_admin_session');
    define('CA_SMET_TBL',$wpdb->prefix.'church_admin_session_meta');
    define('CA_SIT_TBL',$wpdb->prefix.'church_admin_sites');
    define ('CA_SERM_TBL',$wpdb->prefix.'church_admin_sermon_series');
    define('CA_TWI_TBL',$wpdb->prefix.'church_admin_twilio_messages');
    define ('CA_UNI_TBL',$wpdb->prefix.'church_admin_units');
    define ('CA_SUBU_TBL',$wpdb->prefix.'church_admin_unit_meta');
    //define DB
    define('OLD_CHURCH_ADMIN_EMAIL_CACHE',WP_PLUGIN_DIR.'/church-admin-cache/');
    define('OLD_CHURCH_ADMIN_EMAIL_CACHE_URL',WP_PLUGIN_URL.'/church-admin-cache/');

    church_admin_create_directories();

}//end constants


 /**
 *
 * Add new household to admin toolbar
 *
 * @author  Andy Moyle
 * @param    null
 * @return   Array, key is order
 * @version  0.1
 *
 */
function church_admin_menu_item ( $wp_admin_bar) {

    $args = array (
            'id'        => 'household',
            'title'     => __('Household','church-admin'),
            'href'      => wp_nonce_url('admin.php?page=church_admin/index.php&amp;section=people&action=add-household','add-household'),
            'parent'    => 'new-content'
    );

  if(church_admin_level_check('Directory') )  $wp_admin_bar->add_node( $args );
}

add_action('admin_bar_menu', 'church_admin_menu_item',71);




/******************************************************************************************************************************
*
* For prayer request, if made private in settings we want to show the login form at the template_redirect hook 
*
******************************************************************************************************************************/
function church_admin_private_prayer_template( $archive_template ) {
    global $post;
    $private=get_option('church-admin-private-prayer-requests');
    church_admin_debug(get_post_type());
    if ( (is_post_type_archive ( 'prayer-requests' ) ||   'prayer-requests'==get_post_type()) && !is_user_logged_in() && !empty($private) ) {
        church_admin_debug('Prayer request not logged in');
        $located = locate_template( 'private-prayer.php' );
        church_admin_debug($located);
        if(!empty($located)){
            
            $archive_template = $located;
        }
        else
        {
            $archive_template = dirname( __FILE__ ) . '/display/private-prayer.php';
        }
    } 
    return $archive_template;
}
add_filter( 'archive_template', 'church_admin_private_prayer_template' ) ;
add_filter( 'single_template', 'church_admin_private_prayer_template' ) ;

/*

add_filter( 'the_content', 'church_admin_logged_in_prayer', 1 );
function church_admin_logged_in_prayer($content)
{
    global $post;
    if(!church_admin_is_post_type('prayer-requests')) return $content;
    $private=get_option('church-admin-private-prayer-requests');
    if(!empty($private))
    {
        if(!is_user_logged_in()){
            $content=wp_login_form(array('echo'=>FALSE) );
		    $content.='<a href="'.esc_url( wp_lostpassword_url( get_permalink() ) ).'" alt="'.__( 'Lost Password', 'church-admin' ).'">'.__( "I've forgotten my password", 'church-admin' ).'</a></p></div>';
            return $content;
        }
        else
        {
            return $content;
        }
    }

}
*/
/******************************************************************************************************************************
*
* Show a submit prayer requests form at the top of the archive
*
******************************************************************************************************************************/
$theme = wp_get_theme(); // gets the current theme

if ( 'Avada' == $theme->name || 'Avada' == $theme->parent_theme ) {
    add_action('avada_before_main_container', 'church_admin_draft_prayer_request');
	define('CA_PRY_STYLE','style="min-width:80vw;"');
}
elseif ( 'The7' == $theme->name || 'The7' == $theme->parent_theme ) {
    add_action('presscore_before_loop', 'church_admin_draft_prayer_request');
}
elseif( 'Omega' == $theme->name || 'Omega' == $theme->parent_theme )  {
    
    add_action('omega_before_content', 'church_admin_draft_prayer_request');
}
elseif(has_action('church_admin_theme_before_loop') )
{
    add_action('church_admin_theme_before_loop', 'church_admin_draft_prayer_request');
}
elseif(has_action('fusion_blog_shortcode_before_loop') )
{
    add_action('fusion_blog_shortcode_before_loop', 'church_admin_draft_prayer_request');
}
else{
add_action('loop_start', 'church_admin_draft_prayer_request');
}

function church_admin_draft_prayer_request( $content)
{
    global $wpdb,$church_admin_prayer_request_success;
    
		if(is_post_type_archive('prayer-requests')&& is_archive() )
        {
			$private=get_option('church-admin-private-prayer-requests');
			//only show form if not private or logged in
			if (!$private ||(is_user_logged_in() && $private) )
			{
				$out='';

                if ( empty( $_POST['save_prayer_request'] )&&empty( $_POST['non_spammer'] )||!wp_verify_nonce( $_POST['non_spammer'],'prayer-request') )
                {
                        $out.='<div class="church-admin-prayer-request alignwide" ';
                        if(defined('CA_PRY_STYLE') ) $out.= CA_PRY_STYLE;
                        $out.='><h3>'.__('Submit a prayer request','church-admin').'</h3>';
                        $message=get_option('church_admin_prayer_request_message');
                        if(!empty( $message) )$out.='<p>'. wp_kses_post( $message).'</p>';
                        $out.='<form action="" method="POST">';
                    
                        $out.='<div class="church-admin-form-group"><label>'.__('Title','church-admin').'</label><input type="text" name="request_title" class="church-admin-form-control"></div>';
                        $out.='<div class="church-admin-form-group"><label>'.__('Prayer request','church-admin').'</label><textarea name="request_content" class="church-admin-form-control" style="height:100px"></textarea></div>';
                        $out.='<div id="spam-proof">&nbsp;</div>';
                        $out.='<div class="church-admin-form-group"><input type="hidden" value="TRUE" name="save_prayer_request"/><input type="submit" value="'.__('Save','church-admin').'"/></div>';

                        $out.='</form></div>';
                        $nonce=wp_create_nonce('prayer-request');
                        $out.='<script>jQuery(document).ready(function( $) {var content="<div class=\"form-check\"><label>'.__('Check box if not a spammer','church-admin').'<input type=\"checkbox\" name=\"non_spammer\" value=\"'.esc_attr($nonce).'\"/></label></div>"; $("#spam-proof").html(content);});</script>';
                }
                else{
                    $out=$church_admin_prayer_request_success;
                }
                echo $out;
            }
		}

}
add_action('loop_start', 'church_admin_draft_act_of_courage');

function church_admin_draft_act_of_courage( $content)
{
    global $wpdb,$church_admin_acts_success;

		if(is_post_type_archive('acts-of-courage') )
    {
			$private=get_option('church-admin-private-acts-of-courage');
			//only show form if not private or logged in
			if (!$private ||(is_user_logged_in() && $private) )
			{
				$out='';

      	if ( empty( $_POST['save_acts_request'] )&&empty( $_POST['non_spammer'] )||!wp_verify_nonce( $_POST['non_spammer'],'acts-of-courage') )
      	{
					$out.='<h3>'.__('Submit an act of courage','church-admin').'</h3>';
					$message=get_option('church-admin-acts-of-courage-message');
					if(!empty( $message) )$out.='<p>'. wp_kses_post( $message).'</p>';
        	$out.='<form action="" method="POST">';
        	$out.='<table class="form-table"><tbody>';
        	$out.='<tr><th scope="row">'.__('Title','church-admin').'</th><td><input type="text" name="request_title"></td></tr>';
        	$out.='<tr><th scope="row">'.__('Your act of courage','church-admin').'</th><td><textarea name="request_content"></textarea></td></tr>';
					$out.='<tr id="spam-proof">&nbsp;</td></tr>';
					$out.='<tr><td cellspacing=2><input type="hidden" value="TRUE" name="save_act_of_courage_request"/><input type="submit" value="'.__('Save','church-admin').'"/></td></tr></table>';

					$out.='</form>';
					$nonce=wp_create_nonce('acts-of-courage');
					$out.='<script>jQuery(document).ready(function( $) {var content="<th scope=\"row\">'.__('Check box if not a spammer','church-admin').'</th><td><input type=\"checkbox\" name=\"non_spammer\" value=\"'.esc_attr($nonce).'\"/></td></tr>"; $("#spam-proof").html(content);});</script>';
				}
				else{
                    $out = $church_admin_acts_success;
                }
      	echo $out;
			}
		}

}
/****************************************************************************
*
*	From 1.2800 register front end scripts early then enqueue on shortcode process
*
*****************************************************************************/
add_action( 'wp_enqueue_scripts', 'church_admin_register_frontend_scripts' );
add_action( 'admin_enqueue_scripts', 'church_admin_register_frontend_scripts' );
function church_admin_register_frontend_scripts() {
    global $church_admin_version,$post;
    
    //Prayer requests needs jQuery for form
    if(is_post_type_archive('prayer-requests') )wp_enqueue_script('jquery');

    
    wp_register_script('ca-draganddrop', plugins_url( '/', __FILE__ ) . 'includes/draganddrop.js', array( 'jquery' ) , filemtime(plugin_dir_path(__FILE__ ).'includes/draganddrop.js'),TRUE);
    wp_register_script('church-admin-form-case-enforcer',plugins_url( '/', __FILE__ ) . 'includes/jQuery.caseEnforcer.min.js',array( 'jquery' ),FALSE, TRUE);
    wp_register_script('church-admin-giving-form',plugins_url( '/', __FILE__ ) . 'includes/giving.js',array( 'jquery' ),FALSE, TRUE);
    wp_register_script('church-admin-event-booking',plugins_url( '/', __FILE__ ) . 'includes/event-booking.js',array( 'jquery' ),FALSE, TRUE);
	wp_register_script('church-admin-calendar-script',plugins_url( '/', __FILE__ ) . 'includes/calendar.js',array( 'jquery' ),FALSE, TRUE);
	wp_register_script('church-admin-calendar',plugins_url( '/', __FILE__ ) . 'includes/jQueryCalendar.js',array( 'jquery' ),FALSE, TRUE);
	wp_register_script( 'jquery-ui-datepicker',plugins_url('/', __FILE__) . 'includes/jquery-ui.min.js',array('jquery'),NULL );
	if(!empty( $_GET['page'] ) && $_GET['page']=='church_admin/index.php')wp_enqueue_script( 'google-charts','https://www.gstatic.com/charts/loader.js',NULL,FALSE,FALSE);
    $wp_scripts = wp_scripts();
    //Only enqueue jQuery UI styling on pages/post with certain blocks/shortcodes 
    if( is_admin()
        ||  has_shortcode('register',$post)
        ||has_shortcode('basic-register',$post)
        ||has_block('register',$post)
        ||has_block('basic-register',$post)
    )
    {
        wp_enqueue_style('church-admin-ui-css','https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css',false,$church_admin_version,false);
    }
    /****************
     * Podcast
     ***************/
    wp_register_script('ca_podcast_audio_use',plugins_url('/', __FILE__ ) . 'includes/audio.use.js' , array( 'jquery' ) ,$church_admin_version, TRUE);
	wp_register_script( 'jquery-ui-datepicker','','',NULL );
	wp_register_script('church_admin_form_clone',plugins_url('/', __FILE__ ) . 'includes/jquery-formfields.js', array( 'jquery' ) ,FALSE, TRUE);
	//fix issue caused by some "premium" themes, which call google maps w/o key on every admin page. D'uh!
 	wp_dequeue_script('avia-google-maps-api');
	//now enqueue google map api with the key
	$src = 'https://maps.googleapis.com/maps/api/js';
	$key='?key='.get_option('church_admin_google_api_key').'&callback=Function.prototype';
	wp_register_script( 'church_admin_google_maps_api',$src.$key, array() ,FALSE);
	wp_register_script('church_admin_map', plugins_url('/', __FILE__ ) . 'includes/google_maps.js', array( 'jquery' ) ,filemtime(plugin_dir_path(__FILE__ ).'includes/google_maps.js'),FALSE);
	wp_register_script('church_admin_map_script', plugins_url('/', __FILE__ ) . 'includes/maps.js', array( 'jquery' ) ,filemtime(plugin_dir_path(__FILE__ ).'includes/maps.js'),FALSE);
    wp_register_script('church_admin_sg_map_script', plugins_url('church-admin/includes/smallgroup_maps.js',dirname(__FILE__) ), array( 'jquery' ) ,filemtime(plugin_dir_path(__FILE__ ).'includes/smallgroup_maps.js'));
	wp_register_script('jquery-ui-sortable','','',NULL );
    //google graph needs to be called early and in header, didn't like being registered and then enqueued later
	wp_register_script('church_admin_google_graph_api','https://www.google.com/jsapi', array( 'jquery' ) ,FALSE, FALSE);
	
	
}

add_action('wp_head','church_admin_ajaxurl');
function church_admin_ajaxurl()
{
	$ajax_nonce = wp_create_nonce("church_admin_mp3_play");
	?>
	<script type="text/javascript">
		var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
		var security= '<?php echo $ajax_nonce; ?>';
	</script>
	<?php
}
add_action('wp_enqueue_scripts', 'church_admin_init');
add_action('admin_enqueue_scripts', 'church_admin_init',9999);//adding withlow priority to be last to call google maps api
/**
 *
 * Initialises js scripts and css
 *
 * @author  Andy Moyle
 * @param    null
 * @return
 * @version  0.1
 *
 */
function church_admin_init()
{
	if(!empty( $_COOKIE['churchAdminBlur'] ) )wp_enqueue_style( 'church-admin-blur', plugins_url('includes/blur.css',__FILE__ ) ,'',NULL);
	
    //This function add scripts as needed
    
	//wp_enqueue_script('common','','',NULL);
	//wp_enqueue_script('wp-lists','','',NULL);
	//wp_enqueue_script('postbox','','',NULL);
    wp_register_script('church_admin_google_graph_api','https://www.google.com/jsapi', array( 'jquery' ) ,FALSE, FALSE);
	//wp_enqueue_style( 'dashicons' ); - added to style.new.css for less calls.
   

	if(!empty( $_POST['church_admin_search'] ) )church_admin_editable_script();



	if(isset( $_GET['action'] ) )
	{
		switch( $_GET['action'] )
		{
            case 'edit-ministry':
            case 'edit-subunit':
            case 'settings':
            case'people':
            case 'edit_ministry':
            case'view_ministry':
            case'church_admin_member_type':
            case 'send-sms':
            case'twilio-replies':
            case 'app-settings':
                church_admin_autocomplete_script();
            break;
            case 'edit-calendar':
            case 'add-calendar':
            case 'podcast-settings':
                church_admin_media_uploader_enqueue();
                church_admin_date_picker_script();
            break;
			case'church_admin_add_calendar':
            case 'add-calendar':
            case 'view-rota':
            case 'rota':
            case'church_admin_series_event_edit':   
            case'church_admin_single_event_edit':
            case 'show-attendance':
            case'edit_attendance':
            case'church_admin_new_edit_calendar':
            case 'edit-calendar':
            case'edit_kidswork':
            case 'add-attendance':
            case 'weeks-attendance':
            case 'individual-attendance':
            case 'individual-attendance-csv':
            case'individual_attendance':
            case 'csv-rota':
            case 'import-ics':
			case'giving-csv':
            case'edit-service':
            case'add-event':
            case'edit_safeguarding':
            case 'rota':
            case 'church_admin_rota_list':
            case 'add-three-months':
			case 'edit_event':
            case 'edit_ticket_type':
            case 'bulk-bible-readings':
            case 'series-event-edit':
             case 'single-event-edit':   
                church_admin_date_picker_script();break;
			case 'bulk_geocode':
			case 'bulk-geocode':	
				church_admin_google_map_api();
				wp_enqueue_script('ca_batch_geocode', plugins_url('/', __FILE__ ) . 'includes/batch_geocode.js', array( 'jquery' ) ,FALSE, TRUE);
			break;
			case 'services':case'attendance':church_admin_date_picker_script();church_admin_frontend_graph_script();break;
			case'church_admin_cron_email':
				church_admin_debug('Cron fired:'.date('Y-m-d h:i:s')."/r/n");
				church_admin_bulk_email();exit();
			break;
			case 'remove-queue':check_admin_referer('remove-queue');church_admin_remove_queue();break;
			case'send-email':case'church_admin_send_email':church_admin_email_script();church_admin_autocomplete_script();church_admin_date_picker_script();break;
			case'edit_resend':church_admin_email_script();church_admin_autocomplete_script();church_admin_date_picker_script();break;
			case'resend_new':church_admin_email_script();church_admin_autocomplete_script();break;
			case'resend_email':church_admin_email_script();church_admin_autocomplete_script();break;
			case'church_admin_send_sms':church_admin_email_script();church_admin_autocomplete_script();break;
			case'delete_small_group':
                church_admin_sg_map_script();
                church_admin_autocomplete_script();
            break;
			case'church_admin_search';church_admin_editable_script();break;
			//calendar
			case'church_admin_add_category':
			case'church_admin_edit_category':
            case 'edit-category':
                church_admin_farbtastic_script();
            break;

            case 'edit_bubble_booking':case 'add_bubble_booking':
                wp_enqueue_script('church-admin-form-case-enforcer',plugins_url( '/', __FILE__ ) . 'includes/jQuery.caseEnforcer.min.js',array( 'jquery' ),FALSE, TRUE);
            break;
         

            case 'small_groups':
            case'smallgroups-cleanup':
                    church_admin_sortable_script();
					church_admin_form_script();
					church_admin_autocomplete_script();
					$key=get_option('church_admin_google_api_key');
					if(!empty( $key) )church_admin_sg_map_script();
			break;
            case 'add-service':
            case 'edit-service':
			case 'edit_service':church_admin_form_script();church_admin_date_picker_script();break;
            case 'edit-site':
            case 'edit_site':
                church_admin_form_script();
                church_admin_media_uploader_enqueue();
        
                $key=get_option('church_admin_google_api_key');
                if(!empty( $key) )
                {
                    church_admin_map_script();	
                }	
			break;
            
			case 'edit_small_group':
            case 'edit-group':	
            case 'add-group':	
						//church_admin_form_script();
						church_admin_autocomplete_script();
						church_admin_media_uploader_enqueue();
						wp_enqueue_script('ca-draganddrop');
						$key=get_option('church_admin_google_api_key');
						if(!empty( $key) )
						{
							church_admin_map_script();
							church_admin_sg_map_script();	
						}
			break;
			case 'small_groups': 			
						$key=get_option('church_admin_google_api_key');
						if(!empty( $key) )
						{
							church_admin_map_script();
							church_admin_sg_map_script();	
						}
			break;
			case'classes':church_admin_date_picker_script();church_admin_frontend_graph_script();break;
			case'view_class':church_admin_date_picker_script();church_admin_autocomplete_script();church_admin_frontend_graph_script();break;

			case'edit-class':
            case'edit_class':
             case 'edit-gift':
            case 'edit_hope_team':
            case 'edit_file':
            case 'permissions':
            case'file_add':
            case'church_admin_permissions':    
                church_admin_date_picker_script();church_admin_autocomplete_script();
            break;
			//rota
			case'rota';church_admin_editable_script();break;
            case 'church_admin_edit_rota_settings':
                church_admin_autocomplete_script();
            break;
            case'edit_rota';church_admin_editable_script();church_admin_autocomplete_script();church_admin_date_picker_script();break;
			case'list';church_admin_editable_script();break;
            case'church_admin_rota_settings_list':
            case 'app':
            case'church_admin_edit_rota_settings':
                church_admin_sortable_script();break;
			
			//directory
            case 'people-map':
                church_admin_map_script();
            break;
            case 'smallgroups-map':church_admin_sg_map_script();break;
			case'new_household':
            case 'add-household':
            case'church_admin_new_household':
                church_admin_form_script();
                church_admin_map_script();
                
                church_admin_media_uploader_enqueue();
                church_admin_date_picker_script();
            break;
			case'edit_household':
			case'view_household':
            case 'display-household':
            case 'display_household':
            case 'upload-mp3':
				church_admin_map_script();
                church_admin_date_picker_script();
                wp_enqueue_script('ca-draganddrop');
    
			break;
			case 'edit_people':
				church_admin_form_script();
				church_admin_date_picker_script();
				church_admin_media_uploader_enqueue();
                church_admin_map_script();
                wp_enqueue_script('ca-draganddrop');
			break;
			case'app':
            case'edit_sermon_series':
                church_admin_media_uploader_enqueue();
                wp_enqueue_script('ca-draganddrop');
			break;
			
		
			case'church_admin_update_order': church_admin_update_order( $_GET['which'] );exit();break;
			case'get_people':church_admin_ajax_people(TRUE);break;
			case'people':case'edit_funnel':case'delete_funnel':church_admin_sortable_script();break;
            case 'upload-mp3':church_admin_date_picker_script();church_admin_autocomplete_script();break;
      
		}
	}
    elseif(isset( $_GET['page'] )&& $_GET['page']=='church_admin/index.php')
    {
        church_admin_date_picker_script();//needed on main menu page too
    }

}











/* Thumbnails */
add_action( 'after_setup_theme', 'ca_thumbnails' );
function ca_thumbnails()
{
        /**
 *
 * Add thumbnails for plugin use
 *
 * @author  Andy Moyle
 * @param    null
 * @return
 * @version  0.1
 *
 */
    add_theme_support( 'post-thumbnails' );
    if ( function_exists( 'add_image_size' ) )
    {
        add_image_size('ca-people-thumb',75,75);
        add_image_size('ca-address-thumb',150,150);
        add_image_size( 'ca-email-thumb', 300, 200 ); //300 pixels wide (and unlimited height)
        //add_image_size('ca-series-thumbnail',480,360);

    }

}
/* Thumbnails */
add_action( 'admin_enqueue_scripts','church_admin_public_css');
add_action('wp_enqueue_scripts','church_admin_public_css');
function church_admin_public_css()  {
    global $church_admin_version;
    wp_enqueue_style('Church-Admin',plugins_url('/', __FILE__ ) . 'includes/style.new.css',NULL,filemtime(plugin_dir_path( __FILE__ ).'includes/style.new.css' ),'all');
}
add_action('admin_head',"church_admin_colorscheme");
function church_admin_colorscheme()
{    
    //add the users selected admin colors
    global $_wp_admin_css_colors; 
    
    $current_color = get_user_option( 'admin_color' );
    
    if ( empty( $current_color) )  {$current_color='fresh';}
    $church_admin_colors = $_wp_admin_css_colors[$current_color];
    $styles='#church-admin-menu{background:'.esc_attr($church_admin_colors->colors[1]).';}'."\r\n";
    $styles.='.church-admin-top-menu.active .church-admin-top-menu-item{background:'.esc_attr($church_admin_colors->colors[2]).'}'."\r\n";
    $styles.='.church-admin-top-menu.inactive .church-admin-submenu{background:'.esc_attr($church_admin_colors->colors[0]).';}'."\r\n";
    $styles.='.church-admin-submenu.active{background:'.esc_attr($church_admin_colors->colors[0]).';}'."\r\n";
    wp_add_inline_style( 'Church-Admin', $styles );

}
add_action('wp_head', 'church_admin_public_header');
function church_admin_public_header()
{
    global $church_admin_version;
	echo"<!--
 
   ____ _                    _          _       _           _         ____  _             _       
  / ___| |__  _   _ _ __ ___| |__      / \   __| |_ __ ___ (_)_ __   |  _ \| |_   _  __ _(_)_ __  
 | |   | '_ \| | | | '__/ __| '_ \    / _ \ / _` | '_ ` _ \| | '_ \  | |_) | | | | |/ _` | | '_ \ 
 | |___| | | | |_| | | | (__| | | |  / ___ \ (_| | | | | | | | | | | |  __/| | |_| | (_| | | | | |
  \____|_| |_|\__,_|_|  \___|_| |_| /_/   \_\__,_|_| |_| |_|_|_| |_| |_|   |_|\__,_|\__, |_|_| |_|
                                                                                    |___/                   
\r\n";
    echo' Version: '.$church_admin_version.'-->
    <style>table.church_admin_calendar{width:';
    if(get_option('church_admin_calendar_width') )  {
        echo (int)get_option('church_admin_calendar_width').'px}';
    }else {echo'700px}';}
    echo'</style>';
}

//Build Admin Menus
add_action('admin_menu', 'church_admin_menus');
/**
 *
 * Admin menu
 *
 * @author  Andy Moyle
 * @param    null
 * @return
 * @version  0.1
 *
 */
function church_admin_menus()

{

    global $level;
    
    add_menu_page('church_admin:Administration', __('Church Admin','church-admin'),  'read', 'church_admin/index.php', 'church_admin_main',CA_ICON,98);
}

// Admin Bar Customisation
/**
 *
 * Admin Bar Menu
 *
 * @author  Andy Moyle
 * @param    null
 * @return
 * @version  0.1
 *
 */
function church_admin_admin_bar_render() {

 	global $wp_admin_bar;
 	// Add a new top level menu link
 	// Here we add a customer support URL link
	if(current_user_can('publish_posts') )
	{
			$wp_admin_bar->add_menu( array('parent' => false, 'id' => 'church_admin', 'title' => __('Church Admin','church-admin'), 'href' => admin_url().'admin.php?page=church_admin/index.php' ) );
			if(church_admin_level_check('Directory') )$wp_admin_bar->add_menu(array ('parent' => 'church_admin','id'=> 'household1','title'=> __('New Household','church-admin'),'href'=>wp_nonce_url(admin_url().'admin.php?page=church_admin/index.php&amp;section=people&action=add-household','add-household') ) );
			if(current_user_can('manage_options') )$wp_admin_bar->add_menu(array('parent' => 'church_admin','id' => 'church_admin_settings', 'title' => __('Settings','church-admin'), 'href' => admin_url().'admin.php?page=church_admin/index.php&action=settings' ) );
			$wp_admin_bar->add_menu(array('parent' => 'church_admin','id' => 'plugin_support', 'title' => __('Plugin Support','church-admin'), 'href' => 'http://www.churchadminplugin.com/support/' ) );
		}
}

// Finally we add our hook function
add_action( 'wp_before_admin_bar_render', 'church_admin_admin_bar_render' );




//main admin page function


function church_admin_main()
{
   


    global $wpdb,$church_admin_version;
	$user=wp_get_current_user();
    $frontpage=get_option('church-admin-frontpage-look'.$user->ID);
       //check look form
    if(!empty( $_POST['change-look'] ) )
    {
        if( $_POST['change-look']=='classic')  {$frontpage='classic';}
        else $frontpage='boxes';
        update_option('church-admin-frontpage-look'.$user->ID,$frontpage);
    }
	if ( empty( $frontpage) )
    {
        $frontpage='boxes';
        update_option('church-admin-frontpage-look'.$user->ID,$frontpage);

    }
  
    switch( $frontpage)
    {
        case 'classic':
            echo'<div class="church-admin-wrap"><!--church_admin_main-->';
            require_once( plugin_dir_path( __FILE__ ).'includes/admin.new.php');
            church_admin_front_admin();
            church_admin_check_user_in_directory();
            church_admin_classic_header();
            church_admin_detect_runtime_issues();
            church_admin_actions();
            if ( empty( $_GET['action'] ) && church_admin_level_check('Directory') )  {
                require_once( plugin_dir_path( __FILE__ ).'includes/directory.php');
                church_admin_people_main();
            }
            echo'</div><!-- END church-admin-content-->';
            echo'</div><!-- .church-admin-wrap -->';
        break;
        default:
        case 'boxes':
            echo'<div class="church-admin-wrap-new"><!--church_admin_main-->';
            if ( empty( $_GET['action'] ) )
            {
                 church_admin_boxes_look();
            }else 
            {
                echo'<div class="church-admin-content">';
                echo'<div id="church-admin-header">';
                church_admin_title();
                church_admin_change_look();
                echo'</div><!-- END church-admin-header-->';
                church_admin_actions();
                echo'</div><!-- END church-admin-content-->';
            }
            echo'</div><!-- .church-admin-wrap -->';
        break;
    }
   

   echo'<script>// shorthand no-conflict safe document-ready function
            jQuery(function( $) {

                $( document ).on( "click", ".notice-church-admin .notice-dismiss", function () {

                    var type = $( this ).closest( ".notice-church-admin" ).data( "notice" );

                    $.ajax( ajaxurl,
                    {
                        type: "POST",
                        data: {
                        action:"church-admin",
                        method: "dismissed_notice_handler",
                        type: type,
                        }
                    } );
                } );
            });</script>';
   
   
}
/**************************************************
 * 
 *  MAIN SHORTCODE FUNCTION
 * 
 *********************************************************/
function church_admin_shortcode( $atts, $content = null)
{
	
   
    //sort out true false issue where it gets evaluated as a string
   	foreach( $atts AS $key=>$value)
   	{
   		if( $value==='FALSE'||$value==='false')$atts[$key]=0;
   		if( $value==='TRUE'||$value==='true')$atts[$key]=1;
   	}

   	extract(shortcode_atts(array('allow_registrations'=>1,'vcf'=>1,'address_style'=>'one','loginform'=>1,'cache'=>3600,'upcoming'=>true,'playlist_id'=>NULL,'nowhite'=>FALSE,'start_date'=>NULL,'target'=>0,'fund'=>NULL,'monthly'=>TRUE,'cache'=>1,'pdf'=>1,'zoom'=>13,'class_id'=>NULL,'day_calendar'=>TRUE,'style'=>'new','kids'=>TRUE,'height'=>500,'width'=>900,"pdf_font_resize"=>TRUE,"updateable"=>1,"restricted"=>0,"loggedin"=>1,"type" => 'address-list','people_types'=>'all','site_id'=>0,'days'=>30,'year'=>date('Y'),'service_id'=>NULL,'photo'=>0,'category'=>NULL,'weeks'=>4,'ministry_id'=>NULL,'people_type_id'=>NULL,'member_type_id'=>NULL,'kids'=>1,'map'=>0,'series_id'=>NULL,'speaker_id'=>NULL,'file_id'=>NULL,'api_key'=>NULL,'facilities_id'=>NULL,'exclude'=>NULL,'today'=>FALSE,'first_initial'=>0,'show_age'=>FALSE,'show_years'=>FALSE,'most_popular'=>TRUE,'order'=>'DESC','people_types'=>NULL,'title'=>"",'event_id'=>NULL,'unit_id'=>NULL,'url'=>NULL,'comments_title'=>NULL,'url'=>NULL,'hide_views'=>FALSE,'mode'=>"households","max_fields"=>10,'admin_email'=>NULL,'no_address'=>NULL,'cols'=>3,'sermon_page'=>NULL,'initials'=>0,'allow_registration'=>TRUE,"email_text"=>'','background'=>FALSE,'colorscheme'=>'','custom_id'=>NULL,'links'=>TRUE,'name_style'=>'Full','how_many'=>9,'playnoshow'=>0,'show_email'=>0,'show_phone'=>0), $atts) );
    church_admin_posts_logout();
 
    //sanitize
    $allow_registrations = !empty($allow_registrations)?1:0;
    $vcf = !empty($vcf)?1:0;
    $show_email = !empty($show_email)?1:0;
    $show_phone = !empty($show_phone)?1:0;
    // TO DO further sanitization required...

    $out='<div class="church-admin-shortcode-output ';
    if(!empty( $colorscheme) )
    {
       switch( $colorscheme) 
       {
			case 'white':
				$out.='ca-background ';
			break;
			case 'bluegrey':
			default: 
				$out.=' ca-dark-mode-blue-grey ';
			break;
			case 'warmgrey':
				$out.=' ca-dark-mode-warm-grey ';
			break;
			case 'coolgrey':
				$out.=' ca-dark-mode-cool-grey ';
			break;
		}
    }
    if(!empty( $background) )$out.=' ca-background ';
    $out.='">';
    global $wpdb,$wp_query;

    	$upload_dir = wp_upload_dir();
		$path=$upload_dir['basedir'].'/church-admin-cache/';
    	//look to see if church directory is o/p on a password protected page
    	if(!empty( $wp_query->post->ID) )$pageinfo=get_page( $wp_query->post->ID);
    	//grab page info
    	//check to see if on a password protected page
    	if(!empty( $pageinfo)&& $pageinfo->post_password!=''&&isset( $_COOKIE['wp-postpass_' . COOKIEHASH] ) )
    	{
			$text = __('Log out of password protected posts','church-admin');
		//text for link
		$link = site_url().'?church_admin_logout=posts_logout';
		$out.= '<p><a href="' . esc_url( wp_nonce_url( $link, 'posts logout') ).'">' . esc_html( $text ). '</a></p>';
		//output logoutlink
    	}

    	//grab content
    	switch( $type)
    	{
            case 'ministry-rota':
                if(is_user_logged_in()){
                    require_once( plugin_dir_path( __FILE__ ).'includes/rota.new.php');
                    $out.=church_admin_edit_ministry_rota('service',$service_id);
                }
                else{
                    $out.=wp_login_form();
                }

            break;
            case 'not-logged-in':
            case 'not-logged-in':
                    if(!is_user_logged_in() )return $content;
            break;
            case 'logged-in':
            case 'logged-in':
                    if(is_user_logged_in() )return $content;
            break;
            case 'spiritual-gifts':
                require_once( plugin_dir_path( __FILE__ ).'display/spiritual-gifts.php');
				$out.=church_admin_spiritual_gifts( $admin_email);
            break;
			case'unit':
                require_once( plugin_dir_path( __FILE__ ).'display/units.php');
				$out.=church_admin_display_unit( $unit_id);
            break;
			case 'attendance':
				if(is_user_logged_in()&&church_admin_level_check('Directory') )
				{
					require_once( plugin_dir_path( __FILE__ ).'includes/individual_attendance.php');
					$out.=church_admin_individual_attendance();
				}
				else
				{
					$out.='<h3>'.__('Only logged in users with permission can use this feature','church-admin').'</h3>';
					$out.=wp_login_form(array('echo' => false) );
				}
			break;
			
			case 'volunteer':
				require_once( plugin_dir_path( __FILE__ ).'display/volunteer.php');
				$out.=church_admin_display_volunteer();
			break;
			case 'sessions': 
                require_once( plugin_dir_path( __FILE__ ).'includes/sessions.php');
				$out.=church_admin_sessions(NULL,NULL);
			break;
            case 'video':
                if(!empty( $url) )
                {
                    
                    $embed=church_admin_generateVideoEmbedUrl( $url);
                    $out.="\r\n<!-- CHURCH ADMIN VIDEO EMBED -->\r\n";
                    $out.='<div class="container-fluid no-padding">'."\r\n";
                    $out.='<div style="position:relative;padding-top:56.25%">'."\r\n";
                    $out.='<iframe class="ca-video" loading="lazy" style="position:absolute;top:0;left:0;width:100%;height:100%;" src="'.esc_url($embed['embed']).'" '."\r\n";
                    if(!empty( $embed['image'] ) )$out.='srcdoc="<style>*{padding:0;margin:0;overflow:hidden}html,body{height:100%}img,span{position:absolute;width:100%;top:0;bottom:0;margin:auto}span{height:1.5em;text-align:center;font:48px/1.5 sans-serif;color:white;text-shadow:0 0 0.5em black}</style><a href='.esc_url($embed['embed']).'?autoplay=1&mute=1><img src='.esc_url( $embed['image'] ) .' alt=Youtube><span class=ca-play>▶</span></a>" '."\r\n";
                    $out.='frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>'."\r\n";
                    $out.="</div>\r\n</div>\r\n";
                    $views=church_admin_youtube_views_api( $embed['id'] );
                    if(!empty( $views)&& empty( $hide_views) )$out.='<p>'.esc_html( sprintf(__('%1$s views','church-admin'),$views) ).'</p>';
                }
            break;
			case 'podcast':

                church_admin_podcast_script();
				require_once( plugin_dir_path( __FILE__ ).'display/sermon-podcast.php');
	            
                    $out.=church_admin_podcast_display( $series_id,$file_id,$exclude,$most_popular,$order,$nowhite);

			break;
            case 'sermons':
                require_once( plugin_dir_path( __FILE__ ).'display/new-sermon-podcast.php');
                $out.= church_admin_new_sermons_display($how_many,$nowhite,$playnoshow);
            break;
            case 'sermon-series':
				
				require_once( plugin_dir_path( __FILE__ ).'display/sermon-series.php');
	               $out.=church_admin_all_the_series_display( $sermon_page);

			break;  
            case 'single-sermon':
                wp_enqueue_script('ca_podcast_audio_use');
                require_once( plugin_dir_path( __FILE__ ).'display/sermon-podcast.php');
                if(!empty( $file_id) )  {$out.=church_admin_podcast_file_detail( $file_id,NULL);}else{$out.=esc_html( __('No file specified','church-admin') );}
            break;
            case 'player':
                wp_enqueue_script('ca_podcast_audio_use');
                require_once( plugin_dir_path( __FILE__ ).'display/sermon-podcast.php');
                if(!empty( $file_id) )  {$out.=church_admin_player( $file_id);}else{$out.=esc_html( __('No file specified','church-admin'));}
            break;
           
      case 'calendar':
            wp_enqueue_script('church-admin-calendar');//Jan 2020 version
			wp_enqueue_script('church_admin_calendar');
            $out.='<div class="church-admin-calendar">';
			if ( empty( $facilities_id)&& !empty( $pdf) )
			{
				$out.='<table><tr><td>'.__('Yearly Planner PDFs','church-admin').' </td><td>  <form name="guideform" action="'.esc_url($_SERVER['PHP_SELF']).'" method="get"><select name="guidelinks" onchange="window.location=document.guideform.guidelinks.options[document.guideform.guidelinks.selectedIndex].value"> <option selected="selected" value="">-- '.__('Choose a PDF','church-admin').' --</option>';
				for ( $x=0; $x<5; $x++ )
				{
					$y=date('Y')+$x;
					$out.='<option value="'.home_url().'/?ca_download=yearplanner&amp;yearplanner='.wp_create_nonce('yearplanner').'&amp;year='.(int)$y.'">'.(int)$y.__('Year Planner','church-admin').'</option>';
				}
				$out.='</select></form></td></tr></table>';
			}
			if( $style=='old'||!empty( $facilities_id) )
			{
            		require_once( plugin_dir_path( __FILE__ ).'display/calendar.php');
            		$out.=church_admin_display_calendar( $facilities_id);
            }
            else
            {
            	require_once( plugin_dir_path( __FILE__ ).'display/calendar.new.php');
            	//$out.=church_admin_new_calendar_display('day',$day_calendar);
                $out.=church_admin_display_new_calendar();
        	}
            $out.='</div>';
      break;
      case 'classes':
				wp_enqueue_script('jquery-ui-datepicker');
				require_once( plugin_dir_path( __FILE__ ).'display/classes.php');
        		$out.=church_admin_display_classes( $today,$allow_registration);
                $out.='<script type="text/javascript">jQuery(function( $)  {

                    $(".ca-class-toggle").click(function()  {
                            var id=this.id;
                            console.log(id);
                            $("."+id).toggle();
                        });

                    });</script>';
      break;
      case 'class':
				wp_enqueue_script('jquery-ui-datepicker');
			  	require_once( plugin_dir_path( __FILE__ ).'display/classes.php');
        		$out.=church_admin_display_class( $class_id,TRUE,$allow_registration);
               
      break;
    case 'facilities':
                require_once( plugin_dir_path( __FILE__ ).'display/calendar.php');
            	$out.=church_admin_display_calendar( $facilities_id);
    break;
    case 'facility-booking':
        //require_once( plugin_dir_path( __FILE__ ).'display/facility-bookings.php');
       
        //$out.=church_admin_facility_booking( $facilities_id);
    break;
    case 'names':
				if ( empty( $loggedin)||is_user_logged_in() )
				{
					require_once( plugin_dir_path( __FILE__ ).'/display/names.php'); $out.=church_admin_names( $member_type_id,$people_types);
				}
				else //login required
				{
					$out.='<div class="login"><h2>'.esc_html( __('Please login','church-admin') ).'</h2>'.wp_login_form(array('echo'=>FALSE) ).'</div>'.'<p><a href="'.esc_url( wp_lostpassword_url( get_permalink() ) ).'" title="Lost Password">'.esc_html( __('Help! I don\'t know my password','church-admin') ).'</a></p>';
				}
			break;

	case 'calendar-list':
            	require_once( plugin_dir_path( __FILE__ ).'/display/calendar-list.php'); $out.=church_admin_calendar_list( $days,$category);
    break;
    case 'event_booking':
            case 'event':
            case 'events':
           wp_enqueue_script('church-admin-event-booking'); require_once( plugin_dir_path( __FILE__ ).'/display/events.php');
            $out.=church_admin_event_bookings_output( $event_id);
      break;  
      
        case 'recent':
            $access=TRUE;
      		if(is_user_logged_in() )
      		{
      			
      			$current_user=wp_get_current_user();
      			$people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE user_id="'.(int)$current_user->ID.'"');
      			$restrictedList=get_option('church-admin-restricted-access');
      			if(is_array( $restrictedList)&&in_array( $people_id,$restrictedList) )$access=FALSE;
      		}    
			if ( empty( $loggedin)||is_user_logged_in() && $access)
			{
				require_once( plugin_dir_path( __FILE__ ).'includes/recent.php');
				$out.=church_admin_recent_display( $weeks,$member_type_id);
			}
			else //login required
			{
				if(!$access && is_user_logged_in()  )$out.='<div class="notice notice-warning inline">'.esc_html( __("You haven't been granted access to this infromation",'church-admin' ) ) .'</div>';
                $out.='<div class="login"><h2>'.__('Please login','church-admin').'</h2>'.wp_login_form(array('echo'=>FALSE) ).'</div>'.'<p><a href="'.esc_url( wp_lostpassword_url( get_permalink() ) ).'" title="Lost Password">'.esc_html(__('Help! I don\'t know my password','church-admin')).'</a></p>';
			}
			break;
            case 'phone-list':
                $access=TRUE;
                if(is_user_logged_in() )
      		    {
      			
                    $current_user=wp_get_current_user();
                    $people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE user_id="'.(int)$current_user->ID.'"');
                    $restrictedList=get_option('church-admin-restricted-access');
                    if(is_array( $restrictedList)&&in_array( $people_id,$restrictedList) )$access=FALSE;
      		    }
			     if ( empty( $loggedin)||is_user_logged_in() && $access)
			    { 
                    require_once( plugin_dir_path( __FILE__ ).'display/phone-list.php');
                     $out.=church_admin_frontend_phone_list( $people_type_id,$member_type_id);
                }
                else //login required
			     {
					if ( empty( $access) ) $out.='<h2>'.esc_html(__('You have not been granted access to the address list','church-admin')).'</h2>';
					else $out.='<div class="login"><h2>'.esc_html(__('Please login','church-admin')).'</h2>'.wp_login_form(array('echo'=>FALSE) ).'</div>'.'<p><a href="'.esc_url(wp_lostpassword_url(get_permalink() )).'" title="Lost Password">'.esc_html( __('Help! I don\'t know my password','church-admin') ).'</a></p>';
                }
            break;
            case 'custom-field':
            case 'custom-fields':
                $out.='<div class="church-admin-custom-field">';
                require_once( plugin_dir_path( __FILE__ ).'display/custom-fields.php');
                $out.=church_admin_display_custom_field( $days,$show_years,$custom_id);
                $out.='</div>'; 
            break;
            case 'address-list':
            case'addresslist':
            case 'directory':
      		    //assumed no access allowed
                 $out.='<div class="church-admin-directory">'; 
                $access=FALSE;
                if( $loggedin)
                {
                   if(!is_user_logged_in() ) 
                   {
                      $out.='<div class="login"><h2>'.esc_html( __( 'Please login', 'church-admin' ) ).'</h2>'.wp_login_form(array('echo'=>FALSE) ).'</div>'.'<p><a href="'.wp_lostpassword_url(get_permalink() ).'" title="Lost Password">'.__('Help! I don\'t know my password','church-admin').'</a></p>';
                      $out.='</div>';
                      return $out;
                   }
                   if(!empty( $member_type_id) )
                    {
                        if( $member_type_id=='All'||$member_type_id=='all'||$member_type_id=='#')
                        {
                            $access=true;
                        }
                        else
                        {
                            $current_user=wp_get_current_user();
                            $mtArray=explode(",",$member_type_id);
                            church_admin_debug("mtArray");
                            church_admin_debug(print_r( $mtArray,TRUE) );
                            $mt_id=$wpdb->get_var('SELECT member_type_id FROM '.CA_PEO_TBL.' WHERE user_id="'.(int)$current_user->ID.'"');
                            church_admin_debug('User mt '.$mt_id);
                            if ( empty( $mt_id) )return'<p>'.__('Your login does not permit viewing the address list','church-admin').'</p>';
                    
                            if(!church_admin_level_check('Directory')&&!empty( $mt_id)&&!in_array( $mt_id,$mtArray) )  {
                                $out.='<p>'.__('Your login does not permit viewing the address list','church-admin').'</p>';
                                $out.='</div>';
                                return $out;
                            }
                            $access=TRUE;
                        }
                    }   
                    if ( empty( $member_type_id) )$access=true;
                    
                    
                    if(!church_admin_level_check('Directory')&&is_array( $restrictedList)&&in_array( $people_id,$restrictedList) ){
                        return'<p>'.esc_html( __('Your login does not permit viewing the address list', 'church-admin' ) ).'</p>'; 
                    }
                    if(church_admin_level_check('Directory') )$access=TRUE;   
                }
                else
                {
                    //open access
                    $access=TRUE;
                }
      		
			if(!empty( $access) )
			{
				if(!empty( $pdf) )
				{
                    $out.='<div class="church-admin-address-pdf-links">';
					switch( $pdf)
					{
						case '2':
							$out.='<p><a href="'.home_url().'/?ca_download=addresslist&amp;addresslist='.wp_create_nonce('address-list','address-list').'&amp;title='.urlencode( $title).'&amp;loggedin='.$loggedin.'&amp;pdfversion=2&amp;member_type_id='.$member_type_id.'" target="_blank"> '.__('PDF version','church-admin').'</a></p>';
						break;
                        case 'multi':

							$out.='<p><a  target="_blank" href="'.home_url().'/?ca_download=addresslist-family-photos&amp;address_style=multi&amp;loggedin='.$loggedin.'&amp;title='.urlencode( $title).'&amp;kids='.$kids.'&amp;addresslist='.wp_create_nonce('address-list','address-list' ).'&amp;member_type_id='.$member_type_id.'">'.__('PDF version','church-admin').'</a></p>';
						break;
						default:
                        case 1:    
							$out.='<p><a  target="_blank" href="'.home_url().'/?ca_download=addresslist-family-photos&amp;loggedin='.$loggedin.'&amp;title='.urlencode( $title).'&amp;kids='.$kids.'&amp;addresslist='.wp_create_nonce('address-list','address-list' ).'&amp;member_type_id='.$member_type_id.'">'.__('PDF version','church-admin').'</a></p>';
						break;

					}
                    $out.='</div>';
				}
				if( $style=='old')
				{
                    require_once( plugin_dir_path( __FILE__ ).'display/address-list.old.php');
            		$out.=church_admin_frontend_directory( $member_type_id,$map,$photo,$api_key,$kids,$site_id,$updateable,$address_style);
	   			}
                else
                {
                    require_once( plugin_dir_path( __FILE__ ).'display/address-list.php');
                    $out.=church_admin_frontend_directory( $member_type_id,$map,$photo,$api_key,$kids,$site_id,$updateable,$first_initial,0,$vcf,$address_style);
                    //$out.=church_admin_frontend_directory( $member_type_id,$map,$photo,$api_key,$kids,$site_id,$updateable,$first_initial,$cache,$address_style);
                    //$out.=' <p><a href="'.get_permalink().'?ca_refresh=TRUE">'.__("Refresh",'church-admin').'</a></p>';
        	    }
                $out.='</div>';
            }
            else{ $out.='<h2>'.__('You have not been granted access to the address list','church-admin').'</h2>';}
				
      break;
        case 'bible-readings':
        case 'bible-reading':
            require_once( plugin_dir_path( __FILE__ ).'display/bible-readings.php' );
            $out.=church_admin_bible_reading_shortcode();    
        break;
       
        case 'hello':
            if(is_user_logged_in() )
            {
                $user=wp_get_current_user();
                $name=$wpdb->get_var('SELECT first_name FROM '.CA_PEO_TBL.' WHERE user_id="'.(int)$user->ID.'"');
                if( !empty( $name) ){
                    $out.=esc_html( sprintf(__('Welcome back %1$s', 'church-admin' ), $name ) );
                }
            }
        break;
        case 'small-groups-list':
				wp_enqueue_script('church_admin_google_maps_api');
				wp_enqueue_script('church_admin_sg_map_script');
                
            	require_once( plugin_dir_path( __FILE__ ).'/display/small-group-list.php');
            	$out.= church_admin_small_group_list( $map,$zoom,$photo,$loggedin,$title,$pdf,$no_address);
      break;
    case 'my-group':
                require_once( plugin_dir_path( __FILE__ ).'/display/my-group.php');
                $out.=church_admin_my_group();
    break;
        case 'small-group-signup':
            require_once( plugin_dir_path( __FILE__ ).'/display/small-group-signup.php');
        	$out.=church_admin_smallgroup_signup( $title,$people_types);
        break;
	case 'small-groups':
					wp_enqueue_script('church_admin_google_maps_api');
					wp_enqueue_script('church_admin_sg_map_script');
	        		require_once( plugin_dir_path( __FILE__ ).'/display/small-groups.php' );
          			$out.= church_admin_frontend_small_groups( $member_type_id,$restricted);
      break;
    case 'map':
        $out.=church_admin_map_shortcode( $atts, $content);
    break;
    case 'shortcode-generator':
        
        require_once( plugin_dir_path( __FILE__ ).'includes/shortcode-generator.php' );
        $out.=church_admin_shortcode_generator();
    break;
    case 'register':
    case 'basic-register':
                wp_enqueue_script('ca-draganddrop');
                wp_enqueue_script('jquery-ui-datepicker');
                wp_enqueue_script('church_admin_map_script');
                $out.=church_admin_register( $atts, $content);
    break;
      case 'ministries':
            	require_once( plugin_dir_path( __FILE__ ).'/display/ministries.php');
            	$out.=church_admin_frontend_ministries( $ministry_id,$member_type_id);
      break;
      case 'my_rota':case 'my-rota':
				if ( empty( $loggedin)||is_user_logged_in() )
				{
            	require_once( plugin_dir_path( __FILE__ ).'/display/rota.php');
            	$out.=church_admin_my_rota();
				}
				else //login required
				{
					$out.='<div class="login"><h2>'.esc_html( __('Please login','church-admin') ).'</h2>'.wp_login_form(array('echo'=>FALSE) ).'</div>'.'<p><a href="'.esc_url( wp_lostpassword_url(get_permalink() ) ).'" title="Lost Password">'.esc_html( __('Help! I don\'t know my password','church-admin') ).'</a></p>';
				}
			break;
	case 'rota':
            if ( empty( $loggedin)||is_user_logged_in() )
            {
                require_once( plugin_dir_path( __FILE__ ).'/display/rota.php');
                if(!empty( $_REQUEST['rota_date'] ) )  {$date=$_REQUEST['rota_date'];}else{$date=date('Y-m-d');}
                    //$out.=church_admin_front_end_rota( $service_id,$weeks,$pdf_font_resize,$date,$title,$initials);
                    $out.=church_admin_front_end_rota( $service_id,$weeks,FALSE,$date,$title,$initials,$links,$name_style);
            }
            else //login required
            {
                            $out.='<div class="login"><h2>'.__('Please login','church-admin').'</h2>'.wp_login_form(array('echo'=>FALSE) ).'</div>'.'<p><a href="'.esc_url( wp_lostpassword_url(get_permalink() ) ).'" title="Lost Password">'.esc_html( __('Help! I don\'t know my password','church-admin') ).'</a></p>';
            }
    break;
      case 'rolling-average':
      case 'weekly-attendance':
      case 'monthly-attendance':
      case 'rolling-average-attendance':
        case 'graph':
					wp_enqueue_script('jquery-ui-datepicker');
					wp_enqueue_script('church_admin_google_graph_api');
				if ( empty( $width) )$width=900;
				if ( empty( $height) )$height=500;
				if(!empty( $_POST['type'] ) )
				{
					switch( $_POST['type'] )
					{
						case'weekly':$graphtype='weekly';break;
						case'rolling':$graphtype='rolling';break;
						default:$graphtype='weekly';break;
					}
				}else{$graphtype='weekly';}
				if(!empty( $_POST['start'] ) )  {$start=$_POST['start'];}else{$start=date('Y-m-d',strtotime('-1 year') );}
				if(!empty( $_POST['end'] ) )  {$end=$_POST['end'];}else{$end=date('Y-m-d');}
				if(!empty( $_POST['service_id'] ) )  {$service_id=$_POST['service_id'];}else{$service_id='S/1';}

				require_once( plugin_dir_path( __FILE__ ).'display/graph.php');
				$out.=church_admin_graph( $graphtype,$service_id,$start,$end,$width,$height,FALSE);
			break;
			case 'birthdays':
			if ( empty( $loggedin)||is_user_logged_in() )
			{
				require_once( plugin_dir_path( __FILE__ ).'includes/birthdays.php');
                $out.=church_admin_frontend_birthdays( $member_type_id,$people_type_id, $days,$show_age,$show_email,$show_phone);
			}
			else //login required
			{
				$out.='<div class="login"><h2>'.__('Please login','church-admin').'</h2>'.wp_login_form(array('echo'=>FALSE) ).'</div>'.'<p><a href="'.esc_url( wp_lostpassword_url(get_permalink() ) ).'" title="Lost Password">'.esc_html( __('Help! I don\'t know my password','church-admin') ).'</a></p>';
			}

			break;
			case 'restricted':
				//restricts content to certain member_type_ids
				if(!is_user_logged_in() )
				{
					if(!empty( $loginform) )  { 
                            $out.='<div class="login"><h2>'.esc_html( __('Please login','church-admin') ).'</h2>'.wp_login_form(array('echo'=>FALSE) ).'</div>'.'<p><a href="'.wp_lostpassword_url(get_permalink() ).'" title="Lost Password">'.esc_html( __('Help! I don\'t know my password','church-admin') ).'</a></p>';
                    }
                    else{
                        $out.='<p>'.esc_html( __('Restricted content','church-admin') ).'</p>';
                    }
				}
                elseif(church_admin_user_member_level( $member_type_id) )  {
                    $out.=do_shortcode( $content);
                }
                else{
                    $out.=esc_html( __('You are not permitted to view this content','church-admin') );
                }
			break;
			case 'follow-up':
				if(is_user_logged_in()&& church_admin_level_check('Directory') )
				{
					require_once( plugin_dir_path( __FILE__ ).'includes/people_activity.php');
					return church_admin_recent_people_activity();
				}
				else{
                    $out.=esc_html( __( 'You are not permitted to view this content', 'church-admin' ) );
                }
			break;
			default:
				if ( empty( $loggedin)||is_user_logged_in() )
				{

						//$out.='<p><a href="'.home_url().'/?ca_download=addresslist&amp;addresslist='.wp_create_nonce('member'.$member_type_id ).'&amp;member_type_id='.$member_type_id.'">'.__('PDF version','church-admin').'</a></p>';
        	    require_once( plugin_dir_path( __FILE__ ).'display/address-list.php');
         	   $out.=church_admin_frontend_directory( $member_type_id,$map,$photo,$api_key,$kids,$site_id,$updateable);
					 }
					 else //login required
					 {
						 $out.='<div class="login"><h2>'.esc_html( __('Please login','church-admin') ).'</h2>'.wp_login_form(array('echo'=>FALSE) ).'</div>'.'<p><a href="'.esc_url( wp_lostpassword_url(get_permalink() ) ).'" title="Lost Password">'.esc_html( __('Help! I don\'t know my password','church-admin') ).'</a></p>';
					 }
       		break;
            case 'covid-prebooking':
            case'service-prebooking':
                
                if ( empty( $loggedin)||is_user_logged_in() )
                {
                    wp_enqueue_script('church-admin-form-case-enforcer');
                    require_once( plugin_dir_path( __FILE__ ).'display/covid-prebooking.php');
                    $out.=church_admin_covid_attendance( $service_id,$mode,$max_fields,$days,$admin_email,$email_text);
                }
                else
                {
                    $out.='<div class="login"><h2>'.esc_html( __('Please login','church-admin') ).'</h2>'.wp_login_form(array('echo'=>FALSE) ).'</div>'.'<p><a href="'.esc_url( wp_lostpassword_url(get_permalink() ) ).'" title="Lost Password">'.esc_html( __('Help! I don\'t know my password','church-admin') ).'</a></p>';
					  
                }
            break;
            case 'service-booking-pdf':
            case 'covid-prebooking-pdf':
                if(is_user_logged_in()&& (church_admin_level_check('Rota')||church_admin_level_check('Service') ))
                {
                    require_once( plugin_dir_path( __FILE__ ).'includes/covid-prebooking.php');
                    $out.=church_admin_service_booking_pdf_form();
                }
                else
                {
                    $out.='<div class="login"><h2>'.esc_html( __('Please login','church-admin') ).'</h2>'.wp_login_form(array('echo'=>FALSE) ).'</div>'.'<p><a href="'.esc_url( wp_lostpassword_url( get_permalink() ) ).'" title="Lost Password">'.esc_html( __('Help! I don\'t know my password','church-admin' ) ).'</a></p>';
					  
                }
            break;
            case 'how-much':
               
                require_once( plugin_dir_path( __FILE__ ).'display/giving.php');
                $out.=church_admin_fund_so_far( $fund,$start_date,$target);
            break;
            case 'giving':
               wp_enqueue_script('church-admin-giving-form'); 
                require_once( plugin_dir_path( __FILE__ ).'display/giving.php');
                $out.=church_admin_giving_form( $fund,$monthly);
            break;
            case 'pledge':
               
                require_once( plugin_dir_path( __FILE__ ).'display/pledge.php');
                $out.=church_admin_pledge_form();
            break;
            case 'contact-form':
                require_once( plugin_dir_path( __FILE__ ).'display/contact.php');
                $out.=church_admin_contact_public();
            break;
            case 'not-available':
                require_once( plugin_dir_path( __FILE__ ).'display/not-available.php');
                $out.= church_admin_not_available();
            break;
            case 'latest-youtube':
            case 'latest_youtube':
                require_once( plugin_dir_path( __FILE__ ).'display/latest-youtube.php');
                $out.= church_admin_latest_youtube( $playlist_id,$cache);
            break;
            

    	}

//output content instead of shortcode!
    $out.='</div>';
return $out;
}

add_shortcode('church_admin_unsubscribe','church_admin_unsubscribe');
function church_admin_unsubscribe()
{
	$out.='<p>'.__('This shortcode is deprecated','church-admin').'</p>';
	return $out;
}
add_shortcode('church_admin_recent','church_admin_recent');
function church_admin_recent( $atts, $content = null)
{
    extract(shortcode_atts(array('month'=>1), $atts) );
    require_once( plugin_dir_path( __FILE__ ).'includes/recent.php');
    $out.= church_admin_recent_display( $month);
	return $out;
}
add_shortcode("church_admin", "church_admin_shortcode");

add_shortcode("church_admin_map","church_admin_map_shortcode");
function church_admin_map_shortcode( $atts, $content = null)
{
    $out='';
    extract(shortcode_atts(array('zoom'=>13,'member_type_id'=>1,'small_group'=>1,'unattached'=>0,'loggedin'=>1,'width'=>"100%",'height'=>"1000px",'colorscheme'=>''), $atts) );
    global $wpdb;
    $out.='<div class="alignwide church-admin-shortcode-output ';
	if(!empty( $colorscheme) )  {

		switch( $colorscheme)
		{
			case 'white':
				$out.='ca-background ';
			break;
			case 'bluegrey':
			default: 
				$out.=' ca-dark-mode-blue-grey ';
			break;
		}
	}
	$out.='">';
    $out.= church_admin_map( $zoom,$member_type_id,$small_group,$unattached,$loggedin,$width,$height);
    $out.='</div>';
    return $out;
}
function church_admin_map( $zoom=13,$member_type_id=NULL,$small_group=1,$unattached=1,$loggedin=1,$width="100%",$height="500px")
{
	global $wpdb;
		$out='';
	if(defined("CA_DEBUG") )church_admin_debug("****************\r\n church_admin_map function");
	if ( empty( $loggedin)||is_user_logged_in() )
	{
		wp_enqueue_script('church_admin_google_maps_api');
		wp_enqueue_script('church_admin_map');

    
    $coords=church_admin_center_coordinates(CA_HOU_TBL);
    if(defined("CA_DEBUG") )church_admin_debug('Center coordinates'."\r\n".print_r( $coords,TRUE) );
    $out.='<div class="church-admin-member-map"><script type="text/javascript">var xml_url="'.site_url().'/?ca_download=address-xml&member_type_id='.esc_html( $member_type_id).'&small_group='.esc_html( $small_group).'&unattached='.esc_html( $unattached).'&address-xml='.wp_create_nonce('address-xml').'";';
    $out.=' var lat='.esc_html( $coords->lat).';';
    $out.=' var lng='.esc_html( $coords->lng).';';
    if ( empty( $zoom) )$zoom=13;
	$out.=' var zoom='.esc_html( $zoom).';';
	$out.=' var translation=["'.__('Small Groups','church-admin').'","'.__('Unattached','church-admin').'","'.__('In a group','church-admin').'","'.__('Group','church-admin').'"];';
    $out.='jQuery(document).ready(function()  {console.log("Ready to lead");
    load(lat,lng,xml_url,zoom,translation);});</script><div id="church-admin-member-map" style="width:'.esc_attr( $width ).';height:'.esc_attr( $height ).'"></div>';
    $out.='<div id="groups" ><p><img src="https://maps.google.com/mapfiles/kml/paddle/blu-circle.png"/>'.__('Small Group','church-admin').'<br /><img src="https://maps.google.com/mapfiles/kml/paddle/red-circle.png"/>'.__('Not in a small group','church-admin').'<br /><img src="https://maps.google.com/mapfiles/kml/paddle/grn-circle.png"/>'.esc_html( __('In a small Group','church-admin') ).'</p></div>';
    
	}
	else {
		$out.='<h3>'.esc_html( __('You need to be logged in to view the map','church-admin') ).'</h3>'.wp_login_form(array('echo'=>false) );
	}
    return $out;

}
add_shortcode("church_admin_register","church_admin_register");
function church_admin_register( $atts, $content = null)
{
 	   
    extract(shortcode_atts(array('allow_registrations'=>1,'admin_email'=>TRUE,'create_user'=>FALSE,'member_type_id'=>1,'allow'=>NULL,'background'=>FALSE,'exclude'=>NULL), $atts) );
    $noshow=$allowArray=array();
    if(!empty( $exclude) )
	{
		$noshow=explode(",",$exclude);
	}
    if(!empty( $allow) )
	{
		$allowArray=explode(",",$allow);
	}
    church_admin_debug( $allowArray,TRUE);
    require_once( plugin_dir_path( __FILE__ ).'includes/front_end_register.php');
    wp_enqueue_script('church_admin_google_maps_api');
    wp_enqueue_script('church_admin_map_script');
    wp_enqueue_script('ca-draganddrop');
    wp_enqueue_script('jquery-ui-datepicker');
    $out=church_admin_front_end_register( $member_type_id, $noshow, $admin_email, $allowArray, $allow_registrations);
    return $out;
}

function church_admin_posts_logout()
{
    if ( isset( $_GET['church_admin_logout'] ) && ( 'posts_logout' == $_GET['church_admin_logout'] ) &&check_admin_referer( 'posts logout' ) )
    {
	setcookie( 'wp-postpass_' . COOKIEHASH, ' ', time() - 31536000, COOKIEPATH );
	wp_redirect( wp_get_referer() );
	die();
    }
}


add_action( 'init', 'church_admin_posts_logout' );

//end of logout functions



add_action('init','church_admin_download');
function church_admin_download()
{
    global $wpdb;
	if(!empty( $_REQUEST['ca_download'] ) )
	{
		
	$member_type_id=NULL;
    if ( empty( $_REQUEST['addressType'] ) )  {$addressType='street';}
    else
    {
        switch( $_REQUEST['addressType'] )
        {
            default:
            case 'street':
                $addressType='street';
            break;
            case 'mailing':
                $addressType='mailing';
            break;
        
        }
    }
	if(!empty( $_REQUEST['loggedin'] ) )  {$loggedin=(int)$_REQUEST['loggedin'];}else{$loggedin=FALSE;}
	if(!empty( $_REQUEST['member_type_id'] ) )$member_type_id=$_REQUEST['member_type_id'];
	if(!empty( $_REQUEST['date'] ) )  {$date=$_REQUEST['date'];}else{$date=date('Y-m-d');}
	if(!empty( $_REQUEST['pdf_font_resize'] ) )  {$resize=$_REQUEST['pdf_font_resize'];}else{$resize=FALSE;}
	if(!empty( $_REQUEST['pdfversion'] ) )  {$pdfversion=$_REQUEST['pdfversion'];}else{$pdfversion=1;}
	if(!empty( $_REQUEST['service_id'] ) )  {$service_id=(int)$_REQUEST['service_id'];}else{$service_id=1;}
	if(!empty( $_REQUEST['rota_id'] ) )  {$rota_id=$_REQUEST['rota_id'];}else{$rota_id=NULL;}
	if(!empty( $_REQUEST['kids'] ) )  {$kids=$_REQUEST['kids'];}else{$kids=FALSE;}
	if(!empty( $_REQUEST['id'] ) )  {$id=$_REQUEST['id'];}else{$id=FALSE;}
    if(!empty( $_REQUEST['start_date'] ) )  {$start_date=$_REQUEST['start_date'];}else{$start_date=date('Y-m-d');}
    if(!empty( $_REQUEST['end_date'] ) )  {$end_date=$_REQUEST['end_date'];}else{$end_date=date('Y-m-d',strtotime("+3 years") );}
        if(!empty( $_REQUEST['showDOB'] ) )  {$showDOB=TRUE;}else{$showDOB=FALSE;}
	if(!empty( $_REQUEST['service_id'] ) )  {$service_id=$_REQUEST['service_id'];}else{$service_id=FALSE;}
        if(!empty( $_REQUEST['people_id'] ) )  {$people_id=$_REQUEST['people_id'];}else{$people_id=FALSE;}
        if(!empty( $_REQUEST['file_id'] ) )  {$file_id=$_REQUEST['file_id'];}else{$file_id=FALSE;}
        if(!empty( $_REQUEST['unit_id'] ) )  {$unit_id=$_REQUEST['unit_id'];}else{$unit_id=FALSE;}
        	if(!empty( $_REQUEST['date_id'] ) )  {$date_id=$_REQUEST['date_id'];}else{$date_id=FALSE;}
        if(!empty( $_REQUEST['fund'] ) )  {$fund=urldecode( $_REQUEST['fund'] );}else{$fund='All';}
	if(!empty( $_REQUEST['title'] ) )  {$title=$_REQUEST['title'];}else{$title=NULL;}
        if(!empty( $_REQUEST['initials'] ) )  {$initials=1;}else{$initials=0;}
    switch( $_REQUEST['ca_download'] )
    {
        case 'smallgroup-signup':
            require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
            church_admin_smallgroup_signup_pdf( $title);
        break;
        case 'sermon-notes':
            require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
            church_admin_sermon_notes_pdf( $file_id);
        break;
        case 'giving-csv':
            require_once( plugin_dir_path( __FILE__ ).'includes/csv.php');
             church_admin_giving_csv( $start_date,$end_date,$people_id);
            
        break;
        case 'gift-aid-csv':
            require_once( plugin_dir_path( __FILE__ ).'includes/csv.php');
             church_admin_gift_aid_csv( $start_date,$end_date,$fund);
            
        break;
        case 'service_booking_bubble_pdf':
            if(church_admin_level_check('Directory') )
            {
               require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
                church_admin_service_bubble_pdf( $_GET['date_id'],$_GET['service_id'],FALSE); 
            }
        break;
        case 'service_booking_pdf':
            
            if(church_admin_level_check('Directory') )
            {
               require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
                church_admin_service_booking_pdf( $_GET['date_id'],$_GET['service_id'],FALSE); 
            }
        break;
        case 'service_booking_csv':
            
            if(church_admin_level_check('Directory') )
            {
               require_once( plugin_dir_path( __FILE__ ).'includes/csv.php');
                church_admin_service_booking_csv( $_GET['date_id'],$_GET['service_id'],FALSE); 
            }
        break;
        case 'service_booking_alphabetical_pdf':
            
            if(church_admin_level_check('Directory') )
            {
               require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
                church_admin_service_booking_pdf( $_GET['date_id'],$_GET['service_id'],TRUE); 
            }
        break;
        case 'unit-pdf':
            require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
            church_admin_unit_pdf( $unit_id);
        break;
        case 'ical':
            require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
            church_admin_ical( $date_id);
            exit();
        break;
        case 'attendance-csv':
            require_once( plugin_dir_path( __FILE__ ).'includes/csv.php');
            church_admin_attendance_csv_output();
        break;
        case 'bookings_csv':
            if(wp_verify_nonce( $_REQUEST['_wpnonce'],'bookings_csv') )
            {
                require_once( plugin_dir_path( __FILE__ ).'includes/events.php');
                church_admin_bookings_csv( $_REQUEST['event_id'] );
            }
        break;
        case 'bookings_pdf':
            if(wp_verify_nonce( $_REQUEST['_wpnonce'],'bookings_pdf') )
            {
                require_once( plugin_dir_path( __FILE__ ).'includes/events.php');
                church_admin_bookings_pdf( $_REQUEST['event_id'] );
            }
        break;
        case 'tickets':
            
            require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
            if ( empty( $_REQUEST['booking_ref'] ) ) return __('Oops no booking reference','church-admin');
            church_admin_tickets_pdf( $_REQUEST['booking_ref'] );
        break;
        case 'pdf-filter':
            if(church_admin_level_check('Directory') )
            {
                //church_admin_debug("PDF filter");
                require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
                church_admin_filter_pdf();
            }else{
                echo esc_html(  __("You don't have permissions to do that",'church-admin') );
            }
        break;
    	case'kidswork-checkin':
			if(church_admin_level_check('Kidswork') )
			{
				require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
				church_admin_kidswork_checkin_pdf( $id,$service_id,$date);
			}else{
                echo esc_html(  __("You don't have permissions to do that",'church-admin') );
            }
		break;
		case'gdpr-pdf':
            if(church_admin_level_check('Directory') ){
                require_once( plugin_dir_path( __FILE__ ).'includes/directory.php');church_admin_gdpr_pdf();
            }
        break;
    	case'address-list':
        case'addresslist':
            //church_admin_debug('before nonce');
			if(wp_verify_nonce( $_GET['addresslist'],'address-list') )
			{		
                if ( !empty( $_REQUEST['address_style'] ) ){
                    switch( $_REQUEST['address_style'] )
                    {   
                        default:
                        case 'multi':
                            $address_style="multi";
                        break;
                        case'single':
                            $address_style='single';
                        break;
                    }
                }
                $member_type_id=!empty( $_REQUEST['member_type_id'] )?$_REQUEST['member_type_id']:0;
                require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');

					switch( $pdfversion)
                    {
                        case 1:default:     church_admin_address_pdf_v1( $member_type_id,$loggedin,$showDOB,urldecode( $title) ,$address_style);
                        break;
                        case 2:
                            //church_admin_debug('about to do pdf directory');
                            church_admin_address_pdf_v2( $member_type_id,$loggedin);
                        break;
                    }
                       
            }
        break;
        case'addresslist-family-photos':
			if(wp_verify_nonce( $_GET['addresslist'],'address-list') )
			{
				require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
                $member_type_id=!empty( $_REQUEST['member_type_id'] )?$_REQUEST['member_type_id']:0;
				church_admin_address_pdf_v1( $member_type_id,$loggedin,FALSE,$title);
			}else{
                echo'<p>'.esc_html(__('You can only download if coming from a valid link',' church-admin') ).'</p>';
            }
		break;	
        case'kidswork_pdf':
            require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
            church_admin_kidswork_pdf( $member_type_id,$loggedin);
        break;
		//Rotas
        case 'rota-csv':
        case'rotacsv':
        	require_once( plugin_dir_path( __FILE__ ).'includes/rota.new.php');
        	church_admin_rota_csv( $start_date,$end_date,$service_id,$initials);
        	
        break;
		case'rota':
		case'horizontal_rota_pdf':
			require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
			church_admin_new_rota_pdf( $service_id,$date);
			break;
		
		case 'hope_team_pdf':
            require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
            church_admin_hope_team_pdf();
        break;

		case'ministries_pdf':
			if(wp_verify_nonce( $_REQUEST['_wpnonce'],'ministries_pdf') )  {
				require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
				church_admin_ministry_pdf();
			}else{
				echo'<p>'.esc_html(__('You can only download if coming from a valid link',' church-admin') ).'</p>';
			}
		break;
        case 'csv-filter':
            if(church_admin_level_check('Directory') )
            {
                require_once( plugin_dir_path( __FILE__ ).'includes/csv.php');
                church_admin_people_csv();
            }
            else{
                echo esc_html( __("You don't have permissions to do that", 'church-admin' ) );
            }
        break;
   
		case 'people-csv':
				if(wp_verify_nonce( $_REQUEST['people-csv'],'people-csv') )
				{
					require_once( plugin_dir_path( __FILE__ ).'includes/csv.php');
					church_admin_people_csv();
				}
				else
				{
					echo'<p>'.esc_html(__('You can only download if coming from a valid link',' church-admin') ).'</p>';
				}
		break;
		case 'small-group-xml':
				if(wp_verify_nonce( $_REQUEST['small-group-xml'],'small-group-xml') )
				{

					require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
					church_admin_small_group_xml();
				}else{
                    echo'<p>'.esc_html(__('You can only download if coming from a valid link',' church-admin') ).'</p>';
                }
		break;
		case 'address-xml':
            $member_type_id=!empty( $_REQUEST['member_type_id'] )?$_REQUEST['member_type_id']:'#';
            $small_group=!empty( $_REQUEST['small_group'] )?1:0;
			require_once( plugin_dir_path(__FILE__).'includes/pdf_creator.php' );
            
			church_admin_address_xml( $member_type_id,$small_group);
			exit();
		break;
        case'cron-instructions':
            if ( wp_verify_nonce( $_GET['cron-instructions'], 'cron-instructions') )  {
                require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
                church_admin_cron_pdf();
            }
            else {
                echo'<p>'.esc_html(__('You can only download if coming from a valid link',' church-admin') ).'</p>';
                exit();
            }
        break;

        case'yearplanner':
            if ( wp_verify_nonce( $_REQUEST['yearplanner'], 'yearplanner' ) )  {
                require_once ( plugin_dir_path(__FILE__).'includes/pdf_creator.php' );
                church_admin_year_planner_pdf( $_REQUEST['year'] );
            } else {
                echo'<p>'.esc_html(__('You can only download if coming from a valid link',' church-admin') ).'</p>';
                exit();
            }
        break;
		case'smallgroup':
				if(wp_verify_nonce( $_REQUEST['smallgroup'], 'smallgroup') )
					{
						require_once( plugin_dir_path(__FILE__).'includes/pdf_creator.php' );
						church_admin_smallgroup_pdf( $_REQUEST['member_type_id'], $_REQUEST['people_type_id'], $loggedin, urldecode( $title) );
					}
					else{
                        echo'<p>'.esc_html(__('You can only download if coming from a valid link',' church-admin') ).'</p>';
                    }
                exit();
		break;
		case 'smallgroups':
			require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
			church_admin_smallgroups_pdf( $loggedin , urldecode( $title) );
            exit();
		break;
        case 'vcf-person':
            $okay=FALSE;
            if(!empty( $_GET['token'] ) )
            {
                church_admin_debug("Coming from app");
                //coming from app so no nonce, but login can be checked
                $sql='SELECT user_id FROM '.CA_APP_TBL.' WHERE UUID="'.esc_sql(stripslashes( $_GET['token'] ) ).'"';
                church_admin_debug($sql);
		        $result=$wpdb->get_var( $sql);
                church_admin_debug("Result: ".$result);
		        if( !empty( $result) ) { 
                 
                    $okay = TRUE; 
                }
            }
            //only allow login if from logged in app user or correct nonce
			if( !empty($okay) || wp_verify_nonce( $_REQUEST['_wpnonce'],$_GET['id'] ) )
			{
                church_admin_debug('passed checks');
                
				require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
				$people_id=!empty($_GET['id'])?(int)$_GET['id']:null;
                if(empty($people_id)){
                    //app sends $_GET['people_id']
                    $people_id=!empty($_GET['people_id'])?(int)$_GET['people_id']:null;
                }
                ca_person_vcard( $people_id );
			} else {
                echo'<p>'.__('You can only download if coming from a valid link','church-admin').'</p>';
            }
            exit();
		break;
		case 'vcf':
            $okay=FALSE;
            if(!empty( $_GET['token'] ) )
            {
                $sql='SELECT user_id FROM '.CA_APP_TBL.' WHERE UUID="'.esc_sql(stripslashes( $_GET['token'] ) ).'"';
		          $result=$wpdb->get_var( $sql);
		          if(!empty( $result) )$okay=TRUE;
            }
			if( $okay||wp_verify_nonce( $_REQUEST['_wpnonce'],$_REQUEST['id'] ) )
			{
				require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
				ca_vcard( $_REQUEST['id'] );
			}else{
                echo'<p>'.esc_html(__('You can only download if coming from a valid link',' church-admin') ).'</p>';
            }
            exit();
		break;
		case'mailinglabel':
            if(church_admin_level_check('Directory') )
            {
                require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
                church_admin_label_pdf( $member_type_id,$loggedin,$addressType);
            
            }
            exit();

        break;
        case'householdlabel':
            if(church_admin_level_check('Directory') )
            {
                require_once( plugin_dir_path( __FILE__ ).'includes/pdf_creator.php');
                church_admin_household_label_pdf( $member_type_id,$loggedin,$addressType);
            }
            exit();
        break;

    }
	exit();	
	}

}
function church_admin_delete_backup()
{
	$upload_dir = wp_upload_dir();
	$path=$upload_dir['basedir'].'/church-admin-cache/*';
    $files = glob( $path); // get all file names
    foreach( $files as $file)
    { // iterate files
        if(is_file( $file) )unlink( $file); // delete file
    }
    $text="<?php exit('----------------------------------------
  ___ _   _             _ _         _                 _         _
 |_ _| |_( )___    __ _| | |   __ _| |__   ___  _   _| |_      | | ___  ___ _   _ ___
  | || __|// __|  / _` | | |  / _` | '_ \ / _ \| | | | __|  _  | |/ _ \/ __| | | / __|
  | || |_  \__ \ | (_| | | | | (_| | |_) | (_) | |_| | |_  | |_| |  __/\__ \ |_| \__ \
 |___|\__| |___/  \__,_|_|_|  \__,_|_.__/ \___/ \__,_|\__|  \___/ \___||___/\__,_|___/
'); \r\n // Nothing is good! ";
    $fp = fopen( $upload_dir['basedir'].'/church-admin-cache/debug_log.php', 'w');
    fwrite( $fp, $text."\r\n");
    $fp = fopen( $upload_dir['basedir'].'/church-admin-cache/index.php', 'w');
    fwrite( $fp, $text."\r\n");
 
}





function church_admin_activation_log_clear()
{
     delete_option('church_admin_plugin_error');
                                              
     echo'<div class="notice notice-success"><h2>'. esc_html( __( 'Installation errors cleared', 'church-admin' ) ).'</h2></div>';
}



// Add a new interval of a week
// See http://codex.wordpress.org/Plugin_API/Filter_Reference/cron_schedules
add_filter( 'cron_schedules', 'church_admin_add_weekly_cron_schedule' );
function church_admin_add_weekly_cron_schedule( $schedules ) {
    $schedules['weekly'] = array(
        'interval' => 604800, // 1 week in seconds
        'display'  => __( 'Once Weekly' ),
    );

    return $schedules;
}

/**************************
 *END Auto Email rota
 **************************/





add_action('church_admin_cron_email_rota','church_admin_auto_email_rota',1,2);


  /**
 *
 * Cron email rota
 *
 * @author  Andy Moyle, Mick Wall
 * @param    $service_id
 * @return   string
 * @version  0.1
 *
 */
function church_admin_auto_email_rota( $service_id,$user_message=NULL)
{
    global $wpdb,$wp_locale;
		church_admin_debug("Cron email of rota fired\r\n ".print_r( $user_message,TRUE) );
		church_admin_debug('Service id '.$service_id);
  		if ( empty( $service_id) )return FALSE;
	
		
        $service=$wpdb->get_row('SELECT a.*,b.venue FROM '.CA_SER_TBL.' a, '.CA_SIT_TBL.' b WHERE a.site_id=b.site_id AND a.service_id="'.(int) $service_id.'"');
        church_admin_debug( $wpdb->last_query);
        church_admin_debug( $service);
		
		require_once(plugin_dir_path(dirname(__FILE__) ).'church-admin/includes/rota.new.php');
		$rotaJobs=church_admin_required_rota_jobs( $service_id);

		//$rotaJobs is an array rota_task_id=>rota_task
		
		//MICK WALL
		//Change the SQL to look for DISTINCT dates in the next 1 week and then send rotas for all the dates
        church_admin_debug("Look for services...");
		$results=$wpdb->get_results('SELECT DISTINCT(rota_date), service_time FROM  '.CA_ROTA_TBL.' WHERE mtg_type="service" AND  service_id="'.(int)$service_id.'"  AND rota_date BETWEEN CURDATE() AND date_add(CURDATE(), INTERVAL 1 WEEK) ORDER BY service_id,rota_date ASC');
        church_admin_debug( $wpdb->last_query);
        church_admin_debug( $results);
        if ( empty( $results) )
        {
            church_admin_debug("No services in next 1 week");
            return;
        }
		foreach( $results as $rota_data)
		{
			$rota_date=$rota_data->rota_date;;
			//build email
			church_admin_debug("******************************\r\nRota send for $rota_date");

			//build rota with jobs
			
			//fix floated images for email
			$user_message=str_replace('class="alignleft ','style="float:left;margin-right:20px;" class="',$user_message);
			$user_message=str_replace('class="alignright ','style="float:right;margin-left:20px;" class="',$user_message);
			
			if( $service->service_day!=8)  {
                $sendMessage=$user_message.'<h4>'.esc_html(sprintf(__( 'Schedule for %1$s at %2$s on %3$s at %4$s', 'church-admin' ), $service->service_name, $service->venue,$wp_locale->get_weekday( $service->service_day).' '.mysql2date(get_option('date_format'),$rota_date),$service->service_time ) ).'</h4>';
            }
			//MICK WALL 
			//Update else to send date / time option.
			else{$sendMessage=$message.'<h4>'. esc_html(sprintf(__( 'Schedule for %1$s at %2$s on %3$s at %4$s', 'church-admin' ), $service->service_name, $service->venue, mysql2date(get_option('date_format'),$rota_date),$rota_data->service_time) ).'</h4>';}

			
			$sendMessage.='<table><thead><tr><th>'.esc_html( __('Job', 'church-admin' ) ).'</th><th>'.esc_html( __('Who', 'church-admin' ) ).'</th></tr></thead><tbody>';
			$recipients=array();
			foreach( $rotaJobs AS $rota_task_id=>$jobName)
			{
					$people='';

					$people=church_admin_rota_people_array( $rota_date,$rota_task_id,$service_id,'service');
                    church_admin_debug("**********\r\nPeople Array");
                    church_admin_debug( $people);
					if(!empty( $people) )
					{
						foreach( $people AS $people_id=>$name)
						{

                            
							$email=$wpdb->get_var('SELECT email FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'" AND email!="" AND email_send=1 && gdpr_reason!=""');
                            if(!empty( $email)&&!in_array( $email,$recipients) )$recipients[$name]=$email;
                           //send copy to parent if a child
                            $moreData=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
                            if(!empty( $moreData)&&$moreData->people_type_id!=1)
                            {
                                $parentEmail=$wpdb->get_var('SELECT email FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$moreData->household_id.'" AND email!="" AND email_send=1 && gdpr_reason!="" ORDER BY people_order LIMIT 1');
                                $parentName=sprintf(__('Parent of %1$s',"church-admin"),$name);
                                if(!empty( $parentEmail) )$recipients[$parentName]=$parentEmail;
                            }
							
						}
						$sendMessage.='<tr><td>'.esc_html( $jobName ).'</td><td>'.esc_html(implode(", ",$people) ).'</td></tr>';
					}
			}
			$sendMessage.='</table>';
            church_admin_debug('Recipient array');
			church_admin_debug( $recipients);
            church_admin_debug( $sendMessage);
			//start emailing the message
			$sendMessage.='';
			if(!empty( $recipients) )
			{

				add_filter( 'wp_mail_from_name','church_admin_from_name' );
				add_filter( 'wp_mail_from', 'church_admin_from_email');
				add_filter('wp_mail_content_type','church_admin_email_type');
				foreach( $recipients AS $name=>$email)
				{
					 	$email_content='<p>'.esc_html( sprintf( __('Dear %1$s,','church-admin') , $name ) ) .'</p>'.$sendMessage;
						$whenToSend=get_option('church_admin_cron');
						if( $whenToSend=='immediate'||empty( $whenToSend) )
						{

							add_filter( 'wp_mail_content_type', 'set_html_content_type' );
							if(wp_mail( $email, __("This weeks service schedule for ",'church-admin').mysql2date(get_option('date_format'),$rota_date) ,$email_content) )
							{
							church_admin_debug('Sent to '.$email);
							}
							else
							{//log errors
								global $phpmailer;
								if (isset( $phpmailer)&&defined('CA_DEBUG') ) {
									church_admin_debug("**********\r\n Send error\r\n ".print_r( $phpmailer->ErrorInfo,TRUE)."\r\n");
								}
							}
							remove_filter( 'wp_mail_content_type', 'set_html_content_type' );
						}
						else
						{
							QueueEmail( $email,__("This weeks service schedule",'church-admin') ,$email_content,'',get_option('blogname'),get_option('admin_email'),'','',null);
                            church_admin_debug('Queued to '.$email);
                            
						}	
				}
			}
		}	
		church_admin_debug('Cron rota send finished');
		exit();
}
/**************************
 *END Auto Email rota
 **************************/

/**************************
 * Auto SMS/EMAIL rota
 **************************/
add_action('init','church_admin_setup_auto_send_rota');
function church_admin_setup_auto_send_rota()
{
     /*****************************
     * EMAIL ROTA
     ****************************/
    if(!empty( $_POST['email_rota_day'] ) )
    {
        church_admin_debug('************** Start Saving auto email rota **************');
        //initialize variables
        $en_rota_days=array(1=>'Monday',2=>'Tuesday',3=>'Wednesday',4=>'Thursday',5=>'Friday',6=>'Saturday',7=>'Sunday');
        //sanitize
        $service_id=!empty($_POST['service_id'])?(int)$_POST['service_id']:null;
        $email_day=!empty($_POST['email_rota_day'])?(int)$_POST['email_rota_day']:null;
        $message=!empty($_POST['auto-rota-message'])?sanitize_textarea_field( $_POST['auto-rota-message'] ):null;
        
        //validate email day
        if(empty($email_day)||$email_day>7){
            church_admin_debug("Invalid day");
            return;
        }
        //validate service_id
        $services = church_admin_services_array();
        if(empty($service_id) || empty($services[$service_id])){
            church_admin_debug("Invalid service id");
            return;
        }
       
        $args=array('service_id'=>(int)$service_id,'user_message'=>$message);
        church_admin_debug( $args);
        update_option('church_admin_auto_rota_email_message',$message);
    
            update_option('church_admin_email_rota_day',$email_day);
            $first_run = strtotime( $en_rota_days[$email_day] );
            wp_schedule_event( $first_run, 'weekly','church_admin_cron_email_rota',$args);
            church_admin_debug('************** End Saving auto email rota **************');
    }
    /*****************************
     * SMS ROTA
     ****************************/
    if(!empty( $_POST['sms_rota_day'] ) )
    {
        church_admin_debug('************** Start Saving auto sms rota **************');
        //initialize variables
        $en_rota_days=array(1=>'Monday',2=>'Tuesday',3=>'Wednesday',4=>'Thursday',5=>'Friday',6=>'Saturday',7=>'Sunday');
        //sanitize
        $service_id=!empty($_POST['service_id'])?(int)$_POST['service_id']:null;
        $sms_day=!empty($_POST['sms_rota_day'])?(int)$_POST['sms_rota_day']:null;
        $sms_time=!empty($_POST['sms_time'])?sanitize_text_field($_POST['sms_time']):null;
        //validate sms day
        if(empty($sms_day)||$sms_day>7){
            church_admin_debug("Invalid day");
            return;
        }
        //validate service_id
        $services = church_admin_services_array();
        if(empty($service_id) || empty($services[$service_id])){
            church_admin_debug("Invalid service id");
            return;
        }
        //validate time
        if(empty($sms_time)){
            church_admin_debug("No time");
            return;
        }
        $matches =  preg_match("/^(?:2[0-3]|[01][0-9]):[0-5][0-9]$/", $sms_time);
        if(empty($matches)){
            church_admin_debug("Invalid time time");
            return;
    
        }
        
        //safe to proceed
        
        $args=array('service_id'=>(int)$service_id);
        church_admin_debug( $args);
        
        update_option('church_admin_sms_rota_day',$sms_day);
        $first_run = strtotime( $en_rota_days[$sms_day].' '.$sms_time );
        wp_schedule_event( $first_run, 'weekly','church_admin_cron_sms_rota',$args);
        church_admin_debug('************** End Saving auto sms rota **************');
    }
}



add_action('church_admin_cron_sms_rota','church_admin_auto_sms_rota',1,2);

function church_admin_auto_sms_rota($service_id)
{
    global $wpdb,$wp_locale;
    require_once(plugin_dir_path( __FILE__) .'/includes/sms.php');
    church_admin_debug('Firing auto sms');
   
		church_admin_debug('Service id '.$service_id);
  		if ( empty( $service_id) )return FALSE;
	
		
        $service=$wpdb->get_row('SELECT a.*,b.venue FROM '.CA_SER_TBL.' a, '.CA_SIT_TBL.' b WHERE a.site_id=b.site_id AND a.service_id="'.(int) $service_id.'"');
        church_admin_debug( $wpdb->last_query );
        church_admin_debug( $service );
		
		require_once(plugin_dir_path(dirname(__FILE__) ).'church-admin/includes/rota.new.php');
		$rotaJobs=church_admin_required_rota_jobs( $service_id );

		//$rotaJobs is an array rota_task_id=>rota_task
		
		//MICK WALL
		//Change the SQL to look for DISTINCT dates in the next 1 week and then send rotas for all the dates
        church_admin_debug("Look for services...");
		$rota_date=$wpdb->get_row('SELECT rota_date, service_time FROM  '.CA_ROTA_TBL.' WHERE mtg_type="service" AND  service_id="'.(int)$service_id.'"  AND rota_date BETWEEN CURDATE() AND date_add(CURDATE(), INTERVAL 1 WEEK) ORDER BY service_id,rota_date ASC LIMIT 1');
        church_admin_debug( $wpdb->last_query);
      
        if ( empty( $rota_date) )
        {
            church_admin_debug("No services in next 1 week");
            return;
        }
		
        //build sms
        church_admin_debug("******************************\r\nRota send for ".print_r($rota_date,TRUE));

        //build rota with jobs
        //use default time if rota date doesn't have a time set.
        $time=!empty($rota_date->service_time)?$rota_date->service_time:$service->service_time;
        if(empty($time)){$time=null;}

        if( $service->service_day!=8)  {
            $sendMessage=esc_html(sprintf(__( 'Schedule for %1$s at %2$s on %3$s at %4$s.', 'church-admin' ), $service->service_name, $service->venue,$wp_locale->get_weekday( $service->service_day).' '.mysql2date(get_option('date_format'),$rota_date->rota_date),$time ) );
        }
        //MICK WALL 
        //Update else to send date / time option.
        else{
            $sendMessage=esc_html(sprintf(__( 'Schedule for %1$s at %2$s on %3$s at %4$s.', 'church-admin' ), $service->service_name, $service->venue, mysql2date(get_option('date_format'),$rota_date),$rota_date->service_time) );
        }

        $recipients=array();
        foreach( $rotaJobs AS $rota_task_id=>$jobName)
        {
                $people='';

                $people=church_admin_rota_people_array( $rota_date->rota_date,$rota_task_id,$service_id,'service');
                church_admin_debug("**********\r\nPeople Array");
                church_admin_debug( $people);
                if(!empty( $people ) )
                {
                    foreach( $people AS $people_id=>$name )
                    {

                        
                        $mobile=$wpdb->get_var('SELECT mobile FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'" AND mobile!="" AND sms_send=1 ');
                        $message=$sendMessage.' '.sprintf(__('You are scheduled for %1$s','church-admin'), $jobName );
                        if(!empty($mobile)){
                            church_admin_sms( $mobile,$message,$echo=TRUE);
                        }
                        
                    }
                    
                }
        }
			
           
		
			
			
		church_admin_debug('Cron rota send finished');
		exit();

}
/**************************
 *END Auto SMS rota
 **************************/



function church_admin_from_name( $from ) {
    if(!empty( $_POST['from_name'] ) )  {
        return esc_html(stripslashes( $_POST['from_name'] ) );
        }
        else {
            return get_option('blogname');
        }
    }
function church_admin_from_email( $email ) {
    if(!empty( $_POST['from_email'] ) )  {
            return esc_html(stripslashes( $_POST['from_email'] ) );
        }else {
            return get_option('admin_email');
        }
    
}
function church_admin_debug( $message)
{
    $debug=get_option('church_admin_debug_mode');
    if(!defined('CA_DEBUG') && empty($debug) )return;
    if(is_array( $message)||is_object( $message) )$message=print_r( $message,TRUE);
    $text="<?php exit('Nothing is good!') ;?>";
	$upload_dir = wp_upload_dir();
	$debug_path=$upload_dir['basedir'].'/church-admin-cache/';
	if(file_exists( $debug_path.'debug.log') )unlink( $debug_path.'debug.log');
	if(!file_exists( $debug_path.'debug_log.php') )
	{

		
		$fp = fopen( $debug_path.'debug_log.php', 'w');
		fwrite( $fp, $text."\r\n");
	}
	if ( empty( $fp) )$fp = fopen( $debug_path.'debug_log.php', 'a');
    fwrite( $fp, $message."\r\n");
    fclose( $fp);
    if(!file_exists( $debug_path.'index.php') )
    {
        $fp = fopen( $debug_path.'index.php', 'w');
        fwrite( $fp, $text."\r\n");
        fclose( $fp);
    }
}

register_deactivation_hook(__FILE__, 'church_admin_deactivation');

function church_admin_deactivation() {
    $cron=get_option('cron');
    foreach($cron AS $id=>$cronArray)
    {
        if(!empty($cron[$id]['church_admin_bulk_email'])){
            unset($cron[$id]['church_admin_bulk_email']);
        }
        if(!empty($cron[$id]['church_admin_cron_sms_rota'])){
            unset($cron[$id]['church_admin_cron_sms_rota']);
        }
        if(!empty($cron[$id]['church_admin_cron_email_rota'])){
            unset($cron[$id]['church_admin_cron_email_rota']);
        }
    }

    update_option('cron',$cron);
}
add_action('church_admin_bulk_email','church_admin_bulk_email');
function church_admin_bulk_email()
{
    church_admin_debug('BULK EMAIL CRON');
	global $wpdb;

	$max_email=get_option('church_admin_bulk_email');

	if ( empty( $max_email) )$max_email=100;
	$sql='SELECT * FROM '.CA_EMA_TBL.' WHERE schedule <=NOW() OR schedule is NULL  LIMIT 0,'.$max_email;
    church_admin_debug( $sql);
	$result=$wpdb->get_results( $sql);

	if(!empty( $result) )
	{
		foreach( $result AS $row)
		{
			$headers="From: ".$row->from_name." <".$row->from_email.">\n";
			add_filter('wp_mail_content_type','church_admin_email_type');
			$email=$row->from_email;
			$from=$row->from_name;
			add_filter( 'wp_mail_from_name', 'church_admin_from_name');
			add_filter( 'wp_mail_from', 'church_admin_from_email');
			if(wp_mail( $row->recipient,$row->subject,$row->message,$headers,unserialize( $row->attachment) ))
			{

				$wpdb->query('DELETE FROM '.CA_EMA_TBL.' WHERE email_id="'.(int) $row->email_id.'"');
                church_admin_debug('SENT to '.$row->recipient);
			}else {church_admin_debug( $_GLOBALS['phpmailer']->ErrorInfo);}
			remove_filter('wp_mail_content_type','church_admin_email_type');
		}
	}
    echo 'Done';
    exit;
}

//add donate link on config page
add_filter( 'plugin_row_meta', 'church_admin_plugin_meta_links', 10, 2 );
function church_admin_plugin_meta_links( $links, $file ) {
	$plugin = plugin_basename(__FILE__);
	// create link
	if ( $file == $plugin ) {
		return array_merge(
			$links,
			array( '<a href="http://www.churchadminplugin.com/support">Support</a>','<a href="https://pay.sumup.io/b2c/QEEPP89C">Donate</a>' )
		);
	}
	return $links;
}



/**
 *
 * Send out Prayer Request Post to the prayer chain
 *
 * @author  Andy Moyle
 * @param    null
 * @return   html
 * @version  0.1
 *
 */


add_action( 'transition_post_status', 'church_admin_post_message', 10, 3 );

function church_admin_post_message( $new_status, $old_status, $post ) 
{
    //update app cache time
    update_option('church_admin_modified_app_content',time() );
    //if(!defined('CA_DEBUG') )define('CA_DEBUG',TRUE);
	church_admin_debug("**********************************\r\nPublish firing\r\n".date('Y-m-d H:i:s') );
    church_admin_debug("Post title {$post->post_title}");
    church_admin_debug("Post type {$post->post_type}");
    church_admin_debug("New Status {$new_status}");
    church_admin_debug("Old Status {$old_status}");
    //app content modified check
    if( $post->post_type=='app-content' && ( $new_status=='update'||$new_status=='publish') )
    {
        update_option('church_admin_modified_app_content',time() );
    }
    if( $new_status!='publish') 
    {
        church_admin_debug("************ Not publishing so don't proceed **************");
        return;
    }
    global $wpdb,$videoURL;
    //$debug=FALSE;//stop push notifications while testing
    $user=wp_get_current_user();
    $sender=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE user_id="'.(int)$user->ID.'"');
    if(!empty( $sender) )$username=implode(" ",array_filter(array( $sender->first_name,$sender->prefix,$sender->last_name) ));
    $MailChimpSettings=get_option('church_admin_mailchimp');
    $no_push=get_option('church_admin_no_push');
	if( $no_push)
    {
        church_admin_debug("No push");
        return;
    }
    
	
	$title='';
	$type=get_post_type( $post );
	$sent=get_post_meta( $post->ID,'Email Sent',TRUE);
    $pushOK=TRUE;
    if(!empty( $_POST['church_admin_no_push'] ) )return;
    if( $new_status == 'publish' && $old_status != 'publish' && !empty( $type) && ( $type=='prayer-requests'||$type=='post'||$type=='bible-readings') && $pushOK)
    {
     	church_admin_debug("Post status changed to PUBLISH");

	
		switch( $type)
		{
			case 'acts-of-courage':
                $title=__('New Act of Courage','church-admin');
                $contactType='acts-of-courage';
                $ministry=__('Prayer requests send','church-admin');
            break;
			case 'prayer-requests':
				$title=__('New Prayer Request','church-admin');
                $contactType='prayer';
				$ministry=__('Prayer requests send','church-admin');	
			break;
			case 'bible-readings':
                $title=__('New Bible Reading','church-admin');
                $contactType='bible';
                $ministry=__('Bible readings send','church-admin');
                break;
			case 'post':
                $title=__('New Blog Post','church-admin');
                $contactType='posts';
                $ministry=__('News send','church-admin');
            break;
            
		}
        if( $type=='post')$type='posts';
		church_admin_debug("ContactType = $contactType Ministry = $ministry");
		/****************************************
		*
		* Push Notification
		*
		****************************************/
		if( $_SERVER['SERVER_NAME']!="localhost")
        {
           
        	church_admin_debug("Post type is $type");
				//app
				
				$api_key="AAAA50JK2is:APA91bE-SZWcUncaSxdbevuGOdochq7zS2fgJabNBAmbqBnmR8Lq4BoaQwG_p-JM2Ftx5rAKInlnG5RmxhWW_LcOPW9A9cQqpg7tUA1GFi1-NvX2q5YbFqnM9ZmV5xuE0PfeRWFUL1d4Te4zwzpu5qglwzZpg_JWzg";
				$headers = array('Authorization: key=' . $api_key,'Content-Type: application/json');
				
				church_admin_debug("Prepping FCM bundle");
			       
                $url = 'https://fcm.googleapis.com/fcm/send';
				
				$appID=get_option('church_admin_app_id');
				church_admin_debug("App id is $appID");
				
				if(!empty( $appID) )
				{// prep the bundle
					church_admin_debug("Prepping FCM bundle");
			 		$to="/topics/church".$appID;
                    
                   


					$headers = array('Authorization: key=' . $api_key,'Content-Type: application/json');
					$message=$title.' - '.$post->post_title;
                    
                    //updated for iOS13 which requires APNS headers
                    
                    
                    $data=array("notification"=>array("title"=>"Church App",
													  "body"=>$message,
													  "sound"=>"default",
													  //"click_action"=>"FCM_PLUGIN_ACTIVITY",
													  "icon"=>"fcm_push_icon",
													  "content_available"=> 1,
                                                      'apnsPushType'=>'alert'
													 ),
                                  "apns"=> array(
                                            'headers'=> array( 
                                                        'apns-push-type'=> 'alert',
                                                        "apns-priority"=>5,
                                                        "apns-topic"=>"com.churchadminplugin.wpchurch"
                                            ),
                                            "payload"=>array("alert"=>array("title"=>"Church App","body"=>$message),
                                                             "aps"=>array( "content-available"=>1),
                                                             "sound"=>"default","content-available"=>1
                                                            ),
                        
                                ),
								"data"=>array(  "notification_foreground"=>TRUE,
                                                "notification_body" => $message,
                                                "notification_title"=> "Church App",
                                              "notification_android_priority"=>1,
                                              "notification_ios_sound"=>"default",
                                              "sound"=>"default",
                                                "title"=>"Church App",
											  "body"=>$message,
											  "type"=>$contactType,
											  "senderName"=>$username,
												"timestamp"=>wp_date("Y-m-d H:i:s")
										),
								
								"priority"=>"high"
								);
                    $private=get_option('church-admin-private-prayer-requests');
                    if( $type=='bible-readings')
                    {
                        //only send bible readings to logged in app users who accept bible readings
                        $myTokens=$wpdb->get_results('SELECT a.*,a.pushToken,b.meta_date FROM '.CA_PEO_TBL.' a, '.CA_MET_TBL.' b WHERE a.pushToken!="" AND a.people_id=b.people_id AND b.meta_type="bible-readings-notifications"');
                        //church_admin_debug( $wpdb->last_query);
                        $pushTokens=array();
                        if(!empty( $myTokens) )
                        {
                            foreach( $myTokens AS $myToken)
                            {
                                if(!in_array( $myToken->pushToken,$pushTokens) )  {
                                    $pushTokens[]=$myToken->pushToken;
                                }
                                church_admin_debug("Push token for ".church_admin_formatted_name( $myTokens).' is '.$myToken->pushToken);
                            }
                        }
                        //church_admin_debug(print_r( $pushTokens,TRUE) );
                        $data["registration_ids"]=$pushTokens;
                    }elseif( $private && $type=='prayer-requests')
                    {
                        //only send prayer requestes to logged in app users who accept prayer requests
                        $myTokens=$wpdb->get_results('SELECT a.pushToken,b.meta_date FROM '.CA_PEO_TBL.' a, '.CA_MET_TBL.' b WHERE a.pushToken!="" AND a.people_id=b.people_id AND b.meta_type="prayer-requests-notifications"');
                        //church_admin_debug( $wpdb->last_query);
                        $pushTokens=array();
                        if(!empty( $myTokens) )
                        {
                            foreach( $myTokens AS $myToken)if(!in_array( $myToken->pushToken,$pushTokens) )  {$pushTokens[]=$myToken->pushToken;}
                        }
                        //church_admin_debug(print_r( $pushTokens,TRUE) );
                        $data["registration_ids"]=$pushTokens;
                    }elseif( $type=='post')
                    {
                        $myTokens=$wpdb->get_results('SELECT a.pushToken,b.meta_date FROM '.CA_PEO_TBL.' a, '.CA_MET_TBL.' b WHERE a.pushToken!="" AND a.people_id=b.people_id AND b.meta_type="news-notifications"');
                        //church_admin_debug( $wpdb->last_query);
                        $pushTokens=array();
                        if(!empty( $myTokens) )
                        {
                            foreach( $myTokens AS $myToken)if(!in_array( $myToken->pushToken,$pushTokens) )  {$pushTokens[]=$myToken->pushToken;}
                        }
                        //church_admin_debug(print_r( $pushTokens,TRUE) );
                        $data["registration_ids"]=$pushTokens;
                    }else 
                    {
                        //send to all app subscribers
                        //$data["to"]="/topics/church".$appID;
                        $myTokens=$wpdb->get_results('SELECT a.pushToken,b.meta_date FROM '.CA_PEO_TBL.' a, '.CA_MET_TBL.' b WHERE a.pushToken!="" AND a.people_id=b.people_id AND b.meta_type="news-notifications"');
                        //church_admin_debug( $wpdb->last_query);
                        $pushTokens=array();
                        if(!empty( $myTokens) )
                        {
                            foreach( $myTokens AS $myToken)if(!in_array( $myToken->pushToken,$pushTokens) )  {$pushTokens[]=$myToken->pushToken;}
                        }
                        //church_admin_debug(print_r( $pushTokens,TRUE) );
                        $data["registration_ids"]=$pushTokens;
                    }
                    church_admin_debug(print_r( $data,TRUE) );
					church_admin_debug("Headers:\r\n".print_r( $headers,TRUE) );
					
					//church_admin_debug("Data:\r\n".print_r( $data,TRUE) );
					$ch = curl_init ();
    				curl_setopt ( $ch, CURLOPT_URL, $url );
    				curl_setopt ( $ch, CURLOPT_POST, true );
    				curl_setopt ( $ch, CURLOPT_HTTPHEADER, $headers );
    				curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, true );
	    			curl_setopt ( $ch, CURLOPT_POSTFIELDS, json_encode( $data) );

    				$result = curl_exec ( $ch );
    				church_admin_debug(curl_error( $ch) );
					church_admin_debug(print_r( $result,TRUE) );
    				curl_close ( $ch );
				}
    	}//only send push if not localhost
		
		/***************************************
		*
		*	Email send
		*
		****************************************/
		if ( empty( $sent) )
        {
            
            church_admin_debug("Preparing to send ".$contactType);
            
            $post_title = get_the_title( $post->ID );
            $post_url = get_permalink( $post->ID );

            $email_title=$title.' - '.$post->post_title;
            $content_post = get_post( $post->ID);
            church_admin_debug("Post contents************\r\n".print_r( $post,TRUE) );
            $content=church_admin_prepare_post_for_email( $post->post_content,$type,NULL);
            $content.='<p><a href="'.site_url().'/?action=user-email-settings">'.esc_html( __('Update which emails you receive', 'church-admin' ) ).'</a></p>';
		
            church_admin_debug("***** CONTENT *****");
            church_admin_debug( $content);
            church_admin_debug("***** END CONTENT *****");
        

            



            $MailChimpSettings=get_option('church_admin_mailchimp');
            church_admin_debug("Sending option check");
            church_admin_debug(print_r( $MailChimpSettings,TRUE) );


            if ( empty( $MailChimpSettings['api_key'] ) )//send native if no MailChimp
            {
                church_admin_debug("Standard email");
                //standard email 
                //prepare send
                //$sql='SELECT  DISTINCT email,CONCAT_WS(" ",first_name,last_name) AS name FROM '.CA_PEO_TBL.' WHERE  prayer_chain=1 AND email!=""';
                //FROM v1.2608 prayer requests and bible readings are ministries and people who get them in church_admin_people_meta
                $ministryID=$wpdb->get_var('SELECT ID FROM '.CA_MIN_TBL.' WHERE ministry="'.esc_sql( $ministry).'"');
                //$sql='SELECT a.email,CONCAT_WS(" ",a.first_name,a.last_name) AS name FROM '.CA_PEO_TBL.' a, '.CA_MET_TBL.' b WHERE a.people_id=b.people_id AND b.meta_type="'.esc_sql( $type).'"  AND a.email!="" AND email_send!=0 AND gdpr_reason!="" GROUP BY a.email';
                $sql='SELECT DISTINCT email FROM '.CA_PEO_TBL.' a, '.CA_MET_TBL.' b WHERE a.people_id=b.people_id AND b.meta_type="'.esc_sql( $type).'"  AND a.email!="" AND email_send!=0 AND gdpr_reason!=""';
                church_admin_debug( $sql);
                $results=$wpdb->get_results( $sql);
                foreach( $results AS $row)
                {
                    if(get_option('church_admin_cron')!='immediate')
                    {
                                QueueEmail( $row->email, $title,'<h2>'.$email_title.'</h2>'.$content,NULL,$user->name,$user->email,null,null);
                                church_admin_debug("Prayer chain to ".$row->email.' '.date('Y-m-d h:i:s') );
                    }
                    else
                    {
                                add_filter('wp_mail_content_type','church_admin_email_type');
                                add_filter( 'wp_mail_from_name', 'church_admin_from_name');
                                add_filter( 'wp_mail_from', 'church_admin_from_email');
                                if(!wp_mail( $row->email,$email_title,'<h2>'.$email_title.'</h2>'.$content) )
                                {
                                    church_admin_debug("Prayer Chain email failure\r\n");
                                }
                                else{church_admin_debug("Prayer chain to ".$row->email);}
                                remove_filter('wp_mail_content_type','church_admin_email_type');
                    }
                }

            }//end use native mail
            else
            {
                church_admin_debug("Using MailChimp");
                church_admin_mailchimp_post_send( $post) ;  
            }
        
            //set sent field in post meta
            update_post_meta( $post->ID, 'Email Sent', 1);
        }
	} //just published
    church_admin_debug("************ End of church admin publish post function **************");
}

function ca_prayer_create_posttype() {
	$labels = array(
		'name'                => _x( 'Prayer Requests', 'Post Type General Name', 'church-admin' ),
		'singular_name'       => _x( 'Prayer Request', 'Post Type Singular Name', 'church-admin' ),
		'menu_name'           => __( 'Prayer Requests', 'church-admin' ),
		'parent_item_colon'   => __( 'Parent Prayer Request', 'church-admin' ),
		'all_items'           => __( 'All Prayer Requests', 'church-admin' ),
		'view_item'           => __( 'View Prayer Request', 'church-admin' ),
		'add_new_item'        => __( 'Add New Prayer Request', 'church-admin' ),
		'add_new'             => __( 'Add New', 'church-admin' ),
		'edit_item'           => __( 'Edit Prayer Request', 'church-admin' ),
		'update_item'         => __( 'Update Prayer Request', 'church-admin' ),
		'search_items'        => __( 'Search Prayer Requests', 'church-admin' ),
		'not_found'           => __( 'Not Found', 'church-admin' ),
		'not_found_in_trash'  => __( 'Not found in Trash', 'church-admin' ),
	);
	$noPrayer=get_option('church-admin-no-prayer');
	if ( empty( $noPrayer) )
	{
		register_post_type( 'prayer-requests',
	// CPT Options
		array(
			'labels' => $labels,
			'public' => true,
			'exclude_from_search'=>true,
			'has_archive' => true,
			'publicly_queryable'=>true,
			'show_ui'=>true,
			'supports' => array( 'thumbnail','title','editor','comments' ),
			'show_in_menu'        => TRUE,
			'show_in_nav_menus'   => TRUE
		)
	);
	}
}
add_action( 'init', 'ca_prayer_create_posttype' );

/****************************************************************************************
*
*  From v2.2520 app content has it's own post type app-content, so create app-content and move content over
*
****************************************************************************************/
add_action( 'init', 'ca_app_content_create_posttype' );
function ca_app_content_create_posttype() {
	$licence=get_option('church_admin_app_new_licence');
	if(!empty( $licence) && $licence == "subscribed")
	{
		
		$labels = array(
			'name'                => _x( 'App Content', 'Post Type General Name', 'church-admin' ),
			'singular_name'       => _x( 'App Content', 'Post Type Singular Name', 'church-admin' ),
			'menu_name'           => __( 'App Content', 'church-admin' ),
			'parent_item_colon'   => __( 'Parent App Content', 'church-admin' ),
			'all_items'           => __( 'All App Content', 'church-admin' ),
			'view_item'           => __( 'View App Content', 'church-admin' ),
			'add_new_item'        => __( 'Add New App Content', 'church-admin' ),
			'add_new'             => __( 'Add New', 'church-admin' ),
			'edit_item'           => __( 'Edit App Content', 'church-admin' ),
			'update_item'         => __( 'Update App Content', 'church-admin' ),
			'search_items'        => __( 'Search App Content', 'church-admin' ),
			'not_found'           => __( 'Not Found', 'church-admin' ),
			'not_found_in_trash'  => __( 'Not found in Trash', 'church-admin' ),

		);
        $args=array(
			'labels' => $labels,
			'public' => true,
			'exclude_from_search'=>true,
			'has_archive' => true,
			'publicly_queryable'=>true,
			'show_ui'=>true,
			'supports' => array( 'thumbnail','title','editor'),
           	'show_in_menu'        => true,
			'show_in_nav_menus'   => true,
            
			);
        $gutenbergapp=get_option('church_admin_app_gutenberg');
        if(!empty($gutenbergapp))$args['show_in_rest']=true;
		register_post_type( 'app-content',$args);
			
		
		//church_admin_fix_app_default_content();
	}	
}
/****************************
*
*
* Bible Reading Plan
*
*
*****************************/

function ca_bible_reading_create_posttype() {
$noBible=get_option('church-admin-no-bible-readings');
	if ( empty( $noBible) )
	{
	$labels = array(
		'name'                => _x( 'Bible Readings', 'Post Type General Name', 'church-admin' ),
		'singular_name'       => _x( 'Bible Reading', 'Post Type Singular Name', 'church-admin' ),
		'menu_name'           => __( 'Bible Readings', 'church-admin' ),
		'parent_item_colon'   => __( 'Parent Bible Reading', 'church-admin' ),
		'all_items'           => __( 'All Bible Readings', 'church-admin' ),
		'view_item'           => __( 'View Bible Reading', 'church-admin' ),
		'add_new_item'        => __( 'Add New Bible Reading', 'church-admin' ),
		'add_new'             => __( 'Add New', 'church-admin' ),
		'edit_item'           => __( 'Edit Bible Reading', 'church-admin' ),
		'update_item'         => __( 'Update Bible Reading', 'church-admin' ),
		'search_items'        => __( 'Search Bible Readings', 'church-admin' ),
		'not_found'           => __( 'Not Found', 'church-admin' ),
		'not_found_in_trash'  => __( 'Not found in Trash', 'church-admin' ),

	);

	register_post_type( 'bible-readings',
	// CPT Options
		array(
			'labels' => $labels,
			'public' => true,
			'exclude_from_search'=>false,
			'has_archive' => true,
			'publicly_queryable'=>true,
			'show_ui'=>true,
			'supports' => array( 'thumbnail','title','editor','comments' ),
			'show_in_menu'        => TRUE,
			'show_in_nav_menus'   => TRUE,
            'show_in_rest' => true,
            'supports' => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail','custom-fields', 'comments', 'revisions', 'permalinks', 'featured_image' )
			)
	);
	}
}

add_action( 'init', 'ca_bible_reading_create_posttype' );
/****************************
*
*
* Acts of courage
*
*
*****************************/

function ca_acts_of_courage_create_posttype() {

	$acts=get_option('church-admin-acts-of-courage');
	if( $acts)
	{
		$labels = array(
		'name'                => _x( 'Acts of Courage', 'Post Type General Name', 'church-admin' ),
		'singular_name'       => _x( 'Act of Courage', 'Post Type Singular Name', 'church-admin' ),
		'menu_name'           => __( 'Acts of Courage', 'church-admin' ),
		'parent_item_colon'   => __( 'Parent Act of Courage', 'church-admin' ),
		'all_items'           => __( 'All Acts of Courage', 'church-admin' ),
		'view_item'           => __( 'View Act of Courage', 'church-admin' ),
		'add_new_item'        => __( 'Add New Acts of Courage', 'church-admin' ),
		'add_new'             => __( 'Add New', 'church-admin' ),
		'edit_item'           => __( 'Edit Acts of Courage', 'church-admin' ),
		'update_item'         => __( 'Update Act of Courage', 'church-admin' ),
		'search_items'        => __( 'Search Acts of Courage', 'church-admin' ),
		'not_found'           => __( 'Not Found', 'church-admin' ),
		'not_found_in_trash'  => __( 'Not found in Trash', 'church-admin' ),

		);

		register_post_type( 'acts-of-courage',
	// CPT Options
		array(
			'labels' => $labels,
			'public' => true,
			'exclude_from_search'=>false,
			'has_archive' => true,
			'publicly_queryable'=>true,
			'show_ui'=>true,
			'supports' => array( 'thumbnail','title','editor','comments' ),
			'show_in_menu'        => TRUE,
			'show_in_nav_menus'   => TRUE
		)
	);
}
}

add_action( 'init', 'ca_acts_of_courage_create_posttype' );
/**

* Adds a meta box to the post editing screen

*/

function ca_brp_custom_meta() {

    add_meta_box( 'ca_brp_meta', __( 'Scripture', 'church-admin' ), 'ca_brp_meta_callback', 'bible-readings','normal','high' );

}

add_action( 'add_meta_boxes', 'ca_brp_custom_meta' );

add_action('edit_form_after_title',  'ca_move_metabox_after_title'  );

 

function ca_move_metabox_after_title () {

    global $post, $wp_meta_boxes;

    do_meta_boxes( get_current_screen(), 'after_title', $post );

    unset( $wp_meta_boxes[get_post_type( $post )]['after_title'] );

}
/**
 * Outputs the content of the meta box
 */
function ca_brp_meta_callback( $post ) 
{
    wp_nonce_field( basename( __FILE__ ), 'ca_brp__nonce' );
    $stored_meta = get_post_meta( $post->ID ,'bible-passage',TRUE);
    ?>

    <p>
        <label for="meta-text" class="ca_brp_-row-title"><?php _e( 'Bible Passage', 'church-admin' )?></label>
        <input type="text" name="meta-text" class="large-text" id="meta-text" value="<?php if ( isset ( $stored_meta ) ) echo $stored_meta; ?>" />
    </p>

    <?php
}

/**
 * Saves the custom meta input
 */
function ca_brp__meta_save( $post_id ) {

    // Checks save status
    $is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
    $is_valid_nonce = ( isset( $_POST[ 'ca_brp__nonce' ] ) && wp_verify_nonce( $_POST[ 'ca_brp__nonce' ], basename( __FILE__ ) ) ) ? 'true' : 'false';

    // Exits script depending on save status
    if ( $is_autosave || $is_revision || !$is_valid_nonce ) {
        return;
    }

    // Checks for input and sanitizes/saves if needed
    if( !empty( $_POST[ 'meta-text' ] ) ) {
        update_post_meta( $post_id, 'bible-passage', sanitize_text_field( $_POST[ 'meta-text' ] ) );
    }

}
add_action( 'save_post', 'ca_brp__meta_save' );

// Add the custom columns to the bible-readings post type:
add_filter( 'manage_bible-readings_posts_columns', 'church_admin_set_custom_bible_readings_columns' );
function church_admin_set_custom_bible_readings_columns( $columns) 
{
   
    $mailChimpSettings=get_option('church_admin_mailchimp');
    $newcolumns=array() ;
    foreach( $columns as $key=>$value) {
        if( $key=='date') 
        {  // when we find the date column
            
           $newcolumns['passage'] = __( 'Bible passage', 'church-admin' ); 
           $newcolumns['thumbnail'] = __( 'Featured Image', 'church-admin' );
           if(!empty( $mailChimpSettings) )
            {
                $newcolumns['resend'] = __('Resend email','church-admin');
            }  
               
            
        }  
        $newcolumns[$key]=$value;
    }   
   
     return $newcolumns;
}

// Add the data to the custom columns for the book post type:
add_action( 'manage_bible-readings_posts_custom_column' , 'church_admin_custom_bible_readings_column', 10, 2 );
function church_admin_custom_bible_readings_column( $column, $post_id ) {
    switch ( $column ) {

        case 'passage' :
            $passages=get_post_meta( $post_id,'bible-passage',true);
            if ( is_string( $passages ) )
                echo esc_html( $passages);
            else
                _e( 'Unable to get passage(s)', 'church-admin' );
        break;
        case'thumbnail':
            if(has_post_thumbnail( $post_id) )
            {
                echo get_the_post_thumbnail( $post_id, 'ca-address-thumb' );
            }
            else
            {
                _e('No featured image','church-admin');
            }
        break;
        case 'resend':
            $mailChimpSettings=get_option('church_admin_mailchimp');
            if(!empty( $mailChimpSettings) )
            {
                echo '<a href="admin.php?page=church_admin/index.php&action=resend-bible-reading&ID='.(int)$post_id.'">'.__('Resend','church-admin').'</a>';
            }
        break;
    }
}

function ca_bible_reading_passage( $content ) {

//this function prepends the passage to content for bible readings
	global $post;
    if ( is_single() && 'bible-readings' == get_post_type() ) {
        $custom_content='';
        $version=get_option('church_admin_bible_version');
        if(empty($version)){
            $version='ESV';
        }
        $passages=explode(",",get_post_meta( $post->ID ,'bible-passage',TRUE) );
        if(!empty( $passages) )
        {
           // church_admin_debug(print_r( $passages,true) );
            foreach( $passages AS $key=>$passage)
            {
                $sanitizedPassage = church_admin_bible_audio_link( $passage, $version );
                $dayNo=get_the_date('z')+1;
                $custom_content.='<div class="ca-bible-date">'.get_the_date().' '.__('Day','church-admin').' '.$dayNo.'</div>';
                if(!empty( $passage) )
                {
                    $custom_content .= '<p class="ca-bible-reading"><a href="https://www.biblegateway.com/passage/?search='.urlencode( $sanitizedPassage['passage']).'&version='.urlencode( $version).'&interface=print" target="_blank" >'.esc_html( $sanitizedPassage['passage']).'</a></p>';
                    $headphonesSVG='<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M6 23v-11c-4.036 0-6 2.715-6 5.5 0 2.807 1.995 5.5 6 5.5zm18-5.5c0-2.785-1.964-5.5-6-5.5v11c4.005 0 6-2.693 6-5.5zm-12-13.522c-3.879-.008-6.861 2.349-7.743 6.195-.751.145-1.479.385-2.161.716.629-5.501 4.319-9.889 9.904-9.889 5.589 0 9.29 4.389 9.916 9.896-.684-.334-1.415-.575-2.169-.721-.881-3.85-3.867-6.205-7.747-6.197z"/></svg>';
                   
                    //church_admin_debug(print_r( $bibleCV,true) );
                    if(!empty( $bibleCV['url'] ) )$custom_content.='<p><a href="'.$sanitizedPassage['url'].'">'.$headphonesSVG.' '.$sanitizedPassage['linkText'].'</a></p>';
                }
            }
            $custom_content .= $content;
        }
        return $custom_content;
    } else {
        return $content;
    }
}
add_filter( 'the_content', 'ca_bible_reading_passage' );
/****************************
*
*
* Ajax operations
*
*
*****************************/

//Bulk email
add_action('wp_ajax_nopriv_church_admin_cronemail', 'church_admin_bulk_email');
add_action('wp_ajax_church_admin_cronemail', 'church_admin_bulk_email');


add_action('wp_ajax_nopriv_church_admin_twilio_listener', 'church_admin_ajax_twilio_listener');
add_action('wp_ajax_church_admin_twilio_listener','church_admin_ajax_twilio_listener');
function church_admin_ajax_twilio_listener()
{
   church_admin_debug("Twilio ajax listener fired");
    require_once(plugin_dir_path( __FILE__) .'/includes/twilio.php');
    
    church_admin_twilio_listener();
   
    exit();
    
}


add_action('wp_ajax_church_admin_rota_dates','church_admin_ajax_rota_dates');
function church_admin_ajax_rota_dates()
{
	global $wpdb;
	//check_admin_referer('church_admin_rota_dates','nonce');
	$sql='SELECT rota_date FROM '.CA_ROTA_TBL.' WHERE mtg_type="service" AND service_id="'.(int)$_REQUEST['service_id'].'" AND rota_date>=CURDATE() GROUP BY rota_date ORDER BY rota_date ASC LIMIT 12';

	$results=$wpdb->get_results( $sql);
	if(!empty( $results) )
	{
		$out='<select name="rota_date">';
		foreach( $results AS $row)
		{
			$out.='<option value="'.esc_html( $row->rota_date).'">'.esc_html( mysql2date( get_option('date_format'), $row->rota_date ) ) .'</option>';
		}
		$out.='</select>';

	}else{
        $out= esc_html( __('No dates yet, create some first!', 'church-admin' ) );
    }
    echo $out;
	exit();
}



add_action('wp_ajax_church_admin_calendar_date_display','church_admin_date');
add_action('wp_ajax_nopriv_church_admin_calendar_date_display', '');

/**
 *
 * Ajax image upload
 *
 * @author  Andy Moyle
 * @param    null
 * @return   html
 * @version  0.1
 *
 */
add_action('wp_ajax_church_admin_image_upload','church_admin_image_upload');
add_action('wp_ajax_nopriv_church_admin_image_upload', 'church_admin_image_upload');
function church_admin_image_upload()
{
	church_admin_debug("********************\r\nAJAX Image upload");
	// These files need to be included as dependencies when on the front end.
	require_once( ABSPATH . 'wp-admin/includes/image.php' );
	require_once( ABSPATH . 'wp-admin/includes/file.php' );
	require_once( ABSPATH . 'wp-admin/includes/media.php' );
	// Let WordPress handle the upload.
	// Remember, 'my_image_upload' is the name of our file input in our form above.
	$attachment_id = media_handle_upload( 'file-0', 0 );
	church_admin_debug("attachment_id: ".$attachment_id);
	if ( is_wp_error( $attachment_id ) ) {
		exit();
	} else {
		// The image was uploaded successfully!
		$image=wp_get_attachment_image_src(  $attachment_id, "thumbnail", false );
		church_admin_debug(print_r( $image,TRUE) );
		echo json_encode(array('src' => esc_url( $image[0] ), 'attachment_id' => (int)$attachment_id ) );
		exit();
	}
		
	

}

/**
 *
 * Popup of calendar events
 *
 * @author  Andy Moyle
 * @param    null
 * @return   html
 * @version  0.1
 *
 */
add_action('wp_ajax_church_admin_calendar_event_display','church_admin_calendar_event_display');
add_action('wp_ajax_nopriv_church_admin_calendar_event_display', 'church_admin_calendar_event_display');
function church_admin_calendar_event_display()
{
	church_admin_debug('Calendar Event' .date('Y-m-d h:i:s') );
	global $wpdb;
	$date_sql=1;
	$out='';
	$dates=explode(',',$_POST['date'] );
    foreach( $dates AS $key=>$value)  { $datesql[]='a.start_date="'.esc_sql( $value).'"';}
    if(!empty( $datesql) ) {
        $date_sql=' ('.implode(' || ',$datesql).')';
    }else{ 
        echo esc_html( __( 'No event to show', 'church-admin' ) );
        exit();
    }

	$sql='SELECT a.*, b.* FROM '.CA_DATE_TBL.' a LEFT JOIN '.CA_CAT_TBL.' b ON b.cat_id = a.cat_id WHERE '.esc_sql( $date_sql );


	$result=$wpdb->get_results( $sql);

	if(!empty( $result) )
	{
		foreach( $result AS $row)
		{
			$out.='<div class="ca-event ">';
			$out.='<span class="ca-close">x</span>';
			$out.='<h2 style="color:'.esc_html( $row->bgcolor).'">'.esc_html( $row->title).'</h2>';
			$out.='<p>'.esc_html( mysql2date( get_option('date_format'), $row->start_date) ).' '.esc_html( mysql2date(get_option('time_format'),$row->start_time) ).' -  '.esc_html( mysql2date(get_option('time_format'),$row->end_time) ).'</p>';
			if(!empty( $row->description) )$out.='<p>'.esc_html( $row->description ).'</p>';
			if(!empty( $row->page_id) )$out.='<p><a href="'.get_permalink( $row->page_id ).'">'.__('More information','church-admin').'</p>';
			if(!empty( $row->booking_id) )$out.='<p><a class="button-primary" href="'.esc_url( get_permalink( $row->booking_id) ).'">'.esc_html( __('Book Now', 'church-admin' ) ).'</p>';
			$out.='</div>';
		}
	}
	else
	{
		$out= esc_html( __('No event to show','church-admin') );
	}
	echo json_encode(array('id'=>esc_html( $_POST['date'] ),'output'=>$out) );
	exit();
}



/****************************************
 * MAIN AJAX HANDLER
 *****************************************/

add_action('wp_ajax_church_admin','church_admin_ajax_handler');
add_action('wp_ajax_nopriv_church_admin', 'church_admin_ajax_handler');

function church_admin_ajax_handler()
{
	global $wpdb;
	$current_user = wp_get_current_user();	
		switch ( $_REQUEST['method'] )
		{
           
            case 'add-to-group':
                check_ajax_referer('add-to-group','nonce');
                church_admin_debug('*** Add to group AJAX ****');
                //sanitize
                $people_id=!empty($_POST['people_id'])?sanitize_text_field($_POST['people_id']):exit();
                $group_id = !empty($_POST['group_id'])?sanitize_text_field($_POST['group_id']):exit();
                //validate
                if(!ctype_digit($people_id)){
                    church_admin_debug('Invalid people_id');
                    exit();
                }
                if(!ctype_digit($group_id)){
                    church_admin_debug('Invalid group_id');
                    exit();
                }
                //check
                $checked_people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
                if(empty($checked_people_id)){
                    church_admin_debug('People_id not in DB');
                    exit();
                }
                $groups=church_admin_groups_array();
                if(empty($groups[$group_id])){
                    church_admin_debug('Group not recognised');
                    exit();
                }

                //safe to proceed
                //delete persons current group
                $wpdb->query('DELETE FROM '.CA_MET_TBL.' WHERE people_id="'.(int)$people_id.'" AND meta_type="smallgroup"');
                $wpdb->query('INSERT INTO '.CA_MET_TBL.' (meta_type,people_id,ID,meta_date) VALUES("smallgroup","'.(int)$people_id.'","'.(int)$group_id.'","'.wp_date('Y-m-d').'")');
                //send out put back
                
                $output=array('people_id'=>$people_id);
                header('Access-Control-Max-Age: 1728000');
                header('Access-Control-Allow-Origin: *');
                header('Access-Control-Allow-Methods: *');
                header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
                header('Access-Control-Allow-Credentials: true');
                echo json_encode( $output);
                die();

            break;
            case 'sermon_length':
                church_admin_debug('Sermon length AJAX');
                check_ajax_referer('sermon_length','nonce');
                $file_id=(int)$_REQUEST['id'];
                $length=sanitize_text_field($_REQUEST['length']);
                $regex='/(2[0-3]|[01][0-9]):[0-5][0-9]:[0-5][0-9]/';
                $match=preg_match($regex,$length);
                church_admin_debug("match - ".$match);
                if(!empty($match)){
                    $wpdb->query('UPDATE '.CA_FIL_TBL.' SET length="'.esc_sql($length).'" WHERE file_id="'.(int)$file_id.'"');
                    church_admin_debug($wpdb->last_query);
                }
                header('Access-Control-Max-Age: 1728000');
                header('Access-Control-Allow-Origin: *');
                header('Access-Control-Allow-Methods: *');
                header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
                header('Access-Control-Allow-Credentials: true');
                if($wpdb->rows_affected==1)echo esc_html(sprintf(__('%1$s updated','church-admin'), $length));
                exit();
            break;
            case 'rota_get_edit':
                if(!$current_user||!church_admin_level_check('rota',$current_user->ID) )
                {
                    exit();
                }
                church_admin_debug( $_REQUEST);
                $premium=get_option('church_admin_payment_gateway');
                $rota_task_id=(int)$_REQUEST['rota_task_id'];
                $service_id=(int)$_REQUEST['service_id'];
                $id=stripslashes( $_REQUEST['id'] );
                $time=stripslashes( $_REQUEST['time'] );
                $rota_date=stripslashes( $_REQUEST['rota_date'] );
                $idtochange=stripslashes( $_REQUEST['idtochange'] );
                $ministry_id=$wpdb->get_var('SELECT ministries FROM '.CA_RST_TBL.' WHERE rota_id="'.(int)$rota_task_id.'"');
                $out='<input type="text" data-service_id="'.(int)$service_id.'" data-id="'.esc_html( $idtochange).'" data-data="'.$current.'" value="'.$current.'" data-time="'.esc_html( $time).'" data-rota_date="'.esc_html( $rota_date).'" data-rota_task_id="'.(int)$rota_task_id.'"  class="editable_rota" autofocus placeholder="'.__('Add people','church-admin').'"/><br />';
                church_admin_debug( $wpdb->last_query);
                if(!empty( $ministry_id) )
                {
                    $people=array();
                    church_admin_debug('looking for '.$ministry_id);
                    $people=church_admin_ministry_people_array( $ministry_id);
                    church_admin_debug("people ids hopefully");
                
                    church_admin_debug( $people);
                   
                    if( $people)
                    {
                        
                        $out.='<select class="rota-dropdown" data-rota_task_id="'.(int)$rota_task_id.'" data-time="'.esc_html( $time).'" data-rota_date="'.esc_html( $rota_date).'" data-service_id="'.(int)$service_id.'" data-id="'.esc_html( $id).'"><option>'.__('Or please choose','church-admin').'</option>';
                        foreach( $people AS $id=>$people)
                        {
                            $check=FALSE;
                            if(!empty( $premium) )
                            {
                                $check=$wpdb->get_var('SELECT not_id FROM '.CA_NOT_TBL.' WHERE unavailable="'.esc_sql( $rota_date).'" AND people_id="'.(int)$id.'"');
                                church_admin_debug( $wpdb->last_query);
                            }
                            if ( empty( $check) )$out.='<option value="'.esc_html( $people).'">'.esc_html( $people).'</option>';
                        }
                        $out.='</select><br />';
                    }

                }
                $output=array('id'=>$idtochange,'html'=>$out);
                header('Access-Control-Max-Age: 1728000');
                header('Access-Control-Allow-Origin: *');
                header('Access-Control-Allow-Methods: *');
                header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
                header('Access-Control-Allow-Credentials: true');
                echo json_encode( $output);
                die();
            break;

            case 'facility-booking':
                check_ajax_referer('facility-booking','nonce');
                church_admin_debug(print_r( $_POST,TRUE) );
                
                $facilities_id=(int)$_POST['facilities_id'];
                $startDate=esc_sql( $_POST['start_date'] );
                $startTime=esc_sql( $_POST['start_time'] );
                $endTime=esc_sql( $_POST['end_time'] );
                $check=$wpdb->get_row('SELECT * FROM '.CA_DATE_TBL.' WHERE facilities_id="'.$facilities_id.'" AND 
                (startTime BETWEEN "'.$startTime.'" AND "'.$endTime.'") OR
                (endTime BETWEEN "'.$startTime.'" AND "'.$endTime.'") OR
                (startTime BETWEEN "'.$startTime.'" AND "'.$endTime.'" AND endTime BETWEEN "'.$startTime.'" AND "'.$endTime.'") OR
                (startTime<="'.$startTime.'" AND endTime>="'.$endTime.'")');
                
                if ( empty( $check) )  {
                    $out=array('message'=> '<span style="color:green;">'. __('Date and time are  available','church-admin').'</span>','available'=>1);
                }else{$out=array('message'=>'<span style="color:red;">'.  __('Date and time are NOT available','church-admin').'</span>','available'=>0);}
                header('Access-Control-Max-Age: 1728000');
                header('Access-Control-Allow-Origin: *');
                header('Access-Control-Allow-Methods: *');
                header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
                header('Access-Control-Allow-Credentials: true');
                echo json_encode( $out);
                die();
            break;  
            case 'update-site':
                $ID=(int)$_POST['id'];
                $div=stripslashes( $_POST['div'] );
                if(!empty($ID))
                {
                    $wpdb->query('UPDATE '.CA_SIT_TBL.' SET lat="'.esc_sql(stripslashes( $_POST['lat'] ) ).'",lng="'.esc_sql(stripslashes( $_POST['lng'] ) ).'" WHERE  site_id="'.(int)$ID.'"');
                    church_admin_debug( $wpdb->last_query);
                }        
            break;

            case 'update-directory':
                church_admin_debug(print_r( $_POST,TRUE) );
              
                //check_ajax_referer('update-directory','nonce');
                $id=(int)$_POST['id'];
                $div=stripslashes( $_POST['div'] );
                $what=stripslashes( $_POST['what'] );
                $custom_id=(int)$_REQUEST['custom-id'];
                
                if(!empty( $_POST['value'] ) )$value=stripslashes( $_POST['value'] );
                switch( $what)
                {
                    case 'member_type_id':
                        if(!empty( $id) && !empty( $value) ) $wpdb->query('UPDATE '.CA_PEO_TBL.' SET member_type_id="'.(int)$value.'" WHERE people_id="'.(int)$id.'"');
                        church_admin_debug( $wpdb->last_query);
                        $mtOut=church_admin_member_type_option( $value);
                    break;
                    case 'people_type_id':
                        if(!empty( $id) && !empty( $value) ) $wpdb->query('UPDATE '.CA_PEO_TBL.' SET people_type_id="'.(int)$value.'" WHERE people_id="'.(int)$id.'"');
                        church_admin_debug( $wpdb->last_query);
                    break;
                    case 'household-custom':
                        $ID=$wpdb->get_var('SELECT ID FROM '.CA_CUST_MET_TBL.' WHERE custom_id="'.$custom_id.'" AND household_id="'.$id.'"');
                        if( $ID)
                        {
                            $wpdb->query('UPDATE '.CA_CUST_MET_TBL.' SET data="'.$value.'" WHERE ID="'.(int)$ID.'"' );
                        }
                        else
                        {
                            $wpdb->query('INSERT INTO '.CA_CUST_MET_TBL.' (custom_id,household_id,data) VALUES("'.$custom_id.'","'.$id.'","'.$value.'")');
                        }
                    break;

                    case 'phone':$wpdb->query('UPDATE '.CA_HOU_TBL.' SET phone="'.esc_sql( $value).'" WHERE household_id="'.$id.'"');break;
                    case 'address':$wpdb->query('UPDATE '.CA_HOU_TBL.' SET address="'.esc_sql( $value).'" WHERE household_id="'.$id.'"');break;
                    case 'mailing-address':$wpdb->query('UPDATE '.CA_HOU_TBL.' SET mailing_address="'.esc_sql( $value).'" WHERE household_id="'.$id.'"');break;
                    case 'email':$wpdb->query('UPDATE '.CA_PEO_TBL.' SET email="'.esc_sql( $value).'" WHERE people_id="'.$id.'"');break;
                    case 'mobile':case 'cell':
                        
                        $e164cell=!empty( $value)?church_admin_e164( $value):'';
                        $wpdb->query('UPDATE '.CA_PEO_TBL.' SET mobile="'.esc_sql( $value).'", e164cell="'.esc_sql( $e614cell).'" WHERE people_id="'.$id.'"');
                        
                    break;


                    case 'geocode':
                        $wpdb->query('UPDATE '.CA_HOU_TBL.' SET geocoded=1, lat="'.esc_sql(stripslashes( $_POST['lat'] ) ).'",lng="'.esc_sql(stripslashes( $_POST['lng'] ) ).'" WHERE  household_id="'.$id.'"');
                        
                    break;
                }
                church_admin_debug($wpdb->last_query);
                //reset app address list cache
                delete_option('church_admin_app_address_cache');
                delete_option('church_admin_app_admin_address_cache');
                
                header('Access-Control-Max-Age: 1728000');
                header('Access-Control-Allow-Origin: *');
                header('Access-Control-Allow-Methods: *');
                header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
                header('Access-Control-Allow-Credentials: true');
                $outputArray=array();
                if(!empty( $div) ) $outputArray['div']=esc_html( $div);
                if(!empty( $mtOut) )$outputArray['mtout']=$mtOut;
                echo json_encode( $outputArray);
              
                exit();
            break;  
            case 'smallgroup-map-geocode':
                church_admin_debug('Small group map geocode');
                //check_ajax_referer('smallgroup-map','nonce');
                church_admin_debug(print_r( $_POST,TRUE) );
                $sql='UPDATE '.CA_SMG_TBL.' SET lat="'.esc_sql(stripslashes( $_POST['lat'] ) ).'",lng="'.esc_sql(stripslashes( $_POST['lng'] ) ).'" WHERE  id="'.(int)$_POST['id'].'"';
                
                church_admin_debug( $sql);
                $wpdb->query( $sql);
                header('Access-Control-Max-Age: 1728000');
                header('Access-Control-Allow-Origin: *');
                header('Access-Control-Allow-Methods: *');
                header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
                header('Access-Control-Allow-Credentials: true');
                echo json_encode(array('lat'=>esc_sql(stripslashes( $_POST['lat'] ) ),'lng'=>esc_sql(stripslashes( $_POST['lng'] ) )) );
                exit();
            break;
            case 'ignore-last-name':
                check_ajax_referer('ignore-last-name','nonce');
                if(!empty( $_POST['household_id'] ) )
                {
                    $wpdb->query('UPDATE '.CA_PEO_TBL.' SET ignore_last_name_check=1 WHERE household_id="'.(int)$_POST['household_id'].'"');
                    header('Access-Control-Max-Age: 1728000');
                    header('Access-Control-Allow-Origin: *');
                    header('Access-Control-Allow-Methods: *');
                    header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
                    header('Access-Control-Allow-Credentials: true');
                    echo (int)$_POST['household_id'];
                    die();
                }
            break;
            case 'mailchimp_webhook':
                church_admin_debug(print_r( $_POST,TRUE) );
            break;
            case 'week-attendance':
                check_ajax_referer('week-attendance','nonce');
                church_admin_debug("Weekly Attendance");
                church_admin_debug(print_r( $_POST,TRUE) );
                $data=$_POST['formdata'];
                $out='<h2>'.__('Attendance entered','church-admin').'</h2>';
                foreach( $data AS $id=>$item)
                {
                    if(!empty( $item[3] )&& !empty( $item[4] ) &&$item[4]!="0000-00-00")
                    {
                        $rowsAffected=FALSE;
                        //non zero attendance!
                        $service_id=(int)$item[0];
                        $type=esc_sql( $item[1] );
                        $people_type_id=(int)$item[2];
                        switch( $people_type_id)
                        {
                            default:case '1' : $column='adults'; $readablePeopleType=__('adults','church-admin');break;
                            case '2' : $column='children'; $readablePeopleType=__('children','church-admin');break;
                            
                        }
                        $number=(int)$item[3];
                        $date=esc_html( $item[4] );
                        $readable=$item[5];
                        
                        $attendance_id=$wpdb->get_var('SELECT attendance_id FROM '.CA_ATT_TBL.' WHERE date="'.$date.'" AND mtg_type="'.$type.'" AND service_id="'.$service_id.'"');
                        if(!empty( $attendance_id) )
                        {
                            $rowsAffected=$wpdb->query('UPDATE '.CA_ATT_TBL.' SET `'.$column.'`="'.$number.'" WHERE attendance_id="'.(int)$attendance_id.'"');
                            
                        }
                        else
                        {
                            $rowsAffected=$wpdb->query('INSERT INTO '.CA_ATT_TBL.' (`'.$column.'`,`mtg_type`,`service_id`,`date`)VALUES("'.$number.'","'.$type.'","'.$service_id.'","'.$date.'")');
                        }
                        if( $rowsAffected)$out.='<p>'.esc_html(sprintf( $readable,$number) ).'</p>';;
                    }

                }
                church_admin_refresh_rolling_average();
                echo $out;
                exit();
            break;
            case 'show-help':
                //church_admin_debug( $_REQUEST["which"] );
                require_once( plugin_dir_path( __FILE__ ).'includes/helper.php');
                $out=church_admin_helper( $_REQUEST["which"] );
                if ( empty( $out) )$out='';
                header('Access-Control-Max-Age: 1728000');
                header('Access-Control-Allow-Origin: *');
                header('Access-Control-Allow-Methods: *');
                header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
                header('Access-Control-Allow-Credentials: true');
                echo $out;
                die();
            break;
            case'dismissed-notice-handler':
                //church_admin_debug('Dismiss notice');
                switch( $_REQUEST['type'] )
                {
                    case 'dismissed-church-admin-please-review':update_option('dismissed-church-admin-please-review',TRUE);break;
                    case "church-admin-email-settings":update_option('dismissed-church-admin-email-settings',TRUE);break;
                    case "church-admin-set-sermon-page":update_option('dismissed-church-admin-set-sermon-page',TRUE);break;
                    case "church-admin-bible-version":update_option('dismissed-church-admin-bible-version',TRUE);break;
                    case "church-admin-app":update_option( 'dismissed-church-admin-app', TRUE );break;
                    case "church-admin-gdpr":update_option( 'dismissed-church-admin-gdpr', TRUE );break;
                    case "church-admin-cron":church_admin_debug('cron dismissed');update_option( 'dismissed-church-admin-cron', TRUE );echo'Dismissed';break;
                }
                exit();
            break;
            
            case 'refresh-sms':
                check_ajax_referer('refresh-sms','nonce');
                $out='';
                $sql='SELECT * FROM '.CA_TWI_TBL.' WHERE mobile="'.esc_sql( $_POST['e164cell'] ).'" AND direction=0 AND message_id>"'.(int)$_POST['lastID'].'" ORDER BY message_date ASC';
               
                $results=$wpdb->get_results( $sql);
                if(!empty( $results) )
                {
                    foreach( $results AS $row)
                    {
                        church_admin_debug(print_r( $row,TRUE) );
                        $out.='<div class="ca-message-blue"><div class="ca-message-content">';
                        $out.= '<div class="ca-message-content">'.esc_html( $row->message).'</div>';
                        $out.='<div class="ca-message-timestamp-left">'.mysql2date(get_option('date_format').' '.get_option('time_format'),$row->message_date).'</div></div>';
                        
                    }
                    $id=$row->message_id;
                }
                $output=array('messages'=>$out,'id'=>$id);
                church_admin_debug(print_r( $output,TRUE) );
                header('Access-Control-Max-Age: 1728000');
                header('Access-Control-Allow-Origin: *');
                header('Access-Control-Allow-Methods: *');
                header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
                header('Access-Control-Allow-Credentials: true');
                echo json_encode( $output);
                die();
            break;
            case 'refresh-sms-replies':
                check_ajax_referer('refresh-sms-replies','nonce');
                require_once(plugin_dir_path( __FILE__) .'/includes/twilio.php');
                $out=church_admin_sms_replies_list();
                
                header('Access-Control-Max-Age: 1728000');
                header('Access-Control-Allow-Origin: *');
                header('Access-Control-Allow-Methods: *');
                header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
                header('Access-Control-Allow-Credentials: true');
                echo json_encode( $out);
                die();
            break;    
            case 'remove-from-favourites':
                //church_admin_debug(print_r( $_POST,TRUE) );
                check_ajax_referer('remove-from-favourites','nonce');
                $user_id=(int)$_POST['user_id'];
                $what=$_POST['what'];
                $favourites=get_option('church-admin-favourites');
                $userFavourites=$favourites[$user_id];
                $key = array_search( $what, $userFavourites);
               if ( $key !== false)
                {
                    //church_admin_debug( $key);
                    unset( $favourites[$user_id][$key] );
                }
                update_option('church-admin-favourites',$favourites);
                church_admin_favourites_menu( $user_id);
                exit();
            break;
            case 'add-to-favourites':
                check_ajax_referer('add-to-favourites','nonce');
                $user_id=(int)$_POST['user_id'];
                $what=$_POST['what'];
                if( $what=='favourites')exit();
                $favourites=array();
                $favourites=get_option('church-admin-favourites');
                if(in_array( $what,$favourites[$user_id] ) )exit();
                $favourites[$user_id][]=$what;
                update_option('church-admin-favourites',$favourites);
                church_admin_favourites_menu( $user_id);
                exit();
            break;
            case 'email-checker':
                check_ajax_referer('email-checker','nonce');
                $email=stripslashes( $_POST['email'] );
                church_admin_debug('Email checker :'.$email);
                if(is_email( $email) && email_exists( $email) )
                {
                    $response=array('found'=>TRUE,'email'=>$email);
                    if(!empty( $_POST['id'] ) )$response['id']=(int)$_POST['id'];
                
                }else {
                    $response=array('found'=>FALSE,'nonce'=>wp_create_nonce('second-step'),'email'=>$email);
                    if(!empty( $_POST['id'] ) )$response['id']=(int)$_POST['id'];
                }
                echo json_encode( $response);
                exit();
            break;
            case 'remove-series-image':
                check_ajax_referer('remove-series-image');
                $wpdb->query('UPDATE '.CA_SER_TBL.' SET attachment_id="" WHERE series_id="'.(int)$_REQUEST['series_id'].'"');
                wp_delete_attachment( $_REQUEST['series_id'] );
                exit();
            break;
            case 'calendar-render':
                require_once(plugin_dir_path( __FILE__) .'/display/calendar.new.php');
                if ( empty( $_REQUEST['date'] ) )$_REQUEST['date']=date('Y-m-d');
                $d=explode("-",$_REQUEST['date'] );
                
                church_admin_render_month( $d[1],$d[0],$d[2] );
                exit();
            break;
            case 'calendar-day-render':
                require_once(plugin_dir_path( __FILE__) .'/display/calendar.new.php');
               
                church_admin_render_day( $_REQUEST['date'] );
                
                exit();
            break;
            case 'rota-dates':
                $sql='SELECT rota_date FROM '.CA_ROTA_TBL.' WHERE mtg_type="service" AND service_id="'.(int)$_REQUEST['service_id'].'" AND rota_date>=CURDATE() GROUP BY rota_date ORDER BY rota_date ASC LIMIT 12';

                $results=$wpdb->get_results( $sql);
                if(!empty( $results) )
                {
                    $out='<select name="rota_date">';
                    foreach( $results AS $row)
                    {
                        $out.='<option value="'.esc_html( $row->rota_date).'">'.mysql2date(get_option('date_format'),$row->rota_date).'</option>';
                    }
                    $out.='</select>';

                }else{$out=__('No dates yet, create some first!','church-admin');}
                echo $out;
                exit();
            break;
            case 'edit-app-menu':
                check_ajax_referer('edit-app-menu','nonce');
                $chosenMenu=get_option('church_admin_app_new_menu');
                $menuItem=stripslashes( $_POST['menuItem'] );
                $menuTitle=stripslashes( $_POST['menuTitle'] );
                if(!empty( $chosenMenu[$menuItem] ) )
                {
                    $chosenMenu[$menuItem]['item']=$menuTitle;
                }
                update_option('church_admin_app_new_menu',$chosenMenu);
                echo '<span class="ca-editable" data-item="'.$menuItem.'">'.$menuTitle.'</span>';
                exit();
            break;
            case 'app-menu-show':
                check_ajax_referer('edit-app-menu','nonce');
                $chosenMenu=get_option('church_admin_app_new_menu');
                church_admin_debug(print_r( $chosenMenu,TRUE) );
                $menuItem=stripslashes( $_POST['menuItem'] );
                $status=$_POST['status'];
                if( $status=="ON")
                {
                    $chosenMenu[$menuItem]['show']=1;
                }else  $chosenMenu[$menuItem]['show']=0;
                update_option('church_admin_app_new_menu',$chosenMenu);
                church_admin_debug(print_r( $chosenMenu,TRUE) );
                echo'DONE';
                exit();
            break;    
            case 'app-menu-login':
                check_ajax_referer('edit-app-menu','nonce');
                $chosenMenu=get_option('church_admin_app_new_menu');
                //church_admin_debug(print_r( $chosenMenu,TRUE) );
                $menuItem=stripslashes( $_POST['menuItem'] );
                $status=$_POST['status'];
                if( $status=="ON")
                {
                    $chosenMenu[$menuItem]['loggedinOnly']=1;
                }else  $chosenMenu[$menuItem]['loggedinOnly']=0;
                update_option('church_admin_app_new_menu',$chosenMenu);
                //church_admin_debug(print_r( $chosenMenu,TRUE) );
                echo'DONE';
                exit();
            break;     
            case 'add-ticket':
                require_once(plugin_dir_path( __FILE__) .'/includes/events.php');
                $x=$_REQUEST['id'];
                
                echo church_admin_event_ticket_form(NULL,$x,FALSE);
                
                exit();
            break;
            case 'event-ticket':
                require_once(plugin_dir_path( __FILE__) .'/display/events.php');
                $x=$_REQUEST['id'];
               
                $ticket=church_admin_front_end_ticket( $_REQUEST['event_id'],$x,TRUE);
                echo $ticket['output'];
                exit();
            break;
            case 'event-booking':
                require_once(plugin_dir_path( __FILE__) .'/display/events.php');
                
                $booking_ref =  church_admin_save_event_booking();
                //church_admin_debug( $booking_ref);
                //get cost
                $cost=$wpdb->get_var('SELECT SUM(a.ticket_price) FROM '.CA_TIK_TBL.' a, '.CA_BOO_TBL.' b WHERE a.ticket_id=b.ticket_type AND b.booking_ref="'.esc_sql( $booking_ref).'"');
                //church_admin_debug( $wpdb->last_query);
                //church_admin_debug( $cost);
                header('Access-Control-Max-Age: 1728000');
				header('Access-Control-Allow-Origin: *');
				header('Access-Control-Allow-Methods: *');
				header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
				header('Access-Control-Allow-Credentials: true');
                $output=json_encode(array('booking_ref'=>$booking_ref,'cost'=>$cost) );
                //church_admin_debug( $output);
                echo $output;
                exit();
                exit();
            break;
                
            case 'assign_funnel':
				check_admin_referer('assign_funnel','nonce');
				$check=$wpdb->get_var('SELECT id FROM '.CA_FP_TBL.' WHERE funnel_id="'.(int)$_REQUEST['funnel_id'].'" AND people_id="'.(int)$_REQUEST['people_id'].'" AND member_type_id="'.(int)$_REQUEST['member_type_id'].'" AND assign_id="'.(int)$_REQUEST['assign_id'].'" AND assigned_date="'.date("Y-m-d").'"');
				if(!$check)
				{
					$sql='INSERT INTO '.CA_FP_TBL .'(funnel_id,people_id,member_type_id,assign_id,assigned_date,completion_date)VALUES("'.(int)$_REQUEST['funnel_id'].'","'.(int)$_REQUEST['people_id'].'","'.(int)$_REQUEST['member_type_id'].'","'.(int)$_REQUEST['assign_id'].'","'.date("Y-m-d").'","0000-00-00")';
					church_admin_debug( $sql);
        			$wpdb->query( $sql);
				}
				//find name of funnel
				$funnel=$wpdb->get_var('SELECT action FROM '.CA_FUN_TBL.' WHERE funnel_id="'.(int)$_REQUEST['funnel_id'].'"');
				church_admin_debug( $wpdb->last_query);
				$response=array('people_id'=>(int)$_REQUEST['people_id'] );
				if(!empty( $funnel) )  {$response['message']= sprintf(__('Assigned to %1$s','church-admin'),$funnel);}else{$response['message']=__('Oopsie','church-admin');}
				header('Access-Control-Max-Age: 1728000');
				header('Access-Control-Allow-Origin: *');
				header('Access-Control-Allow-Methods: *');
				header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
				header('Access-Control-Allow-Credentials: true');
				echo json_encode( $response);
				exit();
				
			break;
			case 'app_menu_order':
			
				church_admin_debug("Posted".print_r( $_REQUEST,TRUE) );
				if(!empty( $_POST['order'] ) )
				{
					$order=explode(",",$_POST['order'] );
					$appMenu=get_option('church_admin_app_new_menu');
					foreach( $order AS $key=>$name)
					{
						church_admin_debug("Handling $name and giving it order of $key");
						if(!empty( $appMenu[$name] ) )$appMenu[$name]['order']=(int)$key;
					}
					church_admin_debug(print_r( $appMenu,TRUE) );
					update_option('church_admin_app_new_menu',$appMenu);
				}
			break;
			case 'update-oversight':
				check_admin_referer('update-oversight','nonce');
				church_admin_debug(print_r( $_POST,TRUE) );
				if(!empty( $_POST['name'] ) )  {$wpdb->query('UPDATE '.CA_CEL_TBL.' SET name="'.esc_sql(stripslashes( $_POST['name'] ) ).'" WHERE ID="'.(int)$_POST['cell_id'].'"');}
				if(!empty( $_POST['people'] ) )
				{
					$wpdb->query('DELETE FROM '.CA_MET_TBL.' WHERE meta_type="oversight" AND ID="'.(int)$_POST['cell_id'].'"');
					$autocompleted=explode(',',$_POST['people'] );//string with entered names

				foreach( $autocompleted AS $x=>$name)
				{
					$p_id=church_admin_get_one_id(trim( $name) );//get the people_id

					if(!empty( $p_id) )
					{
						church_admin_update_people_meta((int)$_POST['cell_id'],$p_id,'oversight');//update person as leader at that level
					}
				}
			}
				
			break;
			case 'ministry-parents':
				church_admin_debug(print_r( $_POST,TRUE) );
				$order=explode(",",$_POST['order'] );
				church_admin_debug(print_r( $order,TRUE) );
				$wpdb->query('UPDATE '.CA_MIN_TBL.' SET parentID=NULL');
				for ( $x=0; $x<count( $order)-1; $x++ )
				{
					
					$sql='UPDATE '.CA_MIN_TBL.' SET parentID="'.(int)substr( $order[$x],3).'" WHERE ID="'.(int)substr( $order[$x+1],3).'"';
					church_admin_debug( $sql);
					$wpdb->query( $sql);
				}
				
				church_admin_debug( $sql);
				$wpdb->query( $sql);
			break;
			case 'remove-image':
				check_ajax_referer( 'remove-image', 'nonce' );

				switch( $_POST['type'] )
				{
					case'people':$wpdb->query('UPDATE '.CA_PEO_TBL.' SET attachment_id=NULL WHERE people_id="'.(int)$_POST['id'].'"');break;
					case'household':$wpdb->query('UPDATE '.CA_HOU_TBL.' SET attachment_id=NULL WHERE household_id="'.(int)$_POST['id'].'"');break;
				}
				echo (int)$_POST['id'];
				exit();
			break;
			case 'show-person':
				check_ajax_referer( 'show-person', 'security' );
				require_once(plugin_dir_path( __FILE__) .'/display/address-list.php');
				$data= church_admin_people_data((int)$_POST['id'] );
				church_admin_debug(print_r( $data,TRUE) );
				echo church_admin_formatted_household( $data,$_POST['map'],$_POST['updateable'],$_POST['photo'],$_POST['vcf'],$_POST['address_style'] );
				exit();
			break;
            case 'show-personv2':
				check_ajax_referer( 'show-person', 'security' );
				require_once(plugin_dir_path( __FILE__) .'/display/address-list.php');
				$data= church_admin_people_data((int)$_POST['id'] );
				church_admin_debug(print_r( $data,TRUE) );
				header('Access-Control-Max-Age: 1728000');
		          header('Access-Control-Allow-Origin: *');
		          header('Access-Control-Allow-Methods: *');
		          header('Access-Control-Allow-Headers: Content-MD5, X-Alt-Referer');
		          header('Access-Control-Allow-Credentials: true');
                 
                    $outputData=church_admin_formatted_household( $data,$_POST['map'],$_POST['updateable'],$_POST['photo'],$_POST['vcf'],$_POST['address_style'] );
                echo json_encode(array('householdIndex'=>$data['household_index'],'id'=>$data['household_id'],'entry'=>$outputData) );
				exit();
			break;
			//podcast
			case "podcast-file"://checked
				require_once(plugin_dir_path( __FILE__) .'/display/sermon-podcast.php');
				church_admin_debug('podcast file');
				echo church_admin_podcast_file_detail((int)$_POST['id'],FALSE);
				exit();
			break;
            case 'dropdown'://checked
                if(defined('CA_DEBUG') )
                {
                    church_admin_debug('FUNCTION church_admin_podcast_files_list');
                    church_admin_debug(print_r( $_REQUEST,TRUE) );
                }
				require_once(plugin_dir_path( __FILE__) .'/display/sermon-podcast.php');
                $response=array();
                if(defined('CA_DEBUG') )  {church_admin_debug('Calling church_admin_podcast_file_list');}
                $file_list=church_admin_podcast_files_list((int)$_REQUEST['series_id'],(int)$_REQUEST['page'],(int)$_REQUEST['limit'],stripslashes( $_REQUEST['speaker'] ),NULL,stripslashes( $_REQUEST['order'] ) );
               $series_detail=''; 
               if(!empty( $_REQUEST['series_id'] ) )$series_detail=church_admin_podcast_series_detail((int)$_REQUEST['series_id'],NULL);
                
                $SQL=array();
                if(!empty( $_REQUEST['series_id'] ) )
                {
                    $SQL[]=' AND series_id="'.(int)$_REQUEST['series_id'].'"';
                }
                if(!empty( $_REQUEST['speaker'] ) )
                {
                    $speaker=stripslashes( $_REQUEST['speaker'] );
                    $SQL[]=' AND speaker LIKE "%'.esc_sql( $speaker).'%"';
                }
                $first_sermon_id=$wpdb->get_var('SELECT file_id FROM '.CA_FIL_TBL.' WHERE 2=2 '.implode(" ",$SQL).' ORDER BY pub_date '.esc_sql( $_REQUEST['order'] ).' LIMIT 1');
                $first_sermon=church_admin_podcast_file_detail( $first_sermon_id,$exclude=NULL);
                
                $outputArray=array('series_detail'=>$series_detail,'file_list'=>$file_list,'first_sermon'=>$first_sermon,'file_id'=>$first_sermon_id);
                if(defined('CA_DEBUG') )
                {
                    church_admin_debug(print_r( $outputArray,TRUE) );
                   
                }
				echo json_encode( $outputArray);
				exit();
			break;    
			case 'series-dropdown'://checked
				require_once(plugin_dir_path( __FILE__) .'/display/sermon-podcast.php');
                $response=array();
                $file_list=church_admin_podcast_files_list((int)$_REQUEST['id'],(int)$_REQUEST['page'],(int)$_REQUEST['limit'] );
                $series_detail=church_admin_podcast_series_detail((int)$_REQUEST['id'],NULL);
                $first_sermon_id=$wpdb->get_var('SELECT file_id FROM '.CA_FIL_TBL.' WHERE series_id="'.(int)$_REQUEST['id'].'" ORDER BY pub_date DESC LIMIT 1');
                $first_sermon=church_admin_podcast_file_detail( $first_sermon_id,$exclude=NULL);
				echo json_encode(array('series_detail'=>$series_detail,'file_list'=>$file_list,'first_sermon'=>$first_sermon,'file_id'=>$first_sermon_id) );
				exit();
			break;
            case 'speaker-dropdown'://checked
				require_once(plugin_dir_path( __FILE__) .'/display/sermon-podcast.php');
                $response=array();
                $file_list=church_admin_podcast_files_list(NULL,(int)$_REQUEST['page'],(int)$_REQUEST['limit'],esc_html( $_REQUEST['speaker'] ) );
                $series_detail=church_admin_podcast_series_detail(NULL,NULL);
                $first_sermon_id=$wpdb->get_var('SELECT file_id FROM '.CA_FIL_TBL.' WHERE speaker LIKE"%'.esc_sql( $_REQUEST['speaker'] ).'%" ORDER BY pub_date DESC LIMIT 1');
                $first_sermon=church_admin_podcast_file_detail( $first_sermon_id,$exclude=NULL);
				echo json_encode(array('series_detail'=>$series_detail,'file_list'=>$file_list,'first_sermon'=>$first_sermon,'file_id'=>$first_sermon_id) );
				exit();
			break;    
			case 'latest-series-sermon':
			require_once(plugin_dir_path( __FILE__) .'/display/sermon-podcast.php');

				echo church_admin_podcast_latest_sermon((int)$_REQUEST['id'] );
				exit();
			break;
			case 'more-sermons'://checked
				require_once(plugin_dir_path( __FILE__) .'/display/sermon-podcast.php');
				echo church_admin_podcast_files_list((int)$_REQUEST['series_id'],(int)$_REQUEST['page'],(int)$_REQUEST['limit'],esc_html( $_REQUEST['speaker'] ),$_REQUEST['sermon-search'] );
				exit();
			break;
            case 'sermon-search'://checked
				require_once(plugin_dir_path( __FILE__) .'/display/sermon-podcast.php');
				echo church_admin_podcast_files_list(NULL,(int)$_REQUEST['page'],(int)$_REQUEST['limit'],NULL,$_REQUEST['sermon-search'] );
				exit();
			break;
			case 'unattach_user'://checked
				check_ajax_referer( 'church_admin_unattach_user', 'nonce' );
				church_admin_unattach_user();
			break;
			case 'autocomplete'://checked
				check_ajax_referer( 'church-admin-autocomplete', 'security' );
				church_admin_ajax_people(TRUE);
			break;
			case 'mp3_plays'://checked
				church_admin_debug('Logging a play');
				
				church_admin_mp3_plays();
			break;
			case 'username_check'://checked
				church_admin_username_check();
			break;

			case 'filter'://checked
				require_once(plugin_dir_path( __FILE__) .'/includes/filter.php');

				church_admin_filter_callback();
			break;
			case 'filter_email'://checked
				require_once(plugin_dir_path( __FILE__) .'/includes/filter.php');
                //following function is in functions.php
				church_admin_filter_email_callback();
			break;
			case 'people_activate'://checked
				church_admin_people_activate_callback();
			break;
			case'note_delete':
				church_admin_note_delete_callback();
			break;
			case 'calendar_date_display':
				church_admin_date();
			break;

			case'connect_user':
				check_ajax_referer('connect_user','nonce',TRUE);
				if(church_admin_level_check('Directory') )
				{
                    church_admin_debug(print_r( $_POST,TRUE) );
                    if(!empty( $_POST['user_id'] )&&ctype_digit( $_POST['user_id'] ) )$ID=church_admin_user_id_exists( $_POST['user_id'] );
                    if(!empty( $_POST['people_id'] )&&ctype_digit( $_POST['people_id'] )&& !empty( $ID) )
                    {
                        $sql='UPDATE '.CA_PEO_TBL.' SET user_id="'.(int)$_POST['user_id'].'" WHERE people_id="'.(int)$_POST['people_id'].'"';
                        church_admin_debug( $sql);
                        $wpdb->query( $sql);
                        $user=get_userdata( $_POST['user_id'] );
                        $response= json_encode(array('login'=>$user->user_login,'people_id'=>(int)$_POST['people_id'] ) );
                        church_admin_debug( $response);
                        echo $response;
                    }
				}
				exit();
			break;
			case'create_user':
				check_ajax_referer('create_user','nonce',TRUE);
				if(church_admin_level_check('Directory') )
				{
                    church_admin_debug(print_r( $_POST,TRUE) );

                    if(!empty( $_POST['people_id'] )&&ctype_digit( $_POST['people_id'] ) )
                    {
                        $person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$_POST['people_id'].'"');
                        
                        church_admin_create_user( $person->people_id,$person->household_id);
                        $userID=$wpdb->get_var('SELECT user_id FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$_POST['people_id'].'"');
                        $user= get_userdata( $userID);
                        $response= json_encode(array('login'=>$user->user_login.' '.$out,'people_id'=>(int)$_POST['people_id'] ) );
                        church_admin_debug( $response);
                        echo $response;

                        
                    }
                }
				exit();
			break;
			case 'individual_attendance':
					church_admin_debug('Individual attendance');
					check_ajax_referer('individual_attendance','nonce',TRUE);

					$sql='SELECT * FROM '.CA_IND_TBL.' WHERE meeting_type="'.esc_sql( $_GET['meeting_type'] ).'" AND meeting_id="'.(int)$_GET['meeting_id'].'" AND `date`="'.esc_sql( $_GET['date'] ).'"';
					church_admin_debug( $sql);
					$results=$wpdb->get_results( $sql);
					church_admin_debug(print_r( $results,TRUE) );
					$out=array();
					if(!empty( $results) )
					{
						foreach( $results AS $row)
						{
							$out[]='person-'.$row->people_id;

						}
						church_admin_debug(print_r( $out,TRUE) );
						echo json_encode( $out);
					}
					exit();
			break;
			case 'image_upload':
			check_ajax_referer('church_admin_image_upload','nonce',TRUE);
				// These files need to be included as dependencies when on the front end.
				require_once( ABSPATH . 'wp-admin/includes/image.php' );
				require_once( ABSPATH . 'wp-admin/includes/file.php' );
				require_once( ABSPATH . 'wp-admin/includes/media.php' );
				// Let WordPress handle the upload.
				// Remember, 'my_image_upload' is the name of our file input in our form above.
				$attachment_id = media_handle_upload( 'file-0', 0 );
				church_admin_debug( $attachment_id);
				if ( is_wp_error( $attachment_id ) ) {
						// There was an error uploading the image.
				} else {
				// The image was uploaded successfully!
				$image=wp_get_attachment_image_src(  $attachment_id, "medium", false );
				church_admin_debug(print_r( $image,TRUE) );
				echo json_encode(array('src'=>$image[0],'attachment_id'=>$attachment_id) );
				exit();
			}
			break;
            case 'household-upload':
                //church_admin_debug("*********************\r\n Household image upload");
                //church_admin_debug(print_r( $_POST,TRUE) );
                //church_admin_debug(print_r( $_FILES,TRUE) );
                check_ajax_referer('household-image-upload','nonce',TRUE);
				// These files need to be included as dependencies when on the front end.
				require_once( ABSPATH . 'wp-admin/includes/image.php' );
				require_once( ABSPATH . 'wp-admin/includes/file.php' );
				require_once( ABSPATH . 'wp-admin/includes/media.php' );
				// Let WordPress handle the upload.
				$attachment_id = media_handle_upload( 'userImage', 0 );
                //church_admin_debug("attachment id $attachment_id");
				
				if ( is_wp_error( $attachment_id ) ) {
						// There was an error uploading the image.
				} else {
				// The image was uploaded successfully!
				$image=wp_get_attachment_image_src(  $attachment_id, "medium", false );
				//church_admin_debug(print_r( $image,TRUE) );
                if(!empty( $_POST['id'] ) )$wpdb->query('UPDATE '.CA_HOU_TBL.' SET attachment_id="'.(int)$attachment_id.'" WHERE household_id="'.(int)$_POST['id'].'"');    
				echo json_encode(array('src'=>$image[0],'attachment_id'=>$attachment_id,'div'=>'household-image','id'=>'attachment_id') );
				exit();
			}
			break;
            case 'smallgroup-upload':
                //church_admin_debug("*********************\r\n People image upload");
                //church_admin_debug(print_r( $_POST,TRUE) );
                //church_admin_debug(print_r( $_FILES,TRUE) );
                
                check_ajax_referer('smallgroup-image-upload','nonce',TRUE);
				// These files need to be included as dependencies when on the front end.
				require_once( ABSPATH . 'wp-admin/includes/image.php' );
				require_once( ABSPATH . 'wp-admin/includes/file.php' );
				require_once( ABSPATH . 'wp-admin/includes/media.php' );
				// Let WordPress handle the upload.
				$attachment_id = media_handle_upload( 'userImage', 0 );
				//church_admin_debug("attachment id $attachment_id");
				if ( is_wp_error( $attachment_id ) ) {
						// There was an error uploading the image.

				} else {
				// The image was uploaded successfully!
				$image=wp_get_attachment_image_src(  $attachment_id, "medium", false );
				church_admin_debug(print_r( $image,TRUE) );
                if(!empty( $_POST['id'] ) )$wpdb->query('UPDATE '.CA_SMG_TBL.' SET attachment_id="'.(int)$attachment_id.'" WHERE id="'.(int)$_POST['id'].'"');    
				echo json_encode(array('src'=>$image[0],'attachment_id'=>$attachment_id,'div'=>'smallgroup-image'.(int)$_POST['id'],'id'=>'attachment_id') );
				exit();
			}
			break;
            case 'people-upload':
                //church_admin_debug("*********************\r\n People image upload");
                //church_admin_debug(print_r( $_POST,TRUE) );
                //church_admin_debug(print_r( $_FILES,TRUE) );
                
                check_ajax_referer('people-image-upload','nonce',TRUE);
				// These files need to be included as dependencies when on the front end.
				require_once( ABSPATH . 'wp-admin/includes/image.php' );
				require_once( ABSPATH . 'wp-admin/includes/file.php' );
				require_once( ABSPATH . 'wp-admin/includes/media.php' );
				// Let WordPress handle the upload.
				$attachment_id = media_handle_upload( 'userImage', 0 );
				//church_admin_debug("attachment id $attachment_id");
				if ( is_wp_error( $attachment_id ) ) {
						// There was an error uploading the image.

				} else {
				// The image was uploaded successfully!
				$image=wp_get_attachment_image_src(  $attachment_id, "medium", false );
				church_admin_debug(print_r( $image,TRUE) );
                if(!empty( $_POST['id'] ) )$wpdb->query('UPDATE '.CA_PEO_TBL.' SET attachment_id="'.(int)$attachment_id.'" WHERE people_id="'.(int)$_POST['id'].'"');    
				echo json_encode(array('src'=>$image[0],'attachment_id'=>$attachment_id,'div'=>'people-image'.(int)$_POST['id'],'id'=>'attachment_id','people_id'=>(int)$_POST['id'] ) );
				exit();
			}
			break;
          
            case 'series-upload':
                //church_admin_debug("*********************\r\n People image upload");
                //church_admin_debug(print_r( $_POST,TRUE) );
                //church_admin_debug(print_r( $_FILES,TRUE) );
                
                check_ajax_referer('series-image-upload','nonce',TRUE);
				// These files need to be included as dependencies when on the front end.
				require_once( ABSPATH . 'wp-admin/includes/image.php' );
				require_once( ABSPATH . 'wp-admin/includes/file.php' );
				require_once( ABSPATH . 'wp-admin/includes/media.php' );
				// Let WordPress handle the upload.
				$attachment_id = media_handle_upload( 'userImage', 0 );
				//church_admin_debug("attachment id $attachment_id");
				if ( is_wp_error( $attachment_id ) ) {
						// There was an error uploading the image.

				} else {
				// The image was uploaded successfully!
				$image=wp_get_attachment_image_src(  $attachment_id, "medium", false );
				church_admin_debug(print_r( $image,TRUE) );
                if(!empty( $_POST['id'] ) )$wpdb->query('UPDATE '.CA_SERM_TBL.' SET series_image="'.(int)$attachment_id.'" WHERE series_id="'.(int)$_POST['id'].'"');    
				echo json_encode(array('src'=>$image[0],'attachment_id'=>$attachment_id,'div'=>'series-image','id'=>'attachment_id') );
				exit();
			}
			break;
			case 'remove-app-logo':
				check_ajax_referer('remove-app-logo','nonce',TRUE);
				delete_option('church_admin_app_logo');
				echo TRUE;
				exit();
			break;
			case 'update-app-logo':
				check_ajax_referer('update-app-logo','nonce',TRUE);
				update_option('church_admin_app_logo',stripslashes( $_POST['logo'] ) );
				echo TRUE;
				exit();
			break;
			case 'category_list':
				//filter count
				require_once(plugin_dir_path( __FILE__) .'/includes/filter.php');
				echo church_admin_filter_count(null);
				exit();
			break;
           
			case 'edit_rota':
                $premium=get_option('church_admin_payment_gateway');
                if(!$current_user||!church_admin_level_check('rota',$current_user->ID) )
                {
                    exit();
                }
				church_admin_debug("Edit rota Ajax\r\n".print_r( $_POST,TRUE) );
				//check_ajax_referer('edit_rota','nonce',TRUE);
				$rota_task_id=$_POST['rota_task_id'];
				$rota_date=$_POST['rota_date'];
				$content=stripslashes( $_POST['content'] );
				$idtochange=stripslashes( $_POST['idtochange'] );
				$service_time=$_POST['time'];
				$service_id=(int)$_POST['service_id'];
				//delete current entry
				$wpdb->query('DELETE FROM '.CA_ROTA_TBL.' WHERE rota_task_id="'.(int)$rota_task_id.'" AND rota_date="'.esc_sql( $rota_date).'" AND service_time="'.esc_sql( $service_time).'" AND service_id="'.(int)$service_id.'" AND mtg_type="service"');
				church_admin_debug( $wpdb->last_query);
				$people=unserialize(church_admin_get_people_id( $content) );
                church_admin_debug("people ids hopefully");
                church_admin_debug( $people);
				$peopleIDs=array_unique( $people);//prevent duplication
				foreach( $peopleIDs AS $key=>$people_id)
				{
					
					$check=FALSE;
                    if(!empty( $premium) )
                    {
                        church_admin_debug('CHECK availability');
                        $check=$wpdb->get_var('SELECT not_id FROM '.CA_NOT_TBL.' WHERE unavailable="'.esc_sql( $rota_date).'" AND people_id="'.(int)$people_id.'"');
                        church_admin_debug( $wpdb->last_query);
                        church_admin_debug('CHECK - '.$check);
                    }
                    if ( empty( $check) )
                    {
                        church_admin_debug('OKAY to save');
                        church_admin_update_rota_entry( $rota_task_id,$rota_date,$people_id,'service',$service_id,$service_time);
                    }
                    else
                    {
                        $person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
                        $errors[]='<strong>'.sprintf(__('%1$s not added ','church-admin'),church_admin_formatted_name( $person) ).'</strong>';
                        $content='';
                    }
					
				}
                //$idOfSpan=esc_html('rota-item-'.$rota_date.'-'.$service_id.'-'.$id);
				$newContent='';
                
                $newContent.='<span data-service_id="'.(int)$service_id.'" data-time="'.esc_html( $service_time).'" data-id="'.esc_html( $idtochange).'" data-rota_date="'.$rota_date.'" data-rota_task_id="'.(int)$rota_task_id.'" class="rota_edit">';
                if(!empty( $errors) )
                {
                    $newContent.=implode("<br />",$errors);
                }
                $newContent.=esc_html( $content).'</span>'; 
				
                $output=json_encode(array('idtochange'=>esc_html( $idtochange),'content'=>$newContent,'persondata'=>esc_html( $content) ));
				church_admin_debug( $output);
                echo $output;
				exit();
			break;
		}



}

add_action('init','church_admin_receive_prayer');

function church_admin_receive_prayer()
{
	//handle front end prayer request which needs to happen later than plugins_loaded action
	global $church_admin_prayer_request_success;
	if(!empty( $_POST['save_prayer_request'] )&&!empty( $_POST['non_spammer'] )&&wp_verify_nonce( $_POST['non_spammer'],'prayer-request') )
	{
        if(is_user_logged_in()){
            $user=wp_get_current_user();
            $ID=$user->ID;
        }
        if(empty($ID))$ID=1;
        church_admin_debug("**** church_admin_receive_prayer ****");
        church_admin_debug('$_POST ');
        church_admin_debug($_POST);
        $post_content=sanitize_textarea_field( $_POST['request_content'] );
        $post_title=wp_strip_all_tags( $_POST['request_title'] );
        $post_type='prayer-requests';
		$args=array(
                'post_author'=>(int)$ID,
				'post_content'=>$post_content,
				'post_title'=>$post_title,
				'post_status'=>'draft',
				'post_type'=>$post_type
			);
                            
		if(church_admin_level_check('Prayer Requests') )  {$args['post_status']='publish';}
        //post_exists not available in front end, so check and require post.php if needed
        if ( ! function_exists( 'post_exists' ) ) {
            require_once( ABSPATH . 'wp-admin/includes/post.php' );
        }
        church_admin_debug('Args for insert_post');
        church_admin_debug($args);
        if(post_exists( $post_title, $post_content, '', $post_type, '' ) )return;
		$postid = wp_insert_post( $args);

		if( $postid)
		{
                church_admin_debug('Post inserted');
				//the post is valid
				$church_admin_prayer_request_success='<div class="notice notice-success">';
				if( $args['post_status']=='publish')  {
                    $church_admin_prayer_request_success.=__('Your prayer-request has been published','church-admin');
                    church_admin_debug('Post status - publish');
                }
				else
				{
                    church_admin_debug('Post status - draft');
					$church_admin_prayer_request_success.=__('Your prayer-request has been put in the moderation queue','church-admin');
					$message='<p>'.__('New prayer request draft for moderation','church-admin').'</p><p><a href="'.admin_url().'?edit.php?post_type=prayer-requests">'.__('View prayer requests','church-admin').'</a>';
				    $prm= get_option('prayer-request-moderation');
                    
                    if(empty( $prm) )$prm=get_option('admin_email');
                    church_admin_debug('Email to be sent to :'.$prm);
                    add_filter( 'wp_mail_from_name','church_admin_from_name' );
                    add_filter( 'wp_mail_from', 'church_admin_from_email');
                    add_filter('wp_mail_content_type','church_admin_email_type');
                    
                    if(wp_mail( $prm,__('Prayer Request Draft','church-admin'),__('A draft prayer request has been posted. Please moderate','church-admin') ))
                    {
                        church_admin_debug('Email sent');
                    }
                    
                    church_admin_debug( print_r( $GLOBALS['phpmailer'] ,TRUE));
                    remove_filter('wp_mail_content_type','church_admin_email_type');
                    remove_filter( 'wp_mail_from_name','church_admin_from_name' );
                    remove_filter( 'wp_mail_from', 'church_admin_from_email');
                    
                    
                    /*****************************************
                     * push to admins if required!
                     * 
                     * ***************************************/
                    $prayer_request_people_ids=get_option('church_admin_prayer_request_receive_push_to_admin');
                    church_admin_debug('Attempting to push prayer request moderation');
                    church_admin_debug(print_r( $prayer_request_people_ids,TRUE) );
                    $licence=get_option('church_admin_app_new_licence');
                    if(!empty( $prayer_request_people_ids)&&!empty( $licence) )
                    {
                        $pushTokens=church_admin_get_push_tokens_from_ids( $prayer_request_people_ids);
                        church_admin_debug('Push tokens');
                        //church_admin_debug(print_r( $pushTokens,TRUE) );
                        if(!empty( $pushTokens) )
                        {
                            require_once( plugin_dir_path( __FILE__ ).'includes/push.php');
                        
                            $dataMessage=$message= esc_html( __('Please moderate a new prayer request','church-admin') );
                            //$dataMessage=$message.'<p><a href="'.admin_url().'edit.php?post_type=prayer-requests">'.__('View prayer requests','church-admin').'</a>';
                            
                            church_admin_debug('Data Message variable: ' . $dataMessage);
                            church_admin_filtered_push( $message,$pushTokens,esc_html(  __('Prayer Request Moderation','church-admin') ),$dataMessage,'prayer',NULL);

                        }


                    }
                    
				}
				$church_admin_prayer_request_success.='</div>';
		}
	}
}





add_action('init','church_admin_acts_courage');

function church_admin_acts_courage()
{
	//handle front end prayer request which needs to happen later than plugins_loaded action
	global $church_admin_acts_success;
	if(!empty( $_POST['save_act_of_courage_request'] )&&!empty( $_POST['non_spammer'] )&&wp_verify_nonce( $_POST['non_spammer'],'acts-of-courage') )
	{

		$args=array(
								'post_content'=>sanitize_textarea_field( $_POST['request_content'] ),
								'post_title'=>wp_strip_all_tags( $_POST['request_title'] ),
								'post_status'=>'draft',
								'post_type'=>'acts-of-courage'
							);
		if(church_admin_level_check('Prayer Requests') )  {$args['post_status']='publish';}


		$postid = wp_insert_post( $args);

		if( $postid)
		{

				//the post is valid
				$church_admin_acts_success='<div class="notice notice-success">';
				if( $args['post_status']=='publish')  {
                    $church_admin_acts_success.=esc_html(  __('Your act of courage has been published','church-admin') );
                }
				else
				{
					$church_admin_acts_success.=esc_html(  __('Your act of courage has been put in the moderation queue','church-admin') );
					$message='<p>'.esc_html(  __('New act of courage draft for moderation','church-admin') ).'</p>';
					wp_mail(get_option('admin_email'),esc_html(  __('New act of courage draft for moderation','church-admin') ) ,$message);

				}
				$church_admin_acts_success.='</div>';
		}
	}
}

/**
 * Redirect user after successful login.
 *
 * @param string $redirect_to URL to redirect to.
 * @param string $request URL the user is coming from.
 * @param object $user Logged user's data.
 * @return string
 */

function church_admin_login_redirect( $redirect_to, $request, $user ) {
   	$check=get_option('church_admin_login_redirect');
   	if( $check && isset( $user->roles) && is_array( $user->roles) ) {
        //check for subscribers
        if (in_array('subscriber', $user->roles) ) {
            // redirect them to another URL, in this case, the homepage 
            $redirect_to =  $check;
        }
    }

    return $redirect_to;
}

add_filter( 'login_redirect', 'church_admin_login_redirect', 10, 3 );


/**************************************************************************
*
*   Paypal GIVING IPN
*
*
***************************************************************************/
add_action( 'wp_ajax_church_admin_paypal_giving_ipn', 'church_admin_paypal_giving_ipn_callback' );
add_action( 'wp_ajax_nopriv_church_admin_paypal_giving_ipn', 'church_admin_paypal_giving_ipn_callback' );
function church_admin_paypal_giving_ipn_callback() {
    global $wpdb;
    
    church_admin_debug("Paypal Giving IPN Call");
	
    // here we can verify and validate the transactions.
    
    // STEP 1: read POST data
    // Reading POSTed data directly from $_POST causes serialization issues with array data in the POST.
    // Instead, read raw POST data from the input stream.
    $raw_post_data = file_get_contents('php://input');
    $raw_post_array = explode('&', $raw_post_data);
    $myPost = array();
    foreach ( $raw_post_array as $keyval) 
    {
        $keyval = explode ('=', $keyval);
        if (count( $keyval) == 2)$myPost[$keyval[0]] = urldecode( $keyval[1] );
    }
    // read the IPN message sent from PayPal and prepend 'cmd=_notify-validate'
    $req = 'cmd=_notify-validate';
    if (function_exists('get_magic_quotes_gpc') ) {
        $get_magic_quotes_exists = true;
    }
    foreach ( $myPost as $key => $value) 
    {
        if ( $get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1) 
        {
            $value = urlencode(stripslashes( $value) );
        } 
        else 
        {
            $value = urlencode( $value);
        }
        $req .= "&$key=$value";
    }
   
    // Step 2: POST IPN data back to PayPal to validate
    $ch = curl_init(CA_PAYPAL);
    curl_setopt( $ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
    curl_setopt( $ch, CURLOPT_POST, 1);
    curl_setopt( $ch, CURLOPT_RETURNTRANSFER,1);
    curl_setopt( $ch, CURLOPT_POSTFIELDS, $req);
    curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, 1);
    curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt( $ch, CURLOPT_FORBID_REUSE, 1);
    curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Connection: Close') );


    if ( !( $res = curl_exec( $ch) ) ) 
    {
        church_admin_debug("Got " . curl_error( $ch) . " when processing IPN data");
        curl_close( $ch);
        exit;
    }
    curl_close( $ch);
    // inspect IPN validation result and act accordingly
    if (strcmp ( $res, "VERIFIED") == 0) 
    {
        church_admin_debug("Verified");
        church_admin_debug(print_r( $_POST,TRUE) );
        // The IPN is verified, process it
        if(!empty( $_POST['mc_gross1'] ) )
        {
            $payment_amount = esc_sql( $_POST['mc_gross1']-$_POST['mc_fee'] );
        }
        else
        {
            $payment_amount = esc_sql( $_POST['mc_gross']-$_POST['mc_fee'] );
        }
        $fund=urldecode( $_POST['item_name'] );
        if ( empty( $fund) )$fund=__('General','church-admin');
        if(!empty( $_POST['custom'] ) )  {$giftAid=1;}else{$giftAid=0;}
        
        $txn_id = esc_sql( $_POST['txn_id'] );
        $continue=FALSE;
        switch( $_POST['txn_type'] )
        {
            case 'subscr_payment':
                $txn_type=__('Paypal','church-admin');
                $txn_frequency=__('Monthly','church-admin');
                $gross_amount=$_POST['mc_gross'];
                $paypal_fee=$_POST['mc_fee'];
                $continue=TRUE;
            break;
            case 'web_accept':  
                $txn_type=__('Paypal','church-admin');
                $txn_frequency=__('One off','church-admin');
                $gross_amount=$_POST['mc_gross'];
                $paypal_fee=$_POST['mc_fee'];
                $continue=TRUE;
            break;   
                
        }
        if( $continue)
        {   
            $payer_email = esc_sql( $_POST['payer_email'] );
            $people_id= (int)$_POST['custom'];
            if ( empty( $people_id) )
            {
                $person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE email="'.$payer_email.'"LIMIT 1');
                if(!empty( $giftAid)&&!empty( $person) )
                {
                    $wpdb->query('UPDATE '.CA_PEO_TBL.' SET gift_aid=1 WHERE people_id="'.(int)$person->people_id.'"');
                }
                
            }
            
            if ( empty( $people_id) )$people_id=0;
            if(!empty( $_POST['first_name'] )&&!empty( $_POST['last_name'] ) )
            {
                $name=esc_sql(stripslashes( $_POST['first_name'].' '.$_POST['last_name'] ) );
            }
            else
            {
                $name='';
            }
            if(!empty( $_POST['address_street'] ) )
            {
                $address=implode(", ",array_filter(array(stripslashes( $_POST['address_street'] ),stripslashes( $_POST['address_city'] ),stripslashes( $_POST['address_city'] ),stripslashes( $_POST['address_state'] ),stripslashes( $_POST['address_zip'] ) )) );
            }else{$address='';}
            /*
            //Deprecated code
            $sql='SELECT giving_id FROM '.CA_GIV_TBL.' WHERE gross_amount="'.$gross_amount.'" AND paypal_fee="'.$paypal_fee.'" AND txn_id="'.$txn_id.'" AND payer_email="'.$payer_email.'" AND people_id="'.(int)$people_id.'"';
            church_admin_debug( $sql);
            $check=$wpdb->get_var( $sql);

            if ( empty( $check) )
            {
                $wpdb->query('INSERT INTO '.CA_GIV_TBL.' (gross_amount,paypal_fee,gift_aid,txn_id,txn_type,txn_frequency,email,people_id,donation_date,fund,service_id,name,address) VALUES ("'.$gross_amount.'","'.$paypal_fee.'","'.$giftAid.'","'.$txn_id.'","PayPal","'.$txn_frequency.'","'.$payer_email.'","'.$people_id.'","'.date('Y-m-d H:i:s').'","'.esc_sql(stripslashes( $_POST['item_name'] ) ).'","0","'.$name.'","'.$address.'")');
                church_admin_debug( $wpdb->last_query);
            }
            */
            /***************************************************
             *  Delete any previous transactions with the txn_id
             * *************************************************/
            $givng_id=$wpdb->get_var('SELECT giving_id FROM '.CA_GIV_TBL.' WHERE txn_id="'.$txn_id.'"');
            if(!empty( $giving_id) )
            {
                $wpdb->query('DELETE FROM '.CA_GIV_TBL.' WHERE giving_id="'.(int)$giving_id.'"');
                $wpdb->query('DELETE FROM '.CA_GMET_TBL.' WHERE giving_id="'.(int)$giving_id.'"');
            }
            /***************************
             * Insert into Giving table
             ***************************/
            $wpdb->query('INSERT INTO '.CA_GIV_TBL.' (txn_id,txn_type,txn_frequency,name,address,email,people_id,donation_date,gift_aid) VALUES ("'.$txn_id.'","PayPal","'.$txn_frequency.'","'.esc_sql( $name).'","'.esc_sql( $address).'","'.$payer_email.'","'.$people_id.'","'.date('Y-m-d H:i:s').'","'.$giftAid.'")');
            $giving_id=$wpdb->insert_id;
            church_admin_debug( $wpdb->last_query);
            //Insert into Giving Meta table
            $wpdb->query('INSERT INTO '.CA_GMET_TBL.' (gross_amount,paypal_fee,txn_id,fund,giving_id) VALUES ("'.$gross_amount.'","'.$paypal_fee.'","'.$txn_id.'","'.esc_sql(stripslashes( $_POST['item_name'] ) ).'","'.(int)$giving_id.'")');
            church_admin_debug( $wpdb->last_query);
        }
        } else if (strcmp ( $res, "INVALID") == 0) 
        {
                // IPN invalid, log for manual investigation
                church_admin_debug("Not Verified");
        }
        exit();
}
add_action( 'wp_ajax_church_admin_paypal_ipn', 'church_admin_paypal_ipn_callback' );
add_action( 'wp_ajax_nopriv_church_admin_paypal_ipn', 'church_admin_paypal_ipn_callback' );
function church_admin_paypal_ipn_callback() {
    global $wpdb;
    church_admin_debug("Paypal IPN Call");
	
    // here we can verify and validate the transactions.
    
    // STEP 1: read POST data
    // Reading POSTed data directly from $_POST causes serialization issues with array data in the POST.
    // Instead, read raw POST data from the input stream.
    $raw_post_data = file_get_contents('php://input');
    $raw_post_array = explode('&', $raw_post_data);
    $myPost = array();
    foreach ( $raw_post_array as $keyval) 
    {
        $keyval = explode ('=', $keyval);
        if (count( $keyval) == 2)$myPost[$keyval[0]] = urldecode( $keyval[1] );
    }
    // read the IPN message sent from PayPal and prepend 'cmd=_notify-validate'
    $req = 'cmd=_notify-validate';
    if (function_exists('get_magic_quotes_gpc') ) {
        $get_magic_quotes_exists = true;
    }
    foreach ( $myPost as $key => $value) 
    {
        if ( $get_magic_quotes_exists == true && get_magic_quotes_gpc() == 1) 
        {
            $value = urlencode(stripslashes( $value) );
        } 
        else 
        {
            $value = urlencode( $value);
        }
        $req .= "&$key=$value";
    }
   
    // Step 2: POST IPN data back to PayPal to validate
    $ch = curl_init(CA_PAYPAL);
    curl_setopt( $ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
    curl_setopt( $ch, CURLOPT_POST, 1);
    curl_setopt( $ch, CURLOPT_RETURNTRANSFER,1);
    curl_setopt( $ch, CURLOPT_POSTFIELDS, $req);
    curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, 1);
    curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt( $ch, CURLOPT_FORBID_REUSE, 1);
    curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Connection: Close') );


    if ( !( $res = curl_exec( $ch) ) ) 
    {
        church_admin_debug("Got " . curl_error( $ch) . " when processing IPN data");
        curl_close( $ch);
        exit;
    }
    curl_close( $ch);
    // inspect IPN validation result and act accordingly
    if (strcmp ( $res, "VERIFIED") == 0) 
    {
        church_admin_debug("Verified");
        church_admin_debug(print_r( $_POST,TRUE) );
        // The IPN is verified, process it
        if(!empty( $_POST['mc_gross1'] ) )
        {
            $payment_amount = esc_sql( $_POST['mc_gross1'] );
        }
        else
        {
            $payment_amount = esc_sql( $_POST['mc_gross'] );
        }
        
        $txn_id = esc_sql( $_POST['txn_id'] );
        $payer_email = esc_sql( $_POST['payer_email'] );
        $booking_ref= esc_sql( $_POST['custom'] );
        $event_id=$wpdb->get_var('SELECT event_id FROM '.CA_BOO_TBL.' WHERE booking_ref="'.esc_sql( $booking_ref).'"');
        $sql='SELECT payment_id FROM '.CA_PAY_TBL.' WHERE amount="'.$payment_amount.'" AND txn_id="'.$txn_id.'" AND payer_email="'.$payer_email.'" AND event_id="'.(int)$event_id.'" AND booking_ref="'.$booking_ref.'"';
        church_admin_debug( $sql);
        $check=$wpdb->get_var( $sql);
        
        if ( empty( $check) )
        {
            $wpdb->query('INSERT INTO '.CA_PAY_TBL.' (amount,txn_id,payer_email,booking_ref,payment_date,event_id) VALUES ("'.$payment_amount.'","'.$txn_id.'","'.$payer_email.'","'.$booking_ref.'","'.date('Y-m-d H:i:s').'","'.(int)$event_id.'")');
            church_admin_debug( $wpdb->last_query);
        }
    } else if (strcmp ( $res, "INVALID") == 0) 
    {
        // IPN invalid, log for manual investigation
        church_admin_debug("Not Verified");
    }
}



add_action( 'save_post', 'church_admin_sermon_check', 10,3 );
function church_admin_sermon_check( $post_id, $post, $update)
{
    if(strpos( $post->post_content,'[church_admin') !== false && strpos( $post->post_content,'podcast') !== false)
    {
        
        update_option('church_admin_sermon_page',$post_id);
      
    }
}

function church_admin_find_sermon_page()
{
    /*
    global $wpdb;
    $result=$wpdb->get_var('SELECT ID FROM '.$wpdb->posts.' WHERE post_content LIKE "%[church_admin%" AND post_content LIKE"%podcast%" AND post_status="publish" LIMIT 1');
    if( $result) 
    {
        $link=get_permalink( $result);
      
        return $link;
    }
    */
    $sermonPageID=get_option('church-admin-sermon-page');
    if(!empty( $sermonPageID) )  {return get_permalink( $sermonPageID);}
    else return get_permalink(); 

}

function church_admin_cpanel_fix()
{
    church_admin_debug("Cpanel fix");
    //look in CA_PATH
    function church_admin_remover( $path)
    {
        if (is_dir( $path) ) 
        {
            if ( $dh = opendir( $path) ) 
            {
                while (( $file = readdir( $dh) ) !== false) 
                {
                    if( $file==".ea-php-cli.cache")
                    {
                        unlink( $path.$file);
                        church_admin_debug(" .ea-php-cli.cache deleted from ".$path);
                    }
                }
                    closedir( $dh);
            }
        }
    }
    church_admin_remover(CA_PATH);
    church_admin_remover(CA_PATH.'/display/');
    church_admin_remover(CA_PATH.'/includes/');
    church_admin_remover(CA_PATH.'/app/');
    church_admin_remover(CA_PATH.'/gutenberg/');
    church_admin_remover(CA_PATH.'/css/');
    
    
}

/*************************************************************
*
* Add column for custom button to the app-content post type
*
*************************************************************/
// Add the custom columns to the book post type:
add_filter( 'manage_app-content_posts_columns', 'church_admin_custom_app_content_columns' );
function church_admin_custom_app_content_columns( $columns) {
    unset( $columns['date'] );
   $columns['mybutton'] = __( 'App button code', 'church-admin' );
     $columns['date'] =__('Date','church-admin');
    return $columns;
}

// Add the data to the custom columns for the book post type:
add_action( 'manage_app-content_posts_custom_column' , 'church_admin_custom_app_content_column', 10, 2 );
function church_admin_custom_app_content_column( $column, $post_id ) {
    
    switch ( $column ) {
      
        case 'mybutton' :
            echo esc_html('<button id="myButton" class="button red" data-page="'.sanitize_title(get_the_title( $post_id) ).'">'.get_the_title( $post_id).'</button>');
        break;
    }
}

/*************************************************************
*
* Add don't send push notification for this post meta box
*
*************************************************************/

function church_admin_add_custom_box()
{
    $screens = ['post'];
    foreach ( $screens as $screen) {
        add_meta_box(
            'church_admin_no_push',           // Unique ID
            'Church Admin Post Settings',  // Box title
            'church_admin_custom_box_html',  // Content callback, must be of type callable
            $screen                   // Post type
        );
    }
}
add_action('add_meta_boxes', 'church_admin_add_custom_box');

function church_admin_custom_box_html( $post)
{
    ?>
    <label for="church_admin_field">Don't send a push notification when this post is published</label>
    <input type="checkbox" name="church_admin_no_push" id="church_admin_field" value=1/>
    
    <?php
}



function church_admin_create_directories()
{
    //use native WordPress functions to check and create directories 2020-09-30
   
    $upload_dir = wp_upload_dir();
    $church_admin_sermon_dir=$upload_dir['basedir'].'/sermons/';
    wp_mkdir_p( $church_admin_sermon_dir);
    $index="<?php\r\n//nothing is good;\r\n?>";
    if(is_dir( $church_admin_sermon_dir) )
    {
        $fp = fopen( $church_admin_sermon_dir.'index.php', 'w');
        fwrite( $fp, $index);
        fclose( $fp);    
    }
    $church_admin_cache_dir=$upload_dir['basedir'].'/church-admin-cache/';
    wp_mkdir_p( $church_admin_cache_dir);
    if(is_dir( $church_admin_sermon_dir) )
    {
        $fp = fopen( $church_admin_cache_dir.'index.php', 'w');
        fwrite( $fp, $index);
        fclose( $fp);    
    }
}

/******************************************************
 *  Add warning boxin v3.4.107 for MailChimp users
 ******************************************************/


function church_admin_mailchimp_warning_box()
{
    /*********************************
     * Only show if MailChimp set up
     *********************************/
    $mailChimpSettings=get_option('church_admin_mailchimp');
    if ( empty( $mailChimpSettings) )return;
    /*********************************
     * Only show if MailChimp set up
     *********************************/
    $mailchimpSyncd=get_option('church_admin_mail_chimp_syncd');
    if(!empty( $mailchimpSyncd) )return;
    echo '<div class="ca-boxes" id="mailchimp-warning">';
            echo    '<div class="ca-boxes-header ca-brown">'."\r\n";
            echo '<p><i class="fas fa-bullhorn fa-4x" aria-hidden="true"></i></p>'."\r\n";
            echo'<h3>'.__('MailChimp').'</h3>'."\r\n";
            echo'</div>'."\r\n";
            echo '<div class="ca-boxes-content">';
            echo '<p style="color:red"><strong>'.__('MailChimp has been updatedin plugin v3.4.107. It is really important you sync MailChimp now to ensure people still receive emails.','church-admin').'</strong></p>';
            echo'<p><a class="button-primary" href="admin.php?page=church_admin/index.php&action=sync-mailchimp">'.__('Sync now','church-admin').'</a></p>';
            echo'</div></div>';
}


/**
 * Adds a privacy policy statement.
 */
function church_admin_add_privacy_policy_content() {
	if ( ! function_exists( 'wp_add_privacy_policy_content' ) ) {
		return;
	}
	$content = '<p class="privacy-policy-tutorial">' . __( 'The Church Admin plugin handles a fair of amount personal data within the website in a secure way. ', 'church-admin' ) . '</p>'
			
			. '<h3>'.__('Registration','church-admin').'</h3>'
            .'<p>'.__('When you register on this website, your information is stored in our database and viewable by the church admin team. You can set your own privacy settings to restrict who can see what and if and how you are communicated with.','church-admin')
            .'<h3>'.__('Address list','church-admin').'</h3>'
            .'<p>'.__('The church has an address list which is visible to logged in users of the website. You can opt whether or not your personal data appears on the address list.','church-admin').'</p>'
            .'<h3>'.__('Schedules','church-admin').'</h3>'
            .'<p>'.__('The church organises who is doing what and when for our services in schedules. You can opt to recieve email, SMS and push notifications of your involvement. The schedule is also visible to other logged in users of the site, showing only names and what jobs and when.','church-admin')
            .'<h3>'.__('Communications','church-admin').'</h3>'
            .'<p>'.__('Logged in users can set the communications settings for their household. You can opt to receive or not receive phone calls, SMS, email and mail letters.','church-admin')
            .'<h3>'.__('Donations','church-admin').'</h3>'
            .'<p>'.__('If you make a donation using PayPal on the website, the donation details are stored in the database and viewable by the admin team','church-admin. UK churches will use your name, address and donation amount to make a Gift Aid claim if you have opted for Gift Aid claims.','church-admin')
            .'<h3>'.__('Classes and events','church-admin').'</h3>'
            .'<p>'.__('If you book a place for a class or event your personal data will be stored for that booking to allow event checkin and attendance records.','church-admin')
            .'<h3>'.__('MailChimp (if used)','church-admin').'</h3>'
            .'<p>'.__('This site uses MailChimp as its email sending partner. To send email, first name, last name, email and which member level, gender, small groups and classes is stored on their database to allow the correct emails to be sent.','church-admin')
            .'<h3>'.__('Google (if api key is set','church-admin')
            .'<p>'.__('To allow map pins on mapping on the website, latitude and longitude of addresses are used by mapping on site')
            .'<h3>'.__('Right to be forgotten','church-admin')
            .'<p>'.__('If you are logged in user, you can completely delete all your household information','church-admin');
            

	wp_add_privacy_policy_content( 'Church Admin Plugin', wp_kses_post( wpautop( $content, false ) ) );
}

add_action( 'admin_init', 'church_admin_add_privacy_policy_content' );