<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function church_admin_volunteer_approval( $people_id,$ministry_id)
{
    global $wpdb,$current_user;
    echo '<h2>'.__('Ministry volunteer approval','church-admin').'</h2>';
    $ministry=$wpdb->get_var('SELECT ministry FROM '.CA_MIN_TBL.' WHERE ID="'.intval( $ministry_id).'"');
    $team_contact=$wpdb->get_var('SELECT people_id FROM '.CA_MET_TBL.' WHERE ID="'.intval( $ministry_id).'" AND meta_type="team_contact"');
    if(!empty( $team_contact) )$team_contact_ID=$wpdb->get_var('SELECT user_id FROM '.CA_PEO_TBL.' WHERE people_id="'.intval( $team_contact).'"');

    $current_user = wp_get_current_user();

    if(current_user_can('manage_options')||(!empty( $team_contact_ID) && $current_user->ID==$team_contact_ID) )
    {
        $person=$wpdb->get_row('SELECT CONCAT_WS(" ",first_name,last_name) AS name,email FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
        if(!empty( $person) && !empty( $ministry) )
        {
            $contact=__('No contact details','church-admin');
            if(!empty( $person->email) )  {$contact=$person->email;}
            elseif(!empty( $person->mobile) )  {$contact=$person->mobile;}
            $wpdb->query('UPDATE '.CA_MET_TBL.' SET meta_type="ministry" WHERE meta_type="volunteer" AND people_id="'.(int)$people_id.'" AND ID="'.intval( $ministry_id).'"');
            echo '<p><strong>'.sprintf(__('%1$s has been approved for ministry "%2$s". Please get in touch with them at %3$s','church-admin'),esc_html( $person->name),esc_html( $ministry),esc_html( $contact) ).'<strong></p>';

        }
        echo church_admin_volunteer_display();

    }else {
        echo '<p>'.__("You don't have permission to do that",'church-admin').'</p>';
    }



}


function church_admin_volunteer_decline( $people_id,$ministry_id)
{
    global $wpdb,$current_user;
    echo '<h2>'.__('Ministry volunteer decline','church-admin').'</h2>';
    $ministry=$wpdb->get_var('SELECT ministry FROM '.CA_MIN_TBL.' WHERE ID="'.intval( $ministry_id).'"');
    $team_contact=$wpdb->get_var('SELECT people_id FROM '.CA_MET_TBL.' WHERE ID="'.intval( $ministry_id).'" AND meta_type="team_contact"');
    if(!empty( $team_contact) )$team_contact_ID=$wpdb->get_var('SELECT user_id FROM '.CA_PEO_TBL.' WHERE people_id="'.intval( $team_contact).'"');

    $current_user = wp_get_current_user();

    if(current_user_can('manage_options')||(!empty( $team_contact_ID) && $current_user->ID==$team_contact_ID) )
    {
        $person=$wpdb->get_row('SELECT CONCAT_WS(" ",first_name,last_name) AS name,email FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
        if(!empty( $person) && !empty( $ministry) )
        {
            $contact=__('No contact details','church-admin');
            if(!empty( $person->email) )  {$contact=$person->email;}
            elseif(!empty( $person->mobile) )  {$contact=$person->mobile;}
            $wpdb->query('DELETE FROM '.CA_MET_TBL.' WHERE meta_type="volunteer"  AND people_id="'.(int)$people_id.'" AND ID="'.intval( $ministry_id).'"');
            echo '<p><strong>'.sprintf(__('%1$s has been declined for ministry "%2$s". Please get in touch with them at %3$s','church-admin'),esc_html( $person->name),esc_html( $ministry),esc_html( $contact) ).'<strong></p>';

        }
		echo church_admin_volunteer_display();
    }else {
        echo '<p>'.__("You don't have permission to do that",'church-admin').'</p>';
    }



}

function church_admin_volunteer_display()
{

	global $wpdb;
	$out='';
	$results=$wpdb->get_results('SELECT CONCAT_WS(" ", a.first_name,a.last_name) AS name,a.people_id,b.meta_date AS date, c.ministry,c.ID as ministry_id FROM '.CA_PEO_TBL.' a, '.CA_MET_TBL.' b, '.CA_MIN_TBL.' c WHERE a.people_id=b.people_id AND b.meta_type="volunteer" AND b.ID=c.ID');
	if(!empty( $results) )
	{
		$out.='<table class="widefat wp-list-table striped"><thead><tr><th>'.__('Approve','church-admin').'</th><th>'.__('Decline','church-admin').'</th><th>'.__('Date requested','church-admin').'</th><th>'.__('Name','church-admin').'</th><th>'.__('Ministry task','church-admin').'</th></tr></thead><tbody>';
		foreach( $results AS $row)
		{
				$approve='<a href="'.admin_url().'admin.php?page=church_admin/index.php&amp;action=approve_volunteer&ministry_id='.intval( $row->ministry_id).'&people_id='.(int)$row->people_id.'">'.__("Approve",'church-admin').'</a>';
                
				$decline='<a href="'.admin_url().'admin.php?page=church_admin/index.php&amp;action=decline_volunteer&ministry_id='.intval( $row->ministry_id).'&people_id='.(int)$row->people_id.'">'.__('Decline','church-admin').'</a>';
				$out.='<tr><td>'.$approve.'</td><td>'.$decline.'</td><td>'.mysql2date(get_option('date_format'),$row->date).'</td><td>'.esc_html( $row->name).'</td><td>'.esc_html( $row->ministry).'</td></tr>';
		}
		$out.='</tbody><tfoot><tr><th>'.__('Approve','church-admin').'</th><th>'.__('Decline','church-admin').'</th><th>'.__('Date requested','church-admin').'</th><th>'.__('Name','church-admin').'</th><th>'.__('Ministry task','church-admin').'</th></tr></tfoot></table>';
	}
	else{$out.='<p>'.__('No serving requests currently','church-admin').'</p>';}
	return $out;
}
