<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


function church_admin_shortcode_generator()
{
    global $wpdb,$wp_locale;
    $out='';
    $out.='<h2>'.__('Church Admin Shortcode Generator','church-admin').'</h2>'."\r\n";
    $classes=church_admin_classes_array();
    $facilities=church_admin_facilities_array();
    $series=church_admin_sermon_series_array();
    $sermons=church_admin_sermon_sermons_array();
    $sites=church_admin_sites_array();
    $services = church_admin_services_array();
    $groups=church_admin_groups_array();
	$member_types=church_admin_member_type_array();
    $people_types=get_option('church_admin_people_type');
    $map_api_key=get_option('church_admin_google_api_key');
    $categories=church_admin_calendar_categories_array();
    $units = church_admin_units_array();
    $exclude=array('seriesName'=>__('Series name','church-admin'),
                    'seriesDescription'=>__('Series description','church-admin'),
                    'seriesImage'=>__('Series image','church-admin'),
                    'subtitle'=>__('Subtitle','church-admin'),
                    'download'=>__('Download link','church-admin'),
                    'fileDescription'=>__('File description','church-admin'),
                    'speaker'=>__('Speaker','church-admin'),
                    'date'=>__('Date','church-admin'),
                    'views'=>__('Views','church-admin'),
                    'bible'=>__('Bible','church-admin'),
                    'sharing'=>__('Sharing','church-admin')
                );  
    $shortcodes=array(
        'address-list'=>array('title'=>__('Address list','church-admin'),
                               'description'=>__('Displays the address list, with various options','church-admin'),
                               'options'=>array('loggedin','member_type_id','people_type_id','photos','pdf_link','kids','updateable','vcf','map' ),
                               'type'=>'no-content'
                        ),
        'attendance' =>array('title'=>__('Attendance','church-admin'),
                'description'=>__('Form to log attendance','church-admin'),
                'options'=>NULL,
                'type'=>'no-content'
        ),
        'bible-readings' =>array('title'=>__(' Bible readings','church-admin'),
                'description'=>__('Bible readings','church-admin'),
                'options'=>NULL,
                'type'=>'no-content'
        ),
        'birthdays'=>array('title'=>__(' Birthdays','church-admin'),
                'description'=>__('Show birthdays for different categories, with option to show age and how many days ahead to show.','church-admin'),
                'options'=>array('loggedin','member_type_id','people_type_id','days','show_age','show_phone','show_email'),
                'type'=>'no-content'
        ),
        'calendar' =>array('title'=>__('Calendar','church-admin'),
                    'description'=>__('Displays the calendar','church-admin'),
                    'options'=>array('calendar-pdf','facilities_id','cat_id','style'),
                    'type'=>'no-content'
        ),
        'calendar-list' =>array('title'=>__('Calendar - list style','church-admin'),
                'description'=>__('Displays list style calendar','church-admin'),
                'options'=>array('days','cat_id'),
                'type'=>'no-content'
        ),
        'classes' =>array('title'=>__('Classes','church-admin'),
                'description'=>__('Displays current classes.','church-admin'),
                'options'=>array('registration'),
                'type'=>'no-content'
        ),
        'class' =>array('title'=>__('Class display','church-admin'),
                'description'=>__('Displays a particular class','church-admin'),
                'options'=>array('registration','class_id'),
                'type'=>'no-content'
        ),
        'event-booking' =>array('title'=>__('Event display','church-admin'),
                'description'=>__('Displays an event','church-admin'),
                'options'=>array('event'),
                'type'=>'no-content'
        ),
        'follow-up' =>array('title'=>__('Follow up','church-admin'),
                'description'=>__('Displays follow up actions','church-admin'),
                'options'=>null,
                'type'=>'no-content'
        ),
        'hello' =>array('title'=>__('Hello user','church-admin'),
                'description'=>__('Displays a welcome to a logged in user','church-admin'),
                'options'=>null,
                'type'=>'no-content'
        ),
        'logged-in' =>array('title'=>__('Logged in','church-admin'),
                'description'=>__('Displays content only to logged in website visitors','church-admin'),
                'options'=>NULL,
                'type'=>'content'
        ),
                      
        'ministries'=>array('title'=>__('Ministries','church-admin'),
                'description'=>__('Displays ministries and who is in each ministry team','church-admin'),
                'options'=>array('ministry_id','member_type_id'),
                'type'=>'no-content'
        ),
        'ministry-rota'=>array('title'=>__('Ministry schedule ','church-admin'),
        'description'=>__('Allows the team contact for a ministry to create their own schedule for their schedule task, optionally add a service id or they can pick the service to work on.','church-admin'),
        'options'=>array('service_id'),
        'type'=>'no-content'
),
        'my-group' =>array('title'=>__('My Group','church-admin'),
                        'description'=>__("Displays the members of a user's small group",'church-admin'),
                        'options'=>NULL,
                        'type'=>'no-content'
        ),
        'my-rota' =>array('title'=>__('My Schedule','church-admin'),
                        'description'=>__('Displays services a user is scheduled to be involved in','church-admin'),
                        'options'=>NULL,
                        'type'=>'no-content'
        ),
        'names' =>array('title'=>__('Names','church-admin'),
                'description'=>__('Displays a list of names','church-admin'),
                'options'=>array('member_type_id','people_type_id'),
                'type'=>'no-content'
        ),
        'player' =>array('title'=>__('Sermon audio player','church-admin'),
                'description'=>__('Display single sermon audio player','church-admin'),
                'options'=>array('file_id'),
                'type'=>'no-content'
        ),
        'not-logged-in' =>array('title'=>__('Not logged in','church-admin'),
                'description'=>__('Displays content to not logged in website visitors','church-admin'),
                'options'=>NULL,
                'type'=>'content'
        ),
        'phone-list' =>array('title'=>__('Phone list','church-admin'),
                'description'=>__('Phone list','church-admin'),
                'options'=>array('people_type_id','member_type_id'),
                'type'=>'no-content'
        ),
        
        'recent' =>array('title'=>__('Recent people activity','church-admin'),
                'description'=>__('People edits','church-admin'),
                'options'=>array('weeks','member_type_id'),
                'type'=>'no-content'
        ),
        
        'register' => array('title'=>__('Register','church-admin'),
                'description'=>__('Registration form','church-admin'),
                'options'=>null,
                'type'=>'no-content'
        ),
        'restricted'=>array('title'=>__('Restricts content to certain member types','church-admin'),
                'description'=>__('Only displays content to certain member types','church-admin'),
                'options'=>array('member_type_id'),
                'type'=>'content'
        ),
        'rota' =>array('title'=>__('Schedule','church-admin'),
                        'description'=>__('Displays services schedules','church-admin'),
                        'options'=>array('service_id','weeks','initials'),
                        'type'=>'no-content'
        ),
        'sermons' =>array('title'=>__('Sermons (new style)','church-admin'),
                'description'=>__('New style sermons display','church-admin'),
                'options'=>array('how_many','nowhite'),
                'type'=>'no-content'
        ),
        'podcast' =>array('title'=>__('Sermons (old style)','church-admin'),
                'description'=>__('Displays all the sermons','church-admin'),
                'options'=>array('exclude'),
                'type'=>'no-content'
        ),
        'sessions' =>array('title'=>__('Sessions','church-admin'),
                'description'=>__('Tracking small group activity','church-admin'),
                'options'=>NULL,
                'type'=>'no-content'
        ),
        'single-sermon' =>array('title'=>__('Single Sermon','church-admin'),
                'description'=>__('Display single sermon','church-admin'),
                'options'=>array('file_id'),
                'type'=>'no-content'
        ),
        'small-groups-list' =>array('title'=>__('Small group list','church-admin'),
            'description'=>__('Display list of small groups','church-admin'),
            'options'=>array('map','zoom','photo','title','pdf','no-address'),
            'type'=>'no-content'
        ),
        'small-group-signup'=>array('title'=>__('Small group signup form','church-admin'),
            'description'=>__('Display sign up form for small groups','church-admin'),
            'options'=>array('people_type_id'),
            'type'=>'no-content'
        ),
        'spiritual-gifts' =>array('title'=>__('Spiritual Gifts Questionnaire','church-admin'),
                        'description'=>__('Displays Spiritual Gifts Questionnaire with optional results email to admin email','church-admin'),
                        'options'=>array('admin_email'),
                        'type'=>'no-content'
                ),
        'unit'=>array('title'=>__('Units','church-admin'),
                        'description'=>__('Displays details for a unit','church-admin'),
                        'options'=>array('unit_id' ),
                        'type'=>'no-content'
                ),
        'video' =>array('title'=>__('Video embed','church-admin'),
                        'description'=>__('Video embed with aspect ratio','church-admin'),
                        'options'=>array('video_url'),
                        'type'=>'no-content'
                ),
        'volunteer' =>array('title'=>__('Volunteer','church-admin'),
                        'description'=>__('Form to apply to serve in a ministry','church-admin'),
                        'options'=>NULL,
                        'type'=>'no-content'
                ),
        
        
        
        

        
        

    );
    if(!empty($_POST['create-shortcode']))
    {
      
        $shortcode=sanitize_text_field(stripslashes($_POST['shortcode']));
        //validate
        if(empty($shortcodes[$shortcode])){
            $out.='<div class="church-admin-form-groupnotice notice-danger"><h2>'._('Invalid shortcode choice','church-admin').'</h2>';
            $out.='<p><a href="amdin.php?page=church_admin/index.php&action=shortcode-generator">'.__('Try again','church-admin').'<p>';
            $out.='</div>';
        }
        $expected_options=$shortcodes[$shortcode]['options'];
        if(empty($expected_options)){
            //simple shortcode
            $shortcode_output='[church_admin type="'.esc_attr($shortcode).'"]';
        }else{
            //build options
            $options=array();
            foreach($expected_options AS $key=>$option){
                
                if(isset($_POST[$option]))
                {
                   
                    switch( $option ){
                        case 'exclude':
                            $exc=array();
                            foreach($_POST[$option] AS $key=>$value){
                                
                                    $exc[]=$value;
                                
                            }
                            sort($exc);
                            $options[]='exclude="'.esc_attr(implode(',',$exc)).'"';

                        break;
                        case 'member_type_id':
                            
                            if(is_array($_POST[$option]) && in_array("#",$_POST[$option])){
                                $options[]='member_type_id="#"';
                            }
                            else
                            {
                                $mts=array();
                                foreach($_POST[$option] AS $key=>$id){
                                    if(!empty($member_types) & !empty($member_types[$id])){
                                        $out.='adding '.$member_types[$id].'<br/>';
                                        $mts[]=(int)$id;
                                    }
                                }
                                sort($mts);
                                $options[]='member_type_id="'.esc_attr(implode(',',$mts)).'"';
                            }
                        break;
                        case 'cat_id':
                            
                            if(is_array($_POST[$option]) && in_array("#",$_POST[$option])){
                                $options[]='category=""';
                            }
                            else
                            {
                                $cats=array();
                                foreach($_POST[$option] AS $key=>$id){
                                    if(!empty($categories) & !empty($categories[$id])){
                                        $out.='adding '.$categories[$id].'<br/>';
                                        $cats[]=(int)$id;
                                    }
                                }
                                sort($cats);
                                $options[]='category="'.esc_attr(implode(',',$cats)).'"';
                            }
                        break;    
                        case 'people_type_id':
                            if(is_array($_POST[$option]) && in_array("#",$_POST[$option])){
                                $options[]='people_type_id="#"';
                            }
                            else
                            {
                                $pts=array();
                                foreach($_POST[$option] AS $key=>$id){
                                    if(!empty($people_types) & !empty($people_types[$id])){
                                        $pts[]=(int)$id;
                                    }
                                }
                                sort($pts);
                                $options[]='people_type_id="'.esc_attr( implode( ',', $pts ) ).'"';
                            }
                        break;
                        case'how_many':
                            $value=!empty($_POST[$option])?sanitize_text_field($_POST[$option]):9;
                            $options[]='how_many="'.(int)$value.'"';
                        break;
                        case'nowhite':
                            $value=!empty($_POST[$option])?1:0;
                            $options[]='nowhite="'.$value.'"';
                        break;
                        case'show_email':
                            $value=!empty($_POST[$option])?1:0;
                            $options[]='show_email="'.$value.'"';
                        break;
                        case'show_phone':
                            $value=!empty($_POST[$option])?1:0;
                            $options[]='show_phone="'.$value.'"';
                        break;
                        case 'loggedin':
                            $value=!empty($_POST[$option])?1:0;
                            $options[]='loggedin="'.$value.'"';
                        break;
                        case 'pdf':
                            switch($_POST[$option]){
                                case '1':
                                default:
                                    $options[]='pdf=1';
                                break;
                                case '2':
                                    $options[]='pdf=2';
                                break;
                                case 'multi':
                                    $options[]='pdf="multi"';
                                break;
                            }
                        break;
                        case 'cal-pdf':
                            if(!empty($_POST[$option])){
                                $options[]='pdf=1';
                            }
                        break;
                        case 'days':
                            $options[]='days="'.(int)$_POST[$option].'"';
                        break;
                        case 'weeks':
                            $options[]='days="'.(int)$_POST[$option].'"';
                        break;
                        case 'title':
                            $options[]='title="'.esc_attr( $_POST[$option] ).'"';
                        break;
                        case 'video_url':
                            $options[]='url="'.esc_url( $_POST[$option] ).'"';
                        break;
                        case'photos':
                            $value=!empty($_POST[$option])?1:0;
                            $options[]='photo="'.$value.'"';
                        break;
                        case'updateable':
                            $value=!empty($_POST[$option])?1:0;
                            $options[]='updateable="'.$value.'"';
                        break;
                        case 'map':
                            $value=!empty($_POST[$option])?1:0;
                            $options[]='map="'.$value.'"';
                        break;
                        case 'initials':
                            $value=!empty($_POST[$option])?1:0;
                            $options[]='initials="'.$value.'"';
                        break;
                        case 'vcf':
                            $value=!empty($_POST[$option])?1:0;
                            $options[]='vcf="'.$value.'"';
                        break;
                        case 'groups':
                            $gps=array();
                            foreach($_POST[$option] AS $key=>$id){
                                if(!empty($groups) & !empty($groups[$id])){
                                    $gps[]=(int)$id;
                                }
                            }
                            sort($gps);
                            $options[]='groups="'.esc_attr( implode( ',', $gps ) ).'"';
                        break;
                        case 'zoom':
                            if(!empty($_POST[$option])){
                                $options[]='zoom="'.(int)$_POST['option'].'"';
                            }
                        break;
                        case 'event':
                            if(!empty($_POST[$option])){
                                $options[]='event_id="'.(int)$_POST['option'].'"';
                            }
                        break;
                        case 'sites':
                            $sts=array();
                            foreach($_POST[$option] AS $key=>$id){
                                if(!empty($sites) & !empty($sites[$id])){
                                    $sts[]=(int)$id;
                                }
                            }
                            sort($sts);
                            $options[]='site_id="'.esc_attr( implode( ',', $sts ) ).'"';
                        break;
                        case 'services':
                            if(!empty($_POST[$option])&&!empty($services[$_POST[$option]])){
                                $options='service_id="'.(int)$_POST['option'].'"';
                            }
                        break;
                        case 'series':
                            if(!empty($_POST[$option])&&!empty($series[$_POST[$option]])){
                                $options='series_id="'.(int)$_POST['option'].'"';
                            }
                        break;
                        case 'file_id':
                            if(!empty($_POST[$option])){
                                $options[]='file_id="'.(int)$_POST['option'].'"';
                            }
                        break;
                        case 'facilities_id':
                            if(!empty($_POST[$option])&&!empty($facilities[$_POST[$option]])){
                                $options='facilities_id="'.(int)$_POST['option'].'"';
                            }
                        break;

                    }
                }
                

            }
           
            $shortcode_output='[church_admin type="'.esc_attr($shortcode).'" '.implode(' ',$options).']';
        }
        if( $shortcodes[$shortcode]['type'] == 'content' ){
            $shortcode_output.' '.__('Your Content','church-admin').' [/church_admin]';
        }
        $out.='<p>'.__('Your shortcode with options...','church-admin').'</p>';
        $out.='<p id="shortcodeoutput">'.esc_html( $shortcode_output ).'</p>';
        $out.='<p><button onclick="copyToClipboard()">Copy to clipboard</button></p>';
        $out.='<script>
        function copyToClipboard(){
           
                navigator.clipboard.writeText(document.getElementById("shortcodeoutput").textContent).then(() => {
                    console.log("Copied to clipboard!!!");
                });
            
        }</script>';
        $out.='<p><a class="church-admin-form-groupbutton-primary" href="admin.php?page=church_admin/index.php&action=shortcode-generator">'.esc_html( __( 'Create another shortcode','church-admin')).'</a></p>';
    }
    else{
        $js=$description='';
        $out.='<p><strong>'.esc_html( sprintf( __( 'There are %1$s shortcodes to choose from. Some will display a list of various optional options.','church-admin'),count($shortcodes))).'</strong></p>'."\r\n";
        $out.='<form action="" method="POST">'."\r\n";
        $out.='<div ><label>'.__('Choose shortcode','church-admin').'</label>'."\r\n";
        $out.='<select name="shortcode" id="shortcode">';
        foreach( $shortcodes AS $shortcode=>$details ){
            $out.='<option value="'.esc_attr( $shortcode ).'">'.esc_html( $details['title'] ).'</option>';
            $js.='case "'.$shortcode.'":'."\r\n";
            $js.='$("#'.$shortcode.'-description").show();';
            $js.='console.log("Show options for '.$shortcode.'")'."\r\n";
            church_admin_debug($shortcode);
            church_admin_Debug($details['options']);
            if(!empty($details['options'])){
                foreach($details['options']AS $key=>$option){
                    $js.='$("#'.esc_html($option).'").show();'."\r\n";
                }
            }
            $js.='break;'."\r\n";

            $description.='<div id="'.$shortcode.'-description" class="shortcode-description">'.esc_html($details['description']).'</div>';
        }

        $out.='</select></div>'."\r\n";
        $out.='<h3>'.__('This shortcode...','church-admin').'</h3>';
        $out.= $description;
       
        
        $out.='<script>        
        jQuery(document).ready(function($){
            $(".shortcode-option").hide();
            $(".shortcode-description").hide();
            //form fields for address list - shown initially
            $("#address-list-description").show();
            $("#loggedin").show();
            $("#member_type_id").show();
            $("#people_type_id").show();
            $("#photos").show();
            $("#pdf_link").show();
            $("#kids").show();
            $("#updateable").show();
            $("#vcf").show();
            $("#shortcode").change(function(){
                $(".shortcode-option").hide();
                $(".shortcode-description").hide();
                var which = $("#shortcode option:selected").val();
                
                console.log ("Shortcode selected "+which);
                switch(which)
                {
                    '.$js.'
                }
            });

        });
        
        </script>'."\r\n";

        //exclude
        $out.='<div class="church-admin-form-group shortcode-option" id="exclude" ><h3>'.__('Items to exclude','church-admin').'</h3>';
        foreach( $exclude AS $value=>$name ){
            $out.='<p><input type="checkbox"  name="exclude[]" value="'.esc_html($value).'" ><label> '.esc_html( $name ).'</label></p>'."\r\n";
        }
        $out.='</div>'."\r\n";
        //login
        $out.='<div class="church-admin-form-group shortcode-option" id="loggedin" ><h3>'.__('Login required','church-admin').'</h3>';
        $out.='<p><input type="radio" name="loggedin"  checked="checked" value="1" > '.__('Yes','church-admin').'</p>';
        $out.='<p><input type="radio" name="loggedin"  value="0"/><strong> '.__('No - NOT recommended for privacy reasons!','church-admin').'</strong></p>'."\r\n";
        $out.='</div>'."\r\n";
        //nowhite
        $out.='<div class="church-admin-form-group shortcode-option" id="nowhite" ><h3>'.__('No white space above video (for themes that auto adjust video aspect ratio)','church-admin').'</h3>';
        $out.='<p><input type="radio" name="nowhite"  value="1"/> '.__('Yes','church-admin').'</p>';
        $out.='<p><input type="radio" name="nowhite" checked="checked"  value="0"/><strong> '.__('No ','church-admin').'</strong></p>';
        
        $out.='</div>'."\r\n";
       
        //howmany
        
        $out.='<div class="church-admin-form-group shortcode-option church-admin-form-group" id="how_many" ><h3>'.__('How many sermons per page','church-admin').'</h3>';
        $out.='<p><input type="number" name="how_many" value=9 /></p></div>'."\r\n";

        //show photos
        $out.='<div class="church-admin-form-group shortcode-option" id="photos" ><h3>'.__("Show photos (obeys people's permission settings)",'church-admin').'</h3>';
        $out.='<p><input type="radio" name="photos"  checked="checked" value="1" />'.__('Yes','church-admin').'</p>';
        $out.='<p><input type="radio" name="photos" value="0" />'.__('No','church-admin').'</p>';
        $out.='</div>'."\r\n";
        //pdf
        $out.='<div class="church-admin-form-group shortcode-option" id="pdf" ><h3>'.__('PDF Link','church-admin').'</h3>';
        $out.='<p><input type="radio" name="pdf"  value="2"/> '.__('Yes (family photos, single line address)','church-admin').'</p>';
        $out.='<p><input type="radio" name="pdf"  checked="checked" value="multi"/> '.__('Yes (family photos, multi line address)','church-admin').'</p>';
        $out.='<p><input type="radio" name="pdf" value="1"/> '.__('Yes (no photos)','church-admin').'</p>';
        $out.='<p><input type="radio" name="pdf"  value="0"/> '.__('No PDF','church-admin').'</p>';
        $out.='</div>'."\r\n";
        //calendar pdf
        $out.='<div class="church-admin-form-group shortcode-option" id="calendar-pdf" ><h3>'.__('PDF Link','church-admin').'</h3>';
        $out.='<p><input type="radio" name="cal-pdf" checked="checked" value="1"/> '.__('PDF link','church-admin').'</p>';
        $out.='</div>'."\r\n";
        //show map
        $out.='<div class="church-admin-form-group shortcode-option" id="map" ><h3>'.__('Show map','church-admin').'</h3>';
        if(empty($map_api_key)){
            $out.='<p>'.__('You need to set up a Google API key','church-admin').'</p>';
        }
        $out.='<p><input type="radio" name="map" checked="checked" value="1" />'.__('Yes','church-admin').'</p>';
        $out.='<p><input type="radio" name="map" value="0" />'.__('No','church-admin').'</p>';
        $out.='</div>'."\r\n";
        //initials

        $out.='<div class="church-admin-form-group shortcode-option" id="initials" ><h3>'.__('Use initials or full names','church-admin').'</h3>';
        $out.='<p><input type="radio" name="initials" value="1" />'.__('Initials','church-admin').'</p>';
        $out.='<p><input type="radio" name="initials" checked="checked" value="0" />'.__('Full names','church-admin').'</p>';
        $out.='</div>'."\r\n";
        //zoom 
        $out.='<div class="church-admin-form-group shortcode-option" id="zoom" ><h3>'.__('Map zoom level 0-20','church-admin').'</h3>';
         $out.='<p><input type="number" name="zoom" value=13  max=20 /></p>';
         $out.='</div>'."\r\n";
        //calendar categories
        $out.='<div class="church-admin-form-group shortcode-option" id="cat_id" ><h3>'.__('Calendar Categories','church-admin').'</h3>';
        $out.='<p><input type="checkbox"  name="cat_id[]" value="#" checked="checked"/><label> '.esc_html( __('All','church-admin')).'</label></p>';
        foreach( $categories AS $id=>$category ){
            $out.='<p><input type="checkbox"  name="cat_id[]" value="'.(int)$id.'"/><label> '.esc_html( $category ).'</label></p>';
        }
        $out.='</div>'."\r\n";
       //member types
        $out.='<div class="church-admin-form-group shortcode-option" id="member_type_id" ><h3>'.__('Member Types','church-admin').'</h3>';
        $out.='<p><input type="checkbox"  name="member_type_id[]" value="#" checked="checked"/><label> '.esc_html( __('All','church-admin')).'</label></p>';
        foreach( $member_types AS $id=>$type ){
            $out.='<p><input type="checkbox"  name="member_type_id[]" value="'.(int)$id.'"/><label> '.esc_html( $type ).'</label></p>';
        }
        $out.='</div>'."\r\n";
        //people types
        $out.='<div class="church-admin-form-group shortcode-option" id="people_type_id" ><h3>'.__('People Types','church-admin').'</h3>';
        foreach( $people_types AS $id => $type ){
            $out.='<p><input type="checkbox"  name="people_type_id[]" checked="checked" value="'.(int)$id.'"/><label> '.esc_html( $type ).'</label></p>';
        }
        $out.='</div>'."\r\n";
        //groups
        $out.='<div class="church-admin-form-group shortcode-option" id="groups" ><h3>'.__('Groups','church-admin').'</h3>';
        foreach( $groups AS $id => $name ){
            $out.='<p><input type="checkbox"  name="people_type_id[]" value="'.(int)$id.'"/><label> '.esc_html( $name ).'</label></p>';
        }
        $out.='</div>'."\r\n";
         //units
         
            $out.='<div class="church-admin-form-group shortcode-option" id="units" ><h3>'.__('Units','church-admin').'</h3>';
            if( !empty( $units ) ) {
                foreach( $units AS $id => $type ){
                    $out.='<p><input type="checkbox"  name="people_type_id[]" value="'.(int)$id.'"/><label> '.esc_html( $type ).'</label></p>';
                }
            
            }
            else{
                $out.='<p><a href="admin.php?page=church_admin/index.php&action=edit_unit" target="_blank">'.__('Please set up a unit','church-admin').'</a></p>';
            }
            $out.='</div>'."\r\n";
        //sites
       
        $out.='<div class="church-admin-form-group shortcode-option" id="sites" ><h3>'.__('Sites','church-admin').'</h3>';
        if( !empty( $sites ) ){
            foreach( $sites AS $id => $site ){
                $out.='<p><input type="checkbox"  name="site_id[]" value="'.(int)$id.'"/><label> '.esc_html( $site ).'</label></p>';
            }
            
        }else{
            $out.='<p><a href="admin.php?page=church_admin/index.php&action=edit_site" target="_blank">'.__('Please set up a site','church-admin').'</a></p>';
        }
        $out.='</div>'."\r\n";
        //event
        
            $out.='<div class="church-admin-form-group shortcode-option" id="event" ><h3>'.__('Events','church-admin').'</h3>';
            if( !empty( $events ) ){
                foreach( $events AS $id => $title ){
                    $out.='<p><input type="radio"  name="event_id" value="'.(int)$id.'"/><label> '.esc_html( $title ).'</label></p>';
                }
                
            }else{
                $out.='<p><a href="admin.php?page=church_admin/index.php&action=edit_event" target="_blank">'.__('Please set up an event','church-admin').'</a></p>';
            }


            $out.='</div>'."\r\n";
         //services
         
            $out.='<div class="church-admin-form-group shortcode-option" id="services" ><h3>'.__('Services','church-admin').'</h3>';
            if( !empty( $services) ){
                foreach( $services AS $id => $service ){
                    $out.='<p><input type="radio"  name="service_id" value="'.(int)$id.'"/><label> '.esc_html( $service ).'</label></p>';
                }
            }else{
                $out.='<p><a href="admin.php?page=church_admin/index.php&action=edit_service" target="_blank">'.__('Please set up a service','church-admin').'</a></p>';
            }
            $out.='</div>'."\r\n";
         
         //sermon series
         
            $out.='<div class="church-admin-form-group shortcode-option" id="series" ><h3>'.__('Sermon Series','church-admin').'</h3>';
            if( !empty( $series) ){
                foreach( $series AS $id => $title ){
                    $out.='<p><input type="radio"  name="series_id" value="'.(int)$id.'"/><label> '.esc_html( $title ).'</label></p>';
                }
                
            }
            else{
                $out.='<p><a href="admin.php?page=church_admin/index.php&action=edit_series" target="_blank">'.__('Please set up a sermon series','church-admin').'</a></p>';
            }
            $out.='</div>'."\r\n";

        //file_id

     
            $out.='<div class="church-admin-form-group shortcode-option" id="file_id" ><h3>'.__('Sermons','church-admin').'</h3>';
            $out.='<select name="file_id" class="church-admin-form-groupchurch-admin-form-control">';
            if(!empty($sermons))
            {
                foreach($sermons AS $id=>$sermon){
                    $out.='<option value="'.(int)$id.'">'.esc_html( $sermon).'</option>';
                }
                $out.='</select>';
            }else{
                $out.='<p><a href="admin.php?page=church_admin/index.php&action=upload-mp3" target="_blank">'.__('Please upload a sermon MP3','church-admin').'</a></p>';
            }
                $out.='</div>'."\r\n";

            
        //facilities
        if(!empty($facilities)){
            $out.='<div class="church-admin-form-group shortcode-option" id="facilities_id" ><h3>'.__('Facilities','church-admin').'</h3>';
            foreach( $facilities AS $id => $title ){
                $out.='<p><input type="radio"  name="facilities_id" value="'.(int)$id.'"/><label> '.esc_html( $title ).'</label></p>';
            }
            $out.='</div>'."\r\n";
        }
        //style
        $out.='<div class="church-admin-form-group shortcode-option" id="style" ><h3>'.__('Calendar Style','church-admin').'</h3>';
        $out.='<p><input type="radio"  name="style" value="table"/><label> '.esc_html(__('Table Style') ).'</label></p>';
        $out.='<p><input type="radio"  name="style" checked="checked" value="new"/><label> '.esc_html(__('New Style') ).'</label></p>';
        $out.='</div>'."\r\n";
        //show age
        $out.='<div class="church-admin-form-group shortcode-option" id="show_age" ><h3>'.__('Show age','church-admin').'</h3>';
        $out.='<p><input type="radio" name="show_age"  checked="checked" value="1" />'.__('Yes','church-admin').'</p>';
        $out.='<p><input type="radio" name="show_age" value="0" />'.__('No','church-admin').'</p>';
        $out.='</div>'."\r\n";
         //show_email
         $out.='<div class="church-admin-form-group shortcode-option" id="show_email" ><h3>'.__('Show email','church-admin').'</h3>';
         $out.='<p><input type="radio" name="show_email"  value="1"/> '.__('Yes','church-admin').'</p>';
         $out.='<p><input type="radio" name="show_email" checked="checked"  value="0"/><strong> '.__('No ','church-admin').'</strong></p>';
         
         $out.='</div>'."\r\n";
         //show_phone
         $out.='<div class="church-admin-form-group shortcode-option" id="show_phone" ><h3>'.__('Show phone','church-admin').'</h3>';
         $out.='<p><input type="radio" name="show_phone"  value="1"/> '.__('Yes','church-admin').'</p>';
         $out.='<p><input type="radio" name="show_phone" checked="checked"  value="0"/><strong> '.__('No ','church-admin').'</strong></p>';
         
         $out.='</div>'."\r\n";
        //allow registrations
        $out.='<div class="church-admin-form-group shortcode-option" id="registrations" ><h3>'.__('Allow registrations','church-admin').'</h3>';
        $out.='<p><input type="radio" name="allow_registrations"  checked="checked" value="1" />'.__('Yes','church-admin').'</p>';
        $out.='<p><input type="radio" name="allow_registrations" value="0" />'.__('No','church-admin').'</p>';
        $out.='</div>'."\r\n";
        //allow registrations
        $out.='<div class="church-admin-form-group shortcode-option" id="updateable" ><h3>'.__('Allow users to update their entry','church-admin').'</h3>';
        $out.='<p><input type="radio" name="updateable"  checked="checked" value="1" />'.__('Yes','church-admin').'</p>';
        $out.='<p><input type="radio" name="updateable" value="0" />'.__('No','church-admin').'</p>';
        $out.='</div>'."\r\n";
        //class_id
        
            $out.='<div class="church-admin-form-group shortcode-option" id="class_id" ><h3>'.__('Classes','church-admin').'</h3>';
            if(!empty($classes)){
                foreach( $classes AS $id => $title ){
                    $out.='<p><input type="radio"  name="class_id" value="'.(int)$id.'"/><label> '.esc_html( $title ).'</label></p>';
                }
            }else{
                $out.='<p><a href="admin.php?page=church_admin/index.php&action=edit-class" target="_blank">'.__('Please add a class','church-admin').'</a></p>';
            }
        $out.='</div>'."\r\n";
        
         //days
         $out.='<div class="church-admin-form-group shortcode-option" id="days" ><h3>'.__('No of days to show','church-admin').'</h3>';
         $out.='<input type="number" name="days"  class="church-admin-form-groupchurch-admin-form-control"/>';
         $out.='</div>'."\r\n";

         //weeks
         $out.='<div class="church-admin-form-group shortcode-option" id="weeks" ><h3>'.__('No of weeks to show','church-admin').'</h3>';
         $out.='<input type="number" name="weeks"  class="church-admin-form-groupchurch-admin-form-control"/>';
         $out.='</div>'."\r\n";
        //video url
        $out.='<div class="church-admin-form-group shortcode-option" id="video_url" ><h3>'.__('Video embed','church-admin').'</h3>';
        $out.='<input type="url" name="url" placeholder="embed url" class="church-admin-form-groupchurch-admin-form-control"/>';
        $out.='</div>'."\r\n";
        //title
        $out.='<div class="church-admin-form-group shortcode-option" id="title" ><h3>'.__('Title','church-admin').'</h3>';
        $out.='<input type="text" name="title" placeholder="'.__('PDF title','church-admin').'" class="church-admin-form-groupchurch-admin-form-control"/>';
        $out.='</div>'."\r\n";
        //vcf

        $out.='<div class="church-admin-form-group shortcode-option" id="vcf" ><h3>'.__('V-card link','church-admin').'</h3>';
        $out.='<p><input type="radio" name="initials" checked="checked" value="1" />'.__('Yes','church-admin').'</p>';
        $out.='<p><input type="radio" name="initials"  value="0" />'.__('No','church-admin').'</p>';
        $out.='</div>'."\r\n";

        //submit
        $out.='<p><input type="hidden" name="create-shortcode" value="yes"/><input type="submit" class="church-admin-form-groupbutton-primary"/></p></form>'."\r\n";
    }
 return $out;
}