<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/**
 *
 * displays list of services
 *
 * @author  Andy Moyle
 * @param    NULL
 * @return   html
 * @version  0.945
 *
 *	2016-05-12 Added sites
 *
 */
function church_admin_service_list( $message=NULL)
{
    global $wpdb,$wp_locale;
    $out='';
    if(!empty( $message) )
    {
        $out.='<div class="notice notice-success inline"><h2>'.esc_html( $message).'</h2></div>';
    }
	$out.='<p><a  class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit-service&section=services','edit_service').'">'.__('Add a service','church-admin').'</a></p>';
   

    $sql='SELECT a.*,b.venue AS site FROM '.CA_SER_TBL.' a ,'.CA_SIT_TBL.' b WHERE a.site_id=b.site_id';
    $results=$wpdb->get_results( $sql);
    if( $results)
    {
        $theader='<tr><th class="column-primary">'.__('Service Name','church-admin').'</th><th>'.__('Edit','church-admin').'</th><th>'.__('Delete','church-admin').'</th><th>'.__('Active','church-admin').'</th><th>'.__('Day','church-admin').'</th><th>'.__('Time','church-admin').'</th><th>'.__('Site','church-admin').'</th><th>'.__('Max attendance','church-admin').'</th><th>'.__('Schedule Shortcode','church-admin').'</th></tr>';
        $out.='<table class="widefat striped wp-list-table"><thead>'.$theader.'</thead><tbody>';
        foreach( $results AS $row)
        {
											
           $edit='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_service&amp;id='.intval( $row->service_id),'edit_service').'">'.__('Edit','church-admin').'</a>';
           $delete='<a onclick="return confirm(\''.__('Are you sure?','church-admin').'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete_service&amp;id='.intval( $row->service_id),'delete_service').'">'.__('Delete','church-admin').'</a>';
			$site= '<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_site&amp;id='.intval( $row->site_id),'edit_site').'">'.esc_html( $row->site).'</a>';          
            if( $row->active==1)  {$active=__('Active','church-admin');}else{$active=__('Inactive','church-admin');}
            if( $row->service_day<=7&&$row->service_day>=0)
            {
                $serviceDay=$wp_locale->get_weekday( $row->service_day);
            }
            else
            { 
                $serviceDay=__('As Arranged','church-admin');
            }
            $serviceTime=esc_html( $row->service_time);
            if(!empty( $row->end_time) ) $serviceTime.='-'.$row->end_time;
            $bookingShortcodes='<strong>'.__('By individuals','church-admin').'</strong><br />'.intval( $row->max_attendance).'<br />[church_admin type="covid-prebooking" loggedin=FALSE max_fields=10 days=7 admin_email="'.get_option('admin_email').'" service_id="'.intval( $row->service_id).'"]<br>';
            if(!empty( $row->bubbles) )
            {
                $bookingShortcodes.='<strong>'.__('By households/support bubbles','church-admin').'</strong><br>';
                $bookingShortcodes.= sprintf(__('%1$s bubbles of max bubble size %2$s','church-admin'),intval( $row->bubbles),intval( $row->bubble_size) );
                $bookingShortcodes.='<br />[church_admin type="covid-prebooking" loggedin=FALSE  days=7 mode="bubbles" admin_email="'.get_option('admin_email').'" service_id="'.(int)$row->service_id.'"]';
            }
            $shortcode='[church_admin type="rota" service_id="'.intval( $row->service_id).'" weeks=5]';


            $out.='<tr>
                <td class="column-primary" data-colname="'.__('Service name','church-admin').'">'.esc_html( $row->service_name).'<button type="button" class="toggle-row"><span class="screen-reader-text">show details</span></button></td>
                <td data-colname="'.__('Edit','church-admin').'">'.$edit.'</td>
                <td data-colname="'.__('Delete','church-admin').'">'.$delete.'</td>
                <td data-colname="'.__('Active','church-admin').'">'.$active.'</td>
                <td data-colname="'.__('Day','church-admin').'">'.$serviceDay.'</td>
                <td data-colname="'.__('Time','church-admin').'">'.$serviceTime.'</td>
                <td data-colname="'.__('Site','church-admin').'">'.$site.'</td>
                <td data-colname="'.__('Booking shortcodes','church-admin').'">'.$bookingShortcodes.'</td>
                <td data-colname="'.__('Service shortcode','church-admin').'">'.$shortcode.'</td>
            </tr>';
  
        }
        $out.='</tbody><tfoot>'.$theader.'</tfoot></table>';
    }
    return $out;
}


/**
 *
 * delete a service
 *
 * @author  Andy Moyle
 * @param    $service_id
 * @return   html
 * @version  0.1
 *
 *
 */
function church_admin_delete_service( $service_id)
{
	global $wpdb;
    echo'<h1>'.__('Delete service','church-admin').'</h1>';
	if(!empty( $_POST['confirm_delete'] ) )
	{
		$event_id=$wpdb->get_var('SELECT event_id FROM '.CA_SER_TBL.' WHERE service_id="'.(int)$service_id.'"');
        $wpdb->query('DELETE FROM '.CA_SER_TBL.' WHERE service_id="'.esc_sql((int)$service_id).'"');
		$wpdb->query('DELETE FROM '.CA_ROTA_TBL.' WHERE service_id="'.esc_sql((int)$service_id).'"');
        if(!empty( $event_id) )$wpdb->query('DELETE FROM '.CA_DATE_TBL.' WHERE event_id="'.esc_sql((int)$event_id).'" AND start_date>="'.date('Y-m-d').'"');
		echo'<div class="notice notice-success inline"><p>'.__('Service deleted','church-admin').'</p></div>';
        echo   church_admin_service_list(NULL);

	}
	else
	{
		echo'<form action="" method="POST"><p><label>'.__('Are you sure?','church-admin').'</label><input type="hidden" name="confirm_delete" value="yes"/><input class="button-primary" type="submit" value="'.__('Yes','church-admin').'"/></p></form>';
	}

}


/**
 *
 * edit a service
 *
 * @author  Andy Moyle
 * @param    $service_id
 * @return   html
 * @version  0.1
 *
 *
 */
function church_admin_edit_service( $id)
{
    global $wpdb,$wp_locale;
    $wpdb->show_errors;
    if( $id)$data=$wpdb->get_row('SELECT * FROM '.CA_SER_TBL.' WHERE service_id="'.(int)$id.'"');
    echo'<h1>'.__('Add/Edit service','church-admin').'</h1>';
       echo'<form action="" method="post">';
       echo'<table class="form-table"><tbody><tr><th scope="row">'.__('Service Name','church-admin').'</th><td><input type="text" name="service_name" ';
       if(!empty( $data->service_name) )echo' value="'.esc_html( $data->service_name).'" ';
       echo'/></td></tr>';
       echo'<tr><th scope="row">'.__('Service Day','church-admin').'</th><td><select name="service_day"> ';
       
		$myweek = array();
        $first=$option='';
        
		for ( $wdcount = 0; $wdcount <= 6; $wdcount++ ) {
         	if(isset( $data->service_day) && $data->service_day==$wdcount)  {$first='<option value="'.intval( $wdcount).'" selected="selected">'.$wp_locale->get_weekday( $wdcount ).' </option>';}
            else{$option.='<option value="'.intval( $wdcount).'" >'.$wp_locale->get_weekday( $wdcount ).'</option>';}
                


		}
        if( $data->service_day==8)  {$first='<option value="8" selected="selected">'.__('As arranged','church-admin').'</option>';}
        else{$option.='<option value="8">'.__('As arranged','church-admin').'</option>';}
        echo $first.$option;
       echo'</select></td></tr>';
       echo'<tr><th scope="row">'.__('Service Time','church-admin').'</th><td><input type="time" name="service_time" ';
       if(!empty( $data->service_time) )echo' value="'.esc_html( $data->service_time).'" ';
       echo'/></td></tr>';
       $sites=$wpdb->get_results('SELECT * FROM '.CA_SIT_TBL);
       if(!empty( $sites) )
       {
            echo'<tr><th scope="row">'.__('Site','church-admin').'</th><td><select name="site_id">';
            
            $first=$option='';
            foreach( $sites AS $site)
            {
                    if(!empty( $data->site_id)&&$site->site_id==$data->site_id)  {$first='<option selected=selected value="'.intval( $site->site_id).'">'.esc_html( $site->venue).'</option>';}
                    $option.='<option value="'.intval( $site->site_id).'">'.esc_html( $site->venue).'</option>';
            }
            echo$first.$option;
            echo'<select></td></tr>';
        }
        echo'<tr><th scope="row">'.__('Add a site','church-admin').'</th><td><input type="text" name="site_name"/></td></tr>';
        if ( empty( $data)||!empty( $data->active) )  {$active=1;}else{$active=0;}
        echo '<tr><th scope="row">'.__('Active','church-admin').'</th><td><input type="checkbox" name="active" value=1 '.checked(1,$active,FALSE).'</td></tr>';
        
       
        if ( empty( $data->first_date) )  {$calendar=0;}else{$calendar=1;}
        
        $calEntries=$wpdb->get_results('SELECT * FROM '.CA_DATE_TBL.' WHERE start_date>="'.date('Y-m-d').'" GROUP BY event_id');
        if(!empty( $calEntries) )
        {
            echo'<tr><th scope="row">'.__('Connect to current calendar event','church-admin').'</th><td><select class="event_id" name="event_id">';
            echo'<option value="">'.__('Select calendar event if wanted','church-admin').'</option>';
            foreach( $calEntries AS $calEntry)
            {
                $currID=(!empty( $data->event_id) )?(int)$data->event_id:null;
                echo '<option value="'.(int)$calEntry->event_id.'" '.selected( $currID,$calEntry->event_id,TRUE).'>'.esc_html( $calEntry->title).'</option>';
            }
            echo $first.$option.'</select></td></tr>';
            
        }
            
            
            
        echo '<tr class="calCheckRow"><th scope="row">'.__('Create new calendar event (only for regular recurring services. Use to override any previous event selection. CURRENT BOOKINGS WILL BE LOST )','church-admin').'</th><td><input type="checkbox" name="calendar" class="calendarCheck" value="1" </td></tr>';
        
        echo'<tr  class="calendar" style="display:none"><th scope="row">'.__("Start date",'church-admin').'</th><td>';
       if(!empty( $data->first_date) )  {$db_date=$data->first_date;}else{$db_date=NULL;}
        echo  church_admin_date_picker( $db_date,'first_date',FALSE,NULL,NULL,'first_date','first_date',FALSE);
        
        
        echo'</td></tr>';
        /*
        if(!empty( $db->recurring) )  {$recurring=$data->recurring;}else{$recurring==7;}
       
        echo'<tr><th scope="row">'.__('Recurring','church-admin').'</th><td>';
        echo'<select id="recurring">';
        echo'<option value="s" '.selected( $recurring,"s",FALSE).'>'.__('Single','church-admin').'</option>';
        echo'<option value="1" '.selected( $recurring,1,FALSE).'>'.__('Daily','church-admin').'</option>';
        echo'<option value="7" '.selected( $recurring,7,FALSE).'>'.__('Weekly','church-admin').'</option>';
        echo'<option value="14" '.selected( $recurring,14,FALSE).'>'.__('Fortnightly','church-admin').'</option>';
        echo'<option value="m" '.selected( $recurring,"m",FALSE).'>'.__('Monthly on same date','church-admin').'</option>';
        echo'<option value="a" '.selected( $recurring,"a",FALSE).'>'.__('Annually on same date','church-admin').'</option>';
        echo'<option value="n10" '.selected( $recurring,"n10",FALSE).'>'.__('1st Sunday','church-admin').'</option>';
        echo'<option value="n20" '.selected( $recurring,"n20",FALSE).'>'.__('2nd Sunday','church-admin').'</option>';
        echo'<option value="n30" '.selected( $recurring,"n30",FALSE).'>'.__('3rd Sunday','church-admin').'</option>';
        echo'<option value="n40" '.selected( $recurring,"n40",FALSE).'>'.__('4th Sunday','church-admin').'</option>';
        echo'<option value="n11" '.selected( $recurring,"n11",FALSE).'>'.__('1st Monday','church-admin').'</option>';
        echo'<option value="n21" '.selected( $recurring,"n21",FALSE).'>'.__('2nd Monday','church-admin').'</option>';
        echo'<option value="n31" '.selected( $recurring,"n31",FALSE).'>'.__('3rd Monday','church-admin').'</option>';
        echo'<option value="n41" '.selected( $recurring,"n41",FALSE).'>'.__('4th Monday','church-admin').'</option>';
        echo'<option value="n12" '.selected( $recurring,"n12",FALSE).'>'.__('1st Tuesday','church-admin').'</option>';
        echo'<option value="n22" '.selected( $recurring,"n22",FALSE).'>'.__('2nd Tuesday','church-admin').'</option>';
        echo'<option value="n32" '.selected( $recurring,"n32",FALSE).'>'.__('3rd Tuesday','church-admin').'</option>';
        echo'<option value="n42" '.selected( $recurring,"n42",FALSE).'>'.__('4th Tuesday','church-admin').'</option>';
        echo'<option value="n13" '.selected( $recurring,"n11",FALSE).'>'.__('1st Wednesday','church-admin').'</option>';
        echo'<option value="n23" '.selected( $recurring,"n21",FALSE).'>'.__('2nd Wednesday','church-admin').'</option>';
        echo'<option value="n33" '.selected( $recurring,"n31",FALSE).'>'.__('3rd Wednesday','church-admin').'</option>';
        echo'<option value="n33" '.selected( $recurring,"n41",FALSE).'>'.__('4th Wednesday','church-admin').'</option>';
        echo'<option value="n14" '.selected( $recurring,"n12",FALSE).'>'.__('1st Thursday','church-admin').'</option>';
        echo'<option value="n24" '.selected( $recurring,"n22",FALSE).'>'.__('2nd Thursday','church-admin').'</option>';
        echo'<option value="n34" '.selected( $recurring,"n32",FALSE).'>'.__('3rd Thursday','church-admin').'</option>';
        echo'<option value="n44" '.selected( $recurring,"n42",FALSE).'>'.__('4th Thursday','church-admin').'</option>';
        echo'<option value="n15" '.selected( $recurring,"n12",FALSE).'>'.__('1st Friday','church-admin').'</option>';
        echo'<option value="n25" '.selected( $recurring,"n22",FALSE).'>'.__('2nd Friday','church-admin').'</option>';
        echo'<option value="n35" '.selected( $recurring,"n32",FALSE).'>'.__('3rd Friday','church-admin').'</option>';
        echo'<option value="n45" '.selected( $recurring,"n42",FALSE).'>'.__('4th Friday','church-admin').'</option>';
        echo'<option value="n16" '.selected( $recurring,"n12",FALSE).'>'.__('1st Saturday','church-admin').'</option>';
        echo'<option value="n26" '.selected( $recurring,"n22",FALSE).'>'.__('2nd Saturday','church-admin').'</option>';
        echo'<option value="n36" '.selected( $recurring,"n32",FALSE).'>'.__('3rd Saturday','church-admin').'</option>';
        echo'<option value="n46" '.selected( $recurring,"n42",FALSE).'>'.__('4th Saturday','church-admin').'</option>';
        echo'</select></td></tr>';

        */

     

        echo '<tr class="recurring-row calendar" style="display:none"><th scope="row">'.__('Recurring','church-admin').'</th><td><select class="recurring-item" name="recurring" >';
		
		if(!empty( $data->recurring) )
		{
			$option=array('s'=>__('Once','church-admin'),'1'=>__('Daily','church-admin'),'7'=>__('Weekly','church-admin'),'n'=>__('nth day eg.1st Friday','church-admin'),'m'=>__('Monthly','church-admin'),'a'=>__('Annually','church-admin'),'14'=>__("Fortnightly",'church-admin') );
			echo'<option value="'.$data->recurring.'">'.$option[$data->recurring].'</option>';
		}
		echo'<option value="s">'.__('Once','church-admin').'</option><option value="1">'.__('Daily','church-admin').'</option><option value="7">'.__('Weekly','church-admin').'</option><option value="14">'.__('Fortnightly','church-admin').'</option><option value="n">'.__('nth day (eg 1st Friday)','church-admin').'</option><option value="m">'.__('Monthly on same date','church-admin').'</option><option value="a">'.__('Annually','church-admin').'</option></select></td></tr>';
        
        echo '<tr  class="recurring-row" id="nth" ';
		if(!empty( $data->recurring)&&$data->recurring=='n')  {echo '';}else{echo 'style="display:none"';}
		echo'><th scope="row" >'.__('Recurring on','church-admin').' </th><td><select class="recurring-item"';
		if(!empty( $error->nth) )echo $error->nth;echo' name="nth">';
		if(!empty( $data->nth) ) echo '<option value="'.$data->nth.'">'.$data->nth.'</option>';
		echo '<option value="1">'.__('1st','church-admin').'</option><option value="2">'.__('2nd','church-admin').'</option><option value="3">'.__('3rd','church-admin').'</option><option value="4">'.__('4th','church-admin').'</option><option value="5">'.__('5th','church-admin').'</option><option value="'.__('Last','church-admin').'">'.__('Last').'</option></select>&nbsp;<select name="day"><option value="0">'.__('Sunday','church-admin').'</option><option value="1">'.__('Monday','church-admin').'</option><option value="2">'.__('Tuesday','church-admin').'</option><option value="3">'.__('Wednesday','church-admin').'</option><option value="4">'.__('Thursday','church-admin').'</option><option value="5">'.__('Friday','church-admin').'</option><option value="6">'.__('Saturday','church-admin').'</option></select></td></tr>';
        echo '<tr  class="calendar" style="display:none"><th scope="row">'.__('How many times?','church-admin').'</th><td><input class="how_many" type="text" name="how_many" ';
        if(!empty( $data->how_many) )echo ' value="'.intval( $data->how_many).'" ';
        echo'/></td></tr>';
        echo '<tr  class="calendar" style="display:none"><th scope="row">'.__('Service end time','church-admin').'</th><td><input type="time" name="end_time" class="end_time" ';
        if(!empty( $data->end_time) )echo ' value="'.esc_html( $data->end_time).'" ';
        echo'/></td></tr>';
       
        echo'<tr><th colspan=2>'.__("For covid-19 prebooking, set up either a maximum individual attendance or maximum houshold bubbles and bubble size",'church-admin').'</th></tr>';
        echo '<tr  ><th scope="row">'.__('Max Attendance','church-admin').'</th><td><input type="text" name="max_attendance" class="max_attendance" ';
        if(!empty( $data->max_attendance) )echo ' value="'.esc_html( $data->max_attendance).'" ';
        echo'/></td></tr>';
        echo '<tr  ><th scope="row">'.__('Max Household bubbles','church-admin').'</th><td><input type="text" name="bubbles" class="bubbles" ';
        if(!empty( $data->bubbles) )echo ' value="'.esc_html( $data->bubbles).'" ';
        echo'/></td></tr>';
        echo '<tr  ><th scope="row">'.__('Household bubble max size','church-admin').'</th><td><input type="text" name="bubble_size" class="bubble_size" ';
        if(!empty( $data->bubble_size) )echo ' value="'.esc_html( $data->bubble_size).'" ';
        echo'/></td></tr>';
        if(!empty( $id) )echo'<input type="hidden" name="service_id" value="'.(int)$id.'"/>';
       echo'<tr><th scope="row">&nbsp;</th><td><input type="hidden" name="church-admin-save" value="service"/><input class="button-primary"  type="submit" value="'.__('Save Service','church-admin').'&raquo;" /></td></tr></tbody></table></form>';
        echo'<script>jQuery(document).ready(function( $)  {
            $(".recurring-item").on("change",function()  {
                var val=$(this).val();
                if(val==="n")$(".recurring-row").show();
            })
            var showCalendar=$(".calendarCheck").prop("checked");
            if(showCalendar)$(".calendar").show();
            console.log("show calendar:"+showCalendar);
            $(".calendarCheck").on("change",function()  {
                 if( $(this).is(":checked") )
                 {
                    console.log("Show calendar")
                    $(".calendar").show();
                }
                else
                {
                    $(".calendar").hide();
                }
            })
            $(".event_id").on("change",function()
            {
                $(".calendar").hide();
                $(".calendarCheck").prop("checked", false);
                $(".calCheckRow").hide();
            })
                  
        });</script>';
    
}

