<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly




 /**
 *
 * Delete rota settings
 *
 * @author  Andy Moyle
 * @param    $id
 * @return   html
 * @version  0.1
 *
 */
function church_admin_delete_rota_settings( $id)
{
    global $wpdb;
    $wpdb->query("DELETE FROM ".$wpdb->prefix."church_admin_rota_settings WHERE rota_id='".esc_sql((int)$id)."'");
    $wpdb->query('DELETE FROM '.CA_ROTA_TBL.'  WHERE rota_task_id="'.(int)$id.'"');
    church_admin_rota_settings_list();
}


 /**
 *
 * church_admin_edit_rota_settings
 *
 * @author  Andy Moyle
 * @param    $id
 * @return   html
 * @version  0.1
 *
 */
function church_admin_edit_rota_settings( $id=NULL)
{
	global $wpdb,$departments;
	$ministries=church_admin_ministries();
	$wpdb->show_errors();
	//set a rota order
	$rota_order=$wpdb->get_var('SELECT MAX(rota_order) FROM '.CA_RST_TBL)+1;
	if ( empty( $rota_order) )$rota_order=1;
	if(!empty( $_POST['rota_order'] ) )$rota_order=(int)$_POST['rota_order'];


	if(isset( $_POST['rota_task'] )&&check_admin_referer('edit_rota_settings') )
	{

    	$rota_task=esc_sql(stripslashes( $_POST['rota_task'] ) );
		$services=array();

		if(!empty( $_POST['service_id'] ) )  {foreach( $_POST['service_id'] AS $key=>$value)  {$services[]=(int)$value;}}else{$services=array('0'=>'1');}

		if(!empty( $_POST['initials'] ) )  {$initials=1;}else{$initials=0;}
		$ministry=array();
		$ministry_id=!empty( $_POST['ministry_id'] )?(int)$_POST['ministry_id']:NULL;
		if(!empty( $_POST['rota_order'] ) )$rota_order=(int)$_POST['rota_order'];
		//check for new ministry
		if(!empty( $_POST['ministry'] ) )
		{
			$ministry=esc_sql(stripslashes( $_POST['ministry'] ) );
			$ministries=church_admin_ministries();
			if(!in_array( $ministry,$ministries) )
			{
				$wpdb->query('INSERT INTO '.CA_MIN_TBL.' (ministry) VALUES("'.$ministry.'")');
				$ministry_id=$wpdb->insert_id;
			}
			else
			{
				$ministry_id=array_search( $ministry,$ministries);
			}
		}
		//sort out ministry names
		if(!empty( $_POST['people'] ) )
		{
			church_admin_debug( $_POST['people'] );
			$wpdb->query('DELETE FROM '.CA_MET_TBL.' WHERE meta_type="ministry" AND ID="'.(int)$ministry_id.'"');
			church_admin_debug( $wpdb->last_query);
			$peoples_id=maybe_unserialize(church_admin_get_people_id(stripslashes( $_POST['people'] ) ));
			if(!empty( $peoples_id) ) 
			{
				foreach( $peoples_id AS $key=>$people_id)
				{
					$sql='INSERT INTO '.CA_MET_TBL.' (people_id,ID,meta_type,meta_date)VALUES("'.esc_sql( $people_id).'","'.esc_sql( $ministry_id).'","ministry","'.date('Y-m-d').'")';
					$wpdb->query( $sql);
					church_admin_debug( $sql);
				}
			}
		}
		
    	if(!$id)
    	{//insert
        	$id=$wpdb->get_var('SELECT rota_id FROM '.CA_RST_TBL.' WHERE rota_task="'.$rota_task.'"' );
        	if(!$id)
        	{
				

            	$sql='INSERT INTO '.CA_RST_TBL.' (rota_task,initials,rota_order,service_id,ministries) VALUES("'.$rota_task.'","'.$initials.'","'.(int)$rota_order.'","'.esc_sql(serialize( $services) ).'","'.esc_sql( $ministry_id).'")';

            	$wpdb->query( $sql);
            	$job_id=$wpdb->insert_id;


            	if(!empty( $job_id) )  {echo'<div id="message" class="notice notice-success inline"><h2>'.__('Schedule Job Added','church-admin').'</h2></div>';}else{{echo'<div id="message" class="notice notice-success inline"><h2>'.__('Schedule Job failed to save','church-admin').'</h2></div>';}}
            	church_admin_rota_settings_list();
        	}else
        	{
            	$sql='UPDATE '.CA_RST_TBL.' SET rota_order="'.(int)$rota_order.'",rota_task="'.esc_sql(stripslashes( $_POST['rota_task'] ) ).'",service_id="'.esc_sql(serialize( $services) ).'",initials="'.$initials.'", ministries="'.(int)$ministry_id.'" WHERE rota_id="'.esc_sql( $id).'"';

           	 $wpdb->query( $sql);
            	echo'<div id="message" class="notice notice-success inline"><p><strong>'.__('Schedule Job Updated','church-admin').'</strong></p></div>';

            	church_admin_rota_settings_list();
        	}
    	}//insert
    	else
    	{//update
        	$sql='UPDATE '.CA_RST_TBL.' SET rota_order="'.(int)$rota_order.'",rota_task="'.esc_sql(stripslashes( $_POST['rota_task'] ) ).'",service_id="'.esc_sql(serialize( $services) ).'",initials="'.$initials.'",ministries="'.(int)$ministry_id.'" WHERE rota_id="'.esc_sql( $id).'"';

        	$wpdb->query( $sql);
        	echo'<div id="message" class="notice notice-success inline"><p><strong>'.__('Schedule Job Updated','church-admin').'</strong></p></div>';

        	church_admin_rota_settings_list();
   	 	}//update
	}
	else
	{
		echo'<h1>'.__('Set up Schedules','church-admin').'</h1><h2>'.__('Edit a Schedule Job','church-admin').'</h2><form action="" method="post">';
		if ( function_exists('wp_nonce_field') ) wp_nonce_field('edit_rota_settings');
		$rota_task=$wpdb->get_row("SELECT * FROM ".$wpdb->prefix."church_admin_rota_settings WHERE rota_id='".esc_sql( $id)."'");
		echo'<table class="form-table"><tbody><tr><th scope="row">'.__('Schedule Job','church-admin').':</th><td><input type="text" name="rota_task" ';
		if(!empty( $rota_task->rota_task) ) echo'value="'.esc_html( $rota_task->rota_task).'"';
		echo'/></td></tr>';

		echo'<tr><th scope="row">'.__('Enable use initials','church-admin').'</th><td><input type="checkbox" name="initials" value="1"';
		if(!empty( $rota_task->initials)&&$rota_task->initials>0) echo' checked="checked" ';
		echo'/></td></tr>';
		$rota_order=(!empty( $rota_task->rota_order) )?(int)$rota_task->rota_order:$rota_order;//value from above if not set
		echo'<tr><th scope="row">'.__('Rota order','church-admin').'</th><td><input type="number" name="rota_order" value="'.(int)$rota_order.'"/></td></tr>';
		echo'<tr><th scope="row">'.__('Which Services need this task?','church-admin').'</th><td>';
		if(!empty( $rota_task->service_id) )$current_services=unserialize( $rota_task->service_id);
		$services=$wpdb->get_results('SELECT * FROM '.CA_SER_TBL);
		if(!empty( $services) )
		{
			$ser=array();
			foreach( $services AS $service)
			{
				echo'<input type="checkbox" name="service_id[]" value="'.(int)$service->service_id.'" ';
				if(count( $services)==1 || !empty( $current_services)&&!empty( $service->service_id)&&is_array( $current_services) && (in_array( $service->service_id,$current_services) )) echo' checked="checked" ';
				echo'/>'.esc_html( $service->service_name).'<br />';
			}
		}
		echo'</td></tr>';
		//which ministries make up this rota job
		echo'<tr><th colspan=2>'.__('For speedy scheduling, a ministry can be assigned to a schedule task. The people in that ministry can then be quickly added to a schedule by checking their checkbox or selecting them.','church-admin').'</th></tr>';
		
		if(!empty( $ministries) )
		{
			echo '<tr><th scope="row">'.__('Choose which ministries do this job','church-admin').'</th><td><select id="ministry_id" name="ministry_id"><option id="no-ministry">'.__('Pick a ministry','church-admin').'</option>';
		
		
			/******************************************************
			 * Only one ministry id now allowed for each rota task
			 ******************************************************/
			$people=NULL;
			if(!empty( $rota_task->ministries) )
			{
				$currentMinistryId=(int)$rota_task->ministries;
				
				$people=church_admin_get_people_meta_array('ministry',$currentMinistryId);
			}

			if(!empty( $ministries) )
			{
				foreach( $ministries AS $id=>$ministry)
				{
					echo'<option  value="'.(int)$id.'"';
					if(!empty( $currentMinistryId) ) selected( $id,$currentMinistryId);
					echo'>';
					echo esc_html( $ministry).'</option>';
				}
				echo '</select></td></tr>';
			}
			echo '<tr><th scope="row">'.__('Or create a new ministry to do this rota task','church-admin').'</th><td><input type="text" name="ministry" id="add-ministry"/></td></tr>';
		
		}
		else
		{
			//no current ministries
			echo '<tr><th scope="row">'.__('Create a new ministry to do this rota task','church-admin').'</th><td><input type="text" name="ministry" id="add-ministry"/></td></tr>';
		
		}
		/*******************************
		 * Show people in that ministry
		 *******************************/
		echo'<tr><th scope="row">'.__('People in ministry').'</th><td>';
		if ( empty( $people) )$people=array();	
		echo  church_admin_autocomplete('people','friends','to',$people,FALSE);
		echo'</td></tr>';
		echo'<tr><th scope="row"><input type="submit" name="edit_rota_setting" value="'.__('Save Schedule Job','church-admin').' &raquo;" class="button-primary"/></td></tr></table></form>';

		echo'<script>jQuery(document).ready(function( $)  {
			$("#add-ministry").focusout(function()  {
				$("#ministry_id").val("");
				$("#no-ministry").attr("selected","selected");
			});
		});</script>';
	}
}
 /**
 *
 * church_admin-_rota_settings_list
 *
 * @author  Andy Moyle
 * @param
 * @return   html
 * @version  0.1
 *
 */
function church_admin_rota_settings_list()
{
    //outputs the list of rota jobs
	global $wpdb;

	/****************
	* Handle change job order
	*/
	if(!empty( $_POST['change_rota_job_order'] ) )
	{
		$wpdb->query('UPDATE '.CA_RST_TBL.' SET rota_order = "'.(int)$_POST['rota_order'].'" WHERE rota_id="'.(int)$_POST['change_rota_job_order'].'"');
	}

	$allMinistries=church_admin_ministries();
	echo '<h2>'.__('Rota Jobs','church-admin').'</h2>';
	echo '<p><a href="'.wp_nonce_url("admin.php?page=church_admin/index.php&amp;action=edit-rota-job&section=rota",'edit-rota-job').'" class="button-primary">'.__('Add a schedule job','church-admin').'</a></p>';

	$rota_results=$wpdb->get_results('SELECT * FROM '.CA_RST_TBL.' ORDER BY rota_order ASC');
	if(!empty( $rota_results) )
	{
		$numberRows=$wpdb->num_rows;
		$theader='<tr><th class="column-primary">'.__('Rota Task','church-admin').'</th><th>'.__('Edit','church-admin').'</th><th>'.__('Delete','church-admin').'</th><th>'.__('Which Services?','church-admin').'</th><th>'.__('Initials?','church-admin').'</th><th>'.__('Ministries','church-admin').'</th></tr>';
		echo '<table id="sortable" class="widefat striped wp-list-table"><thead>'.$theader.'</thead><tfoot>'.$theader.'</tfoot><tbody  class="content">';
		foreach( $rota_results AS $rota_row)
		{
			$rota_edit_url='admin.php?page=church_admin/index.php&action=church_admin_edit_rota_settings&id='.$rota_row->rota_id;
			$rota_delete_url='admin.php?page=church_admin/index.php&action=church_admin_delete_rota_settings&id='.$rota_row->rota_id;

			if(!empty( $rota_row->initials) )  {$initials=__('Yes','church-admin');}else{$initials=__('No','church-admin');}
			//services
			$ser=array();
			$services=maybe_unserialize( $rota_row->service_id);
			foreach( $services AS $key=>$value)  {$ser[]=$wpdb->get_var('SELECT service_name FROM '.CA_SER_TBL .' WHERE service_id="'.esc_sql( $value).'"');}
			//ministries
			$ministry=!empty( $rota_row->ministries)?$allMinistries[$rota_row->ministries]:'';
			
			
			


			echo '<tr class="sortable" id="'.$rota_row->rota_id.'">
				<td data-colname="'.__('Rota Task','church-admin').'" class="column-primary">'.esc_html(stripslashes( $rota_row->rota_task) ).'<button type="button" class="toggle-row"><span class="screen-reader-text">show details</span></button></td>	
				<td data-colname="'.__('Edit','church-admin').'" ><a href="'.wp_nonce_url( $rota_edit_url, 'edit_rota_settings').'">Edit</a></td>
				<td data-colname="'.__('Delete','church-admin').'" ><a href="'.wp_nonce_url(        $rota_delete_url, 'delete_rota_settings').'">Delete</a></td>
				
				<td data-colname="'.__('Which services?','church-admin').'" >'.implode('<br />',$ser).'</td>
				<td data-colname="'.__('Enable use initials','church-admin').'" >'.esc_html( $initials).'</td>
				<td data-colname="'.__('Ministries','church-admin').'" >'.esc_html( $ministry).'</td>
				
			</tr>';
		}
		echo'</tbody></table>';

		echo' <script type="text/javascript">

		jQuery(document).ready(function( $) {
	
		var fixHelper = function(e,ui)  {
				ui.children().each(function() {
					$(this).width( $(this).width() );
				});
				return ui;
			};
		var sortable = $("#sortable tbody.content").sortable({
		helper: fixHelper,
		stop: function(event, ui) {
			//create an array with the new order
	
	
					var Order = "order="+$(this).sortable(\'toArray\').toString();
	
	
	
			$.ajax({
				url: "admin.php?page=church_admin/index.php&action=church_admin_update_order&which=rota_settings",
				type: "post",
				data:  Order,
				error: function() {
					console.log("theres an error with AJAX");
				},
				success: function() {
	
				}
			});}
		});
		$("#sortable tbody.content").disableSelection();
		});
	
	
	
			</script>';
		
	}
}
