<?php

if ( ! defined( 'ABSPATH' ) ) exit('You need Jesus!'); // Exit if accessed directly


//use $email=TRUE to stop javascript activating as well eg for SMS and CSV download
function church_admin_directory_filter( $JSUse=TRUE,$email=FALSE)
{

	//Make $email TRUE when used for email and SMS
	global $wpdb,$church_admin_spiritual_gifts;
	$church_admin_marital_status=get_option('church_admin_marital_status');
	if( $JSUse)echo'<h2>'.__('Filtered Address List','church-admin').'</h2>';

	if( $JSUse)echo'<p><strong>'.__('Use the checkboxes to filter the address list you will see, results appear under the filter boxes','church-admin').'</strong></p>';
	if( $JSUse)echo'<p><strong>'.__('People totals in brackets are for that particular item only','church-admin').'</strong></p>';
    
	//exclude section
	$disabled=$message='';
	$premium=get_option('church_admin_payment_gateway');
	if(empty($premium)){
		$disabled='disabled = "disabled" ';
		$message= ' <a href="'.admin_url().$church_admin_url.'&action=app">'. esc_html( __('This is a premium feature, please upgrade','church-admin' ) ).'</a>';
	}
	echo'<div class="church-admin-form-group"><label>'.esc_html( __( 'Exclude people from results (comma separated)' , 'church-admin' ) ). $message .'</label>';
	echo '<input type="text" name="exclude" class="church-admin-form-control" '.$disabled.' id="exclude"/>';
	echo'</div>';



	if ( empty( $email) )  {echo'<form action="admin.php?page=church_admin%2Findex.php" method="POST"><div id="filters" class="ca-box">';}else{echo'<div id="filters1" class="ca-box">';}
	$class='category';
    
	$whichFilters=get_option('church-admin-which-filters');
church_admin_debug($whichFilters);
	//gender
	if(!empty( $whichFilters['genders'] ) )
    {
        $genders=get_option('church_admin_gender');
        echo'<div class="filterblock"><label>'.__('Gender','church-admin').'</label>';
        foreach( $genders AS $key=>$gender)
        {
            $count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  sex="'.esc_sql( $key).'" ');
            echo'<p><input type="checkbox" name="check[]" class="'.$class.' gender" value="ge/'.sanitize_title( $gender).'" />'.esc_html( $gender).' ('.(int)$count.')</p>';
        }
        echo'</div>';
    }
    //address
	if(!empty( $whichFilters['address'] ) )
    {
        
        echo'<div class="filterblock"><label>'.__('Address','church-admin').'</label>';
		$noAddressCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_HOU_TBL. ' WHERE  address="" ');
		$addressCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_HOU_TBL. ' WHERE  address!="" ');
		echo'<p><input type="checkbox" name="check[]" class="'.$class.' address" value="ad/no" />'.__("No address",'church-admin').' ('.(int)$noAddressCount.')</p>';
		echo'<p><input type="checkbox" name="check[]" class="'.$class.' email" value="ad/yes" />'.__("Has address",'church-admin').' ('.(int)$addressCount.')</p>';

	   echo'</div>';
    }
	//email
	if(!empty( $whichFilters['email-addresses'] ) )
    {
		echo'<div class="filterblock"><label>'.__('Email Address','church-admin').'</label>';
		$noEmailCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  email="" ');
		$emailCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  email!="" ');
		echo'<p><input type="checkbox" name="check[]" class="'.$class.' email" value="em/no" />'.__("No email address",'church-admin').' ('.(int)$noEmailCount.')</p>';
		echo'<p><input type="checkbox" name="check[]" class="'.$class.' email" value="em/yes" />'.__("Has email address",'church-admin').' ('.(int)$emailCount.')</p>';

	   echo'</div>';
    }
	if(!empty( $whichFilters['email-send'] ) )
    {
		echo'<div class="filterblock"><label>'.__('Email send permission','church-admin').'</label>';
		$noPermission=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  email_send=0 ');
		$emailCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  email_send=1 and email!=""');
		echo'<p><input type="checkbox" name="check[]" class="'.$class.' email_send" value="se/0" />'.__("No email send permission",'church-admin').' ('.(int)$noEmailCount.')</p>';
		echo'<p><input type="checkbox" name="check[]" class="'.$class.' email_send" value="se/1" />'.__("Email send permission and an email address",'church-admin').' ('.(int)$emailCount.')</p>';

	   echo'</div>';
    }
    
	//cell
	if(!empty( $whichFilters['cell'] ) )
    {
        echo'<div class="filterblock"><label>'.__('Cell phone','church-admin').'</label>';
		$noMobileCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  mobile="" ');
		$mobileCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  mobile!="" ');
		echo'<p><input type="checkbox" name="check[]" class="'.$class.' mobile" value="ce/no" />'.__("No cell phone",'church-admin').' ('.(int)$noMobileCount.')</p>';
		echo'<p><input type="checkbox" name="check[]" class="'.$class.' mobile" value="ce/yes" />'.__("Has cell phone",'church-admin').' ('.(int)$mobileCount.')</p>';

	   echo'</div>';
    }
	//photo-permission
	if(!empty( $whichFilters['photo-permission'] ) )
    {
        echo'<div class="filterblock"><label>'.__('Photo permission','church-admin').'</label>';
		$noPhotoPermissionCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  photo_permission=0 ');
		$PhotoPermissionCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  photo_permission=1');
		echo'<p><input type="checkbox" name="check[]" class="'.$class.' mobile" value="pp/0" />'.__("No photo permission",'church-admin').' ('.(int)$noPhotoPermissionCount.')</p>';
		echo'<p><input type="checkbox" name="check[]" class="'.$class.' mobile" value="pp/1" />'.__("Photo permission",'church-admin').' ('.(int)$PhotoPermissionCount.')</p>';

	   echo'</div>';
    }
	//user account
	if(!empty( $whichFilters['user-accounts'] ) )
    {	echo'<div class="filterblock"><label>'.__('Connected User account','church-admin').'</label>';
		$noUserCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  user_id="" ');
		$userCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  user_id!="" ');
		echo'<p><input type="checkbox" name="check[]" class="'.$class.' user" value="us/no" />'.__("No connected user account",'church-admin').' ('.(int)$noUserCount.')</p>';
		echo'<p><input type="checkbox" name="check[]" class="'.$class.' user" value="us/yes" />'.__("Connect user account",'church-admin').' ('.(int)$userCount.')</p>';

	   echo'</div>';
    }
	//data protection
	if(!empty( $whichFilters['gdpr'] ) )
    {
        echo'<div class="filterblock"><label>'.__('Personal Data','church-admin').'</label>';
        $notCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  gdpr_reason IS NULL OR gdpr_reason="" ');
        $count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  gdpr_reason IS NOT NULL OR gdpr_reason!="" ');
        echo'<p><input type="checkbox" name="check[]" class="'.$class.' gdpr" value="da/1" />'.__('Confirmed','church-admin').' ('.(int)$count.')</p>';
        echo'<p><input type="checkbox" name="check[]" class="'.$class.' gdpr" value="da/0" />'.__('Not Confirmed','church-admin').' ('.(int)$notCount.')</p>';
        echo'</div>';
    }
	//people types
    if(!empty( $whichFilters['people_types'] ) )
    {
	   $people_types=get_option('church_admin_people_type');
        if(!empty( $people_types) )
        {
            echo'<div class="filterblock"><label>'.__('People Types','church-admin').'</label>';
            $count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL);
            echo'<p><input type="checkbox" name="check[]" class="all '.$class.'" data-id="people" value="all"/><strong>'.__('All','church-admin').' ('.(int)$count.')</strong></p>';
            foreach( $people_types AS $key=>$people_type)
            {
                $count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  people_type_id="'.esc_sql( $key).'" ');
                echo'<p><input type="checkbox" name="check[]" class="'.$class.' spiritual-gifts" value="pe/'.sanitize_title( $people_type).'" />'.esc_html( $people_type).' ('.(int)$count.')</p>';
            }
            echo'</div>';
        }
    }
	if(!empty( $whichFilters['spiritual-gifts'] ) )
	{
		echo'<div class="filterblock"><label>'.__('Spiritual gifts','church-admin').'</label>';
		$count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL);
        echo'<p><input type="checkbox" name="check[]" class="all '.$class.'" data-id="people" value="all"/><strong>'.__('All','church-admin').' ('.(int)$count.')</strong></p>';
        foreach( $church_admin_spiritual_gifts AS $giftID=>$gift)
		{
			$count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_MET_TBL.' WHERE meta_type="spiritual_gifts" AND ID="'.(int)$giftID.'"');
			echo'<p><input type="checkbox" name="check[]" class="'.$class.' people" value="sp/'.(int)$giftID.'" />'.esc_html( $gift).' ('.(int)$count.')</p>';
            }
            echo'</div>'; 
	}
    //phone calls
    if(!empty( $whichFilters['phone-calls'] ) )
    {
	   $phoneCallsCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  phone_calls="1" ');
        $noPhoneCallsCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  phone_calls="0" ');
        
            echo'<div class="filterblock"><label>'.__('Phone calls','church-admin').'</label>';
           
            echo'<p><input  type="checkbox" name="check[]" class="'.$class.' phone-calls" value="pc/1" />'.__('Can receive phonecalls','church-admin').' ('.(int)$phoneCallsCount.')</p>';
        
        echo'<p><input  type="checkbox" name="check[]" class="'.$class.' phone-calls" value="pc/0" />'.__('No phone calls permission','church-admin').' ('.(int)$noPhoneCallsCount.')</p>';
            echo'</div>';
       
    }
	//active
	 if(!empty( $whichFilters['active'] ) )
    {
        echo'<div class="filterblock"><label>'.__('Active/Deactivated','church-admin').'</label>';
        $count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  active="1" ');
        echo'<p><input  type="checkbox" name="check[]" class="'.$class.' marital" value="ac/1" />'.__('Active','church-admin').' ('.(int)$count.')</p>';
        $count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  active="0" ');
        echo'<p><input  type="checkbox" name="check[]" class="'.$class.' marital" value="ac/0" />'.__('Inactive','church-admin').' ('.(int)$count.')</p>';
        echo'</div>';
    }
	//marital status
	 if(!empty( $whichFilters['marital'] ) )
    {
        echo'<div class="filterblock"><label>'.__('Marital Status','church-admin').'</label>';
        foreach( $church_admin_marital_status AS $key=>$status)
        {
            $count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  marital_status="'.esc_sql( $status).'" AND people_type_id=1');
            echo'<p><input  type="checkbox" name="check[]" class="'.$class.' marital" value="ma/'.sanitize_title( $status).'" />'.esc_html( $status).' ('.(int)$count.')</p>';
        }
        echo'</div>';
    
    }
	//Sites
     if(!empty( $whichFilters['sites'] ) )
    {
            $results=$wpdb->get_results('SELECT venue,site_id FROM '.CA_SIT_TBL.' ORDER BY venue ASC');
        if(!empty( $results) )
        {
            echo'<div class="filterblock"><label>'.__('Sites','church-admin').'</label>';
            echo'<p><input type="checkbox" name="check[]" class="all '.$class.'" data-id="sites" value="all"/><strong>'.__('All','church-admin').'</strong></p>';

            foreach( $results AS $row)
            {
                    $count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL. ' WHERE  site_id="'.esc_sql( $row->site_id).'" ');
                    echo'<p><input type="checkbox" name="check[]" class="'.$class.' sites" value="si/'.sanitize_title( $row->venue).'" />'.esc_html( $row->venue).' ('.(int)$count.')</p>';

            }
                    echo'</div>';
        }
    }
	//Member Types
	 if(!empty( $whichFilters['member_types'] ) )
    {
        $results=$wpdb->get_results('SELECT member_type_id,member_type FROM '.CA_MTY_TBL.' ORDER BY member_type_order ASC');
        if(!empty( $results) )
        {
            echo'<div class="filterblock"><label>'.__('Member Types','church-admin').'</label>';
            echo'<p><input type="checkbox" name="check[]" class="all '.$class.'" data-id="member" value="all"/><strong>'.__('All','church-admin').'</strong></p>';
            foreach( $results AS $mt)
            {
                $count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL.' WHERE member_type_id="'.intval( $mt->member_type_id).'"');
                echo'<p><input  type="checkbox" name="check[]" class="'.$class.' member" value="mt/'.sanitize_title( $mt->member_type).'" />'.esc_html( $mt->member_type).' ('.(int)$count.')</p>';
            }
            echo'</div>';
        }
    }
	//Small Groups
    if(!empty( $whichFilters['small-groups'] ) )
    {
    $results=$wpdb->get_results('SELECT id, group_name FROM '.CA_SMG_TBL.' ORDER BY group_name ASC');
	if(!empty( $results) )
	{

		echo'<div class="filterblock"><label>'.__('Small Groups','church-admin').'</label>';
		echo'<p><input type="checkbox" name="check[]" class="all '.$class.'" data-id="groups" value="all"/><strong>'.__('All','church-admin').'</strong></p>';
		echo'<p><input type="checkbox" name="check[]" class="'.$class.'" value="gp/no-group"/><strong>'.__('Not in a group (overrides other small group selections)','church-admin').'</strong></p>';
		echo'<p>';

			foreach( $results AS $row)
			{
				$count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_MET_TBL.' WHERE ID="'.(int)$row->id.'" AND meta_type="smallgroup"');

				echo'<span ><input type="checkbox" name="check[]" class="'.$class.' groups" value="gp/'.sanitize_title( $row->group_name).'" />'.esc_html( $row->group_name).' ('.(int)$count.')</span><br />';

			}
		}

				echo'</p></div>';
    }
	//Classes
    if(!empty( $whichFilters['classes'] ) )
    {
    $results=$wpdb->get_results('SELECT class_id, name FROM '.CA_CLA_TBL.' ORDER BY name ASC');
	if(!empty( $results) )
	{

		echo'<div class="filterblock"><label>'.__('Classes','church-admin').'</label>';
		echo'<p><input type="checkbox" name="check[]" class="all '.$class.'" data-id="classes" value="all"/><strong>'.__('All','church-admin').'</strong></p>';
		
		echo'<p>';

			foreach( $results AS $row)
			{
				$count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_MET_TBL.' WHERE ID="'.intval( $row->class_id).'" AND meta_type="class"');

				echo'<span ><input type="checkbox" name="check[]" class="'.$class.' classes" value="cl/'.sanitize_title( $row->name).'" />'.esc_html( $row->name).' ('.(int)$count.')</span><br />';

			}
		}

				echo'</p></div>';
    }
	//Ministries
     if(!empty( $whichFilters['ministries'] ) )
    {
        $results=$wpdb->get_results('SELECT ministry,ID FROM '.CA_MIN_TBL.' ORDER BY ministry ASC');
        if(!empty( $results) )
        {
            echo'<div class="filterblock"><label>'.__('Ministries','church-admin').'</label>';
            echo'<p><input type="checkbox" name="check[]" class="all '.$class.'" data-id="ministries" value="all"/><strong>'.__('All','church-admin').'</strong></p>';

             echo '<p>';
            foreach( $results AS $row)
            {
                $count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_MET_TBL.' WHERE ID="'.(int)$row->ID.'" AND meta_type="ministry"');

                echo'<span ><input type="checkbox" name="check[]" class="'.$class.' ministries" value="mi/'.sanitize_title( $row->ministry).'" />'.esc_html( $row->ministry).' ('.(int)$count.')</span><br />';

            }
                    echo'</p></div>';
        }
    }
	//year of birth
	 if(!empty( $whichFilters['birth-year'] ) )
    {
        $years=$wpdb->get_results('SELECT YEAR(date_of_birth) AS year FROM '.CA_PEO_TBL.' WHERE date_of_birth!="0000-00-00" GROUP BY YEAR(date_of_birth) ORDER BY YEAR(date_of_birth) ASC');
        if(!empty( $years) )
        {
                echo'<div class="filterblock"><label>'.__('Year of Birth','church-admin').'</label><ul style="columns:2">';
                
                foreach( $years AS $year)
                {
                    $count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL.' WHERE YEAR(date_of_birth)="'.esc_sql( $year->year).'"');

                    echo'<li><input type="checkbox" name="check[]" value="ye/'.sanitize_title( $year->year).'">'.esc_html( $year->year).' ('.(int)$count.')</li>';
                }
                echo'</ul></div>';
        }
    }
     if(!empty( $whichFilters['birth-month'] ) )
    {
        $months=$wpdb->get_results('SELECT MONTH(date_of_birth) AS month FROM '.CA_PEO_TBL.' WHERE date_of_birth!="0000-00-00" GROUP BY MONTH(date_of_birth) ORDER BY MONTH(date_of_birth) ASC');
        if(!empty( $months) )
        {
                echo'<div class="filterblock"><label>'.__('Month of Birth','church-admin').'</label>';
                echo '<p>';
                foreach( $months AS $month)
                {
                    $count=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL.' WHERE MONTH(date_of_birth)="'.esc_sql( $month->month).'"');
                    echo'<span ><input type="checkbox" name="check[]" class="'.$class.' parents" value="mo/'.sanitize_title( $month->month).'" />'.mysql2date('F','2018-'.sprintf('%02d',$month->month).'-01').' ('.intval( $count).')</span>';
                    echo'<br />';
                }
                echo'</p></div>';
        }
    }
	//parents
     if(!empty( $whichFilters['parents'] ) )
    {
        $results=$wpdb->get_results('SELECT * FROM '.CA_KID_TBL.' ORDER BY youngest');
        if(!empty( $results) )
        {
            echo'<div class="filterblock"><label>'.__('Parents with children in...','church-admin').'</label>';
            echo'<p><input type="checkbox" name="check[]" class="all '.$class.'" data-id="parents" value="all"/><strong>'.__('All','church-admin').'</strong></p>';
            echo '<p>';
            foreach( $results AS $row)
            {

                echo'<span ><input type="checkbox" name="check[]" class="'.$class.' parents" value="pa/'.sanitize_title( $row->id).'" />'.esc_html( $row->group_name).'</span>';
                echo'<br />';
            }
            echo'<p></div>';
        }
    }
	/********************************************************
	*
	* Custom Fields
	*
	*********************************************************/
	$customFields=church_admin_get_custom_fields();

	if(!empty( $customFields) )
	{

		foreach ( $customFields AS $ID=>$field)
		{
            if( $field['section']!='people')continue;
			if(!empty( $whichFilters[$field['sanitized-name']] ) )
            {
				church_admin_debug('Print '.$field['name']);
                $type=$field['type'];
                switch( $type)
                {
                    case'boolean';
                        $counttrue=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_CUST_MET_TBL. ' WHERE  custom_id='.(int)$ID.' AND data=1 ');
                        $countfalse=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_CUST_MET_TBL. ' WHERE  custom_id='.(int)$ID.' AND data=0 ');

                        echo'<div class="filterblock"><label>'. esc_html( $field['name'] ).'</label>';


                        echo'<p><span ><input type="checkbox" name="check[]" class="'.$class.' custom" value="cu/bo~1~'.(int)$ID.'" />'.__('Yes','church-admin').' ('.$counttrue.') </span><span ><input type="checkbox" name="check[]" class="'.$class.' custom" value="cu/bo~0~'.(int)$ID.'"/>'.__('No','church-admin').' ('.$countfalse.')</span>';

                        echo'</div>';
                    break;
                    case 'date':
                        $dates=$wpdb->get_results('SELECT  `data` AS customDate FROM '.CA_CUST_MET_TBL.' WHERE data!="0000-00-00" AND custom_id="'.(int)$ID.'" GROUP BY `data` ORDER BY `data` ASC');

                        if(!empty( $dates) )
                        {
                            echo'<div class="filterblock"><label>'.esc_html( $field['name'] ).'</label><p>';

                            if( $wpdb->num_rows>20)
                            {
                                echo'<select name="check[]" class="'.$class.' custom"><option>'.__('Please choose a date','church-admin').'</option>';
                                foreach( $dates as $date)
                                {
                                    if(!empty( $date->customDate) )
                                    {
                                        echo'<option value="cu/da~'.sanitize_title( $date->customDate).'" />'.mysql2date(get_option('date_format'),$date->customDate).'</option>';

                                    }
                                }
                                echo'</select>';
                            }
                            else{
                                foreach( $dates as $date)
                                {
                                    if(!empty( $date->customDate) )
                                    {
                                        echo'<span ><input type="checkbox" name="check[]" class="'.$class.' custom" value="cu/da~'.sanitize_title( $date->customDate).'" />'.mysql2date(get_option('date_format'),$date->customDate).'</span>';
                                        echo'<br />';
                                    }
                                }
                            }
                            echo'</p></div>';
                        }
                    break;
                    case'text':
                        $sql='SELECT DISTINCT `data` AS textString FROM '.CA_CUST_MET_TBL.' WHERE `data`!="" AND custom_id="'.(int)$ID.'" ORDER BY `data` ASC';
                        $texts=$wpdb->get_results( $sql);

                        if(!empty( $texts) )
                        {
                            echo'<div class="filterblock"><label>'.esc_html( $field['name'] ).'</label><p>';

                            if( $wpdb->num_rows>20)
                            {
                                echo'<select name="check[]" class="'.$class.' custom"><option>'.__('Please choose a text string','church-admin').'</option>';
                                foreach( $texts AS $text)
                                {
                                    if(!empty( $text->textString) )
                                    {
                                        $string=substr( $text->textString,0,50);
                                        echo'<option value="cu/tx~'.urlencode( $string).'">'.esc_html( $string).'</option>';

                                    }
                                }
                                echo'</select>';
                            }
                            else
                            {
                                foreach( $texts AS $text)
                                {
                                    if(!empty( $text->textString) )
                                    {
                                        $string=substr( $text->textString,0,50);
                                        echo'<span ><input type="checkbox" name="check[]" class="'.$class.' custom" value="cu/tx~'.urlencode( $string).'" />'.esc_html( $string).'</span>';
                                        echo'<br />';
                                    }
                                }	
                            }
                            echo'</p></div>';
                        }
                    break;
                }
            }
		}

	}
	echo'</div>';
	if ( empty( $email) )echo'<p><input type="checkbox" name="ca_download" value="pdf-filter">'.__('PDF of filter results','church-admin').'</p><p><input type="checkbox" name="ca_download" value="csv-filter">'.__('CSV of filter results','church-admin').'</p><input type="submit" value="'.__('Download results','church-admin').'" class="button-primary"/></form>';
    echo'<div id="filtered-response"></div>';
	$nonce = wp_create_nonce("church_admin_filter");
	if( $JSUse)echo'

	<script >
		jQuery(document).ready(function( $) {
			$("#filters .all").on("change", function()  {
				var id = $(this).attr("data-id");

				$("input."+id).prop("checked", !$("."+id).prop("checked") )
			});
		   
		   function doFilter()  {
				var exclude = $("#exclude").val();
      			var category_list = [];
      			$("#filters :input:checked").each(function()  {
							var category = $(this).val();
        			category_list.push(category);

        		});
				$("#filters :selected").each(function()  {

        			category = $(this).val();
							console.log(category);
        			category_list.push(category);

        		});
      			var data = {
				"action": "church_admin",
				method:"filter",
				"data": category_list,
				"exclude":exclude,
				"nonce": "'.$nonce.'"
				};
				console.log(data);
				$("#filtered-response").html(\'<p style="text-align:center"><img src="'.admin_url().'/images/wpspin_light-2x.gif"/></p>\');
				// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
				jQuery.post(ajaxurl, data, function(response) {
					$("#filtered-response").html(response);
				});
			};

			$("#filters .category").on("change",doFilter);
			$("#exclude").on("change",doFilter);
		   	
		});
	</script>
	
	';

}



function church_admin_filter_process()
{
	//if changes made here also update email.php

	global $wpdb;
    $wpdb->show_errors();
	$ptypes=get_option('church_admin_people_type');
	$church_admin_marital_status=get_option('church_admin_marital_status');
	$out='';
	$group_by='';
	$email_send=$spiritual_gifts=$addresses=$classes=$gdpr=$userAccount=$custom=$months=$years=$member_types=$parents=$genders=$people_types=$sites=$smallgroups=$ministries=$photo_permission=array();
	$email_sendSQL=$spiritual_giftsSQL=$addressesSQL=$classesSQL=$customSQL=$userSQL=$monthSQL=$yearSQL=$marritalSQL=$genderSQL=$memberSQL=$peopleSQL=$smallgroupsSQL=$ministriesSQL=$filteredby=$photo_permissionSQL=array();
	$gdprSQL='';
	$sql= church_admin_build_filter_sql( $_POST['data'],NULL);
	if(defined('CA_DEBUG') )church_admin_debug( $sql);
	$results=$wpdb->get_results( $sql);
	echo'<h2>'.__('Filter results: ','church-admin').'</h2>';
	if(!empty( $results) )
	{

		echo'<table class="widefat striped wp-list-table">';
		$header='<tr><th class="column-primary">'.__('Name','church-admin').'</th><th>'.__('Edit','church-admin').'</th>
		<th>'.__('Delete','church-admin').'</th>
		<th>'.__('Display whole household','church-admin').'</th>
		<th>'.__('Active','church-admin').'</th>
		
		<th>'.__('People type','church-admin').'</th>
		<th>'.__('Home Phone','church-admin').'</th>
		<th>'.__('Cell phone','church-admin').'</th>
		<th>'.__('Email','church-admin').'</th>
		<th>'.__('Address','church-admin').'</th>
		<th>'.__('User Account','church-admin').'</th>
		<th>'.__('Last updated','church-admin').'</th>
		<th>'.__('Household ID','church-admin').'</th>
		<th>'.__('Move to different household','church-admin').'</th>
		</tr>';
		echo'<thead>'.$header.'</thead><tfoot>'.$header.'</tfoot><tbody>';
		foreach( $results AS $row)
		{
			//church_admin_debug(print_r( $row,TRUE) );
			$class=array('is-expanded');
			if ( empty( $row->show_me) )$class[]='ca-private';
			if ( empty( $row->active) )$class[]='ca-deactivated';
			if(!empty( $class) )  {$classes=' class="'.implode(" ",$class).'"';}else$classes='';
			echo '<tr '.$classes.' id="row'.(int)$row->people_id.'">';
			$name=array_filter(array( $row->first_name,$row->middle_name,$row->prefix,$row->last_name) );
			echo'<td class="ca-names column-primary" data-colname="'.__('Name','church-admin').'">'.esc_html(implode(' ',$name) ).'</td>';
			echo'<td data-colname="'.__('Edit','church-admin').'"><a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_people&amp;people_id='.$row->people_id.'&amp;household_id='.$row->household_id,'edit_people').'">'.__('Edit','church-admin').'</a></td>';
			echo'<td data-colname="'.__('Delete','church-admin').'"><a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete_people&amp;people_id='.$row->people_id.'&amp;household_id='.(int)$row->household_id,'edit_people').'">'.__('Delete','church-admin').'</a></td>';
			echo'<td data-colname="'.__('Display household','church-admin').'"><a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=display_household&amp;household_id='.$row->household_id,'display_household').'">'.__('Display','church-admin').'</a></td>';
            if(!empty( $row->active) )  {$activate=__('Active','church-admin');}else{$activate=__('Inactive','church-admin');}
			echo'<td  data-colname="'.__('Active','church-admin').'"><span class="activate ca-active" id="active-'.(int)$row->people_id.'">'.$activate.'</span> </td>';
			
			if(!empty( $row->people_type_id) )  {echo'<td data-colname="'.__('People type','church-admin').'">'.esc_html( $ptypes[$row->people_type_id] ).'</td>';}else{echo'<td  data-colname="'.__('People type','church-admin').'">&nbsp;</td>';}
			echo'<td class="ca-phone" data-colname="'.__('Phone','church-admin').'">'.esc_html( $row->phone).'</td>';
			echo'<td class="ca-mobile"  data-colname="'.__('Cell ','church-admin').'">'.esc_html( $row->mobile).'</td>';
			if(!empty( $row->email) )  {echo'<td class="ca-email"  data-colname="'.__('Email','church-admin').'"><a href="mailto:'.$row->email.'">'.esc_html( $row->email).'</a></td>';}else{echo'<td>&nbsp;</td>';}
			echo'<td class="ca-addresses"  data-colname="'.__('Address','church-admin').'"><a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_household&amp;household_id='.$row->household_id,'edit_household').'">';
			if(!empty( $row->address) )  {echo esc_html( $row->address);}
			else {echo __('Add Address','church-admin');}
			echo '</a></td>';
            $user='&nbsp;';
			if(!empty( $row->email) )
			{//user account only relevant for people with email
				if(!empty( $row->user_id) )
				{
					$user_info=get_userdata( $row->user_id);
					if(!empty( $user_info) )$user=$user_info->user_login;
				}
				else
				{
					//check if a user exists for this email
					$user_id=email_exists( $row->email);
					$unassigned_user=get_userdata( $user_id);
					if(!empty( $user_id) )
					{
						$user='<span class="ca_connect_user" data-peopleid="'.(int)$row->people_id.'" data-userid="'.(int)$user_id.'">'.__('Connect','church-admin').' '.$unassigned_user->user_login.'</span>';

					}
					else
					{
						if(!empty( $row->gdpr_reason) )
						{
							$user='<span class="ca_create_user" data-peopleid="'.(int)$row->people_id.'" >'.__('Create user account','church-admin').'</span>';
						}
						else
						{
							$user='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&action=single-gdpr-email&people_id='.(int)$row->people_id,'single-gdpr-email').'" >'.__('Send GDPR confirmation email','church-admin').'</a>';
						}
						
					}
				}
			}
			echo'<td><div class="ca-names userinfo'.(int)$row->people_id.'">'.$user.'</div></td>';
            $updatedBy='';
            if(!empty( $row->updated_by) )
            {
                $updatedBy=$wpdb->get_var('SELECT CONCAT_WS(" ",first_name,last_name) FROM '.CA_PEO_TBL.' WHERE user_id="'.intval( $row->updated_by).'"');
            }
            $updated=sprintf(__('Person updated %1$s, Household updated %2$s','church-admin'),mysql2date(get_option('date_format'),$row->last_updated),mysql2date(get_option('date_format'),$row->householdUpdated) );
            echo'<td  data-colname="'.__('Last update','church-admin').'">'.$updated.'</td>';
            echo'<td  data-colname="'.__('Household ID','church-admin').'">'.(int)$row->household_id.'</td>';
			echo'<td  data-colname="'.__('Move household','church-admin').'"><a class="button-secondary" onclick="return confirm(\''.esc_html(sprintf(__('Are you sure you want to move %1$s','church-admin'),church_admin_formatted_name( $row) )).'\')" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=church_admin_move_person&amp;people_id='.$row->people_id,'move_person').'">'.__('Move','church-admin').'</a></td>';
			echo'</tr>'."\r\n";

		}
		echo'</tbody></table>';

	}else{echo'<p>'.__('Your filters produced no results. Please try again.','church-admin').'</p>';}
	$connect_nonce = wp_create_nonce("connect_user");
	$create_nonce = wp_create_nonce("create_user");
	echo'<script >jQuery(document).ready(function( $) {

			$(".ca_connect_user").click(function() {
			var people_id=$(this).attr("data-peopleid");
			var data = {
			"action": "church_admin",
			"method": "connect_user",
			"people_id": people_id,
			"user_id": $(this).attr("data-userid"),
			"nonce": "'.$connect_nonce.'",
			dataType: "json"
			};console.log(data);
			// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
			jQuery.post(ajaxurl, data, function(response)
			{
				var data=JSON.parse(response);
				console.log("body .userinfo"+data.people_id + " "+data.login)
				$(".userinfo"+data.people_id).replaceWith(data.login);
			});

		});
        $("body").on("click",".activate",function()  {
            var people_id=$(this).attr("id");
            var nonce="'.wp_create_nonce('activate').'";
            var data = {
			"action": "church_admin",
			"method": "people_activate",
			"people_id": people_id,
			"nonce": nonce,
			dataType:"json"
			};
            console.log(data);
            jQuery.post(ajaxurl, data, function(response)
			{
				var data=JSON.parse(response);
				console.log(data.status)
				$("active-"+data.id).html(data.status);
                if(data.status=="Active")
                {
                    $("body #row"+data.id).addClass("ca-activated");
                    $("body #row"+data.id).removeClass("ca-deactivated")
                    $("body #active-"+data.id).html("'.__("Active",'church-admin').'");
                }
                else
                {
                    $("body #row"+data.id).removeClass("ca-activated");
                    $("body #row"+data.id).addClass("ca-deactivated");
                     $("body #active-"+data.id).html("'.__("Inactive",'church-admin').'");
                    
                }
			});
        });
		$(".ca_create_user").click(function() {
			var people_id=$(this).attr("data-peopleid");
			var data = {
			"action": "church_admin",
			"method": "create_user",
			"people_id": $(this).attr("data-peopleid"),
			"nonce": "'.$create_nonce.'",
			dataType:"json"
			};
			console.log(data);
			// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
			jQuery.post(ajaxurl, data, function(response)
			{
				var data=JSON.parse(response);
				console.log("body .userinfo"+data.people_id + " "+data.login)
				$(".userinfo"+data.people_id).replaceWith(data.login);
			});
		});
			});</script>';

}


function church_admin_filter_count( $type)
{
	//if changes made here also update email.php

	global $wpdb;
	$church_admin_marital_status=get_option('church_admin_marital_status');
	$out='';
	$group_by='';
	$email_send=$spiritual_gifts=$addresses=$classes=$gdpr=$userAccount=$custom=$months=$years=$member_types=$parents=$genders=$people_types=$sites=$smallgroups=$ministries=$photo_permission=array();
	$email_sendSQL=$spiritual_giftsSQL=$addressesSQL=$classesSQL=$customSQL=$userSQL=$monthSQL=$yearSQL=$marritalSQL=$genderSQL=$memberSQL=$peopleSQL=$smallgroupsSQL=$ministriesSQL=$filteredby=$photo_permissionSQL=array();
	
	$sql= church_admin_build_filter_sql( $_POST['data'],$type='email');
	church_admin_debug( $sql);
	$result=$wpdb->get_results( $sql);
	$count=$wpdb->num_rows;
	if ( empty( $count) )$count='0';
	return '<strong>'.sprintf(__('%1$s people','church-admin'),$count).'</strong>';
}
function church_admin_filter_email()
{
	//if changes made here also update email.php

	global $wpdb;
	$church_admin_marital_status=get_option('church_admin_marital_status');
	$out='';
	$group_by='';
	$email_send=$spiritual_gifts=$addresses=$classes=$member_types=$genders=$people_types=$sites=$smallgroups=$ministries=$photo_permission=array();
	$email_sendSQL=$spiritual_giftsSQL=$addressesSQL=$classesSQL=$maritalSQL=$genderSQL=$memberSQL=$peopleSQL=$smallgroupsSQL=$ministriesSQL=$photo_permissionSQL=$filteredby=array();
	$sql= church_admin_build_filter_sql( $_POST['data'],'email');
	church_admin_debug( $sql);
	$result=$wpdb->get_results( $sql);
	if(!empty( $result) )
    {
        $out='<h2>'.__('Recipients (check before sending)','church-admin').'</h2><p>';
        foreach( $result AS $row)
        {
            $out.=esc_html( $row->first_name.' '. $row->last_name).' '.$row->email.'<br />';
        }
		$out.='</p>';
    }else $out='<h2>'.__('No-one with an email selected','church-admin').'</h2>';
	return $out;
}




function church_admin_build_filter_sql( $input,$type=NULL)
	{
		church_admin_debug($_POST);
		global $wpdb,$church_admin_spiritual_gifts;
        $email_send=$spiritual_gifts=$phoneCalls=$addresses=$classes=$active=$custom=$months=$years=$marital=$genders=$people_types=$email=$sites=$smallgroups=$ministries=$parents=$mobile=$photo_permission=array();
        $email_sendSQL=$spiritual_giftsSQL=$phoneCallsSQL=$addressesSQL=$emailSQL=$mobileSQL=$classesSQL=$maritalSQL=$genderSQL=$memberSQL=$peopleSQL=$smallgroupsSQL=$ministriesSQL=$filteredby=$photo_permissionSQL=array();
		$church_admin_marital_status=get_option('church_admin_marital_status');
		//church_admin_debug(print_r( $input,TRUE) );
		foreach( $input AS $key=>$data)
		{
			//extract posted data
			$temp=explode('/',$data);
			switch( $temp[0] )
			{
				case 'se':$email_send[]=(int)$temp[1];break;
				case 'da':	if ( empty( $temp[1] ) )  {$gdprSQL=' (a.gdpr_reason IS NULL OR a.gdpr_reason="" )';}else{$gdprSQL=' (a.gdpr_reason!="") ';}break;
                case 'ad':$addresses[]=sanitize_text_field( $temp[1] );break;
				case 'ac':	$active[]=(int)$temp[1];break;
                case 'pc':	$phoneCalls[]=(int)$temp[1];break;
                case 'cl':  $classes[]=sanitize_text_field( $temp[1] );break;
                case 'cu':	$custom[]=sanitize_text_field( $temp[1] );break;
				case 'us':	$user[]=sanitize_text_field( $temp[1] );break;
				case 'ce':	$mobile[]=sanitize_text_field( $temp[1] );break;
				case 'mo':	$months[]=(int)$temp[1];break;
				case 'ye':	$years[]=(int)$temp[1];break;
				case 'ma': $marital[]=sanitize_text_field( $temp[1] );			break;
				case 'ge': 	$genders[]=sanitize_text_field( $temp[1] );			break;
				case 'mt': 	$member_types[]=sanitize_text_field( $temp[1] );		break;
				case 'pe':	$people_types[]=sanitize_text_field( $temp[1] );		break;
				case 'em':$email[]=sanitize_text_field( $temp[1] );break;
				case 'si':	$sites[]=sanitize_text_field( $temp[1] );			break;
				case 'gp':	$smallgroups[]=sanitize_text_field( $temp[1] );		break;
				case 'mi':	$ministries[]=sanitize_text_field( $temp[1] );		break;
				case 'pa':	$parents[]=sanitize_text_field( $temp[1] );		break;
				case 'pp':	$photo_permission[]=(int)$temp[1];break;
				case 'sp':$spiritual_gifts[]=(int)$temp[1];break;
			}
		}
		//create clauses for different
		if(!empty( $active)&&is_array( $active) )
		{
			foreach( $active AS $key=>$act)$activeSQL[]='a.active="'.(int)$act.'" ';
		}
        if(!empty( $phoneCalls)&&is_array( $phoneCalls) )
		{
			foreach( $phoneCalls AS $key=>$pc)$phoneCallsSQL[]='a.phone_calls="'.(int)$pc.'" ';
		}
		if(!empty( $email_send)&&is_array( $email_send) )
		{
			foreach( $email_send AS $key=>$se)$email_sendSQL[]='a.email_send="'.(int)$se.'" ';
		}
		if(!empty( $photo_permission)&&is_array( $photo_permission) )
		{
			foreach( $photo_permission AS $key=>$pp)$photo_permissionSQL[]='a.photo_permission="'.(int)$pp.'" ';
		}
		if(!empty( $custom)&&is_array( $custom) )
		{

			foreach( $custom AS $key=>$cust)
			{
				$customData=explode('~',$cust);

				switch( $customData[0] )
				{
					case'bo':$customSQL[]='h.`custom_id`="'.intval( $customData[2] ).'" AND h.`data`="'.(int)$customData[1].'" AND h.people_id=a.people_id';break;
					case'da':$customSQL[]='h.`data`="'.esc_sql( $customData[1] ).'"AND h.people_id=a.people_id';break;
					case'tx': $customSQL[]=' h.`data` LIKE "%'.esc_sql(urldecode( $customData[1] ) ).'%" AND h.people_id=a.people_id';break;
				}

			}
		}
		if(!empty( $email) )
		{
			foreach ( $email AS $key=>$emailAnswer)
			{
				if( $emailAnswer=='no' && !in_array(' a.email="" ',$emailSQL) )$emailSQL[]= ' a.email="" ';
				elseif(!in_array(' a.email!="" ',$emailSQL) )  {$emailSQL[]=' a.email!="" ';}	
			}
		}

        if(!empty( $addresses) )
		{
			foreach ( $addresses AS $key=>$addressAnswer)
			{
				if( $addressAnswer=='no' && !in_array(' b.address="" ',$addressesSQL) )$addressesSQL[]= ' b.address="" ';
								    elseif(!in_array(' b.address!="" ',$addressesSQL) )  {$addressesSQL[]=' b.address!="" ';}	
								}
		}
		if(!empty( $user) )
		{
			foreach ( $user AS $key=>$userAnswer)
			{
				if( $userAnswer=='no' && !in_array(' a.user_id="" ',$userSQL) )$userSQL[]= ' a.user_id="" ';
				elseif(!in_array(' a.user_id!="" ',$userSQL) )  {$userSQL[]=' a.user_id!="" ';}	
			}
		}
		if(!empty( $mobile) )
		{	
						
			foreach ( $mobile AS $key=>$mobileAnswer)
			{
				if( $mobileAnswer=='no' && !in_array('a.mobile=""',$mobileSQL) )  {$mobileSQL[]= 'a.mobile=""';}
				elseif(!in_array('a.mobile!=""',$mobileSQL) )  {$mobileSQL[]='a.mobile!=""';}	
			}
		}
				
		if(!empty( $months)&&is_array( $months) )
		{
				foreach( $months AS $key=>$month)
				{
					$monthSQL[]=' MONTH(a.date_of_birth)="'.(int)$month.'"';
				}

		}
		if(!empty( $years)&&is_array( $years) )
		{
				foreach( $years AS $key=>$year)
				{
					$yearSQL[]='YEAR(a.date_of_birth)="'.(int)$year.'"';
				}

		}

		if(!empty( $marital)&&is_array( $marital) )
		{
			foreach( $church_admin_marital_status AS $key=>$status)
			{
				if(in_array(sanitize_title( $status),$marital) )$maritalSQL[]='a.marital_status="'.esc_sql( $status).'"';
			}
		}
					
		if(!empty( $genders) )
		{

			$sex=get_option('church_admin_gender');
			foreach( $sex AS $key=>$gender)
			{

				if(in_array(sanitize_title( $gender),$genders) )
				{
					$genderSQL[]='(a.sex="'.(int)$key.'")';
					$filteredby[]=$gender;
				}
			}

		}

		//end gender section
		//member types
		if(!empty( $member_types)&&is_array( $member_types) )
		{

			$allmembers=$wpdb->get_results('SELECT * FROM '.CA_MTY_TBL);

			if(!empty( $allmembers) )
			{
				foreach( $allmembers AS $onetype)
				{

					if(in_array(sanitize_title( $onetype->member_type),$member_types) )
					{
						$memberSQL[]='(a.member_type_id="'.(int)$onetype->member_type_id.'" AND a.member_type_id=f.member_type_id)';
						$filteredby[]=$onetype->member_type;
					}
				}
			}
		}//end member_types

		//people types
		$ptypes=get_option('church_admin_people_type');
		if(!empty( $people_types) )
		{

			if(!in_array('all',$people_types) )//only do if all not selected
			{
				$ptypes=get_option('church_admin_people_type');

				foreach( $ptypes AS $key=>$ptype)
				{
					if(in_array(sanitize_title( $ptype),$people_types) )
					{
						$peopleSQL[]='(a.people_type_id="'.(int)$key.'")';
						$filteredby[]=$ptype;
					}
				}
			}
		}//end people type section

		//sites

		if(!empty( $sites)&&is_array( $sites) )
		{
			if(!in_array('all',$sites) )//only do if all not selected
			{
				$campuses=$wpdb->get_results('SELECT * FROM '.CA_SIT_TBL);

				if(!empty( $campuses) )
				{
					foreach( $campuses AS $campus)
					{
						if(in_array(sanitize_title( $campus->venue),$sites) )
						{
							$sitesSQL[]='(a.site_id="'.(int)$campus->site_id.'")';
							$filteredby[]=$campus->venue;
						}
					}
				}
			}
		}//end sites
		//Parents
		//$parents is array of kidswork group_id we are looking for parents of!

		$kidsworkData=church_admin_whosin_kidswork_array();

		$kidsworkSQL=array();
		if(!empty( $parents)&&is_array( $parents) )
		{
				foreach( $parents AS $id=>$kidswork_group_id)
				{
					if(!empty( $kidsworkData[$kidswork_group_id]['children'] ) )
					{
							foreach( $kidsworkData[$kidswork_group_id]['children'] AS $childData)
							{
									foreach( $childData['parents'] AS $y=>$people_id)$kidsworkSQL[]='(a.people_id="'.(int)$people_id.'")';
							}
					}
				}

		}
		//spiritual gifts

		if(!empty( $spiritual_gifts)&&is_array( $spiritual_gifts) )
		{

			if(!in_array('all',$spiritual_gifts) )//only do if all not selected
			{
				
				if(!empty( $church_admin_spiritual_gifts) )
				{
					foreach( $church_admin_spiritual_gifts AS $gift_id=>$gift)
					{

						if(in_array(sanitize_title( $gift_id),$spiritual_gifts) )
						{
							$spiritual_giftsSQL[]='a.people_id=(SELECT c.people_id FROM '.CA_MET_TBL.' c WHERE  c.ID="'.(int)$gift_id.'" AND c.meta_type="spiritual-gifts" AND c.people_id=a.people_id)';
							$filteredby[]=$gift;
						}
					}
				}
			}
			if(in_array('no-group',$smallgroups) )
			{
				 $spiritual_giftsSQL=array('a.people_id NOT IN (SELECT people_id FROM '.CA_MET_TBL.' WHERE meta_type="spiritual-gifts")');
					}
		}//end spiritual gifts
		//small groups

		if(!empty( $smallgroups)&&is_array( $smallgroups) )
		{

			if(!in_array('all',$smallgroups) )//only do if all not selected
			{
				$sgs=$wpdb->get_results('SELECT * FROM '.CA_SMG_TBL);
				if(!empty( $sgs) )
				{
					foreach( $sgs AS $sg)
					{

						if(in_array(sanitize_title( $sg->group_name),$smallgroups) )
						{
							$smallgroupsSQL[]='a.people_id=(SELECT c.people_id FROM '.CA_MET_TBL.' c WHERE  c.ID="'.(int)$sg->id.'" AND c.meta_type="smallgroup" AND c.people_id=a.people_id)';
							$filteredby[]=$sg->group_name;
						}
					}
				}
			}
			if(in_array('no-group',$smallgroups) )
			{
				 $smallgroupsSQL=array('a.people_id NOT IN (SELECT people_id FROM '.CA_MET_TBL.' WHERE meta_type="smallgroup")');
					}
		}//end smallgroups
        /**************************************************
        *
        *   Classes
        *
        ***************************************************/
        if(!empty( $classes)&&is_array( $classes) )
		{
            if(defined('CA_DEBUG') )church_admin_debug('Classes section');
            if(defined('CA_DEBUG') )church_admin_debug(print_r( $classes,TRUE) );
			if(!in_array('all',$classes) )//only do if all not selected
			{
				if(defined('CA_DEBUG') )church_admin_debug("Not all classes");
                $cls=$wpdb->get_results('SELECT * FROM '.CA_CLA_TBL);
                if(defined('CA_DEBUG') )church_admin_debug(print_r( $cls,TRUE) );
				if(!empty( $cls) )
				{
					foreach( $cls AS $cl)
					{

						if(in_array(sanitize_title( $cl->name),$classes) )
						{
							$classesSQL[]='a.people_id=(SELECT c.people_id FROM '.CA_MET_TBL.' c WHERE  c.ID="'.(int)$cl->class_id.'" AND c.meta_type="class" AND c.people_id=a.people_id)';
							$filteredby[]=$cl->name;
						}
					}
				}
			}

		}//end classes

		//ministries
		if(!empty( $ministries)&&is_array( $ministries) )
		{
			if(!in_array('all',$ministries) )//only do if all not selected
			{
				$mins=$wpdb->get_results('SELECT * FROM '.CA_MIN_TBL);

				if(!empty( $mins) )
				{
					foreach( $mins AS $min)
					{
						if(in_array(sanitize_title( $min->ministry),$ministries) )
						{
							$ministriesSQL[]=' a.people_id=(SELECT people_id FROM '.CA_MET_TBL.' c, '.CA_MIN_TBL.' g WHERE  c.ID="'.(int)$min->ID.'" AND c.ID=g.ID AND c.meta_type="ministry" AND c.people_id=a.people_id)';
							$filteredby[]=$min->ministry;
						}
					}
				}
			}
		}//end smallgroups
		$other=$tbls='';
		 $group_by=' GROUP BY a.people_id ';
		$columns=array('a.pushToken','a.people_id','a.user_id','a.household_id','a.head_of_household','a.first_name','a.middle_name','a.prefix','a.last_name','a.people_type_id','a.member_type_id','a.email','a.mobile','a.e164cell','a.sex','b.phone','b.address','b.mailing_address','a.show_me','a.active','a.marital_status','a.date_of_birth','a.last_updated','b.last_updated AS householdUpdated','a.updated_by','a.gdpr_reason');
		$tables=array(CA_PEO_TBL.' a',CA_HOU_TBL.' b');
		$table_header=array(__('Edit','church-admin'),__('Delete','church-admin'),__('Activate','church-admin'),__('Name','church-admin'),__('People Type','church-admin'),__('Phone','church-admin'),__('Mobile','church-admin'),__('Email','church-admin'),__('Address','church-admin'),__('Site User','church-admin') );
		if(!empty( $email_sendSQL) )		$other.=' AND ('. implode(" OR ",$email_sendSQL).')';
		if(!empty( $photo_permissionSQL) )		$other.=' AND ('. implode(" OR ",$photo_permissionSQL).')';
		if(!empty( $activeSQL) )		$other.=' AND ('. implode(" OR ",$activeSQL).')';
        if(!empty( $phoneCallsSQL) )  $other.=' AND ('. implode(" OR ",$phoneCallsSQL).')';
        if(!empty( $addressesSQL) )		$other.=' AND ('. implode(" OR ",$addressesSQL).')';
		if(!empty( $emailSQL) )		$other.=' AND ('. implode(" OR ",$emailSQL).')';
		if(!empty( $mobileSQL) )		$other.=' AND ('. implode(" OR ",$mobileSQL).')';
		if(!empty( $userSQL) )		$other.=' AND ('. implode(" OR ",$userSQL).')';
		if(!empty( $gdprSQL) )			$other.=' AND '.$gdprSQL;
		if(!empty( $maritalSQL) )		$other.=' AND ('. implode(" OR ",$maritalSQL).')';
		if(!empty( $genderSQL) ) 		$other.=' AND ('. implode(" OR ",$genderSQL).')';
		if(!empty( $peopleSQL) ) 		$other.=' AND ('. implode(" OR ",$peopleSQL).')';
		if(!empty( $maritalSQL) ) 		$other.=' AND ('. implode(" OR ",$maritalSQL).')';
		if(!empty( $kidsworkSQL) )	$other.=' AND ('. implode(" OR ",$kidsworkSQL).')';
		if(!empty( $yearSQL) )		$other.=' AND ('. implode(" OR ",$yearSQL).')';
		if(!empty( $monthSQL) )		$other.=' AND ('. implode(" OR ",$monthSQL).')';
		if(!empty( $sitesSQL) ) 		{
										$other.=' AND ('. implode(" OR ",$sitesSQL).') AND a.site_id=d.site_id';
										$tables['d']=CA_SIT_TBL.' d';
										$columns[]='d.venue';
									}
		if(!empty( $smallgroupsSQL) ) 	{
										$other.=' AND ('. implode(" OR ",$smallgroupsSQL).') AND c.ID=e.id';
										$columns[]='e.group_name';
										$tables['c']=CA_MET_TBL.' c';
										$tables['e']=CA_SMG_TBL.' e';
									}
		if(!empty( $spiritual_giftsSQL) ) 	{
			$other.=' AND ('. implode(" OR ",$spiritual_giftsSQL).')';
			//$columns[]='e.group_name';
			$tables['c']=CA_MET_TBL.' c';
			//$tables['e']=CA_SMG_TBL.' e';
		}
        if(!empty( $classesSQL) ) 	{
										$other.=' AND ('. implode(" OR ",$classesSQL).') AND c.ID=i.class_id';
										$columns[]='i.name';
										$tables['c']=CA_MET_TBL.' c';
										$tables['i']=CA_CLA_TBL.' i';
									}
		if(!empty( $memberSQL) ) 		{
										$other.=' AND ('. implode(" OR ",$memberSQL).')';
										$columns[]='f.member_type';
										$tables['f']=CA_MTY_TBL.' f';
									}
		if(!empty( $ministriesSQL) ) 	{
										$other.=' AND ('. implode(" OR ",$ministriesSQL).')';
										$columns[]='g.ministry ';
										$tables['g']=CA_MIN_TBL.' g';
										$tables['c']=CA_MET_TBL.' c';
									}
		if(!empty( $customSQL) )
		{

										$other.=' AND ('. implode(" OR ", $customSQL).')';
										$columns[]='h.data ';
										$tables['h']=CA_CUST_MET_TBL.' h';
		}
        if( $type=='push')$other.=' AND a.pushToken!="" ';
        if( $type=='email')$other.=' AND a.email!="" AND a.email_send=1';
        if( $type=='sms')$other.=' AND a.mobile!="" AND a.sms_send=1';
		foreach( $tables AS $letter=>$table)$tbls.=', '.$table.' '.$letter;

		
		
		//handle exclude
		$premium=get_option('church_admin_payment_gateway');
		if(!empty($premium)){
			$excludeSQL='';
			$exclude = !empty($_POST['exclude'])?sanitize_text_field($_POST['exclude']):null;
			if(!empty($exclude)){
				church_admin_debug('Exclude: '.$exclude);
				$excludeArray=array();
				
				$people = church_admin_get_people_ids(stripslashes( $exclude ) );
				church_admin_debug($people);
				foreach( $people AS $key=>$people_id)
				{
					$excludeArray[]=' (a.people_id!="'.(int)$people_id.'") ';

				}
				if(!empty($excludeArray))
				{
					church_admin_debug($excludeArray);
					$excludeSQL.=' AND '.implode(' AND ',$excludeArray);
				}
				if(empty($excludeSQL)){
					church_admin_debug( 'ExcludeSQL is: '.$excludeSQL);
				}
			}
		}
		$sql='SELECT '.implode(", ",$columns).' FROM '.implode(", ",array_filter( $tables) ).' WHERE a.household_id=b.household_id '.$other.' '.$excludeSQL.' '.$group_by.' ORDER BY a.last_name,a.people_order';
		
		church_admin_debug('Filter sql function output....');
		church_admin_debug( $sql);
		
		return $sql;
	}
