<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
//Address Directory Functions
//2016-09-26 Added Nickname
//2020-08-07 added phone call privacy permission


/**
 * People Admin
 *
 * @param
 * @param
 *
 * @author andy_moyle
 *
 */
function church_admin_people_main()
{
    global $wpdb,$people_type;

	$allowed_html = array(
		'a' => array(
			'href' => array(),
			'title' => array(),
			'class' => array()
		),
		'br' => array(),
		'em' => array(),
		'strong' => array(),
	);


	$member_type=church_admin_member_type_array();
 	echo'<h1>'.esc_html( __(  'People', 'church-admin' ) ).'</h1>';
    

	 echo'<div class="notice notice-error">';
	 church_admin_gdpr_check();
	 echo'</div>';
	/*************************************************************
		 * 
		 * Check for app user address updates that need geolocating
		 * 
		 *************************************************************/
		$api_key=get_option('church_admin_google_api_key');
		if(!empty( $api_key) )
		{
			//only perform check if there is a Google api key
			$geocodeRequiredCount=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_HOU_TBL.' WHERE address!=", , , ," AND address!=", , ," AND address!="" AND (geocoded=0 OR lat="" OR lng="")');
			if(!empty( $geocodeRequiredCount) )
			{
							
				echo'<div class="notice inline notice-warning"><h3>'.esc_html( sprintf( _n('%s household needs its address geocoding','%s households need their addresses geocoding',$geocodeRequiredCount,'church-admin' ) , $geocodeRequiredCount ) ).'</h3><p><a class="button-primary" href="admin.php?page=church_admin%2Findex.php&action=bulk_geocode&section=people">'.esc_html( __( 'Update mapping now', 'church-admin' ) ).'</a></p></div>';
			}
		}
	require_once(plugin_dir_path(__FILE__).'/filter.php');
    church_admin_directory_filter(TRUE,FALSE);
	
	
}

function church_admin_export_csv()
{
    //CSV
	echo'<h1>'.esc_html( __( 'Download a CSV of people/ Mailing labels','church-admin') ).'</h1>';
	
	echo'<form action="" method="POST">';
	echo wp_nonce_field('people-csv','people-csv');
	require_once(plugin_dir_path(dirname(__FILE__) ).'/includes/filter.php');
	church_admin_directory_filter(FALSE,TRUE);
    echo'<br style="clear:left"/>';
	echo'<p><input type="radio" name="ca_download" checked="checked" value="people-csv"/>'.esc_html( __( 'CSV file','church-admin' ) ).'</p>';
	echo'<p><input type="radio" name="ca_download" value="mailinglabel"/>'.esc_html( __( 'Individual mailing labels','church-admin' ) ).'</p>';
    echo'<p><input type="radio" name="ca_download" value="householdlabel"/>'.esc_html( __( 'Household mailing labels','church-admin' ) ).'</p>';
	echo'<p><select name="addressType"><option value="street">'.esc_html( __( 'Use street address','church-admin' ) ).'</option><option value="mailing">'.esc_html( __( 'Prefer mailing address if it exists', 'church-admin' ) ).'</option></select></p>';
	echo'<p><input class="button-primary" type="submit" value="'.esc_html( __( 'Download','church-admin') ).'"/></p>';
	echo'</form>';
}


function church_admin_pdf_menu()
{
    echo'<h1>'.esc_html( __( 'PDF of address list','church-admin' ) ).'</h2>';
    echo'<form action="'.site_url().'" method="get">';
					wp_nonce_field('address-list','addresslist');
					echo '<table class="form-table"><tbody>';
					echo'<input type="hidden" name="ca_download"  value="addresslist-family-photos"/>';

					$member_type=church_admin_member_type_array();
					if(!empty( $member_type) )
					{

						foreach( $member_type AS $id=>$membertype)
				    {
							 echo '<tr><th scope="row">'.esc_html( $membertype ).'</th><td><input type="checkbox" name="member_type_id[]" checked="checked" value="'.(int)$id.'" /></td></tr>';
						}
					}
					echo'<tr><td colspan=2><input type="submit" class="button-primary" value="'.esc_html( __( 'Download','church-admin') ).'"/></td></tr></tbody></table></form>';
}


function church_admin_view_person( $people_id=NULL)
{

	global $wpdb;

	$data=$wpdb->get_row('SELECT *,first_name,middle_name,prefix,last_name FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
	if(!empty( $data) )
	{
		if(!empty( $data->attachment_id) )
		{//photo available

			echo wp_get_attachment_image( $data->attachment_id,'ca-people-thumb',NULL,array('class'=>'alignleft') );

		}//photo available
		$name=church_admin_formatted_name( $data );
		echo'<h2><a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_people&amp;people_id='.(int)$people_id,'edit_people').'">'.esc_html( $name).'</a></h2><br style="clear:left"/>';
		echo'<h3>'.esc_html( __( 'Contact Details','church-admin') ).'</h3>';
		echo'<table class="form-table">';
		if(!empty( $data->mobile) )echo'<tr><th scope="row">'.esc_html( __( 'Mobile','church-admin') ).'</th><td><a href="call:'.esc_html( $data->mobile ).'">'.esc_html( $data->mobile).'</a></td></tr>';
		if(!empty( $data->email) )echo'<tr><th scope="row">'.esc_html( __( 'Email','church-admin') ).'</th><td><a href="call:'.esc_html( $data->email ).'">'.esc_html( $data->email).'</a></td></tr>';
		if(!empty( $data->twitter) )echo'<tr><th scope="row">Twitter</th><td><a href="https://twitter.com/'.esc_html( $data->twitter).'">@'.esc_html( $data->twitter).'</a></td></tr>';
		if(!empty( $data->facebook) )echo'<tr><th scope="row">Facebook</th><td><a href="https://www.facebook.com/'.esc_html( $data->facebook).'">'.esc_html( $data->facebook).'</a></td></tr>';
		if(!empty( $data->instagram) )echo'<tr><th scope="row">Instagram</th><td><a href="https://www.instagram.com/'.esc_html( $data->instagram).'">'.esc_html( $data->instagram).'</a></td></tr>';
		echo'</table>';
		echo'<h3>'.esc_html( __( 'Church Metadata','church-admin') ).'</h3>';
		echo'<table class="form-table">';
		//site
		if(!empty( $data->site_id) )$site_details=$wpdb->get_var('SELECT venue FROM '.CA_SIT_TBL.' WHERE site_id="'.intval( $data->site_id).'"');
		if(!empty( $site_details) )echo'<tr><th scope="row">'.esc_html( __( 'Site attended','church-admin') ).'</th><td>'.esc_html( $site_details).'</td></tr>';
		//small groups
		$groupIDs=church_admin_get_people_meta( $people_id,'smallgroup');

		if(!empty( $groupIDs) )
		{
			foreach( $groupIDs AS $groupID)	$group[]=$wpdb->get_var('SELECT group_name FROM '.CA_SMG_TBL.' WHERE id="'.(int) $groupID.'"');
			if(!empty( $group) )echo'<tr><th scope="row">'.esc_html( __( 'Small group','church-admin') ).'</th><td>'.esc_html( implode( ", ", $group ) ).'</td></tr>';
		}
		//ministries
		$mins=array();//temp stor for person'sministries
		$ministries=church_admin_ministries();

		$person_ministries=$wpdb->get_results('SELECT ID FROM '.CA_MET_TBL.' WHERE people_id="'.(int)$people_id .'" AND meta_type="ministry"');

		if(!empty( $person_ministries) )
		{
			foreach( $person_ministries AS $person_ministry)$mins[]=$ministries[$person_ministry->ID];
			echo'<tr><th scope="row">'.esc_html( __( 'Ministries','church-admin') ).'</th><td>'.esc_html( implode(", ",$mins) ).'</td></tr>';
		}
		//hope team
		$hopeteamjobs=array();
		$hts=$wpdb->get_results('SELECT job,hope_team_id FROM '.CA_HOP_TBL);
		if(!empty( $hts) )
		{
			foreach( $hts AS $ht)  {$hopeteamjobs[$ht->hope_team_id]=$ht->job;}
		}
		$jobs=$wpdb->get_results('SELECT ID FROM '.CA_MET_TBL.' WHERE people_id="'.esc_sql( $people_id).'" AND meta_type="hope_team"');
		$person_jobs=array();
		if(!empty( $jobs) )
		{
			foreach( $jobs AS $job)$personjobs[]=$hopeteamjobs[$job->ID];
			echo'<tr><th scope="row">'.esc_html( __( 'Hope Teams','church-admin') ).'</th><td>'.esc_html(implode(", ",$personjobs) ).'</td></tr>';

		}
		echo'</table>';

		$others=$wpdb->get_results('SELECT *,CONCAT_WS(" ",first_name,prefix,last_name) AS name FROM '.CA_PEO_TBL.' WHERE household_id="'.intval( $data->household_id).'" AND people_id!="'.(int)$people_id.'" ORDER BY people_order ASC');
		if(!empty( $others) )
		{
			echo'<h3>'.esc_html( __( 'Others in household','church-admin') ).'</h3>';
			foreach( $others AS $other)
			{
				echo '<p><a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_people&amp;people_id='.intval( $other->people_id),'edit_people').'">'.esc_html( $other->name).'</a></p>';
			}
		}
		//notes
		require_once(plugin_dir_path(dirname(__FILE__) ).'includes/comments.php');
		if(!empty( $people_id) )church_admin_show_comments('people',	$people_id);

	}

}

function church_admin_view_directory()
{
    if(isset( $_POST['member_type_id'] ) )
    {
        church_admin_address_list( $_POST['member_type_id'] );
    }
    else
    {
        echo'<table class="form-table"><tbody><tr><th scope="row">'.esc_html( __( 'Select a directory to view','church-admin' ) ).'</th><td><form name="address" action="'.$church_admin_url.'&amp;action=view_directory" method="POST"><select name="member_type_id" >';
        echo '<option value="0">'.esc_html( __( 'All Member Types', 'church-admin' ) ).'</option>';
		foreach( $member_type AS $key=>$value)
		{
			$count=$wpdb->get_var('SELECT COUNT(people_id) FROM '.CA_PEO_TBL.' WHERE member_type_id="'.esc_sql( $key).'"');
			echo '<option value="'.esc_html( $key).'" >'.esc_html( $value).' ('.$count.' people)</option>';
		}
		echo'</select><input  class="button-primary"  type="submit" value="'.esc_html( __( 'Go','church-admin') ).'"/></form></td></tr></tbody></table>';
}
}

function church_admin_address_list( $member_type_id=0)
{
    if(!church_admin_level_check('Directory') )wp_die(esc_html( __( 'You don\'t have permissions to do that','church-admin') ) );
    global $wpdb;
    $wpdb->query('UPDATE '.CA_PEO_TBL.' SET head_of_household=0 WHERE head_of_household=NULL');
	$member_type=church_admin_member_type_array();
	$member_type[0]=esc_html( __( 'Complete','church-admin') );



    //grab address list in order
	$sql='SELECT DISTINCT household_id FROM '.CA_PEO_TBL;
    if(!empty( $member_type_id) )  {$sql.=' WHERE member_type_id="'.esc_sql( $member_type_id).'"';}

    $result = $wpdb->get_var( $sql);
    $items=$wpdb->num_rows;

    echo'<hr/><table class="form-table"><tbody><tr><th scope="row">'.esc_html( __( 'Select different address list to view','church-admin') ).'</th><td><form name="address" action="admin.php?page=church_admin/index.php&amp;action=church_admin_address_list&section=people" method="POST"><select name="member_type_id" >';
			    echo '<option value="0">'.esc_html( __( 'All Member Type...','church-admin') ).'</option>';
			    foreach( $member_type AS $key=>$value)
			    {
					$count=$wpdb->get_var('SELECT COUNT(people_id) FROM '.CA_PEO_TBL.' WHERE member_type_id="'.esc_sql( $key).'"');
					echo '<option value="'.esc_html( $key).'" >'.esc_html( $value).' ('.$count.' people)</option>';
			    }
			    echo'</select><input class="button-primary" type="submit" value="'.esc_html( __( 'Go','church-admin') ).'"/></form></td></tr></tbody></table>';
    // number of total rows in the database
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/pagination.class.php');
    if( $items > 0)
    {

	$p = new caPagination;
	$p->items( $items);
	$page_limit=get_option('church_admin_pagination_limit');
	if ( empty( $page_limit) )  {$page_limit=20;update_option('church_admin_pagination_limit',20);}
	$p->limit( $page_limit); // Limit entries per page

	$p->target("admin.php?page=church_admin/index.php&section=people&action=church_admin_address_list&section=people&amp;member_type_id=".$member_type_id);
	if(!isset( $p->paging) )$p->paging=1;
	if(!isset( $_GET[$p->paging] ) )$_GET[$p->paging]=1;
	$p->currentPage((int)$_GET[$p->paging] ); // Gets and validates the current page
	$p->calculate(); // Calculates what to show
	$p->parameterName('paging');
	$p->adjacents(1); //No. of page away from the current page
	if(!isset( $_GET['paging'] ) )
	{
	    $p->page = 1;
	}
	else
	{
	    $p->page = intval( $_GET['paging'] );
	}
        //Query for limit paging
	$limit = esc_sql("LIMIT " . ( $p->page - 1) * $p->limit  . ", " . $p->limit);


    //prepare WHERE clause using given Member_type_id
	$sort='last_name ASC';
	if(!empty( $_GET['sort'] ) )
	{
		switch( $_GET['sort'] )
		{
			case'date' :$sort='last_updated DESC';break;
			case'last_name':$sort='last_name ASC';break;
			default:$sort='last_name ASC';break;
		}
	}
    $sql='SELECT * FROM '.CA_PEO_TBL ;
    if(!empty( $member_type_id) )$sql.=' WHERE member_type_id="'.esc_sql( $member_type_id).'"';
    $sql.=' GROUP BY household_id ORDER BY '.$sort.' '.$limit;

    $results=$wpdb->get_results( $sql);

    if(!empty( $results) )
    {
		if ( empty( $member_type[$member_type_id] ) )$member_type[$member_type_id]=esc_html( __( 'Whole','church-admin') );
		echo '<h2>'.esc_html(sprintf( __( '%1$s address list','church-admin'),$member_type[$member_type_id] ) ).'</h2>';
	 	echo'<p><span class="ca-private">'.esc_html( __( 'Households not shown publicly have an orange background','church-admin') ).' </span></p>';
		// Pagination
    	echo '<div class="tablenav"><div class="tablenav-pages">';
    	echo $p->show();
    	echo '</div></div>';
    	//Pagination
    	//grab address details and associate people and put in table
		$theader='<tr><th>'.esc_html( __( 'Delete','church-admin') ).'</th><th>'.esc_html( __( 'Display household','church-admin') ).'</th><th><a href="admin.php?page=church_admin/index.php&action=church_admin_address_list&section=people&member_type_id='.intval( $member_type_id).'&sort=last_name">'.esc_html( __( 'Last name','church-admin') ).'</a></th><th>'.esc_html( __( 'First Name(s)','church-admin') ).'</th><th>'.esc_html( __( 'Address','church-admin') ).'<a></th><th><a href="admin.php?page=church_admin/index.php&action=church_admin_address_list&section=people&member_type_id='.intval( $member_type_id).'&sort=date">'.esc_html( __( 'Household last update','church-admin') ).'</th></tr>';
		echo '<table class="widefat striped"><thead>'.$theader.'</thead><tbody>';
		foreach( $results AS $row)
		{
	    	$first=1;//in case head of household not set
			$firstPeopleID=0;//in case head of household not set
			$firstLastName='';//in case head of household not set
	    	//grab address
	    	$add_row=$wpdb->get_row('SELECT * FROM '.CA_HOU_TBL.' WHERE household_id="'.esc_sql( $row->household_id).'"');
            //church_admin_debug(print_r( $add_row,TRUE) );
	     	//grab people
	    	$people_results=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE household_id="'.esc_sql( $row->household_id).'" ORDER BY people_order,people_type_id ASC,sex DESC');
	    	$adults=$children=array();
	    	$prefix='';
			$private='';
			$head=0;

			$class=array();
			if(!empty( $add_row->privacy) )$class[]='ca-private';

	    	foreach( $people_results AS $people)
	    	{
				//setting head of household recover variables if needed later...
				if( $first==1)  {$firstPeopleID=$people->people_id; $firstLastName=$people->last_name;}
				$first++;
				if ( empty( $people->active) )$class[]='ca-deactivated';
				if ( $people->head_of_household==1)
				{
					$head=1;
					$last_name='';
					if(!empty( $people->prefix) )$last_name.=$people->prefix.' ';
					$last_name.=$people->last_name;
				}
				if ( empty( $last_name) )$last_name=esc_html( __( 'Add Surname','church-admin') );
				if ( empty( $people->first_name) )$people->first_name=esc_html( __( 'Add Firstname','church-admin') );
				if( $people->people_type_id=='1')  {$adults[]='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&section=people&action=edit_people&amp;household_id='.(int)$row->household_id.'&amp;people_id='.(int)$people->people_id,'edit_people').'">'.esc_html( $people->first_name).'</a>';}else{$children[]='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_people&section=people&household_id='.(int)$row->household_id.'&amp;people_id='.(int)$people->people_id,'edit_people').'">'.esc_html( $people->first_name).'</a>' ;}
				if(!empty( $people->prefix) )  {$prefix=$people->prefix.' ';}else{$prefix='';}
	    	}
	    	//check if there were anyone as head of household
	    	if( $head==0)
	    	{

	    		//no head of household set so make first named person in household the head
	    		$wpdb->query('UPDATE '.CA_PEO_TBL.' SET head_of_household=1 WHERE people_id="'.intval( $firstPeopleID).'"');
	    		$last_name=esc_html( $firstLastName);
	    	}
	    	if(!empty( $adults) )  {$adult=implode(" & ",$adults);}else{ $adult=esc_html( __( "Add Name",'church-admin') );}
	    	if(!empty( $children) )  {$kids=' ('.implode(", ",$children).')';}else{$kids='';}

	    	$delete='<a onclick="return confirm(\''.esc_html( __( 'Are you sure?','church-admin') ).'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&section=people&action=delete_household&household_id='.$row->household_id.'&amp;member_type_id='.(int)$member_type_id,'delete_household').'">'.esc_html( __( 'Delete','church-admin') ).'</a>';
	    	//if ( empty( $add_row->address) )$add_row->address=esc_html( __( 'Add Address','church-admin') );
	    	if(!empty( $class) )  {$classes=' class="'.implode(" ",$class).'"';}else$classes='';
	   		echo '<tr '.$classes.' id="'.(int)$row->household_id.'"><td>'.$delete.'</td><td><a  href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=display_household&section=people&household_id='.$row->household_id,'display_household').'">'.esc_html( __( 'Display household','church-admin') ).'</a></td><td><a  href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=display_household&section=people&household_id='.$row->household_id,'display_household').'">'.esc_html( $prefix.$last_name).'</a></td><td>'.$adult.' '.$kids.'</td><td>';
				//changed to direct edit link 2018-04-09
	   		echo '<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_household&amp;household_id='.$row->household_id,'edit_household').'">';
	   		if(!empty( $add_row->address) )  {echo esc_html( $add_row->address);}else{echo esc_html( __( 'Add Address','church-admin') );}
            $updated_by='';
            if(!empty( $add_row->updated_by) )
            {
                $updated_by=$wpdb->get_var('SELECT CONCAT_WS(" ",first_name, last_name) FROM '.CA_PEO_TBL.' WHERE user_id="'.intval( $add_row->updated_by).'"');
            }
            
			echo'</a></td><td>'.mysql2date('d/M/Y',$add_row->last_updated).'<br />'.$updated_by.'</td></tr>';
		}


		echo '</tbody><tfoot>'.$theader.'</tfoot></table>';
    	echo '<div class="tablenav"><div class="tablenav-pages">';
    	// Pagination
    	echo '<div class="tablenav"><div class="tablenav-pages">';
    	echo $p->show();
    	echo '</div></div>';
		//echo'<script></script>';
    	//Pagination

    }//end of items>0
    else{echo'<p>'.esc_html( __( 'There are no people in that member type category','church-admin') ).'</p>';}
    }	else{echo'<p>'.esc_html( __( 'There are no people in that member type category','church-admin') ).'</p>';}




}
 /**
 *
 * Edit Household
 *
 * @author  Andy Moyle
 * @param    $household_id
 * @return   html
 * @version  0.1
 *
 */
function church_admin_edit_household( $household_id=NULL)
{

    global $wpdb,$church_admin_version;
	$member_type=church_admin_member_type_array();
    if(is_user_logged_in() )$user=wp_get_current_user();
    


    $member_type_id=$wpdb->get_var('SELECT member_type_id FROM '.CA_PEO_TBL.' WHERE household_id="'.esc_sql( $household_id).'"  ORDER BY people_type_id ASC LIMIT 1');
    if(!empty( $household_id) )  {$data=$wpdb->get_row('SELECT * FROM '.CA_HOU_TBL.' WHERE household_id="'.esc_sql( $household_id).'"');}else{$data=new stdClass();}
    if(!empty( $_POST['edit_household'] ) )
    {//process form
		$private=NULL;
		if(!empty( $_POST['show_me'] ) )  {$private=0;}else{$private=1;}
		$form=array();
		foreach ( $_POST AS $key=>$value)$sql[$key]=esc_sql(sanitize_text_field(stripslashes( $value) ));
		if(!$household_id)$household_id=$wpdb->get_var('SELECT household_id FROM '.CA_HOU_TBL.' WHERE address="'.$sql['address'].'" AND mailing_address="'.$sql['mailing_address'].'" AND lat="'.$sql['lat'].'" AND lng="'.$sql['lng'].'" AND phone="'.$sql['phone'].'"');
		if(!$household_id)
		{//insert
	    	$success=$wpdb->query('INSERT INTO '.CA_HOU_TBL.' (address,lat,lng,mailing_address,phone,privacy,attachment_id) VALUES("'.$sql['address'].'", "'.$sql['lat'].'","'.$sql['lng'].'","'.$sql['mailing_address'].'","'.$sql['phone'].'","'.$private.'","'.$sql['household_attachment_id'].'" )');
	    $household_id=$wpdb->insert_id;
		}//end insert
		else
		{//update
	   	 	$sql='UPDATE '.CA_HOU_TBL.' SET address="'.$sql['address'].'" , lat="'.$sql['lat'].'" , lng="'.$sql['lng'].'",mailing_address="'.$sql['mailing_address'].'" , phone="'.$sql['phone'].'", privacy="'.$private.'" , attachment_id="'.$sql['household_attachment_id'].'" WHERE household_id="'.(int)$household_id.'"';
	   	 //echo $sql;
	   		$success=$wpdb->query( $sql);
		}//update
        if(!empty( $user->ID) )$wpdb->query('UPDATE '.CA_HOU_TBL.' SET updated_by="'.(int)$user->ID.'" WHERE household_id="'.(int)$household_id.'"');
		if( $success)
		{
	    	echo '<div class="notice notice-success inline"><p><strong>'.esc_html( __( 'Address saved','church-admin') ).' <br /><a href="./admin.php?page=church_admin/index.php&section=people&action=church_admin_address_list&member_type_id='.$member_type_id.'">'.esc_html( __( 'Back to Directory','church-admin') ).'</a></strong></td></tr></div>';
		}
	    echo'<div id="post-body" class="metabox-holder columns-2"><!-- meta box containers here -->';

		echo'<div class="notice notice-success inline"><p><strong>'.esc_html( __( 'Household Edited','church-admin') ).' <br />';
		if(church_admin_level_check('Directory') ) echo'<a href="./admin.php?page=church_admin/index.php&section=people&action=church_admin_address_list&member_type_id='.$member_type_id.'">'.esc_html( __( 'Back to Directory','church-admin') ).'</a>';
		echo'</strong></td></tr></div>';
        update_option('addressUpdated',time() );
		church_admin_head_of_household_tidy( $household_id);
		church_admin_new_household_display( $household_id);


    }//end process form
    else
    {//household form
		if(!empty( $household_id) )  {$text='Edit ';}else{$text='Add ';}
		echo '<form action="" method="post">';
		//clean out old style address data
		if(!empty( $data->address)&&is_array(maybe_unserialize( $data->address) ))
		{
			$data->address=implode(", ",array_filter(maybe_unserialize( $data->address) ));
		}
		echo church_admin_address_form( $data,$error=NULL);
		//Phone
    	echo '<table class="form-table"><tr><th scope="row">'.esc_html( __( 'Phone','church-admin') ).'</th><td><input type="text" name="phone" ';
		if(!empty( $data->phone) ) echo ' value="'.esc_html( $data->phone).'"';
    	if(!empty( $errors['phone'] ) )echo' class="red" ';
    	echo '/></td></tr>';
        //Default to private
        $privacy=1;
        if(isset( $data->privacy)&&$data->privacy==0)$privacy=0;
    	
		echo'<tr><th scope="row">'.esc_html( __( 'Show household on the password protected address list','church-admin') ).'</th><td><input type="checkbox" name="show_me" value="1" '.checked(0,$privacy,FALSE).'/></td></tr>';

		echo'<tr><td colspan="2"><input type="hidden" name="edit_household" value="yes"/><input class="button-primary" type="submit" value="'.esc_html( __( 'Save Address','church-admin') ).'&raquo;" /></th></tr></table></form>';
    }//end household form


}



 /**
 *
 * Edit a person
 *
 * @author  Andy Moyle
 * @param    $people_id,$household_id
 * @return
 * @version  0.2
 *
 * 0.11 added photo upload 2012-02-24
 * 0.2 added site_id, marital status 2016-05-12
 *
 */


function church_admin_edit_people( $people_id=NULL,$household_id=NULL)
{


    global $wpdb,$people_type,$ministries,$current_user;
	$member_type=church_admin_member_type_array();
	$ministries=church_admin_ministries();
	$church_admin_marital_status=get_option('church_admin_marital_status');
	if ( empty( $church_admin_marital_status) )
	{
		$church_admin_marital_status=array(0=>esc_html( __( 'N/A','church-admin') ),
		1=>esc_html( __( 'Single','church-admin') ),
		2=>esc_html( __( 'Co-habiting','church-admin') ),
		3=>esc_html( __( 'Married','church-admin') ),
		4=>esc_html( __( 'Divorced','church-admin') ),
		5=>esc_html( __( 'Widowed','church-admin') )
		)	;
		update_option('church_admin_marital_status',$church_admin_marital_status);
	}
  	


    echo'<h2>'.esc_html( __( 'Edit Person','church-admin') ).'</h2>';
	$hopeteamjobs=array();
		$hts=$wpdb->get_results('SELECT job,hope_team_id FROM '.CA_HOP_TBL);
		if(!empty( $hts) )
		{

			foreach( $hts AS $ht)  {$hopeteamjobs[$ht->hope_team_id]=$ht->job;}
		}


    if( $people_id)$data=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.esc_sql( $people_id).'"');
		if ( empty( $data) ) $data = new stdClass();

    if(!empty( $data->household_id) )$household_id=$data->household_id;
    if(!empty( $_POST['edit_people'] ) )
    {//process


    	if ( empty( $household_id) )
		{
			$wpdb->query('INSERT INTO '.CA_HOU_TBL.' (lat,lng) VALUES("52.000","0.000")');
			$household_id=$wpdb->insert_id;
		}



    	$output=church_admin_save_person(1,$people_id,$household_id);
        update_option('addressUpdated',time() );

		//new small group
		if(!empty( $_POST['group_name'] ) )
		{
			$check=$wpdb->get_row('SELECT * FROM '.CA_SMG_TBL.' WHERE group_name="'.$sql['group_name'].'" AND whenwhere="'.$sql['when'].'" AND address="'.$sql['where'].'"');

			if(!empty( $check) )
			{//update
				$ldrs=esc_sql(serialize(array(1=>$people_id) ));
				$query='UPDATE '.CA_SMG_TBL.' SET leadership="'.$ldrs.'",group_name="'.$sql['group_name'].'",whenwhere="'.$sql['when'].'" AND address="'.$sql['where'].'" WHERE id="'.esc_sql( $check->id).'"';
				$wpdb->query( $query);
				$sg_id=$check->id;
			}//end update
			else
			{//insert
				$leaders=esc_sql(maybe_serialize(array(1=>array(1=>$people_id) )) );
				$query='INSERT INTO  '.CA_SMG_TBL.' (group_name,leadership,whenwhere,address) VALUES("'.$sql['group_name'].'","'.$leaders.'","'.$sql['when'].'","'.$sql['where'].'")';
				$wpdb->query( $query);
				$sg_id=$wpdb->insert_id;
			}//insert
			church_admin_update_people_meta( $sg_id,$people_id,'smallgroup');
		}


		church_admin_head_of_household_tidy( $household_id);
		echo'<div class="notice notice-success inline"><p><strong>'.esc_html( __( 'Person Edited','church-admin') ).' <br />'.$output['output'];
		if(church_admin_level_check('Directory') &&!empty( $sql['member_type_id'] ) ) echo'<a href="./admin.php?page=church_admin/index.php&amp;action=church_admin_address_list&section=people&amp;member_type_id='.$sql['member_type_id'].'">'.esc_html( __( 'Back to Directory','church-admin') ).'</a>';
		echo'</strong></td></tr></div>';
		church_admin_search_form();
		church_admin_new_household_display( $household_id);

        update_option('addressUpdated',time() );//for the app

    }//end process
    else
    {//form
		if( $people_id)$data=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.esc_sql( $people_id).'"');

		echo'<form action="" method="POST" enctype="multipart/form-data">';

		echo church_admin_edit_people_form(1,$data,NULL);
		if(!empty( $data->user_id ) )
		{
			echo'<table class="form-table"><tr><th scope="row">'.esc_html( __( 'Wordpress User','church-admin') ).'</th><td><input type="hidden" name="ID" value="'.esc_html( $data->user_id).'"/>';
			$user_info=get_userdata( $data->user_id);
			if(!empty( $user_info) )
			{
				echo '<span class="username">'.esc_html( __( 'Username','church-admin') ).': '.$user_info->user_login.'<span class="unattach_user"><span class="dashicons dashicons-no"></span></span><br />'.esc_html( __( 'User level','church-admin') ).': '.$user_info->roles['0'].'</span>';

			$nonce = wp_create_nonce("church_admin_unattach_user");
			echo'<script >jQuery(document).ready(function( $) {
			$(".unattach_user").click(function() {
			var data = {
			"action": "church_admin",
			"method": "unattach_user",
			"people_id": '.intval( $data->people_id).',
			"user_id": '.intval( $data->user_id).',
			"nonce": "'.$nonce.'"
		};

		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
		jQuery.post(ajaxurl, data, function(response) {console.log(response);
			$(".username").html("'.esc_html( __( 'User disconnected - refresh page to reconnect to a user account','church-admin') ).'");
		});

			});
			});</script>';

			}
			echo'</td></tr></table>';
		}
		else
		{
            echo'<table class="form-table">';
			echo church_admin_username_form();
            echo'</table>';
		}



		echo'<table class=form-table"><tr><th scope="row"><input type="hidden" name="edit_people" value="yes"/><input class="button-primary" type="submit" value="'.esc_html( __( 'Save Details','church-admin') ).'&raquo;" /></td></tr></tbody></table></form>';
    }//form
    require_once(plugin_dir_path(dirname(__FILE__) ).'includes/comments.php');
	if(!empty( $people_id) )church_admin_show_comments('people',	$people_id);

}
 
 
 /**
 *
 * Table row for username entry
 *
 * @author  Andy Moyle
 * @param
 * @return   html
 * @version  0.1
 *
 */
function church_admin_username_form()
{
	if(!church_admin_level_check('Directory') )wp_die(esc_html( __( 'You don\'t have permissions to do that','church-admin') ) );
	global $wpdb;
			$sql='SELECT user_login,ID FROM '.$wpdb->prefix.'users WHERE `ID` NOT IN (SELECT user_id FROM '.CA_PEO_TBL.' WHERE user_id!=0) ORDER BY user_login';
			$users=$wpdb->get_results( $sql);
			$out='';
			if(!empty( $users) )
			{
					$out.='<tr><th scope="row">'.esc_html( __( 'Choose a Wordpress account to associate','church-admin') ).'</th><td><select name="ID"><option value="">'.esc_html( __( 'Select a user...','church-admin') ).'</option>';
					foreach( $users AS $user) $out.='<option value="'.esc_html( $user->ID).'">'.esc_html( $user->user_login).'</option>';
					$out.='</select></td></tr>';
			}
			$out.='<tr><th scope="row">'.esc_html( __( 'Or create a new Wordpress User','church-admin') ).'</th><td><input id="username" type="text" placeholder="'.esc_html( __( 'Username','church-admin') ).'" name="username" value=""/><span id="user-result"></span></td></tr>'."\r\n";
			$nonce = wp_create_nonce("church_admin_username_check");
			$out.='<script >jQuery(document).ready(function( $) {
			$("#username").change(function() {
			var username=$("#username").val();
			var data = {
			"action": "church_admin",
			"method":"username_check",
			"username": username,
			"nonce": "'.$nonce.'"
		};

		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
		jQuery.post(ajaxurl, data, function(response) {console.log(response);
			$("#user-result").html(response);
		});

			});
			});</script>';
	return $out;
}
 
 
 


 /**
 *
 * Address form
 *
 * @author  Andy Moyle
 * @param    $data, $error
 * @return   html
 * @version  0.1
 *
 */
function church_admin_address_form( $data,$error)
{
    global $wpdb;
	$method='update-directory';
	$ID=!empty($data->household_id)?(int)$data->household_id:null;
	if(empty($ID))
	{
		//probably small group, so check that one
		$ID=!empty($data->id)?(int)$data->id:null;
		$method='update-sg';
	}
	if(empty($ID))
	{
		//probably site id
		$ID=!empty($data->site_id)?(int)$data->site_id:null;
		$method='update-site';
	}
    //echos form contents where $data is object of address data and $error is array of errors if applicable
	$api=get_option('church_admin_google_api_key');
    if ( empty( $data) )$data=(object)'';
    if(!empty( $_GET['action'] )&&$_GET['action']=="edit_site")  {$out='<h3>'.esc_html( __( 'Edit Site Details','church-admin') ).'</h3>';}else{$out='<h3>'.esc_html( __( 'Edit Household Details','church-admin') ).'</h3>';}
    if(!empty( $errors) )$out.='<p>'.esc_html( __( 'There were some errors marked in red','church-admin') ).'</p>';
	if(!empty( $api) )
	{
		$out.='<script >var ca_method="update-directory";'."\r\n";
            if(!empty( $data->lat) && !empty( $data->lat) )
            {//initial data for position already available
                
				$out.='var zoom=17;'."\r\n";
				$out.='var ID='.(int)$ID."\r\n";
				$out.='var nonce="'.wp_create_nonce("update-directory").'"'."\r\n";
				$out.='var beginLat='.esc_html( $data->lat).';'."\r\n";
                $out.= 'var beginLng='.esc_html( $data->lng)."\r\n";
				$out.= 'var ca_method="'.esc_html( $method).'"'."\r\n";
				$out.='var what="geocode"'."\r\n";
               
            }else
            {
                $out.='var zoom=17;'."\r\n";
				$out.='var ID='.(int)$ID."\r\n";
				$out.='var nonce="'.wp_create_nonce("update-directory").'"'."\r\n";
				$out.='var beginLat=0;'."\r\n";
                $out.= 'var beginLng=0;'."\r\n";
				$out.= 'var ca_method="'.esc_html( $method).'"'."\r\n";
				$out.='var what="geocode"'."\r\n";
            }
			$out.="\r\n".'</script>';
	}
   	/*************************************
	*
	*	Image
	*
	*************************************/

		$out.='<h3>'.esc_html( __( 'Photo','church-admin') ).'</h3><div class="church-admin-form-group"><label>';
		if(!empty( $data->attachment_id) )
		{
			$out.=wp_get_attachment_image( $data->attachment_id,'medium','', array('class'=>"current-photo",'id'=>"household-frontend-image") );

		}
		else
		{
			$out.= '<img src="'.plugins_url('/images/default-avatar.jpg',dirname(__FILE__) ).'" width="300" height="200" id="household-frontend-image"  alt="'.esc_html( __( 'Photo of Person','church-admin') ).'"  />';
		}
        $out.='</label>';
		if(is_admin() )
		{//on admin page so use media library
			$out.='<button id="household-image"  class=" button-secondary household-upload-button button" >'.esc_html( __( 'Upload Image','church-admin') ).'</button>';

		}else
		{//on front end so use boring update
			$out.='<input type="file" id="file-chooser" class="file-chooser" name="logo" style="display:none;"/><input type="button" id="household_image" class="household-frontend-button" value="'.esc_html( __( 'Upload Photo','church-admin') ).'" />';
    	}
	    $out.='<input type="hidden" name="household_attachment_id" class="attachment_id" id="household_attachment_id" ';
    	if(!empty( $data->attachment_id) )$out.=' value="'.intval( $data->attachment_id).'" ';
    	$out.='/><span id="household-upload-message"></span>';
    	$out.='</div>';


    $out.= '<div class="church-admin-form-group"><label>'.esc_html( __( 'Street Address','church-admin') ).'</label><input  type="text" id="address" name="address" ';
    if(!empty( $data->address) ) $out.=' value="'.esc_html( $data->address).'" ';
	$out.=' class="church-admin-form-control ';
    if(!empty( $error['address'] ) ) $out.= 'red';
    $out.= '"/></div>';
	$api_key=get_option('church_admin_google_api_key');
    if(!empty( $api_key) )
	{
		if(!isset( $data->lng) )$data->lng='51.50351129583287';
    	if(!isset( $data->lat) )$data->lat='-0.148193359375';
    	$out.= '<div class="church-admin-form-group"><label><button id="geocode_address" class="button-primary btn btn-info">'.esc_html( __( 'Update map','church-admin') ).'</button></label><span id="finalise" ></span><input type="hidden" name="what-three-words" id="what-three-words" name="what-three-words"/><input type="hidden" name="lat" id="lat" value="'.$data->lat.'"/><input type="hidden" name="lng" id="lng" value="'.$data->lng.'"/><div id="map" style="width:500px;height:300px;margin-bottom:20px"></div></div>';
	}
	
	//check for what three words
	$w3w=get_option('church_admin_what_three_words');
	$w3wLanguage=get_option('church_admin_what_three_words_language');
	if(empty($w3wLanguage)){
		$w3wLanguage='en';
	}
	if(isset( $w3w) )
	{
		$out.='<script>'."\r\n";
		$out.='const useW3W=true;'."\r\n";
		$out.='const w3wLanguage="'.esc_html( $w3wLanguage).'";'."\r\n";
		
		$out.='</script>'."\r\n";
	}
	
   		if(is_admin() )
   		{
   			$out.='<script >jQuery(document).ready(function( $)  {


		 	//remove image
		 	$(".remove-image").click(function()
		 	{
		 			var type= $(this).data("type");
		 			var attachment_id=$(this).data("attachment_id");
		 			var id=$(this).data("id");

		 			var nonce="'.wp_create_nonce("remove-image").'";
		 			var data={"action":"church_admin","method":"remove-image","type":type,"attachment_id":attachment_id,"id":id,"nonce":nonce};
		 			console.log(data);
		 			$.ajax({
		 								url: ajaxurl,
		 								type: "POST",
		 								data: data,
		 								success: function(res) {
		 									console.log(res);
		 									$("#upload-message").html("'.esc_html( __( "Image Deleted","church-admin") ).'<br />");
		 									$("#household-frontend-image").attr("src","'.plugins_url('/images/default-avatar.jpg',dirname(__FILE__) ).'");
		 									$("#household-frontend-image").attr("srcset","");
		 									$("#attachment_id").val("");
		 								},
		 								error: function(res) {
		 							$("#upload-message").html("Error deleting<br />");
		 								}
		 						 });
		 	});

  var mediaUploader;

  $(".household-upload-button").click(function(e) {
    e.preventDefault();
    var id="#household_attachment_id";
    console.log(id);
    // If the uploader object has already been created, reopen the dialog
      if (mediaUploader) {
      mediaUploader.open();
      return;
    }
    // Extend the wp.media object
    mediaUploader = wp.media.frames.file_frame = wp.media({
      title: "Choose Image",
      button: {
      text: "Choose Image"
    }, multiple: false });

    // When a file is selected, grab the URL and set it as the text fields value
    mediaUploader.on("select", function() {
      var attachment = mediaUploader.state().get("selection").first().toJSON();
      console.log(attachment);
      $(id).val(attachment.id);
      if(attachment.sizes.medium.url)
      {
        $("#household-frontend-image").attr("src",attachment.sizes.medium.url);
      }
      else{$("#household-frontend-image").attr("src",attachment.sizes.thumbnail.url);}
      $("#household-frontend-image").attr("srcset",null);
    });
    // Open the uploader dialog
    mediaUploader.open();
  });

	});</script>';

    }else
    {
   $out.='<script>
	jQuery(document).ready(function( $) {
	$(".household-frontend-button").click(function()  { $("#file-chooser").trigger("click"); });
	$( "body" ).on("change","#file-chooser", function( event ) {


	$("#household-frontend-image").attr("src","'.admin_url().'/images/wpspin_light-2x.gif");
	$("#household-frontend-image").attr("srcset","");
	var data = new FormData();
	jQuery.each(jQuery("#file-chooser")[0].files, function(i, file) {
    data.append("file-"+i, file);
	});
	$.ajax({
        		url: "'.admin_url().'admin-ajax.php?action=church_admin_image_upload",
        		type: "POST",
        		data: data,
        		processData: false,
        		contentType: false,
        		success: function(res) {
        		var image=JSON.parse(res);
        		console.log(image);

        			$("#household-upload-message").html("'.esc_html( __( 'Success uploading', 'church-admin' ) ).'<br />");
        			$("#household-frontend-image").attr("src",image.src);
        			$("#household-frontend-image").attr("srcset","");
        			$("#household_attachment_id").val(image.attachment_id);
        		},
        		error: function(res) {
					$("#upload-message").html("'.esc_html( __( "Error uploading, please try again", 'church-admin' ) ).'<br />");
         		}
         });
    });

	});
	</script>';

	}
	$out.= '<div class="church-admin-form-group"><label>'.esc_html( __( 'Mailing Address','church-admin') ).'</label><input  type="text" id="mailing_address" name="mailing_address" ';
    if(!empty( $data->mailing_address) ) $out.=' value="'.esc_html( $data->mailing_address).'" ';
	$out.=' class="church-admin-form-control ';
    if(!empty( $error['mailing_address'] ) ) $out.= 'red';
    $out.= '"/></div>';

	//household custom fields
    $custom_fields=church_admin_get_custom_fields();
    if(!empty( $custom_fields) )
    {
		foreach( $custom_fields AS $id=>$field)
		{
            if( $field['section']!='household')continue;
			$dataField='';
			if(!empty( $address->household_id) )$dataField=$wpdb->get_var('SELECT data FROM '.CA_CUST_MET_TBL .' WHERE household_id="'.(int)$address->household_id.'" AND custom_id="'.(int)$id.'"');
			$out.='<div class="church-admin-form-group"><label >'.esc_html( $field['name'] ).'</label>';
			switch( $field['type'] )
			{
				case 'boolean':
					$out.='<input type="radio" name="custom-'.(int)$id.'" data-name="custom-'.(int)$id.'" class="church-admin-form-control"  value="1" name="custom-'.(int)$id.'" ';
					if (isset( $dataField)&&$dataField==1)
						$out.= 'checked="checked" ';
					$out.='>'.esc_html( __( 'Yes','church-admin') ).'<br /> <input type="radio" name="custom-'.(int)$id.'" data-name="custom-'.(int)$id.'" class="church-admin-form-control" value="0" name="custom-'.(int)$id.'" ';
					if (isset( $dataField)&& $dataField==0)
						$out.= 'checked="checked" ';
					$out.='>'.esc_html( __( 'No','church-admin') );
					break;
				case'text':
					$out.='<input type="text" data-name="custom-'.(int)$id.'" class="church-admin-form-control"  name="custom-'.(int)$id.'" ';
					if(!empty( $dataField)||isset( $field['default'] ) )$out.=' value="'.esc_html( $dataField).'"';
					$out.='/>';
				break;
				case'date':
					$out.= church_admin_date_picker( $dataField,'custom-'.(int)$id,FALSE,1910,date('Y'),'custom-'.(int)$id,'custom-'.(int)$id);

				break;
			}
			$out.='</div>';

		}
    }
    return $out;

}
 /**
 *
 * Display household
 *
 * @author  Andy Moyle
 * @param    $household_id
 * @return   html
 * @version  0.1
 *
 */
function church_admin_new_display_person( $people_id)
{
    global $wpdb;
    $person_template='<div class="ca-person">
    <div class="ca-name">
        <div class="first_name"><!--first_name--></div><div class="prefix"><!--prefix--></div><div class="last_name"><!--last_name--></div>
    </div>
    <div class="ca=picture"><!--picture--></div>
    <div class="ca-email"><span class="dashicons dashicons-email-alt"></span><!--email--></div>
    <div class="ca-cell"><span class="dashicons dashicons-smartphone"></span><!--cell--></div>
    <div class="ca-dob"><span class="dashicons dashicons-buddicons-community"></span><!--dob--></div>
    <div class="ca-pt"><span class="dashicons dashicons-admin-users"></span><!--member_type-->
    <div class="ca-mt"><span class="dashicons dashicons-businessperson"></span><!--member_type--></div>
    <div class="ca-group"><!--groups--></div>
    <div class="ca-classes><span class="dashicons dashicons-welcome-learn-more"></span><!--classes--></div>
    <div class="ca-att"><span class="dashicons dashicons-chart-line"></span><!--attendance--></div>
    <div class="ca-giving"><span class="dashicons dashicons-money-alt"></span><!--giving--></div>
    </div>';
    $person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
    $output=$person_template;
    $output=str_replace("<!--first_name-->",esc_html( $person->first_name),$output);
    if(!empty( $person->prefix) )$output=str_replace("<!--prefix-->",esc_html( $person->prefix),$output);
    $output=str_replace("<!--last_name-->",esc_html( $person->last_name),$output);
    $output=str_replace("<!--email-->",esc_html( $person->last_name),$output);
}

function church_admin_migrate_users()
{
    global $wpdb;
    $results=$wpdb->get_results('SELECT ID FROM '.$wpdb->users);
    if( $results)
    {
	foreach( $results AS $row)
	{
	    $check=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE user_id="'.esc_sql( $row->ID).'"');
	    if(!$check)
	    {
		$user_info=get_userdata( $row->ID);
		$address='';
		$wpdb->query('INSERT INTO '.CA_HOU_TBL.'(member_type_id,address)VALUES("1","'.$address.'")');
		$household_id=$wpdb->insert_id;
		$wpdb->query('INSERT INTO '.CA_PEO_TBL.' (first_name,last_name,email,household_id,user_id,member_type_id,people_type_id,smallgroup_id,sex) VALUES("'.$user_info->first_name.'","'.$user_info->last_name.'","'.$user_info->user_email.'","'.$household_id.'","'.$row->ID.'","1","1","0","1")');
	    }
	}

	echo'<div class="notice notice-success inline"><p><strong>'.esc_html( __( 'Wordpress Users migrated','church-admin') ).'</strong></td></tr></div>';
    }

    church_admin_address_list();
}
 /**
 *
 * Move person
 *
 * @author  Andy Moyle
 * @param    $people_id
 * @return   html
 * @version  0.1
 *
 */
function church_admin_move_person( $people_id)
{
    global $wpdb;
        $data=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.esc_sql( $people_id).'"');
    $message='';
    if(!empty( $data) )
    {

		if(!empty( $_POST['move_person'] ) )
		{
			//handle if person being moved is head of household
			if(!empty( $data->head_of_household) )
			{//need to reassign head of household
				$message.= esc_html(sprintf(  __(  '%1$s was head of household','church-admin'),$data->first_name.' '.$data->last_name) ).'<br />';
				//look for another adult
				$next_person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$data->household_id .'" AND people_type_id=1 AND people_id!="'.(int)$people_id.'" LIMIT 1');
				if(!empty( $next_person) ){
					$message.=esc_html( sprintf(  __(  'Head of household reassigned to %1$s','church-admin'),$next_person->first_name.' '.$next_person->last_name) ) .'<br />';
				}
				//no adult, find someone!
				if ( empty( $next_person->people_id) ){
					$next_person=$wpdb->get_row('SELECT * from '.CA_PEO_TBL.' WHERE household_id="'.(int)$data->household_id.'"  AND people_id!="'.(int)$people_id.'" AND people_type_id=1 LIMIT 1');
				}
				if(!empty( $next_person) ){
					$message.=esc_html( sprintf( __(  'Head of household reassigned to %1$s','church-admin'),$next_person->first_name.' '.$next_person->last_name) ) .'<br />';
				}
				else{$message='';}
				//set new head of hosuehold
				if(!empty( $next_person->people_id) )
				{
					$sql='UPDATE '.CA_PEO_TBL.' SET head_of_household=1 WHERE people_id="'.intval( $next_person->people_id).'"';
					$wpdb->query( $sql);
				}
				//stop them being head of household!
				$wpdb->query('UPDATE '.CA_PEO_TBL.' SET head_of_household=0 WHERE people_id="'.esc_sql( $people_id).'"');
			}

	    	if(!empty( $_POST['create'] ) )
			{
				$sql='INSERT INTO '.CA_HOU_TBL.' ( address,lat,lng,phone ) SELECT address,lat,lng,phone FROM '.CA_HOU_TBL.' WHERE household_id="'.esc_sql( $data->household_id).'";';

				$wpdb->query( $sql);
				$household_id=$wpdb->insert_id;
				$wpdb->query('UPDATE '.CA_PEO_TBL.' SET household_id="'.esc_sql( $household_id).'",head_of_household=1 WHERE people_id="'.esc_sql( $people_id).'"');
				$message.=esc_html(sprintf(  __(  '%1$s has been moved to a new household with the same address','church-admin'),$data->first_name.' '.$data->last_name) );
				echo'<div class="notice notice-success inline"><p><strong>'.$message.'</strong></td></tr></div>';

			}
			else
			{
				//remove household entry if only one person was in it.
				$no=$wpdb->get_var('SELECT COUNT(people_id) FROM '.CA_PEO_TBL.' WHERE household_id="'.esc_sql( $data->household_id).'"');
				if( $no==1)$wpdb->query('DELETE FROM '.CA_HOU_TBL.' WHERE household_id="'.esc_sql( $data->household_id).'"');
				//move the person to the new household
				$wpdb->query('UPDATE '.CA_PEO_TBL.' SET household_id="'.esc_sql( $_POST['household_id'] ).'" WHERE people_id="'.esc_sql( $people_id).'"');
				$message.=esc_html( sprintf( __(  '%1$s has been moved','church-admin'),$data->first_name.' '.$data->last_name) );
				echo'<div class="notice notice-success inline"><p><strong>'.$message.'</strong></td></tr></div>';
				$household_id=(int)$_POST['household_id'];
			}
	    	church_admin_new_household_display( $household_id);

		}
		else
		{
	   		echo'<div class="wrap"><h2>Move '.esc_html( $data->first_name).' '.esc_html( $data->last_name).'</h2>';

	    	$results=$wpdb->get_results('SELECT a.last_name,a.first_name, a.household_id,b.member_type FROM '.CA_PEO_TBL.' a, '.CA_MTY_TBL.' b WHERE b.member_type_id=a.member_type_id GROUP BY a.household_id,a.last_name ORDER BY a.last_name');
	    	if(!empty( $results) )
	    	{
				echo'<form action="" method="post">';
				echo'<tr><th scope="row">'.esc_html( __( 'Create a new household with same address','church-admin') ).'</th><td><input type="checkbox" name="create" value="yes"/></td></tr>';
				echo'<tr><th scope="row">'.esc_html( __( 'Move to household','church-admin') ).'</th><td><select name="household_id"><option value="">'.esc_html( __( 'Select a new household...','church-admin') ).'</option>';
				foreach( $results AS $row)
				{
		    		echo'<option value="'.esc_html( $row->household_id).'">'.esc_html( $row->last_name).', '.esc_html( $row->first_name).' '.'('.$row->member_type.')</option>';
				}
				echo'</select></td></tr>';
				echo'<p><input type="hidden" name="move_person" value="yes"/><input type="submit" class="button-primary" value="'.esc_html( __( 'Move person','church-admin') ).'"/></td></tr>';
				echo'</form></div>';
	    	}
		}
    }else{
		echo'<div class="notice notice-warning inline"><h2>'.esc_html( __( "Oh No! Couldn't find the person you want to move",'church-admin') ).'</h2></div>';
	}
}
 /**
 *
 * Create user for all people with email address
 *
 * @author  Andy Moyle
 * @param    $people_id
 * @return   html
 * @version  0.1
 *
 */
 function church_admin_users()
 {
 		global $wpdb;
 		echo'<h2>'.esc_html( __( 'Create user accounts for every one with an email address','church-admin') ).'</h2>';
 		if(!empty( $_POST['create_users_member_type_form'] ) )
 		{
 			foreach( $_POST['member_type_id'] AS $key=>$member_type_id)
 			{
 				$sql='SELECT CONCAT(first_name,last_name) AS username,people_id,household_id FROM '.CA_PEO_TBL.' WHERE member_type_id="'.intval( $member_type_id).'"  AND email!=""';
				$results=$wpdb->get_results( $sql);
				if(!empty( $results) )
				{
					foreach( $results AS $row)
                    {
                        echo church_admin_create_user( $row->people_id,$row->household_id,$row->username);
                    }
				}

			}
			echo'<div class="notice notice-sucess inline"><h2>'.esc_html( __( 'Users created','church-admin') ).'</h2</div>';
 		}
 		else
 		{
 			echo'<form action="" method="POST">';

 			$member_type=church_admin_member_type_array();
 			foreach( $member_type AS $key=>$value)
			{
				echo'<p><input type="checkbox" name="member_type_id[]" value="'.esc_html( $key).'" />'.esc_html( $value).'</p>';

			}
			echo'<p><input type="hidden" name="create_users_member_type_form" value="yes"/><input type="submit" class="button-primary" value="'.esc_html( __( 'Create users','church-admin') ).'"/></p></form>';
 		}

 }


function church_admin_confirmed_users()
{
    echo'<h1>'.esc_html( __( 'Create user accounts for GDPR confirmed directory entries','church-admin') ).'</h1>';
    echo'<p>'.esc_html( __( 'User accounts will be created for users with a unique email who have confirmed GDPR','church-admin') ).'</p>';
	global $wpdb;
	$sql='SELECT CONCAT(first_name,last_name) AS username,people_id,household_id FROM '.CA_PEO_TBL.' WHERE (gdpr_reason IS NOT NULL OR gdpr_reason!="") AND email!=""';
	$results=$wpdb->get_results( $sql);
	if(!empty( $results) )
	{
		foreach( $results AS $row)echo church_admin_create_user( $row->people_id,$row->household_id,$row->username);
		echo'<div class="notice notice-success inline"><p><strong>'.esc_html( __( 'Users created and updated','church-admin') ).'</strong></p></div>';
	}
	else{echo'<div class="notice notice-warning inline"><p><strong>'.esc_html( __( 'No GDPR confirmed people with an email to create a user account','church-admin') ).'</strong></p>';}

}


 




function church_admin_get_capabilities( $id)
{
    if ( empty( $id) )return FALSE;
    $user_info=get_userdata( $id);
    if ( empty( $user_info) )return FALSE;
    $cap=$user_info->roles;

	if (in_array('subscriber',$cap) )return 'Subscriber';
	if (in_array('author',$cap) )return 'Author';
	if (in_array('editor',$cap) )return  'Editor';
	if (in_array('administrator',$cap) ) return 'Administrator';
	return FALSE;
}


 /**
 *
 * Search
 *
 * @author  Andy Moyle
 * @param
 * @return   html
 * @version  0.1
 *
 */
function church_admin_search( $search)
{
    global $wpdb,$rota_order;
    $wpdb->show_errors();
    echo '<p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;section=people&action=add-household','add-household').'">'.esc_html( __( 'Add a Household','church-admin') ).'</a> </p>';
	
    $s=esc_sql(stripslashes( $search) );
  
    if(!empty( $_REQUEST['all-records'] ) )
    {
        $active='';
    }
    else{$active=' a.active=1 AND ';}
   
    $sql='SELECT a.user_id,a.people_id,a.household_id, a.last_name, a.first_name,a.email,a.last_updated, b.last_updated AS householdUpdated,b.address AS address,b.phone FROM '.CA_PEO_TBL.' a, '.CA_HOU_TBL.' b  WHERE a.household_id=b.household_id AND '.$active.' (CONCAT_WS(" ",a.first_name,a.last_name) LIKE("%'.$s.'%")||CONCAT_WS(" ",a.first_name,a.prefix,a.last_name) LIKE("%'.$s.'%")||a.first_name LIKE("%'.$s.'%")||a.last_name LIKE("%'.$s.'%")||a.nickname LIKE("%'.$s.'%")||a.email LIKE("%'.$s.'%")||a.mobile LIKE("%'.$s.'%")||a.e164cell LIKE("%'.$s.'%")||b.phone LIKE("%'.$s.'%")||b.address LIKE("%'.$s.'%") ) GROUP BY a.people_id';
  
    $results=$wpdb->get_results( $sql);
    

    if( $results)
    {

		$theader='<tr><th>'.esc_html( __( 'Delete','church-admin') ).'</th><th>'.esc_html( __( 'Display household','church-admin') ).'</th><th>'.esc_html( __( 'Last Name','church-admin') ).'</th><th>'.esc_html( __( 'First Name','church-admin') ).'</th><th>'.esc_html( __( 'Address','church-admin') ).'</th><th>'.esc_html( __( 'Last Update','church-admin') ).'</th><th>'.esc_html( __( 'Move','church-admin') ).'</th><th>'.esc_html( __( 'Household ID','church-admin') ).'</th><th>'.esc_html( __( 'User','church-admin') ).'</th><th>V-card</th></tr>';
	    echo '<h2>'.esc_html( __( 'Address List Results','church-admin') ).' for "'.esc_html( $search).'"</h2><table class="widefat striped"><thead>'.$theader.'</thead><tbody>';
		foreach( $results AS $row)
		{
            
	    
            if(!empty( $row->address) )  {$address='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_household&amp;household_id='.(int)$row->household_id,'edit_household').'">'.esc_html( $row->address).'</a>';}else{$address='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_household&amp;household_id='.(int)$row->household_id,'edit_household').'">Add Address</a>';}
			$user=church_admin_user_check( $row,FALSE);
            $delete='<a onclick="return confirm(\''.esc_html( __( 'Are you sure?','church-admin') ).'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete_people&amp;people_id='.(int)$row->people_id.'&amp;household_id='.(int)$row->household_id,'delete_person').'">'.esc_html( __( 'Delete person','church-admin') ).'</a>';
            $updated=esc_html( sprintf(__( 'Person updated %1$s, Household updated %2$s','church-admin'),mysql2date(get_option('date_format'),$row->last_updated),mysql2date(get_option('date_format'),$row->householdUpdated) ) );
            $move='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=church_admin_move_person&amp;people_id='.$row->people_id,'move_person').'">'.esc_html( __( 'Move','church-admin') ).'</a>';
            $vcf='<a style="text-decoration:none" title="'.esc_html( __( 'Download personal Vcard','church-admin') ).'" href="'.wp_nonce_url(home_url().'/?ca_download=vcf-person&amp;id='.(int)$row->people_id,(int)$row->people_id).'"><span class="dashicons dashicons-index-card"></span> VCF</a>';
       
			echo '<tr><td>'.$delete.'</td><td><a  href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=display_household&section=people&household_id='.$row->household_id,'display_household').'">'.esc_html( __( 'Display household','church-admin') ).'</a></td><td class="ca-names"><a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=display_household&amp;household_id='.(int)$row->household_id,'display_household').'">'.esc_html( $row->last_name).'</a></td><td class="ca-names"><a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_people&amp;people_id='.(int)$row->people_id,'edit_people').'">'.esc_html( $row->first_name).'</td><td class="ca-addresses">'.$address.'</td><td>'.$updated.'</td><td>'.$move.'</td><td>'.(int)$row->household_id.'</td><td>'.$user.'</td><td>'.$vcf.'</td></tr>';


		}
		echo '</tbody><tfoot>'.$theader.'</tfoot></table>';
		echo'<script>
		jQuery(document).ready(function( $)  {
			$(".ca_connect_user").click(function() {
				var people_id=$(this).attr("data-peopleid");
				var data = {
				"action": "church_admin",
				"method": "connect_user",
				"people_id": people_id,
				"user_id": $(this).attr("data-userid"),
				"nonce": "'.wp_create_nonce("connect_user").'",
				dataType: "json"
				};console.log(data);
				// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
				jQuery.post(ajaxurl, data, function(response)
				{
					var data=JSON.parse(response);
					console.log("body .userinfo"+data.people_id + " "+data.login)
					$(".userinfo"+data.people_id).replaceWith(data.login);
				});
	
			});
			$(".ca_create_user").click(function() {
				var people_id=$(this).attr("data-peopleid");
				var data = {
				"action": "church_admin",
				"method": "create_user",
				"people_id": $(this).attr("data-peopleid"),
				"nonce": "'.wp_create_nonce("create_user").'",
				dataType:"json"
				};
				console.log(data);
				// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
				jQuery.post(ajaxurl, data, function(response)
				{
					var data=JSON.parse(response);
					console.log("body .userinfo"+data.people_id + " "+data.login)
					$(".userinfo"+data.people_id).replaceWith(data.login);
				});
			});
		});
		</script>';


    }
	else{echo'<p>"'.esc_html( $search).'" '.esc_html( __( 'not found in directories','church-admin') ).'.</p>';}


	$people_id=church_admin_get_one_id( $search);
	$serial='s:'.strlen( $people_id).':"'.$people_id.'";';
	$serviceResults=$wpdb->get_results('SELECT * FROM '.CA_SER_TBL);
	if(!empty( $serviceResults) )
	{
		$services=array();
		foreach( $serviceResults AS $serviceRow)$services[$serviceRow->service_id]=$serviceRow->service_name;
	}
	/**********************************
	*
	* Search rota
	*
	***********************************/
 	if(!empty( $people_ids) )  {
		foreach( $people_ids AS $key=>$people_id)
		{
		$sql='SELECT a.service_name,a.service_time, b.rota_task,c.rota_date,a.service_id,c.people_id FROM '.CA_SER_TBL.' a, '.CA_RST_TBL.' b, '.CA_ROTA_TBL.' c WHERE a.service_id=c.service_id AND c.mtg_type="service" AND c.rota_task_id=b.rota_id  AND c.people_id="'.(int)$people_id.'" AND c.rota_date>=CURDATE() ORDER BY c.rota_date ASC';

		$dateResults=$wpdb->get_results( $sql);
		if(!empty( $dateResults) )
		{
			echo'<h2>'.esc_html( __( 'Schedule results for ','church-admin') ).esc_html( $search).'</h2>';
			echo'<table class="widefat striped">';
			$thead='<tr><th>'.esc_html( __( 'Date','church-admin') ).'</th><th>'.esc_html( __( 'Service','church-admin') ).'</th><th>'.esc_html( __( 'Name','church-admin') ).'</th><th>'.esc_html( __( 'Job','church-admin') ).'</th></tr>';
			echo'<thead>'.$thead.'</thead><tbody>';
			foreach( $dateResults AS  $dateRow)
			{
					$edit_url=wp_nonce_url('admin.php?page=church_admin/index.php&section=rota&action=edit_rota&rota_date='.esc_html( $dateRow->rota_date).'&amp;service_id='.intval( $dateRow->service_id).'&amp;mtg_type=service','edit_rota');
				echo'<tr><td><a href="'.$edit_url.'">'.mysql2date(get_option('date_format'),$dateRow->rota_date).'</a></td><td>'.esc_html( $dateRow->service_name.' '.$dateRow->service_time).'</td><td class="ca-names">'.esc_html(church_admin_get_person( $dateRow->people_id) ).'</td><td>'.esc_html( $dateRow->rota_task).'</td></tr>';

			}

				echo'</tbody><tfoot>'.$thead.'</tfoot></table>';
		}
	}
	}
	//search podcast

	$results=$wpdb->get_results('SELECT * FROM '.CA_FIL_TBL.' WHERE file_title LIKE "%'.$s.'%" OR file_description LIKE "%'.$s.'%" OR speaker LIKE "%'.esc_sql( $serial).'%" OR speaker LIKE "%'.$s.'%" ORDER BY pub_date DESC');
	if(!empty( $results) )
	{

		$upload_dir = wp_upload_dir();
		$path=$upload_dir['basedir'].'/sermons/';
		$url=content_url().'/uploads/sermons/';
		echo '<h2>'.esc_html( __( 'Sermon Podcast Results for ','church-admin') ).'"'.esc_html( $search).'"</h2>';
		$table='<table class="widefat striped"><thead><tr><th>'.esc_html( __( 'Edit','church-admin') ).'</th><th>'.esc_html( __( 'Delete','church-admin') ).'</th><th>'.esc_html( __( 'Publ. Date','church-admin') ).'</th><th>'.esc_html( __( 'Title','church-admin') ).'</th><th>'.esc_html( __( 'Speakers','church-admin') ).'</th><th>'.esc_html( __( 'Mp3 File','church-admin') ).'</th></th><th>'.esc_html( __( 'File Okay?','church-admin') ).'</th><th>'.esc_html( __( 'Length','church-admin') ).'</th><th>'.esc_html( __( 'Media','church-admin') ).'</th><th>'.esc_html( __( 'Transcript','church-admin') ).'</th><th>'.esc_html( __( 'Event','church-admin') ).'</th><th>'.esc_html( __( 'Shortcode','church-admin') ).'</th></tr></thead>'."\r\n".'<tfoot><tr><th>'.esc_html( __( 'Edit','church-admin') ).'</th><th>'.esc_html( __( 'Delete','church-admin') ).'</th><th>'.esc_html( __( 'Publ. Date','church-admin') ).'</th><th>'.esc_html( __( 'Title','church-admin') ).'</th><th>'.esc_html( __( 'Speakers','church-admin') ).'</th><th>'.esc_html( __( 'Mp3 File','church-admin') ).'</th></th><th>'.esc_html( __( 'File Okay?','church-admin') ).'</th><th>'.esc_html( __( 'Length','church-admin') ).'</th><th>'.esc_html( __( 'Media','church-admin') ).'</th><th>'.esc_html( __( 'Transcript','church-admin') ).'</th><th>'.esc_html( __( 'Event','church-admin') ).'</th><th>'.esc_html( __( 'Shortcode','church-admin') ).'</th></tr></tfoot>'."\r\n".'<tbody>';
        foreach( $results AS $row)
        {
            if(file_exists(plugin_dir_path( $path.$row->file_name) ))  {$okay='<img src="'.plugins_url('images/green.png',dirname(__FILE__) ) .'" width="32" height="32"/>';}else{$okay='<img src="'.plugins_url('images/red.png',dirname(__FILE__) ) .'" width="32" height="32"/>';}
            $edit='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_file&amp;id='.$row->file_id,'edit_podcast_file').'">Edit</a>';
            $delete='<a onclick="return confirm(\''.esc_html( __( 'Are you sure?','church-admin') ).'\');" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete_file&amp;id='.$row->file_id,'delete_podcast_file').'">'.esc_html( __( 'Delete','church-admin') ).'</a>';
            $series_name=$wpdb->get_var('SELECT series_name FROM '.CA_SERM_TBL.' WHERE series_id="'.esc_sql( $row->series_id).'"');
            if(!empty( $row->file_name)&&file_exists( $path.$row->file_name) )  {$file='<a href="'.$url.esc_url( $row->file_name).'">'.esc_html( $row->file_name).'</a>'; $okay='<img src="'.plugins_url('images/green.png',dirname(__FILE__) ) .'"/>';}
			elseif(!empty( $row->external_file) )  {$file='<a href="'.esc_url( $row->external_file).'">'.esc_html( $row->external_file).'</a>'; $okay='<img src="'.plugins_url('images/green.png',dirname(__FILE__) ) .'"/>';}
			else{$file='&nbsp;'; $okay='<img src="'.plugins_url('images/red.png',dirname(__FILE__) ).'"/>';}
            $table.='<tr><td>'.$edit.'</td><td>'.$delete.'</td><td>'.date(get_option('date_format'),strtotime( $row->pub_date) ).'</td><td>'.esc_html( $row->file_title).'</td><td class="ca-names">'.esc_html(church_admin_get_people( $row->speaker) ).'</td><td>'.$file.'</td><td>'.$okay.'</td><td>'.esc_html( $row->length).'</td><td>'.$row->video_url.'</td>';
            if(file_exists( $path.$row->transcript) )  {$table.='<td><a href="'.esc_url( $url.$row->transcript).'">'.esc_html( $row->transcript).'</a></td>';}else{$table.='<td>&nbsp;</td>';}
            $table.='<td>'.esc_html( $series_name).'</td><td>[church_admin type="podcast" file_id="'.intval( $row->file_id).'"]</td></tr>';
        }

        $table.='</tbody></table>';
        echo $table;
	}
	//search calendar

}
 /**
 *
 * Replicate ministries in to roles.
 * The roles must already have been created in wordpress
 *
 * @author  Andy Moyle
 * @param    None
 * @return   N/A
 * @version  0.2
 *
 */

function church_admin_replicate_roles()
{
	if(!church_admin_level_check('Directory') )wp_die(esc_html( __( 'You don\'t have permissions to do that','church-admin') ) );
	global $wpdb;
	$wpdb->show_errors;

    if ( empty( $_POST['replicate-roles'] ) )
    {
        echo'The replicate roles function replicates Church Admin Ministries to WordPress roles.</br>To use this you first need to create the matching role in WordPress, there any many plugins that do this including User Role Editor and Advanced Access Manager (AAM).  Once you have created a matching word press role for the Ministries you want to replicate just use the replicate roles function to add people in your ministries to the equivalent WordPress role.<br />Why would you do this?  It allows you then to use other plugins to restrict access based on the roles, for example if you have a “service leader” role and you want a page only service leaders see when they logon you can so this by.<br />   Use church admin to create a service leader ministry and add you service leaders.<br />Manually create a WordPress role called “Service Leader”, this must match exactly the name of the ministry. Use the Replicate Roles function to populate your new Role with those people you assigned to the ministry.    Now use an access plugin to apply the controls you want. AAM does this very easily.<br />There are a couple of restrictions<br />This function old “adds” people, so if you remove anyone from a ministry you have to manually delete them from the role – or deleted everyone and then use the replicate roles function again.<br /> As mentioned, you have to create the roles manually with another plugin.<br />Once pressed you see this kind of output<br /><ul><li>Andy Moyle already has role PCC (pcc).</li><li>Unable to add Role (WebTeam) to user Andy Moyle. The role was not found in wordpress - please add this manually if required.</li><li>Andy Moyle already has role Church Wardens (church_wardens).</li><li>Adding role Tea Room (tea_room) to Andy Moyle</li></ul>';
        echo'<form action="" method="post"><p><input type="hidden" name="replicate-roles" value="TRUE"/><input type="submit" class="button-primary" value="'.esc_html( __( 'Replicate roles','church-admin') ).'"></p></form>';
    }
    else{
        //Get an array of all the defined roles.
        $wp_roles = new WP_Roles();
        $names =$wp_roles->get_names();
        echo '<h1>'.esc_html( __( 'Replicate roles','church-admin') ).'</h1>';
        echo'<p>'.esc_html( __( "This replicates people's ministries to WordPress user roles, if you have already created roles for those ministry names",'church-admin') ).'</p>';
        echo'<p>'.esc_html( __( 'Starting to replicate roles','church-admin') ).'</p>';

        //Find all users in church admin that have a wordpress user ID.
        $sql='SELECT first_name,last_name,people_id,user_id FROM '.CA_PEO_TBL.' WHERE user_id>=1';

        if(defined('CA_DEBUG') )church_admin_debug('running sql '.$sql);

        $result=$wpdb->get_results( $sql);
        if(defined('CA_DEBUG') )church_admin_debug('Results '.print_r( $result,TRUE) );
        if(!empty( $result) )
        {
            //We found some users with wordpress user ID's - iterate through them.
            foreach( $result AS $users)
            {
                if(defined('CA_DEBUG') )church_admin_debug('Person Found with wordpress ID '.$users->user_id);

                //Now find the ministry ID's this user has.
                $sql='SELECT ID FROM '.CA_MET_TBL.' WHERE meta_type="ministry" AND people_id='.$users->people_id;
                if(defined('CA_DEBUG') )church_admin_debug('running sql '.$sql);
                $metaresult=$wpdb->get_results( $sql);
                if(!empty( $metaresult) )
                {

                    //User is in some ministries - iterate through them to get the names.
                    foreach( $metaresult AS $role)
                    {
                        if(defined('CA_DEBUG') )church_admin_debug('Role ID Found '.$role->ID);
                        //For each ID we find get the actual name.
                        $sql='SELECT ministry FROM '.CA_MIN_TBL.' WHERE ID='.$role->ID;
                        if(defined('CA_DEBUG') )church_admin_debug('running sql '.$sql);
                        $rolename=$wpdb->get_var( $sql);
                        if(defined('CA_DEBUG') )church_admin_debug('Role name is '.$rolename.' Adding role');

                        //Iterate through the available roles to get the internal role name
                        //as this is whats needed for the add role.
                        $internalrolename='';
                        $user=get_userdata( $users->user_id);
                        foreach( $names as $key=>$ID)
                        {
                            if(defined('CA_DEBUG') )church_admin_debug('Role name is '.$key.' ID is ',$ID);

                            if (strtolower( $ID)==strtolower( $rolename) )
                            {
                                $internalrolename=$key;
                                //Check if the user already has the role, user->roles is an array of all the roles the user has
                                if (!in_array( $internalrolename, $user->roles )	)
                                {
                                    //User does not have the role, so add it.
                                    echo'<br> Adding role '.$ID.' ('.$internalrolename.') to '.$users->first_name.' '.$users->last_name;
                                    $user->add_role( $internalrolename);
                                }
                                else
                                    echo'<br>'.$users->first_name.' '.$users->last_name.' already has role '.$ID.' ('.$internalrolename.').';
                                break;
                            }
                        }
                        //We have iterated through all wordpress's known roles and have not found anything that matches.
                        if ( empty( $internalrolename) )
                        {
                            echo'<br>Unable to add Role <b>('.$rolename.')</b> to user '.$users->first_name.' '.$users->last_name.'. The role was not found in wordpress - please add this manually if required.' ;
                        }
                    }
                }
            }
        }
    }
}
 /**
 *
 * Import CSV
 *
 * @author  Andy Moyle
 * @param
 * @return   html
 * @version  0.1
 *
 */
function church_admin_import_csv()
{
		if(!church_admin_level_check('Directory') )wp_die(esc_html( __( 'You don\'t have permissions to do that','church-admin') ) );
		echo'<h2>'.esc_html( __( 'Import CSV','church-admin') ).'</h2>';

		global $wpdb;
		$wpdb->show_errors;
		$people_types=get_option('church_admin_people_type');
		$gender=get_option('church_admin_gender');
		$debug=TRUE;
		$church_admin_marital_status=get_option('church_admin_marital_status');
		if ( empty( $church_admin_marital_status) ){
				$church_admin_marital_status=array(
				0=>esc_html( __( 'N/A','church-admin') ),
				1=>esc_html( __( 'Single','church-admin') ),
				2=>esc_html( __( 'Co-habiting','church-admin') ),
				3=>esc_html( __( 'Married','church-admin') ),
				4=>esc_html( __( 'Divorced','church-admin') ),
				5=>esc_html( __( 'Widowed','church-admin') )
			);
		}
	if(!empty( $_POST['process'] )&& check_admin_referer('csv_upload','nonce') )
	{
		echo'<p>'.esc_html( __( 'Processing','church-admin') ).'</p>';
		if(!empty( $_POST['overwrite'] ) )
		{
			$wpdb->query('TRUNCATE TABLE '.CA_PEO_TBL);
			$wpdb->query('TRUNCATE TABLE '.CA_HOU_TBL);
			$wpdb->query('TRUNCATE TABLE '.CA_MET_TBL);
			$wpdb->query('TRUNCATE TABLE '.CA_CUST_MET_TBL);
			$wpdb->query('TRUNCATE TABLE '.CA_CUST_TBL);
			update_option('church_admin_gender',array(1=>esc_html( __( 'Male','church-admin') ),0=>esc_html( __( 'Female','church-admin') )));
			echo'<p>'.esc_html( __( 'Tables truncated','church-admin') ).'</p>';
		}

		foreach( $_POST AS $key=>$value)
		{
			if(substr( $key,0,6)=='column')
			{
				$column=substr( $key,6);
				switch( $value)
				{
					case'first_name':$first_name=$column;break;
					case'middle_name':$middle_name=$column;break;
					case'nickname':$nickname=$column;break;
					case'prefix':$prefix=$column;break;
					case'last_name':$last_name=$column;break;
					case'sex':$sex=$column;break;
					case'marital_status':$marital_status=$column;break;
					case'date_of_birth':$date_of_birth=$column;break;
					case'email':$email=$column;break;
					case'mobile':$mobile=$column;break;
					case'phone':$phone=$column;break;
					case'address':$address=$column;break;
					case'street_address':$street_address=$column;break;
					case'city':$city=$column;break;
					case'state':$state=$column;break;
					case'zip_code':$zipcode=$column;break;
					case'small_group':$small_group=$column;break;
					case'member_type':$member_type=$column;break;
					case'people_type':$people_type=$column;break;
					case'people_order':$people_order=$column;break;
					case'ministries':$ministries=$column;break;
					case 'custom1':$custom1=$column;break;
					case 'custom2':$custom2=$column;break;
					case 'custom3':$custom3=$column;break;
					case 'custom4':$custom4=$column;break;
					case 'custom5':$custom5=$column;break;
					case 'show_me':$show_me=$column;break;
                    case 'mail_send':$mail_send=$column;break;
                    case 'email_send':$email_send=$column;break;
					case 'news_send':$news_send=$column;break;
                    case 'sms_send':$sms_send=$column;break;
                    case 'photo_permission':$photo_permission=$column;break;  
					case 'head_of_household':$headofhousehold=$column;break;  
					case 'household_id':$householdid=$column;break;
					case 'gdpr_reason':$gdpr_reason=$column;break;
				}

			}

		}
		ini_set('auto_detect_line_endings',TRUE);
		if (( $handle = fopen( $_POST['path'], "r") ) !== FALSE)
		{
			echo'<p>'.esc_html( __( 'Begin file Processing','church-admin') ).'</p>';
			$header=fgetcsv( $handle, 0, ",");
			//handle custom headers
			$customFields=array();
			if(!empty( $custom1) )  {$custom1Header=$header[$custom1]; $customFields[1]=array('name'=>$custom1Header,'type'=>"text");}
			if(!empty( $custom2) )  {$custom2Header=$header[$custom2]; $customFields[2]=array('name'=>$custom2Header,'type'=>"text");}
			if(!empty( $custom3) )  {$custom3Header=$header[$custom3]; $customFields[3]=array('name'=>$custom3Header,'type'=>"text");}
			if(!empty( $custom4) )  {$custom4Header=$header[$custom4]; $customFields[4]=array('name'=>$custom4Header,'type'=>"text");}
			if(!empty( $custom5) )  {$custom5Header=$header[$custom5]; $customFields[5]=array('name'=>$custom5Header,'type'=>"text");}
			if(!empty( $customFields) )
			{
				foreach( $customFields AS $key=>$field)
				{
					$wpdb->query('INSERT INTO '.CA_CUST_TBL.' (name,section,type,ID)VALUES("'.esc_sql( $field['name'] ).'","people","text","'.(int)$key.'")');
				}
			}			
			echo'<p>'.esc_html( __( 'Got CSV header','church-admin') ).'</p>';
			$users=array();
			while (( $data = fgetcsv( $handle, 0, ",") ) !== FALSE)
			{
				$check=array_filter( $data);
				if(!empty( $check) )
				{
                    //ensure data is utf-8
                    foreach( $data AS $key=>$value)
                    {
                        $data[$key]=utf8_encode( $value);
                    }
              
				if(isset( $data[$headofhousehold] ) )
				{
					$head_of_household = $data[$headofhousehold];
				}
				else $head_of_household=1;//reset to 1 each time. Set to 0 if address already stored, which implies head already stored.
				//household
				$household_id=NULL;
				$add='';
				if(!empty( $address)&&!empty( $data[$address] ) )
				{
					$ad=array( $data[$address] );
					if(!empty( $city)&&!empty( $data[$city] ) )$ad[]=$data[$city];
					if(!empty( $state)&&!empty( $data[$state] ) )$ad[]=$data[$state];
					if(!empty( $zipcode)&&!empty( $data[$zipcode] ) )$ad[]=$data[$zipcode];
					$add=implode(', ',$ad);

				}
                     
				if(!empty( $phone)&&!empty( $data[$phone] ) )  {$ph=$data[$phone];}else{$ph=NULL;}
				//if the address is empty then don;t try to match with existing household
				if(!empty( $householdid)&&!empty( $data[$householdid] ) )
				{
					$household_id=$data[$householdid];
				}
				if(!empty( $address)&&!empty( $data[$address] ) && empty( $household_id) )
				{
					$sql='SELECT household_id FROM '.CA_HOU_TBL.' WHERE address="'.esc_sql( $add).'"';
					$household_id=$wpdb->get_var( $sql);
				}
				if ( empty( $household_id) )$household_id=$wpdb->get_var('SELECT MAX(household_id) FROM '.CA_HOU_TBL) + 1;
				$householdData=array('household_id'=>$household_id,'address'=>$add,'phone'=>$ph);
				$format=array('%d','%s','%s','%s');
				$wpdb->replace(CA_HOU_TBL,$householdData,$format);
				
				//member type
				if(!empty( $member_type) )
				{
					$mt=$data[$member_type];
					$member_type_id=$wpdb->get_var('SELECT member_type_id FROM '.CA_MTY_TBL.' WHERE member_type="'.esc_sql( $mt).'"');
					if ( empty( $member_type_id) )
					{
						$wpdb->query('INSERT INTO '.CA_MTY_TBL.' (member_type)VALUES("'.esc_sql( $mt).'")');
						$member_type_id=$wpdb->insert_id;
					}
				}else
				{
					$member_type_id=1;
					$check=$wpdb->get_var('SELECT member_type_id FROM '.CA_MTY_TBL.' WHERE member_type_id=1' );
					if(!$check)
					{
						$wpdb->query('INSERT INTO '.CA_MTY_TBL.' (member_type)VALUES("'.esc_html( __( 'Member','church-admin') ).'")');
						$member_type_id=$wpdb->insert_id;
					}
				}
				//people
				//gender

				if(isset( $sex)&&!empty( $data[$sex] ) )
				{
					$malefemale=array_search(trim( $data[$sex] ),$gender);
					if(!isset( $malefemale) )
					{
						$gender[]=$data[$sex];
						update_option('church_admin_gender',$gender);
					}
					$malefemale=(int)array_search( $data[$sex],$gender);
				}else $malefemale=1;

				if(isset( $date_of_birth) && !empty( $data[$date_of_birth] ) )
				{

					if(church_admin_checkdate( $data[$date_of_birth] ) )  {$dob=$data[$date_of_birth];}
					else{$dob=date('Y-m-d',strtotime( $data[$date_of_birth] ) );}

					if ( empty( $dob) ) $dob=NULL;
				}else{$dob=NULL;}




				if (empty( $marital_status) )  {$data['marital_status']=0;}
				elseif(!in_array( $data[$marital_status],$church_admin_marital_status) )  {$data['marital_status']=0;}else{$data['marital_status']=$data[$marital_status];}
				if ( empty( $data['marital_status'] ) )  {$data['marital_status']=0;}
				if(!isset( $first_name)||empty( $data[$first_name] ) )  {$data['first_name']=NULL;}else{$data['first_name']=$data[$first_name];}
				if(!isset( $middle_name)||empty( $data[$middle_name] ) )  {$data['middle_name']=NULL;}else{$data['middle_name']=$data[$middle_name];}
				if(!isset( $nickname)||empty( $data[$nickname] ) )  {$data['nickname']=NULL;}else{$data['nickname']=$data[$nickname];}
				if(!isset( $prefix)||empty( $data[$prefix] ) )  {$data['prefix']=NULL;}else{$data['prefix']=$data[$prefix];}
				if(!isset( $last_name)||empty( $data[$last_name] ) )  {$data['last_name']=NULL;}else{$data['last_name']=$data[$last_name];}
				
                if(!isset( $mobile)||empty( $data[$mobile] ) )
                {
                    $data['e164cell']=$data['mobile']=NULL;
                }else
                {
                    $data['mobile']=$data[$mobile];
                    $data['e164cell']=church_admin_e164( $data[$mobile] );
                }
				if(!isset( $email)||empty( $data[$email] ) )  {$data['email']=NULL;}else{$data['email']=$data[$email];}
				if(!isset( $custom1)||empty( $data[$custom1] ) )  {$data['custom1']=NULL;}else{$data['custom1']=$data[$custom1];}
				if(!isset( $custom2)||empty( $data[$custom2] ) )  {$data['custom2']=NULL;}else{$data['custom2']=$data[$custom2];}
				if(!isset( $custom3)||empty( $data[$custom3] ) )  {$data['custom3']=NULL;}else{$data['custom3']=$data[$custom3];}
				if(!isset( $custom4)||empty( $data[$custom4] ) )  {$data['custom4']=NULL;}else{$data['custom4']=$data[$custom4];}
				if(!isset( $custom5)||empty( $data[$custom5] ) )  {$data['custom5']=NULL;}else{$data['custom5']=$data[$custom5];}
                if(!isset( $small_group)||empty( $data[$small_group] ) )  {$data['small_group']=1;}else{$data['small_group']=$data[$small_group];} 
                if(!isset( $mail_send)||empty( $data[$mail_send] ) )  {$data['mail_send']=0;}else{$data['mail_send']=1;} 
                if(!isset( $email_send)||empty( $data[$email_send] ) )  {$data['email_send']=0;}else{$data['email_send']=1;} 
				if(!isset( $news_send)||empty( $data[$news_send] ) )  {$data['news_send']=0;}else{$data['news_send']=1;} 
                if(!isset( $sms_send)||empty( $data[$sms_send] ) )  {$data['sms_send']=0;}else{$data['sms_send']=1;}
                if(!isset( $photo_permission)||empty( $data[$photo_permission] ) )  {$data['photo_permission']=0;}else{$data['photo_permission']=1;}     
				if(!isset( $show_me)||empty( $data[$show_me] ) )  {$data['show_me']=0;}else{$data['show_me']=1;} 
				if(!isset( $gdpr_reason)||empty( $data[$gdpr_reason] ) )  {$data['gdpr_reason']="";}else{$data['gdpr_reason']=$data[$gdpr_reason];}
				if(!isset( $people_order)||empty( $data['people_order'] ) )$data['people_order']=0;
				$data['people_type_id']=1;
                if(!isset( $people_type)||empty( $data[$people_type] ) )  {$data['people_type_id']=1;}
				else
				{
					foreach( $people_types AS $id=>$type) if(strtolower( $type)==strtolower( $data[$people_type] ) )  {$data['people_type_id']=(int)$id;}
				}
				if(isset( $gdpr_reason) )  {$gdpr=$data[$gdpr_reason];}else{$gdpr='';}
				$people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE first_name="'.esc_sql(sanitize_text_field( $data['first_name'] ) ).'" AND last_name="'.esc_sql(sanitize_text_field( $data['last_name'] ) ).'" AND household_id="'.(int)$household_id.'"');
				if ( empty( $people_id) )
				{
					$sql='INSERT INTO '.CA_PEO_TBL.' (first_name,middle_name,nickname,prefix,last_name,email,mobile,sex,date_of_birth,member_type_id,household_id,people_type_id,head_of_household,marital_status,people_order,mail_send,email_send,sms_send,photo_permission,e164cell,gdpr_reason,show_me)VALUES("'.esc_sql( $data['first_name'] ).'","'.esc_sql( $data['middle_name'] ).'","'.esc_sql( $data['nickname'] ).'","'.esc_sql( $data['prefix'] ).'","'.esc_sql( $data['last_name'] ).'","'.esc_sql( $data['email'] ).'","'.esc_sql( $data['mobile'] ).'","'.$malefemale.'","'.$dob.'","'.esc_sql( $member_type_id).'","'.esc_sql( $household_id).'","'.intval( $data['people_type_id'] ).'","'.$head_of_household.'","'.esc_sql( $data['marital_status'] ).'","'.intval( $data['people_order'] ).'","'.$data['mail_send'].'","'.$data['email_send'].'","'.$data['sms_send'].'","'.$data['photo_permission'].'","'.$data['e164cell'].'","'.$data['gdpr_reason'].'","'.$data['show_me'].'")';
					if(defined('CA_DEBUG') )church_admin_debug( $sql);
					$wpdb->query( $sql);
					$people_id=$wpdb->insert_id;
					$what=esc_html( __( 'Added','church-admin') );
				}
				else {
					$wpdb->query('UPDATE '.CA_PEO_TBL.' SET first_name="'.esc_sql( $data['first_name'] ).'",middle_name="'.esc_sql( $data['middle_name'] ).'",nickname="'.esc_sql( $data['nickname'] ).'",prefix="'.esc_sql( $data['prefix'] ).'",last_name="'.esc_sql( $data['last_name'] ).'",email="'.esc_sql( $data['email'] ).'",mobile="'.esc_sql( $data['mobile'] ).'",sex="'.$malefemale.'",date_of_birth="'.$dob.'",member_type_id="'.esc_sql( $member_type_id).'",household_id="'.esc_sql( $household_id).'",people_type_id="'.intval( $data['people_type_id'] ).'",head_of_household="'.$head_of_household.'",marital_status="'.esc_sql( $data['marital_status'] ).'",people_order="'.intval( $data['people_order'] ).'",mail_send="'.$data['mail_send'].'",email_send="'.$data['email_send'].'",news_send="'.$data['news_send'].'",sms_send="'.$data['sms_send'].'",photo_permission="'.$data['photo_permission'].'", e164cell="'.$data['e164cell'].'",gdpr_reason="'.$data['gdpr_reason'].'" WHERE people_id="'.(int)$people_id.'"');
					$what=esc_html( __( 'Updated','church-admin') );
                    
				}
				$user_id=email_exists($data['email']);
				//connect user account first time only!
				if(!empty($user_id) && !in_array($data['email'],$users)){
					$wpdb->query('UPDATE '.CA_PEO_TBL.' SET user_id="'.(int)$user_id.'" WHERE people_id="'.(int)$people_id.'"');
					$users[]=$data['email'];
				}
				//news send
				church_admin_update_people_meta(NULL,$people_id,'posts',date('Y-m-d'));
                //small group
                //quick check to see if there is an unattached group
                $check=$wpdb->get_var('SELECT group_name FROM '.CA_SMG_TBL.' WHERE group_name="'.esc_html( __( 'Unattached','church-admin') ).'" AND id=1');
                if ( empty( $check) )$wpdb->query('INSERT INTO '.CA_SMG_TBL.' (group_name, group_day,id)VALUES("'.esc_html( __( 'Unattached','church-admin') ).'",1,1)');    
                if( $data['small_group']==1)
                {
                    church_admin_update_people_meta(1,$people_id,'smallgroup');
                }
                else
                {
                    $smallGroupID=$wpdb->get_var('SELECT id FROM '.CA_SMG_TBL.' WHERE   group_name="'.esc_sql( $data['small_group'] ).'"');
                    if(!empty( $smallGroupID) )
                    {
                        church_admin_update_people_meta(intval( $smallGroupID),$people_id,'smallgroup');
                    }
                    else
                    {
                        $wpdb->query('INSERT INTO '.CA_SMG_TBL.' (group_name,group_day)VALUES("'.esc_sql( $data['small_group'] ).'",0)');
                        $smallGroupID=$wpdb->insert_id;
                        church_admin_update_people_meta(intval( $smallGroupID),$people_id,'smallgroup');
                    }
                }
				//Ministries

				if(isset( $ministries) && !empty( $data[$ministries] ) )
				{
					$temp = $data[$ministries];
					//echo '<br> ministries= '.$temp;
					$ministryarray=explode(":",$temp);
					foreach( $ministryarray AS $key)
					{
						//echo '<br> ministry= '.$key;
						$sql='SELECT ID FROM '.CA_MIN_TBL.' WHERE ministry="'.$key.'"';
						//echo '<br> sql= '.$sql;
						$id=$wpdb->get_var( $sql);
						if(!empty( $id) )
						{
							//echo '<br> ministry id for '.$key.' is '.$id;
							$sql='INSERT INTO '.CA_MET_TBL.' (people_id,ID,meta_type)VALUES("'.esc_sql( $people_id).'","'.esc_sql( $id).'","ministry")';
							$wpdb->query( $sql);
						}

					}
				}
				if(isset( $data['custom1'] ) )
				{

					$wpdb->query('INSERT INTO '.CA_CUST_MET_TBL.' (people_id,custom_id,data) VALUES("'.(int)$people_id.'","1","'.esc_sql( $data['custom1'] ).'")');
				}
				if(isset( $data['custom2'] ) )
				{

					$wpdb->query('INSERT INTO '.CA_CUST_MET_TBL.' (people_id,custom_id,data) VALUES("'.(int)$people_id.'","2","'.esc_sql( $data['custom2'] ).'")');
				}
				if(isset( $data['custom3'] ) )
				{

					$wpdb->query('INSERT INTO '.CA_CUST_MET_TBL.' (people_id,custom_id,data) VALUES("'.(int)$people_id.'","3","'.esc_sql( $data['custom3'] ).'")');
				}
				if(isset( $data['custom4'] ) )
				{


					$wpdb->query('INSERT INTO '.CA_CUST_MET_TBL.' (people_id,custom_id,data) VALUES("'.(int)$people_id.'","4","'.esc_sql( $data['custom4'] ).'")');
				}
				if(isset( $data['custom5'] ) )
				{

					$wpdb->query('INSERT INTO '.CA_CUST_MET_TBL.' (people_id,custom_id,data) VALUES("'.(int)$people_id.'","5","'.esc_sql( $data['custom5'] ).'")');
				}
				//look for custom_ in the array, these are user defined custom fields.
				if(defined('CA_DEBUG') )church_admin_debug('Data array:'.print_r( $data,TRUE) );
				//echo '<br> about to loop '.count( $_POST);

				foreach( $_POST as $field => $value)
				{
					//echo '<br> field= '.$field;
					$key=$value;
					$pos=strpos( $key,'custom_');
					//echo '<br> pos= '.$pos;
					//echo '<br> key= '.$key;
					if ( $pos!==false)
					{
					    //echo '<br> Found custom_ at '.$pos;

						$column=substr( $field,6);
						//found a custom defined field, extract the custom id
						$cust_id=substr( $key,strlen('custom_')+$pos);
						//echo '<br> cust id is'.$cust_id;
						//echo '<br> Data for row '.$column. 'is '.$data[$column];
						$sql='INSERT INTO '.CA_CUST_MET_TBL.' (people_id,custom_id,data) VALUES("'.(int)$people_id.'","'.intval( $cust_id) .'","'.esc_sql( $data[$column] ).'")';
  					    $wpdb->query( $sql);
					}
				}

				echo '<p>'.$what.' '.$data[$first_name].' '.$data[$last_name].'</p>';

			}//non empty data
			

			}
			//fix head of households
			$householdsNeedingFixing=array();
				$households=$wpdb->get_results('SELECT household_id FROM '.CA_HOU_TBL);
				if(!empty( $households) )
				{
					/**************************************************
					 *  Check and Fix head of household missing issue
					 **************************************************/
					echo'<h2>'.esc_html( __( 'Checking for issues with head of household not set ','church-admin') ).'</h2>'."\r\n";
					foreach( $households AS $household)
					{
						$people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE head_of_household=1 AND household_id="'.(int)$household->household_id.'"');
						
						if ( empty( $people_id) )$householdsNeedingFixing[]=$household->household_id;
					}
					if ( empty( $householdsNeedingFixing) )
					{
						echo'<p>'.esc_html( __( 'All households have a head of household set','church-admin') ).'<span class="dashicons dashicons-saved" style="color:green"></span></p>'."\r\n";
					}
					else
					{
						
						$countHouseholds=count( $householdsNeedingFixing);
						echo'<p>'.esc_html(sprintf(__( '%1$s households do not have a head of household set. Fixing now', 'church-admin' ) ,$countHouseholds)) .'</p>'."\r\n";
						foreach( $householdsNeedingFixing AS $key=>$household_id)
						{
							$peopleInHousehold=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$household_id.'" ORDER BY people_order ASC, people_type_id ASC, sex DESC');
							
						if(defined('CA_DEBUG') )church_admin_debug(print_r( $peopleInHousehold,TRUE) );
							if(!empty( $peopleInHousehold) )
							{
								if(defined('CA_DEBUG') )church_admin_debug( $peopleInHousehold);
								if( $wpdb->num_rows==1)
								{
									//one person household
									$wpdb->query('UPDATE '.CA_PEO_TBL.' SET head_of_household=1 WHERE household_id="'.(int)$household_id.'" ');
								
									echo'<p>'.esc_html( __( 'One person household head of household fixed','church-admin') ).'<span class="dashicons dashicons-saved"  style="color:green"></span></p>'."\r\n";
								}
								else
								{
									$wpdb->query('UPDATE '.CA_PEO_TBL.' SET head_of_household=1 WHERE people_id="'.(int)$peopleInHousehold[0]->people_id.'" ');
									echo'<p>'.esc_html( __( 'Multiple person household head of household fixed','church-admin') ).'<span class="dashicons dashicons-saved" style="color:green"></span></p>'."\r\n";
								}
							}
						}
					}
        		}


			echo'<p>'.esc_html( __( 'Finished file Processing','church-admin') ).'</p>';
            update_option('addressUpdated',time() );
		}
		fclose( $handle);


	}
	elseif(!empty( $_POST['save_csv'] ) )
	{
		if(!empty( $_FILES) && $_FILES['file']['error'] == 0)
		{
			$custom_fields=church_admin_get_custom_fields();
			$filename = $_FILES['file']['name'];
			$upload_dir = wp_upload_dir();
			$filedest = $upload_dir['path'] . '/' . $filename;
			if(move_uploaded_file( $_FILES['file']['tmp_name'], $filedest) )echo '<p>'.esc_html( __( 'File Uploaded and saved','church-admin') ).'</p>';

			ini_set('auto_detect_line_endings',TRUE);
			$file_handle = fopen( $filedest, "r");
			$header=fgetcsv( $file_handle, 0, ",");

			$example1=fgetcsv( $file_handle, 0, ",");
			$example2=fgetcsv( $file_handle, 0, ",");
			$example3=fgetcsv( $file_handle, 0, ",");


			echo'<form  action="" method="post"><table class="widefat striped bordered">';
			echo'<input type="hidden" name="path" value="'.$filedest.'"/><input type="hidden" name="process" value="yes"/>';
			if(!empty( $_POST['overwrite'] ) )echo'<input type="hidden" name="overwrite" value="yes"/>';
			echo'<thead><tr><th>'.esc_html( __( 'Your Header','church-admin') ).'</th><th>'.esc_html( __( 'Maps to','church-admin') ).'</th><th>'.esc_html( __( 'Example 1','church-admin') ).'</th><th>'.esc_html( __( 'Example 2','church-admin') ).'</th><th>'.esc_html( __( 'Example 3','church-admin') ).'</th></tr></thead><tbody>';
			foreach( $header AS $key=>$value)
			{
				echo'<tr><th scope="row">'.esc_html( $value).'</th><td>';
				echo'<select name="column'.$key.'">';
				echo'<option value="unused">'.esc_html( __( 'Unused','church-admin') ).'</option>';
				echo'<option value="first_name">'.esc_html( __( 'First Name','church-admin') ).'</option>';
				echo'<option value="middle_name">'.esc_html( __( 'Middle Name','church-admin') ).'</option>';
				echo'<option value="nickname">'.esc_html( __( 'Nickname','church-admin') ).'</option>';
				echo'<option value="prefix">'.esc_html( __( 'Prefix','church-admin') ).'</option>';
				echo'<option value="last_name">'.esc_html( __( 'Last Name','church-admin') ).'</option>';
				echo'<option value="sex">'.esc_html( __( 'Gender','church-admin') ).'</option>';
				echo'<option value="marital_status">'.esc_html( __( 'Marital Status','church-admin') ).'</option>';
				echo'<option value="date_of_birth">'.esc_html( __( 'Date of Birth','church-admin') ).'</option>';
				echo'<option value="email">'.esc_html( __( 'Email Address','church-admin') ).'</option>';
				echo'<option value="mobile">'.esc_html( __( 'Mobile','church-admin') ).'</option>';
				echo'<option value="phone">'.esc_html( __( 'Home phone','church-admin') ).'</option>';
				echo'<option value="address">'.esc_html( __( 'Address','church-admin') ).'</option>';
				echo'<option value="city">'.esc_html( __( 'City','church-admin') ).'</option>';
				echo'<option value="state">'.esc_html( __( 'State','church-admin') ).'</option>';
				echo'<option value="zip_code">'.esc_html( __( 'Zip Code','church-admin') ).'</option>';
				echo'<option value="small_group">'.esc_html( __( 'Small Group','church-admin') ).'</option>';
				echo'<option value="member_type">'.esc_html( __( 'Member Type','church-admin') ).'</option>';
				echo'<option value="ministries">'.esc_html( __( 'Ministries','church-admin') ).'</option>';
				echo'<option value="people_type">'.esc_html( __( 'People Type','church-admin') ).'</option>';
				echo'<option value="show_me">'.esc_html( __( 'Show me (1 or 0)','church-admin') ).'</option>';
				echo'<option value="custom1">'.esc_html( __( 'Custom field 1','church-admin') ).'</option>';
				echo'<option value="custom2">'.esc_html( __( 'Custom field 2','church-admin') ).'</option>';
				echo'<option value="custom3">'.esc_html( __( 'Custom field 3','church-admin') ).'</option>';
				echo'<option value="custom4">'.esc_html( __( 'Custom field 4','church-admin') ).'</option>';
				echo'<option value="custom5">'.esc_html( __( 'Custom field 5','church-admin') ).'</option>';
                echo'<option value="mail_send">'.esc_html( __( 'Mail send (1 or 0)','church-admin') ).'</option>';
                echo'<option value="email_send">'.esc_html( __( 'Email send (1 or 0)','church-admin') ).'</option>';
				echo'<option value="news_send">'.esc_html( __( 'Blog post emails send (1 or 0)','church-admin') ).'</option>';
                echo'<option value="sms_send">'.esc_html( __( 'SMS send (1 or 0)','church-admin') ).'</option>';
                echo'<option value="photo_permission">'.esc_html( __( 'Photo permission (1 or 0)','church-admin') ).'</option>';
				echo'<option value="head_of_household">'.esc_html( __( 'Head of Household (1 or 0)','church-admin') ).'</option>';
				echo'<option value="household_id">'.esc_html( __( 'Household ID (integer)','church-admin') ).'</option>';
				echo'<option value="gdpr_reason">'.esc_html( __( 'GDPR reason','church-admin') ).'</option>';
				foreach( $custom_fields AS $ID=>$field)
				{
					if( $field['section']=='people') echo'<option value=custom_'.$ID.'>'.esc_html( __(  $field['name'].' (custom field)','church-admin') ).'</option>';

				}
				echo'</select>';
				echo'</td>';
				//output examples
				echo'<td>';
				if(!empty( $example1[$key] ) ) 
				{
					echo esc_html( $example1[$key] );
				}
				else {echo '&nbsp;';}
				echo'</td>';
				echo'<td>';
				if(!empty( $example2[$key] ) ) 
				{
					echo esc_html( $example2[$key] );
				}
				else {echo '&nbsp;';}
				echo'</td>';
				echo'<td>';
				if(!empty( $example3[$key] ) ) 
				{
					echo esc_html( $example3[$key] );
				}
				else {echo '&nbsp;';}
				echo'</td>';
				echo'</tr>';
			}
			wp_nonce_field('csv_upload','nonce');
			echo'<tr><td colspan="2"><input type="submit" class="button" value="'.esc_html( __( 'Save','church-admin') ).'"/></td></tr></tbody></table></form>';
		}
	}
	else
	{
		

		echo'<form action="" method="POST" enctype="multipart/form-data">';
		echo'<tr><th scope="row">'.esc_html( __( 'CSV File with 1st row as headers','church-admin') ).'</th><td><input type="file" name="file"/><input type="hidden" name="save_csv" value="yes"/></p>';
		echo'<tr><th scope="row">'.esc_html( __( 'Delete current address details?','church-admin') ).'</th><td><input type="checkbox" name="overwrite" value="yes"/></p>';
		echo'<tr><th colspan=2>'.__('Any entries whose email already has a user account will be connected to that user account (first occurrence only!)','church-admin').'</th></tr>';
		echo'<p><input  class="button-primary" type="submit" Value="'.esc_html( __( 'Upload','church-admin') ).'"/></p></form>';

	}
}
/**
 * add new household.
 *
 * @param
 * @param html display new household
 *
 * @author andy_moyle
 *
 */
function church_admin_new_household()
{
	$debug=TRUE;
	//2016-04-14 Allow duplicate entries
	//v1.05 add middle name

	global $wpdb,$people_type;
	$church_admin_marital_status=get_option('church_admin_marital_status');
	if ( empty( $church_admin_marital_status) )
	{
		$church_admin_marital_status=array(0=>esc_html( __( 'N/A','church-admin')),1=>esc_html( __( 'Single','church-admin') ),
		2=>esc_html( __( 'Co-habiting','church-admin') ),
		3=>esc_html( __( 'Married','church-admin') ),
		4=>esc_html( __( 'Divorced','church-admin') ),
		5=>esc_html( __( 'Widowed','church-admin') )
	);
	update_option('church_admin_marital_status',$church_admin_marital_status);
	}
	$member_type=church_admin_member_type_array();
	$people_type=get_option('church_admin_people_type');
	if(!empty( $_POST['new_household'] ) && check_admin_referer('new-household','nonce') )
	{//process
			if(defined('CA_DEBUG') )church_admin_debug("POST \r\n".print_r( $_POST,TRUE) );
			$return=church_admin_save_household(1,NULL,NULL);//$return is array('household_id','output')
        	if(!empty( $return['output'] ) )
        	{
        		echo $return['output'];
        		echo '<div class="notice notice-success"><p>'.esc_html( __( 'Household Added','church-admin') ).'</p></div>';
        	}
			church_admin_head_of_household_tidy( $return['household_id'] );
			if(!empty( $return['household_id'] ) )church_admin_new_household_display( $return['household_id'] );
				
    }//end process
	else
	{
		echo '<div class="church_admin">';
		  echo '<h2>'.esc_html( __( 'Add new household','church-admin') ).'</h2>';
		  echo'<form action="" method="post"><input type="hidden" name="save" value="yes"/>';
       	    echo church_admin_edit_people_form(1,NULL,NULL);
            echo '<input type="hidden" id="fields" name="fields"  value=1/>';
            echo '<p id="jquerybuttons"><input class="button-primary" type="button" id="btnAdd" value="'.esc_html( __( 'Add another person','church-admin') ).'" /> <input type="button"  disabled=disabled class="button-secondary"  id="btnDel" value="'.esc_html( __( 'Remove person','church-admin') ).'" /></p>';

             echo'<script >
         		jQuery("body").on("focus",".date_of_birth", function()  {
    			jQuery(this).datepicker({dateFormat : "yy-mm-dd",altField:"#"+this(id), changeYear: true ,yearRange: "1910:'.date('Y').'"});
			});</script>';


            echo '<div class="church-admin-form-group"><label>'.esc_html( __( 'Phone','church-admin') ).'</label><input name="phone" type="text"/></div>';
            echo church_admin_address_form(NULL,NULL);

		      echo'<div class="checkbox"><label>'.esc_html( __( 'Private (not shown publicly)','church-admin') ).'<input type="checkbox" name="private" value="1" /></label></div>';
                wp_nonce_field('new-household','nonce');
            echo'<input type="hidden" name="new_entry" value="1"/>';
            echo  '<p><input type="hidden" name="new_household" value="TRUE"/><input  class="button-primary" type="submit" value="'.esc_html( __( 'Save','church-admin') ).'"/></form>';
        echo'</div><!-- .church_admin-->';
    }//form


}


function church_admin_save_household( $member_type_id,$exclude,$household_id)
{
	global $wpdb;
    if ( empty( $member_type_id) )$member_type_id=1;
    if(is_user_logged_in() )$user=wp_get_current_user();
	$out='';
	delete_option('church-admin-directory-output');//get rid of cached directory, so it is updated
	$debug=FALSE;

			$form=$sql=array();
			foreach ( $_POST AS $key=>$value){$form[$key]=sanitize_text_field( $value);}


			if(defined('CA_DEBUG') )church_admin_debug("*************".date('Y-m-d h:i:s')."\r\n"."Save Household\r\n".print_r( $form,TRUE) );
			if ( empty( $household_id) && empty( $form['address'] ) )$household_id=NULL;
		
			if ( empty( $form['phone'] ) )$form['phone']=NULL;
			if ( empty( $form['lat'] ) )$form['lat']=0;
			if ( empty( $form['lng'] ) )$form['lng']=0;
			if ( empty( $household_id) )$household_id=$wpdb->get_var('SELECT household_id FROM '.CA_HOU_TBL.' WHERE address="'.esc_sql( $form['address'] ).'" AND lat="'.esc_sql( $form['lat'] ).'" AND lng="'.esc_sql( $form['lng'] ).'" AND phone="'.esc_sql( $form['phone'] ).'"');



			if ( empty( $household_id)||!empty( $_POST['new_entry'] ) )
			{//insert
				$sql='INSERT INTO '.CA_HOU_TBL.' (address,lat,lng,phone,attachment_id) VALUES("'.esc_sql( $form['address'] ).'", "'.esc_sql( $form['lat'] ).'","'.esc_sql( $form['lng'] ).'","'.esc_sql( $form['phone'] ).'","'.intval( $form['household_attachment_id'] ).'" )';
				if(defined('CA_DEBUG') )church_admin_debug("Inserted Household : $sql\r\n");

	    		$success=$wpdb->query( $sql);
	    		$household_id=$wpdb->insert_id;
	    		if(defined('CA_DEBUG') )church_admin_debug("Inserted Household_id : $household_id \r\n");
			}//end insert
			else
			{//update
				$sql='UPDATE '.CA_HOU_TBL.' SET address="'.esc_sql( $form['address'] ).'" , lat="'.esc_sql( $form['lat'] ).'" , lng="'.esc_sql( $form['lng'] ).'" , phone="'.esc_sql( $form['phone'] ).'", attachment_id="'.intval( $form['household_attachment_id'] ).'" WHERE household_id="'.esc_sql( $household_id).'"';
				//if(defined('CA_DEBUG') )church_admin_debug("Updated Household : $sql\r\n");
	   			$success=$wpdb->query( $sql);


			}//update
            //add updated by
            if(!empty( $user->ID) )  {$user_id=$user->ID;}else{$user_id=0;}
            $wpdb->query('UPDATE '.CA_HOU_TBL.' SET updated_by="'.intval( $user_id).'" WHERE household_id="'.(int)$household_id.'"');
			$sql=array();
			//if(defined('CA_DEBUG') )church_admin_debug("household_id is :".$household_id);
			if(!empty( $_POST['fields'] ) )  {$fields=intval( $_POST['fields'] );}else{$fields=1;}
			for ( $x=1; $x<=$fields; $x++)
      		{
				//Mick - Added to help debug.
				//if(defined('CA_DEBUG') )church_admin_debug("saving person :".$x);
				church_admin_save_person( $x,NULL,$household_id,$exclude);

    		}//add or update people

		/*****************************************************
        * Save Household Custom Fields
        *****************************************************/
        $custom_fields=church_admin_get_custom_fields();

        if(!empty( $custom_fields) )
        {
            $wpdb->query('DELETE FROM '.CA_CUST_MET_TBL.' WHERE household_id="'.(int)$household_id.'"');
            foreach( $custom_fields AS $id=>$field)
            {
                if( $field['section']!='household')continue;
                if(isset( $_POST['custom-'.$id] ) )
                {
                    $sql='INSERT INTO  '.CA_CUST_MET_TBL.' (data,household_id,custom_id) VALUES ("'.esc_sql(stripslashes( $_POST['custom-'.$id] ) ).'","'.(int)$household_id.'","'.(int)$id.'")';
                    if(defined('CA_DEBUG') )church_admin_debug( $sql);
                    $wpdb->query( $sql);
                }
            }

        }



		$head_people_id=church_admin_head_of_household_tidy( $household_id);

        //if(defined('CA_DEBUG') )church_admin_debug("Output :\r\n $out\r\n");
	//reset app address list cache
	delete_option('church_admin_app_address_cache');
	delete_option('church_admin_app_admin_address_cache');
    return array('household_id'=>$household_id,'head_people_id'=>$head_people_id,'output'=> $out,'last_name'=>esc_html(stripslashes( $_POST['last_name1'] ) ),'email'=>$_POST['email1'] );
}


/**
 * Edit people form
 *
 * @param $x,$data
 *
 *
 * @author andy_moyle
 *
 */
function church_admin_edit_people_form( $x=1,$data=null,$exclude=array() )
{
	if ( empty( $exclude) ){
		$exclude=array();
	}
	if ( empty( $x) ){
		$x=1;
	}
	//initialise variables and arrays
	global $wpdb,$people_type,$current_user;

	$required=array();

	$church_admin_marital_status= get_option('church_admin_marital_status');

	$member_type=church_admin_member_type_array();
	$people_type=get_option('church_admin_people_type');

	//start $out
	//Mick  - line move to fron_end_register (setting field value to 1.
	//start cloned area
	$out='<div class="edit-people-form"><div class="clonedInput" id="input'.$x.'">';
	$name=church_admin_formatted_name( $data);

    $out.='<div class="ca-people-form"><h2 class="hndle" data-ID="'.$x.'">'.esc_html( __( 'Person','church-admin') ).' #<span class="person">'.$x.'</span> ';
	if(!empty( $data->first_name)&&!empty( $data->last_name) ){
		$out.= $name;
	}
	$out.=' ('.esc_html( __( 'Click to toggle','church-admin') ).')</h2>';
    $out.='<div class="inside" id="person'.$x.'" ';
	if( $x>1){
		$out.=' style="display:none" ';
	}
	$out.='>';
    $out.='<p>'.esc_html( __( '* required','church-admin') ).'</p>';
    $out.='<input type=hidden value="0" name="people_id[]" id="people_id'.$x.'" />';
     /************************************************
	 * Output Image
	 ***********************************************/
	if(!in_array('image',$exclude) )
	{
		if(!empty( $data->people_id) )  {$people_id=(int)$data->people_id;}else{$people_id=0;}
		$out.='<div class="church-admin-people-image ca-upload-area" data-which="people" data-id="'.$people_id.'" data-nonce="'.wp_create_nonce("people-image-upload").'" id="uploadfile">';
		if(!empty( $data->attachment_id) )
		{
			$person_image_attributes=wp_get_attachment_image_src( $data->attachment_id,'medium','' );
			if ( $person_image_attributes )
			{
				$out.='<img id="people-image'.(int)$data->people_id.'" src="'.$person_image_attributes[0].'" width="'.$person_image_attributes[1].'" height="'.$person_image_attributes[2].'" class="rounded" alt="'.esc_html( $name).'"/>';
			}else
			{
				//image not available although attachment id is saved.
				if(isset( $data->sex) &&$data->sex==1)  {$image='man.svg';}else{$image='woman.svg';}
				$out.='<img id="people-image'.(int)$data->people_id.'"  src="'.plugins_url('/', dirname(__FILE__) ) . 'images/'.$image.'" width="300" height="200" class="rounded current-image" alt="'.esc_html( $name).'"/>';
			}
			$out.='<input id="attachment_id'.(int)$data->people_id.'" type="hidden" name="attachment_id'.(int)$x.'" value="'.(int)$data->attachment_id.'"/>';
		}
		else
		{
			if(isset( $data->sex) &&$data->sex==1)  {$image='man.svg';}else{$image='woman.svg';}
			
			$out.='<img id="people-image'.$people_id.'"  src="'.plugins_url('/', dirname(__FILE__) ) . 'images/'.$image.'" width="300" height="200" class="rounded current-image" alt="'.esc_html( $name).'"/>';
			$out.='<input id="attachment_id'.(int)$people_id.'"  type="hidden" name="attachment_id'.(int)$x.'"/>';
		}
		
		$out.= '<br /><span id="upload-message">'.esc_html(sprintf( __( 'Drag and drop new image for %1$s','church-admin'),$name) ).'</span>';
		$out.='</div>';
		$out.='<p><span id="people-image" data-people-id="'.(int)$people_id.'" class=" button-secondary upload-button button" >'.esc_html( __( 'WordPress Image Uploader','church-admin') ).'</span></p>';
		if(!empty( $data->attachment_id) )  {$attachment_id=(int)$data->attachment_id;}else{$attachment_id=NULL;}
		$out.='<span id="'.$x.'" class="remove-image button-secondary" data-attachment_id="'.(int)$attachment_id.'" data-type="people" data-id="'.(int)$people_id.'">'.esc_html( __( 'Remove image','church-admin') ).'</span>';
	}	
     //first name
    $out.='<div class="church-admin-form-group"><label for="first_name'.(int)$x.'">'.esc_html( __( 'First Name','church-admin') );
   	$out.=' *';
    $out.='</label><input placeholder="'.esc_html( __( 'First Name','church-admin') ).'" type="text" ';
    $out.='required="required" ';
	//mick - added the $x to first_name 
    $out.='data-name="first_name" class="church-admin-form-control" name="first_name'.(int)$x.'"';
    if(!empty( $data->first_name) ) $out.=' value="'.esc_html( $data->first_name).'" ';
    $out.='/></div>';

    //middle name
    $middle_name=get_option('church_admin_use_middle_name');
	if( $middle_name ||!in_array('middle-name',$exclude) )
	{
		$out.='<div class="church-admin-form-group"><label for="middle_name'.(int)$x.'">'.esc_html( __( 'Middle Name','church-admin') );
		 if(in_array('middle_name',$required) )$out.=' *';
		 $out.='</label><input type="text" placeholder="'.esc_html( __( 'Middle Name','church-admin') ).'"';
		  if(in_array('middle_name',$required) )$out.='required="required" ';
		 $out.='  data-name="middle_name" class="church-admin-form-control" name="middle_name'.(int)$x.'" ';
		if(!empty( $data->middle_name) ) $out.=' value="'.esc_html( $data->middle_name).'" ';
    	$out.='/></div>';
    }

    //nickname

	$nickname=get_option('church_admin_use_nickname');
	if(in_array('nickname',$exclude) )$nickname=FALSE;
	if(!empty( $nickname) )
	{
		$out.='<div class="church-admin-form-group"><label for="nickname'.(int)$x.'">'.esc_html( __( 'Nickame','church-admin') );
		 if(in_array('middle_name',$required) )$out.=' *';
		$out.='</label><input type="text" placeholder="'.esc_html( __( 'Nickame','church-admin') ).'" data-name="nickname" class="church-admin-form-control" ';
		 if(in_array('nickname',$required) )$out.='required="required" ';
		$out.='name="nickname'.(int)$x.'" ';
	 	if(!empty( $data->nickname) ) $out.=' value="'.esc_html( $data->nickname).'" ';
    	$out.='/></div>';
    }

    //prefix

	$use_prefix=get_option('church_admin_use_prefix');
	if(in_array('prefix',$exclude) )$use_prefix=FALSE;
	if(!empty( $use_prefix) )
	{
		$out.='<div class="church-admin-form-group"><label for="prefix'.(int)$x.'">'.esc_html( __( 'Prefix e.g. "van der"','church-admin') );
		 if(in_array('prefix',$required) )$out.=' *';
		$out.='</label><input placeholder="'.esc_html( __( 'Prefix e.g. van der','church-admin') ).'" type="text" data-name="prefix" class="church-admin-form-control" ';
		if(in_array('nickname',$required) )$out.='required="required" ';
		$out.=' name="prefix'.(int)$x.'" ';
		if(!empty( $data->prefix) ) $out.=' value="'.esc_html( $data->prefix).'" ';
    	$out.='/></div>';
	}

	//last name
	$out.='<div class="church-admin-form-group"><label for="last_name'.(int)$x.'">'.esc_html( __( 'Last Name','church-admin') );
	$out.=' *';
	$out.='</label><input placeholder="'.esc_html( __( 'Last Name','church-admin') ).'" type="text" required="required" data-name="last_name" class="church-admin-form-control" ';
	if(in_array('last_name',$required) )$out.=' required="required" ';
	$out.='  name="last_name'.(int)$x.'" ';
	if(!empty( $data->last_name) ) $out.=' value="'.esc_html( $data->last_name).'" ';
    $out.='/></div>';
    
	//mobile
    if(!in_array('mobile',$exclude) )
	{
    	$out.='<div class="church-admin-form-group"><label >'.esc_html( __( 'Mobile','church-admin') );
    	if(in_array('mobile',$required) )$out.=' *';
    	$out.='</label><input type="text" data-name="mobile" class="church-admin-form-control" placeholder="'.esc_html( __( 'Mobile','church-admin') ).'"';
    	if(in_array('mobile',$required) )$out.=' required="required"';
    	$out.='  name="mobile'.(int)$x.'" ';
    	if(!empty( $data->mobile) )$out.=' value="'.esc_html( $data->mobile).'" ';
    	$out.='/></div>';
        
        if(church_admin_level_check('Directory') )
        {
            //e164 field
            $out.='<div class="church-admin-form-group"><label ><a href="https://www.churchadminplugin.com/tutorials/e-164-phone-format/" target="_blank">'.esc_html( __( 'Mobile in e.164 format (+Country code and no leading zero, spaces, hyphens or brackets)','church-admin') );
    	   
    	   $out.='</a></label><input type="text" data-name="e164" class="church-admin-form-control" placeholder="'.esc_html( __( 'Mobile in e.164 format','church-admin') ).'"';
    	   
    	   $out.='  name="e164cell'.(int)$x.'" ';
    	   if(!empty( $data->e164cell) )$out.=' value="'.esc_html( $data->e164cell).'" ';
    	   $out.='/></div>';
        }
    }
	//email
	$out.='<div class="church-admin-form-group"><label >'.esc_html( __( 'Email','church-admin') );
	$out.='</label><input type="text" data-name="email" class="church-admin-form-control ca-email" placeholder="'.esc_html( __( 'Email','church-admin') ).'"';
	$out.='  name="email'.(int)$x.'"';
    if(!empty( $data->email) )$out.=' value="'.esc_html( $data->email).'" ';
    $out.='/></div>';

	//date of birth
	if(!in_array('date-of-birth',$exclude) )
	{
		if(!empty( $data->date_of_birth) )  {$dob=$data->date_of_birth;}else{$dob=NULL;}
		$out.= '<div class="church-admin-form-group"><label for="date_of_birth'.(int)$x.'x">'.esc_html( __( 'Date of birth','church-admin') );
		$out.='</label>'. church_admin_date_picker( $dob,'date_of_birth'.(int)$x,FALSE,1910,date('Y'),'date_of_birth','date_of_birth'.(int)$x);
		$out.='</div>';
	}
	if(!in_array('gender',$exclude) )
	{
    	$gender=get_option('church_admin_gender');
		$out.='<div class="church-admin-form-group"><label >'.esc_html( __( 'Gender','church-admin') ).'</label><select name="sex'.(int)$x.'" class="sex church-admin-form-control" >';
		$first=$option='';

		foreach( $gender AS $key=>$value)
		{
			if(isset( $data->sex)&&$data->sex == $key)
				{
					$first= '<option value="'.esc_html( $key).'" selected="selected">'.esc_html( $value).'</option>';
				}
				else
				{
					$option.= '<option value="'.esc_html( $key).'" >'.esc_html( $value).'</option>';
				}

		}
		$out.=$first.$option.'</select></div>'."\r\n";
	}
	//marital status
	if(!in_array('marital-status',$exclude) )
	{
		$church_admin_marital_status=get_option('church_admin_marital_status');
		$out.='<div class="church-admin-form-group"><label for="marital_status'.(int)$x.'">'.esc_html( __( 'Marital Status','church-admin') ).'</label><select name="marital_status'.(int)$x.'" id="marital_status'.(int)$x.'" class="marital_status church-admin-form-control">';
    	$first=$option='';
    	foreach( $church_admin_marital_status AS $id=>$type)
    	{

    		if(!empty( $data->marital_status)&& $data->marital_status==$type)
    		{
    			$first='<option value="'.$id.'" selected="selected">'.$type.'</option>'."\r\n";
    		}else $option.='<option value="'.$id.'">'.$type.'</option>'."\r\n";
    	}
    	$out.=$first.$option.'</select></div>'."\r\n";
	}

	//person type
	$out.='<div class="church-admin-form-group"><label for="people_type_id'.(int)$x.'">'.esc_html( __( 'Person type','church-admin') ).'</label><select name="people_type_id'.(int)$x.'"  class="people_type_id church-admin-form-control">';
    $first=$option='';
    foreach( $people_type AS $id=>$type)
    {

    	if(!empty( $data->people_type_id)&& $id==$data->people_type_id)
    	{
    		$first='<option value="'.$id.'" selected="selected">'.$type.'</option>'."\r\n";
    	}else $option.='<option value="'.$id.'">'.$type.'</option>'."\r\n";


    }
    $out.=$first.$option.'</select></div>'."\r\n";
	
	/*****************************************
    * User bio
    ****************************************/
	if(!empty( $data->user_id) && user_can( $data->user_id, 'edit_posts' ) )
	{
		$bio=get_user_meta( $data->user_id,'description',TRUE);
		$allowed_html = wp_kses_allowed_html( 'data' );
		$out.='<div class="church-admin-form-group"><label >'.esc_html( __( 'Bio for user','church-admin') ).'</label><textarea name="bio'.(int)$x.'" style="height:150px" class="church-admin-form-control">';
		if(!empty( $bio) )$out.=wp_kses( $bio,$allowed_html);
		$out.='</textarea></div>';
	}

   	//small groups
	if(!in_array('small-groups',$exclude) )
	{
		$out.='<h3>'.esc_html( __( 'Small Group','church-admin') ).'</h3>';
		$smallgroups=$wpdb->get_results('SELECT * FROM '.CA_SMG_TBL);
		if(!empty( $smallgroups) )
		{
			if(!empty( $data->people_id) )$dataSmallGroups=church_admin_get_people_meta( $data->people_id,'smallgroup');
			foreach( $smallgroups AS $smallgroup)
			{
				$out.='<div class="checkbox"><label><input type="checkbox" data-name="smallgroup_id"  name="smallgroup_id'.(int)$x.'[]" value="'.intval( $smallgroup->id).'" ';
				if(!empty( $dataSmallGroups) && in_array( $smallgroup->id,$dataSmallGroups) ) $out.=' checked="checked" ';
				$out.='/> '.esc_html( $smallgroup->group_name).'</label></div>'."\r\n";
			}
			
		}
		
		$out.='<div class="church-admin-form-group"><label>'.esc_html( __( 'Or add a new small group','church-admin') ).'</label><input id="smallgroup'.(int)$x.'" data-name="smallgroup" class="church-admin-form-control" type="text" name="smallgroup'.(int)$x.'" placeholder="'.esc_html( __( 'Add New Small Group','church-admin') ).'"/>';
		$out.= '</div>';
	}

	if(!in_array('classes',$exclude) )
	{
		//classes
		$classes=$wpdb->get_results('SELECT * FROM '.CA_CLA_TBL.' WHERE end_date>NOW()');
		if(!empty( $classes) )
		{
			$out.='<h3>'.esc_html( __( 'Classes','church-admin') ).'</h3>';
			if(!empty( $data->people_id) )$dataClasses=church_admin_get_people_meta( $data->people_id,'classes');

			foreach( $classes AS $class)
			{
				$out.='<div class="checkbox"><label><input type="checkbox" data-name="class_id"  name="class_id'.(int)$x.'[]" value="'.(int)$class->class_id.'" ';
				if(!empty( $dataClasses) && in_array( $class->class_id,$dataClasses) ) $out.=' checked="checked" ';
				$out.='/> '.esc_html(sprintf(__( '%1$s starting %2$s','church-admin'),$class->name,mysql2date(get_option('date_format'),$class->next_start_date) ) ).'</label></div>'."\r\n";
			}
			
		}
	}
	//socials
	$socials=get_option('church-admin-socials');
	if(in_array('socials',$exclude) ){
		$socials=FALSE;
	}

	if(!empty( $socials) ){
		$out.='<h3>Socials</h3><div class="church-admin-form-group"><label>'.esc_html( __( 'Facebook username','church-admin') ).'</label><input type="text" data-name="facebook" class="church-admin-form-control" name="facebook'.$x.'" ';
		if(!empty( $data->facebook) ) $out.='value="'.esc_html( $data->facebook).'" ';
		$out.='/></div>';
		$out.='<div class="church-admin-form-group"><label>'.esc_html( __( 'Instagram username','church-admin') ).'</label><input data-name="instagram" class="church-admin-form-control" type="text" name="instagram'.$x.'" ';
		if(!empty( $data->instagram) ) $out.='value="'.esc_html( $data->instagram).'" ';
		$out.='/></div>';
		$out.='<div class="church-admin-form-group"><label>'.esc_html( __( 'Twitter username','church-admin') ).'</label><input data-name="twitter" class="church-admin-form-control" type="text" name="twitter'.$x.'" ';
		if(!empty( $data->twitter) ) $out.='value="'.esc_html( $data->twitter).'" ';
		$out.='/></div>';
		
	}


	/*************************************
	*
	*	Member levels for authorised users
	*
	*************************************/
	$directory_permission=church_admin_level_check('Directory');

	if( $directory_permission)
	{
		$first=$option='';
		$out.='<div class="church-admin-form-group"><label for="member_type'.(int)$x.'">'.esc_html( __( 'Member type','church-admin') ).'</label><select name="member_type_id'.(int)$x.'"  data-name="member_type_id" class="church-admin-form-control">';
        foreach( $member_type AS $id=>$type)
        {
        	if(!empty( $data->member_type_id) && $data->member_type_id==$id)
        	{	$first.= '<option value="'.$id.'" selected="selected" >'.$type.'</option>';
        	}
        	else
        	{
        		$option.='<option value="'.$id.'">'.$type.'</option>';
        	}
        }
        $out.=$first.$option.'</select></div>';
		//member_type_id

		//if(!empty( $data->member_data) )$prev_member_types=maybe_unserialize( $data->member_data);
		$prev_member_types=array();
		if(!empty( $data->people_id) )
		{
			$prev_member_types_res=$wpdb->get_results('SELECT ID,meta_date FROM '.CA_MET_TBL.' WHERE meta_type="member_date" AND people_id="'.intval( $data->people_id).'"');
			if(!empty( $prev_member_types_res) )
			{

				foreach( $prev_member_types_res AS $prevMTrow)
				{
					$prev_member_types[$prevMTrow->ID]=$prevMTrow->meta_date;
				}
			}
		}
		if(!in_array('member-dates',$exclude) )
		{
	    	$out.='<h3 >'.esc_html( __( 'Dates of Member Levels','church-admin') ).'</h3>';
	    	foreach( $member_type AS $key=>$value)
	    	{


	    		if ( empty( $prev_member_types[$key] ) )$prev_member_types[$key]=NULL;
	    		if ( empty( $value) )$value='';

				$out.='<div class="church-admin-form-group"><label>'.$value.'</label>'. 			church_admin_date_picker( $prev_member_types[$key],'mt-'.(int)$key.'-'.$x,FALSE,1910,date('Y'),'mt-'.(int)$key,'mt-'.(int)$key.'-'.$x).'</div>';

			}
			$out.="\r\n";
		}

	}
	else
	{
		/***************************************************************************************
		*
		* user cannot adjust member_type, but we must set to mailing list or keep current level
		*
		***************************************************************************************/
		if(!empty( $data->member_type_id) )  {$member_type_id=intval( $data->member_type_id);}else{$member_type_id=1;}
			$out.='<input type="hidden" data-name="member_type_id"  name="member_type_id'.(int)$x.'" value="'.$member_type_id.'"/>';
		
	}
	/*************************************
	*
	*	Ministries, for authorised users
	*
	*************************************/
	//These next two lines  needed for prayer and bible readings
	if(!empty( $data->people_id) )$personsMinistries=church_admin_get_people_meta( $data->people_id,'ministry');
	$ministries=church_admin_ministries_array();
	if( $directory_permission&&!in_array('ministries',$exclude) ){
		//ministries if allowed

		$out.='<h3 >'.esc_html( __( 'Ministries','church-admin') ).'</h3>';
		foreach( $ministries AS $ministry_id=>$ministry)
		{
			$out.='<div class="checkbox"><label><input type="checkbox" data-name="ministry_id" name="ministry_id'.(int)$x.'[]" value="'.intval( $ministry_id).'" ';
			if(!empty( $personsMinistries) && in_array( $ministry_id,$personsMinistries) ) $out.=' checked="checked" ';
			$out.='/>&nbsp;'.esc_html( $ministry).'</label></div>';

		}
		
	}

	//site
	$sites=$wpdb->get_results('SELECT venue,site_id FROM '.CA_SIT_TBL.' ORDER BY venue ASC');
	if( $wpdb->num_rows>1){
		$out.='<div class="church-admin-form-group"><label >'.esc_html( __( 'Site','church-admin') ).'</label> <select name="site_id'.(int)$x.'" data-name="site_id" class="church-admin-form-control">';
		$first=$option='';
		foreach( $sites AS $site)
		{
			if(!empty( $data->site_id)&& $data->site_id==$site->site_id)
			{
				$first.='<option value="'.intval( $site->site_id).'" selected="selected">'.esc_html( $site->venue).'<option>';
			}
			else
			{
				$option.='<option value="'.intval( $site->site_id).'">'.esc_html( $site->venue).'<option>';
			}
		}
		 $out.=$first.$option.'</select></div>';
    }
    else{
        if(!empty( $sites[0]->venue) )  {$site=esc_html( $sites[0]->venue);}else{$site='&nbsp;';}
        if(!empty( $sites[0]->site_id) )  {$site_id=intval( $sites[0]->site_id);}else{$site_id=1;}
			$out.='<div class="church-admin-form-group"><label >'.esc_html( __( 'Site','church-admin') ).'</label> '.$site;
    	$out.='<input type="hidden" data-name="site_id" name="site_id'.(int)$x.'" value="'.$site_id.'"/></div>';
    }

    

	/*****************************************************
	*
	* Custom Fields
	*
	*****************************************************/
	$custom_fields=church_admin_get_custom_fields();

	if(!empty( $custom_fields)&&!in_array('custom',$exclude) )
	{
		foreach( $custom_fields AS $id=>$field)
		{
			if( $field['section']!="people")continue;
			$dataField='';
			if(!empty( $data->people_id) )$dataField=$wpdb->get_var('SELECT data FROM '.CA_CUST_MET_TBL .' WHERE people_id="'.intval( $data->people_id).'" AND custom_id="'.(int)$id.'"');
			$out.='<div class="church-admin-form-group"><label >'.esc_html( $field['name'] ).'</label>';
			switch( $field['type'] )
			{
				case 'boolean':
					$out.='<input type="radio" data-name="custom-'.(int)$id.'" class="church-admin-form-control"  value="1" name="custom-'.(int)$id.'-'.(int)$x.'" ';
					if (isset( $dataField)&&$dataField==1)
						$out.= 'checked="checked" ';
					$out.='>'.esc_html( __( 'Yes','church-admin') ).'<br /> <input type="radio" data-name="custom-'.(int)$id.'" class="church-admin-form-control" value="0" name="custom-'.(int)$id.'-'.(int)$x.'" ';
					if (isset( $dataField)&& $dataField==0)
						$out.= 'checked="checked" ';
					$out.='>'.esc_html( __( 'No','church-admin') );
					break;
				case'text':
					$out.='<input type="text" data-name="custom-'.(int)$id.'" class="church-admin-form-control"  name="custom-'.(int)$id.'-'.(int)$x.'" ';
					if(!empty( $dataField)||isset( $field['default'] ) )$out.=' value="'.esc_html( $dataField).'"';
					$out.='/>';
				break;
				case'date':
					$out.= church_admin_date_picker( $dataField,'custom-'.(int)$id.'-'.$x,FALSE,1910,date('Y'),'custom-'.(int)$id,'custom-'.(int)$id.'-'.$x);

				break;
			}
			$out.='</div>';

		}

	}

	/*****************************************************
	*
	* Privacy and comms permissions
	*
	*****************************************************/
	$out.='<h3>'.esc_html( __( 'Privacy','church-admin') ).'</h3>';
    $out.='<h2>'.esc_html( __( 'I give permission...','church-admin') ).'</h2>';
	$out.='<div class="checkbox"><label ><input type="checkbox" name="email_send'.$x.'" value="TRUE" id="email_send" class="email-permissions" data-name="email_send"  ';
	if(!empty( $data->email_send)||empty( $data) ) $out.=' checked="checked" ';
	$out.=' /> '.esc_html( __( 'To receive email','church-admin') ).'</label></div>';
	$out.='<p><strong>'.esc_html( __( 'Refine type of email you can receive','church-admin') ).'</strong></p>';
	$out.='<div class="checkbox"><label ><input type="checkbox" name="news_send'.$x.'" value="TRUE" id="news_send" class="email-permissions" data-name="news_send"  ';
	if(!empty( $data->people_id) ){
		$news_send=$wpdb->get_var('SELECT meta_id FROM '.CA_MET_TBL.' WHERE people_id="'.(int)$data->people_id.'" AND meta_type="posts"');
	
	}
	
	if(!empty($news_send)) $out.=' checked="checked" ';
	$out.=' /> '.esc_html( __( 'To receive blog post email','church-admin') ).'</label></div>';
	$noPrayer=get_option('church-admin-no-prayer');
	if ( empty( $noPrayer) ){
		$out.='<div class="checkbox"><label ><input type="checkbox" value="1"  data-name="prayer_chain" id="prayer_requests" class="email-permissions" name="prayer_chain'.$x.'" ';
		if(!empty( $data->people_id) )$prayer=$wpdb->get_var('SELECT meta_id FROM '.CA_MET_TBL.' WHERE people_id="'.intval( $data->people_id).'" AND meta_type="prayer-requests"');
		if(!empty( $prayer) ) $out.=' checked="checked" ';
		$out.=' /> '.esc_html( __( 'To receive Prayer requests by email','church-admin') ).'</label></div>';
	}
	$noBibleReadings=get_option('church-admin-no-bible-readings');
	if ( empty( $noBibleReadings) ){
		$out.='<div class="checkbox"><label ><input type="checkbox" value="1" data-name="bible_readings" id="bible_readings" class="email-permissions" name="bible_readings'.$x.'" ';
		if(!empty( $data->people_id) )$bible=$wpdb->get_var('SELECT meta_id FROM '.CA_MET_TBL.' WHERE people_id="'.intval( $data->people_id).'" AND meta_type="bible-readings"');
		if(!empty( $bible) ) $out.=' checked="checked" ';
		$out.=' /> '.esc_html( __( 'To receive new Bible Reading notes by email','church-admin') ).'</label></div>';
		
	}
	$out.='<p><strong>'.esc_html( __( 'Other privacy permissions','church-admin') ).'</strong></p>';
	$out.='<div class="checkbox"><label ><input type="checkbox" name="sms_send'.$x.'" value="TRUE" data-name="sms_send"  ';
	if(!empty( $data->sms_send)||empty( $data) ) {
		$out.=' checked="checked" ';
	}
	$out.=' /> '.esc_html( __( 'To receive SMS','church-admin') ).'</label></div>';
	
	
	
    
    $out.='<div class="checkbox"><label ><input type="checkbox" name="phone_calls'.$x.'" value="TRUE" data-name="phone_calls"  ';
	if(!empty( $data->phone_calls)||empty( $data) ){
		 $out.=' checked="checked" ';
	}
	$out.=' /> '.esc_html( __( 'To receive phone calls','church-admin') ).'</label></div>';
    
    $out.='<div class="checkbox"><label ><input type="checkbox" name="photo_permission'.$x.'" value="TRUE" data-name="photo_permission"  ';
	if(!empty( $data->photo_permission)||empty( $data) ){
		 $out.=' checked="checked" ';
	}
	$out.=' /> '.esc_html( __( 'To show photos of me on the website','church-admin') ).'</label></div>';

	$out.='<div class="checkbox"><label>';
    $out.='<input type="checkbox" name="show_me'.$x.'" value="TRUE" data-name="show_me"  ';
	if(!empty( $data->show_me) ){
		$out.='checked="checked" ';
	}
	$out.='/>';
	$out.=esc_html( __( 'To show me on the password protected address list','church-admin') );
	$out.='</label></div>';

	$out.='<p><strong>'.__('Refine address list privacy','church-admin').'</strong></p>';
	$fine_privacy=!empty($data->privacy)?maybe_unserialize($data->privacy):array();
	//show email
	$out.='<div class="checkbox"><input type="checkbox" name="show-email'.$x.'" id="show-email" ';
	if(!empty( $fine_privacy['show-email']) )  {$out.=' checked ="checked" ';}
	$out.='/> '.__("Show email address",'church-admin').' </div>';
	//show cell
	$out.='<div class="checkbox"><input type="checkbox" name="show-cell'.$x.'" id="show-cell" ';
	if(!empty( $fine_privacy['show-cell']) )  {$out.=' checked ="checked" ';}
	$out.='/> '.__("Show cell number",'church-admin').' </div>';
	//show landline
	$out.='<div class="checkbox"><input type="checkbox" name="show-landline'.$x.'" id="show-landline"  ';
	if(!empty( $fine_privacy['show-landline']) )  {$out.=' checked ="checked" ';}
	$out.='/> '.__("Show landline",'church-admin').' </div>';
	//show address
	$out.='<div class="checkbox"><input type="checkbox" name="show-address'.$x.'" id="show-address"  ';
	if(!empty( $fine_privacy['show-address']) )  {$out.=' checked ="checked" ';}
	$out.='/> '.__("Show address",'church-admin').' </div><p>&nbsp;</p>';





    $gdpr=get_option('church_admin_gdpr');

	if( $directory_permission){
		$first=$option='';
		$out.='<div class="church-admin-form-group"><label >'.esc_html( __( 'How data permission is given','church-admin') ).'</label><input name="gdpr'.$x.'" type="text" data-name="gdpr" class="church-admin-form-control" ';
		if(!empty( $data->gdpr_reason) )$out.=' value="'.esc_html( $data->gdpr_reason).'" ';
		$out.='/></div>';
		
	}
	else{
		
		$out.='<input type="hidden"  name="gdpr'.$x.'" ';
		if(!empty( $data->gdpr_reason) )  {
			$out.='value="'.esc_html( $data->gdpr_reason).'"';
		}else{
			$out.'value="'.esc_html(esc_html( __( 'User registered on the website','church-admin') ) ).'"';
		}
		$out.='/>';
	}
    
		/*****************************************************
		*
		* user_id,head_of_household
		*
		*****************************************************/
		//MICK WALL
		//Make user_id post value have the index of the user being edited  - so user_id1, user_id2 etc.
		if(!empty( $data->user_id) )$out.='<input type="hidden" data-name="user_id" name="user_id'.$x.'" value="'.intval( $data->user_id).'"/>';
        if(!empty( $data->head_of_household) )$out.='<input type="hidden" data-name="head_of_household" name="head_of_household'.(int)$x.'" value="'.intval( $data->head_of_household).'"/>';
        if(!empty( $data->people_order) )
        {
            $out.='<input type="hidden" data-name="people_order" name="people_order'.(int)$x.'" value="'.intval( $data->people_order).'"/>';
        }
    $out.='<script>jQuery(document).ready(function( $)  {
            
		if( $("#email_send").prop("checked")== false)
		{
			console.log("Unchecking");
			$("#news_send").prop( "checked", false );
			$("#prayer_requests").prop( "checked", false );
			$("#bible_readings").prop( "checked", false );
		}
		
		$(".email-permissions").change(function()
		{
			var id=$(this).attr("id");
			switch(id)
			{
				case "email_send":
					console.log("email send changed");
					if( $(this).prop("checked")==false)
					{
						$("#news_send").prop( "checked", false );
						$("#prayer_requests").prop( "checked", false );
						$("#bible_readings").prop( "checked", false );
					}
				break;
				case "news_send":
				case "prayer_requests":
				case "bible_readings":
					console.log("other checkbox changed");
					if( $(this).prop("checked") ) 
					{
						console.log("Other checked");
						$("#email_send").prop("checked", true);
					}
				break;
			}
		   
		});
		
		});
	</script>';
    $out.='</div><!-- .ca-people-form-->';
    $out.='</div><!-- .cloned-input --></div></div>';
	if( $x==1)
	{
		if(is_admin() )
		{
			$out.='<script >jQuery(document).ready(function( $)  {
				$( "body" ).on("click",".hndle",function()  {
						console.log("person clicked")
						console.log("all data: "+ $(this).data() );
						var id=$(this).data("people-id");
						console.log("Person\'s id "+id);
						$("#person"+id).toggle();
					});
					//remove image
					$(".remove-image").click(function()
					{
						console.log("REMOVE IMAGE");
						var type= $(this).data("type");
						var attachment_id=$(this).data("attachment_id");
						var peopleID=$(this).data("id");
						var imageid=$(this).attr("id");
						var nonce="'.wp_create_nonce("remove-image").'";
						var data={"action":"church_admin","method":"remove-image","type":type,"attachment_id":attachment_id,"id":peopleID,"nonce":nonce};
						console.log("Data to send");
						console.log(data);
						$.ajax({
											url: ajaxurl,
											type: "POST",
											data: data,
											success: function(res) {
												console.log("Response " + res);
												$("#upload-message").html("'.esc_html( __( 'Image Deleted. Drag and drop new image.','church-admin' ) ).'<br />");
												$("#people-image"+res).attr("src","'.plugins_url('/', dirname(__FILE__) ) . 'images/man.svg");
												$("#people-image"+res).attr("srcset","");
												$("#attachment_id"+res).val("");
											},
											error: function(res) {
										$("#upload-message").html("Error deleting<br />");
											}
										});
					});


					var mediaUploader;

					$(".upload-button").click(function(e) {
						console.log("Upload button clicked");
						e.preventDefault();
						var id="#attachment_id"+$(this).data("people-id");
						var peopleID=$(this).data("people-id");
						console.log("Attachment id: "+id);
						// If the uploader object has already been created, reopen the dialog
						if (mediaUploader) {
						mediaUploader.open();
						return;
						}
						// Extend the wp.media object
						mediaUploader = wp.media.frames.file_frame = wp.media({
						title: "Choose Image",
						button: {
						text: "Choose Image"
						}, multiple: false });

						// When a file is selected, grab the URL and set it as the text fields value
						mediaUploader.on("select", function() {
						var attachment = mediaUploader.state().get("selection").first().toJSON();
						console.log("Attachment details");
						console.log(attachment);
						$(id).val(attachment.id);
						
						if(typeof attachment.sizes.medium !=="undefined")
						{
							console.log("Image id: " +"#people-image"+peopleID);
							console.log("Medium "+ attachment.sizes.medium.url);
							$("#people-image"+peopleID).attr("src",attachment.sizes.medium.url);
							$("#upload-message").html("'.esc_html( __( 'Image uploaded','church-admin') ).'");
						}
						else
						{
							console.log("Medium "+ attachment.sizes.full.url);
							$("#people-image"+peopleID).attr("src",attachment.sizes.full.url);
						}
						$("#people-image"+peopleID).attr("srcset",null);
					});
						// Open the uploader dialog
						mediaUploader.open();
					});
				

				});</script>';

    

		}
	}
    return $out;
}


/**
 * save a person using POST with $x
 *
 * @param $_POST,$x,$people_id,$household_id
 *
 *
 * @author andy_moyle
 *
 */
function church_admin_save_person( $x=1,$people_id=NULL,$household_id=NULL,$exclude=array() )
{

    global $wpdb;
    if(is_user_logged_in() )
    {
        $user=wp_get_current_user();
        
    }
	/************************************
	 * GET $old_email for MailChimp sync
	 ************************************/
    if(!empty( $people_id) )
	{
		$old_email=$wpdb->get_var('SELECT email FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
	}
	else
	{
		$old_email=NULL;
	}
	
	
	
	$member_type=church_admin_member_type_array();
	$people_type=get_option('church_admin_people_type');
	$church_admin_marital_status= get_option('church_admin_marital_status');
	$out='';
	//sanitise form input

    	$form=array();
    	foreach( $_POST AS $key=>$value) $form[$key]=church_admin_sanitize( $value );

    	//prepare and check odd data
		if ( empty( $_POST['data_of_birth'.$x] )&&!empty( $_POST['date_of_birth'.$x.'x'] ) )$form['date_of_birth'.$x]=date('Y-m-d',strtotime( $_POST['date_of_birth'.$x.'x'] ) );
		if(!empty( $_POST['date_of_birth'.$x] )&& church_admin_checkdate( $_POST['date_of_birth'.$x] ) )  {$form['date_of_birth1']=$_POST['date_of_birth'.$x];}else{$form['date_of_birth'.$x]=NULL;}
    	if(!empty( $_POST['attachment_id'.$x] ) )  {$form['attachment_id'.$x]=intval( $_POST['attachment_id'.$x] );}else{if(!empty( $data->attachment_id) )$form['attachment_id'.$x]=intval( $data->attachment_id);}

    	//build data array for query
    	$data=array();
    	$data['user_id']			=	!empty( $form['user_id'.$x] )?intval( $form['user_id'.$x] ):NULL;
    	//solve issue of new ID getting formed.
		if(!empty( $form['ID'] ) )$data['user_id']=intval( $form['ID'] );
		if ( empty( $exclude) )$exclude=array();

		$data['attachment_id']=!empty( $form['attachment_id'.$x] )?intval( $form['attachment_id'.$x] ):0;
    	$data['people_type_id']		=	!empty( $form['people_type_id'.$x] )?intval( $form['people_type_id'.$x] ):1;
    	$data['household_id']		=	!empty( $household_id)?(int)$household_id:NULL;
    	$data['member_type_id']		=	isset( $form['member_type_id'.$x] )?intval( $form['member_type_id'.$x] ):1;
    	$data['first_name']			=	!empty( $form['first_name'.$x] )?trim( $form['first_name'.$x] ):"";
    	if(!in_array('nickname',$exclude) )$data['nickname']			=	!empty( $form['nickname'.$x] )?trim( $form['nickname'.$x] ):"";
    	if(!in_array('middlename',$exclude) )$data['middle_name']		=	!empty( $form['middle_name'.$x] )?trim( $form['middle_name'.$x] ):"";
    	if(!in_array('prefix',$exclude) )$data['prefix']				=	!empty( $form['prefix'.$x] )?trim( $form['prefix'.$x] ):"";
    	$data['last_name']			=	!empty( $form['last_name'.$x] )?trim( $form['last_name'.$x] ):"";
    	$data['email']				=	!empty( $form['email'.$x] )?$form['email'.$x]:"";
    	$data['mobile']				=	!empty( $form['mobile'.$x] )?$form['mobile'.$x]:"";
        if(!empty( $form['mobile'.$x] )&& empty( $form['e164cell'.$x] ) )  {
			$data['e164cell']=church_admin_e164( $form['mobile'.$x] );
		}else{
			$data['e164cell']= !empty( $form['e164cell'.$x] ) ? esc_sql( $form['e164cell'.$x] ) : NULL;
		}
    	if(!in_array('socials',$exclude) )$data['facebook']			=	!empty( $form['facebook'.$x] )?$form['facebook'.$x]:"";
    	if(!in_array('socials',$exclude) )$data['twitter']			=	!empty( $form['twitter'.$x] )?$form['twitter'.$x]:"";
    	if(!in_array('socials',$exclude) )$data['instagram']			=	!empty( $form['instagram1'] )?$form['instagram'.$x]:"";
    	if(!in_array('date-of-birth',$exclude) )$data['date_of_birth']		=	!empty( $form['date_of_birth'.$x] )?$form['date_of_birth'.$x]:NULL;
    	if(!in_array('marital-status',$exclude) )$data['marital_status']		=	isset( $form['marital_status'.$x] )?$church_admin_marital_status[$form['marital_status'.$x]]:0;
    	if(!in_array('image',$exclude) )$data['attachment_id']		=	!empty( $form['attachment_id'.$x] )?$form['attachment_id'.$x]:0;
    	//must use isset as female is  0 and !empty(0) returns false!
    	$data['sex']				=	isset( $form['sex'.$x] )?intval( $form['sex'.$x] ):1;
    	//$data['prayer_chain']		=	isset( $form['prayer_chain'.$x] )?1:0;//deprecated 1.2608, now part of ministries
    	$data['site_id']			=	isset( $form['site_id'.$x] )?intval( $form['site_id'.$x] ):1;
    	$data['email_send']			=	!empty( $form['email_send'.$x] )?1:0;
		$data['news_send']			=	!empty( $form['news_send'.$x] )?1:0;
        $data['phone_calls']			=	!empty( $form['phone_calls'.$x] )?1:0;
    	$data['sms_send']			=	!empty( $form['sms_send'.$x] )?1:0;
    	$data['mail_send']			=	!empty( $form['mail_send'.$x] )?1:0;
        $data['photo_permission']	=	!empty( $form['photo_permission'.$x] )?1:0;
		$data['show_me']			= 	!empty( $form['show_me'.$x] )?1:0;
    	$data['gdpr_reason']		=	!empty( $form['gdpr'.$x] )?$form['gdpr'.$x]:"";
     	$data['kidswork_override']	=	!empty( $form['kidswork_override'.$x] )?$form['kidswork_override'.$x]:"0";
		if ( empty( $form['people_order'.$x] ) )
        {
            $data['people_order']=(int)$x;
        }
        else{$data['people_order']=intval( $form['people_order'.$x] );}
		$data['head_of_household']	=	isset( $form['head_of_household'.$x] )?intval( $form['head_of_household'.$x] ):0;
		 //privacy
		 $privacy=array();
		 if(!empty($_POST['show-email'.$x])){$privacy['show-email']=1;}
		 if(!empty($_POST['show-cell'.$x])){$privacy['show-cell']=1;}
		 if(!empty($_POST['show-landline'.$x])){$privacy['show-landline']=1;}
		 if(!empty($_POST['show-address'.$x])){$privacy['show-address']=1;}
		 $data['privacy']=serialize($privacy);
	
		church_admin_debug($data);
		//front_end_register doesn't pass people_id so let's check they are not in first...
		if ( empty( $people_id) )
    	{
					$people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$household_id.'" AND first_name="'.esc_sql( $data['first_name'] ).'" AND last_name="'.esc_sql( $data['last_name'] ).'" AND people_type_id = "'.esc_sql( $data['people_type_id'] ).'"');
		}
		if(!empty( $people_id) )
		{
			
			$SET=array();
			foreach( $data AS $key=>$value) {$SET[]=' '.$key.'="'.esc_sql( $value).'"';}
			$sql='UPDATE '.CA_PEO_TBL.' SET '.implode(",",$SET).' WHERE people_id="'.(int)$people_id.'"' ;
   		}
		else
		{
			
			
			$columns=$rows=array();
			foreach( $data AS $key=>$value)  {$columns[]=$key; $rows[]=esc_sql( $value);}
           
			$sql='INSERT INTO '.CA_PEO_TBL.' ('.implode(", ",$columns).') VALUES ("'.implode('", "',$rows).'")';
		}
		//if(defined('CA_DEBUG') )church_admin_debug("Person update/insert \r\n".$sql);
		$wpdb->query( $sql);
		church_admin_debug($sql);
		if ( empty( $people_id) )$people_id=$wpdb->insert_id;


		



		
	   	/**************************************
		* add updated by tp people table
		**************************************/
        if(!empty( $user->ID) )  {$user_id=$user->ID;}else{$user_id=0;}
        $wpdb->query('UPDATE '.CA_PEO_TBL.' SET updated_by="'.(int)$user_id.'" WHERE people_id="'.(int)$people_id.'"');
		$wpdb->query('DELETE FROM '.CA_MET_TBL .' WHERE people_id="'.(int)$people_id.'"');
		if(!empty( $user->ID) )  {$user_id=$user->ID;}else{$user_id=0;}
        $wpdb->query('UPDATE '.CA_HOU_TBL.' SET updated_by="'.(int)$user_id.'" WHERE household_id="'.(int)$data['household_id'].'"');
    	
    	
		if ( empty( $people_id) )  {
            $people_id=$wpdb->insert_id;
            if(defined('CA_DEBUG') )church_admin_debug("People_id:".$people_id);
        }
		//create user if necessary
    	if(!empty( $_POST['username'] )&&church_admin_level_check('Directory') )church_admin_create_user( $people_id,$household_id,stripslashes( $_POST['username'] ) );
		/***************
		 * USER bio
		 ****************/
		//user bio
        $user_id=$wpdb->get_var('SELECT user_id FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
        if(!empty( $user_id)&&!empty( $_POST['bio'.$x] ) )
        {
            update_user_meta( $user_id,'description',stripslashes( $_POST['bio'.$x] ) );
        }
		/*************************************************************
		*
		*    Member level dates
		*
		***************************************************************/
			

			if(is_array( $exclude)&&!in_array('member-dates',$exclude) )
			{
				//handle member type dates


				foreach( $member_type AS $id=>$type)
				{

					if(!empty( $_POST['mt-'.$id.'-'.$x] ) && church_admin_checkdate( $_POST['mt-'.$id.'-'.$x] ) )
					{
						church_admin_update_people_meta( $id,$people_id,'member_date',$_POST['mt-'.$id.'-'.$x] );

					}
				}
			}
			/*************************************************************
			*
			*    Small Group
			*
			***************************************************************/
		$wpdb->query('DELETE FROM '.CA_MET_TBL.' WHERE people_id="'.(int)$people_id.'" AND meta_type="smallgroup"');
		//handle new smallgroup
		if(!empty( $_POST['smallgroup'.$x] ) )
		{

				$check=$wpdb->get_var('SELECT id FROM '.CA_SMG_TBL.' WHERE group_name="'.esc_sql(stripslashes( $_POST['smallgroup'.$x] ) ).'"');
				if(!empty( $check) )  {church_admin_update_people_meta( $check,$people_id,'smallgroup');}
				else
				{
					$wpdb->query('INSERT INTO '.CA_SMG_TBL.' (group_name) VALUES("'.esc_sql(stripslashes( $_POST['smallgroup'.$x] ) ).'")');
					$id=$wpdb->insert_id;
					church_admin_update_people_meta( $id,$people_id,'smallgroup');
				}

		}
		
		if(!empty( $_POST['smallgroup_id'.$x] ) )
		{
			foreach( $_POST['smallgroup_id'.$x] AS $key=>$id)
			{

					church_admin_update_people_meta( $id,$people_id,'smallgroup');
			}
		}
        else
        {
            if(defined('CA_DEBUG') )church_admin_debug('Need to put '.$people_id.' in unattached');
            church_admin_update_people_meta(1,$people_id,'smallgroup');
        }
		//classes
		
		
		if(!empty( $_POST['class_id'.$x] ) )
		{

				foreach( $_POST['class_id'.$x] AS $key=>$class_id)church_admin_update_people_meta( $class_id,$people_id,'classes');

		}


		//ministries

		

		if(!empty( $_POST['prayer_chain'.$x] ) )  {church_admin_update_people_meta(1,$people_id,"prayer-requests",date('Y-m-d'));}
		if(!empty( $_POST['bible_readings'.$x] ) )  {church_admin_update_people_meta(1,$people_id,"bible-readings",date('Y-m-d'));}
		if(!empty( $_POST['news_send'.$x] ) )  {church_admin_update_people_meta(1,$people_id,"posts",date('Y-m-d'));}
		if(!empty( $_POST['ministry_id'.$x] ) )
		foreach( $_POST['ministry_id'.$x] AS $key=>$id)
		{
				church_admin_update_people_meta( $id,$people_id,"ministry");
		}



		//classes
		if(!empty( $_POST['class_id'.$x] ) )foreach( $_POST['class_id'.$x] AS $key=>$id) 		church_admin_update_people_meta( $id,$people_id,'class');
		/********************************************************
		*
		*   USER id
		*
		*********************************************************/


		//user account
		//check is user has user_id
		$user_id=$wpdb->get_var('SELECT user_id FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
		//MICK WALL
		//add the .$x. to get the user id for the current index.
		
		if(!empty( $_POST['user_id'.$x] )&&empty( $user_id) )
		{
			$out.= church_admin_create_user( $people_id,$household_id,$_POST['user_id'.$x] );
		}
		if(!empty( $_POST['ID'] ) )
		{
			$wpdb->query('UPDATE '.CA_PEO_TBL.' SET user_id="'.(int)$_POST['ID'].'" WHERE people_id="'.(int)$people_id.'"');
		}
	/*****************************************************
	*
	* Custom Fields
	*
	*****************************************************/
	$custom_fields=church_admin_get_custom_fields();

	if(!empty( $custom_fields) )
	{
		$wpdb->query('DELETE FROM '.CA_CUST_MET_TBL.' WHERE people_id="'.(int)$people_id.'"');
		foreach( $custom_fields AS $id=>$field)
		{
			if( $field['section']!='people')continue;
			if(isset( $_POST['custom-'.$id.'-'.$x] ) )
			{
				$sql='INSERT INTO  '.CA_CUST_MET_TBL.' (data,people_id,household_id,custom_id) VALUES ("'.stripslashes( $_POST['custom-'.$id.'-'.$x] ).'","'.(int)$people_id.'","'.(int)$household_id.'","'.(int)$id.'")';
				if(defined('CA_DEBUG') )church_admin_debug( $sql);
				$wpdb->query( $sql);
			}
		}

	}
	//church_admin_debug( $out);
    update_option('addressUpdated',time() );

	//update user_meta
	$data=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
	if(!empty( $data->user_id) )church_admin_update_user_meta( $people_id,$data->user_id);
	/*******************************************************
	* Update MailChimp
	*******************************************************/
	$email_method=get_option('church_admin_email_method');
	if(!empty( $email_method) && $email_method=='mailchimp')
	{
		$person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
		church_admin_update_mailchimp_member( $person,$old_email,FALSE);
	}
	//reset app address list cache
	delete_option('church_admin_app_address_cache');
	delete_option('church_admin_app_admin_address_cache');
	return array('output'=>$out,'people_id'=>$people_id,'household_id'=>$household_id);
}



function church_admin_gdpr_email()
{
	if(!church_admin_level_check('Directory') ){
		wp_die(esc_html( __( 'You don\'t have permissions to do that','church-admin') ) );
	}
	global $wpdb;

	//grab ID of church_admin_register shortcode
	$registerID=$wpdb->get_var('SELECT ID FROM '.$wpdb->posts.' WHERE post_content LIKE "%[church_admin_register]%" AND post_status="publish"');
	if(!empty( $registerID) )update_option('church_admin_register',$registerID);

	echo'<h2>'.esc_html( __( 'General Data Protection Requirement Email Sending','church-admin') ).'</h2>';
	$result=$wpdb->get_results(' SELECT CONCAT_WS(" ", a.first_name, a.last_name) AS name, a.last_name,a.people_id, a.email ,b.* FROM '.CA_PEO_TBL.' a, '.CA_HOU_TBL.' b  WHERE a.household_id=b.household_id AND  email!=""  AND (gdpr_reason IS NULL OR gdpr_reason="")  GROUP BY email ');
	if(!empty( $result) )
	{

		foreach( $result AS $row)
		{

			church_admin_gdpr_email_send( $row);
		}
	}
	else
	{

		echo'<p>'.esc_html( __( 'Everyone has responded! So you are GDPR compliant where communications permissions are concerned','church-admin') ).'</p>';
	}
}
function church_admin_gdpr_email_test()
{
	if(!church_admin_level_check('Directory') ){
		wp_die(esc_html( __( 'You don\'t have permissions to do that','church-admin') ) );
	}
	global $wpdb;
	$user = wp_get_current_user();
	$row=$wpdb->get_row(' SELECT CONCAT_WS(" ", a.first_name, a.last_name) AS name, a.last_name,a.people_id, a.email ,b.* FROM '.CA_PEO_TBL.' a, '.CA_HOU_TBL.' b  WHERE a.household_id=b.household_id AND  email!=""  AND  user_id="'.(int)$user->ID.'"');
	if ( empty( $row) )  {echo'<div class="notice notice-warning notice-inline">'.esc_html( __( 'Your login is not attached to anyone in the directory','church-admin') ).'</div>';}
	else
	{
		echo'<h2>'.esc_html( __( 'GDPR test email send','church-admin') ).'</h2>';
		church_admin_gdpr_email_send( $row);
	}
}
function church_admin_gdpr_email_send( $row,$echo=TRUE)
{
	//if(!church_admin_level_check('Directory') )wp_die(esc_html( __( 'You don\'t have permissions to do that','church-admin') );
	global $wpdb;
	if ( empty( $row->name) )$row->name=implode(" ",array_filter(array( $row->first_name,$row->prefix,$row->last_name) ));
	$message=$row->name.'<br />';

	$message.=get_option('church_admin_gdpr_email');
	$message=str_replace('[CONFIRM_LINK]', home_url().'?confirm_email='.md5( $row->email).'&amp;people_id='.md5( $row->people_id),$message);
	$message=str_replace('[SITE_URL]',home_url(),$message);
	$message=str_replace('[CHURCH_NAME]',get_bloginfo('name'),$message);
	$message=str_replace('[CONFIRM_URL]',' <a href="'.home_url().'?confirm_email='.md5( $row->email).'&amp;people_id='.md5( $row->people_id).'">'.esc_html( __( 'Click to confirm','church-admin') ).'</a>',$message);
	
	$message=str_replace('[EDIT_URL]','',$message);


			$people=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$row->household_id.'" ORDER BY people_order ASC');
			if(!empty( $people) )
			{
				$details='<p><strong>'.esc_html( __( 'Household details','church-admin') ).'</strong></p>';
				$details.='<table><thead><tr><th>'.esc_html( __( 'Name','church-admin') ).'</th><th>'.esc_html( __( 'Cell phone','church-admin') ).'</th><th>'.esc_html( __( 'Email','church-admin') ).'</th><th>'.esc_html( __( 'Date of Birth','church-admin') ).'</th></tr></thead><tbody>';
				foreach( $people AS $person)
				{
					$name=array_filter(array( $person->first_name,$person->middle_name,$person->last_name) );
					$mobile=!empty( $person->mobile)?esc_html( $person->mobile):"";
					$email=!empty( $person->email)?esc_html( $person->email):"";

					if(!empty( $person->date_of_birth)&&$person->date_of_birth!=NULL)  {$dob=mysql2date(get_option('date_format'),$person->date_of_birth);}else{$dob="";}

					$details.='<tr><td>'.esc_html(implode(" ",$name) ).'</td><td>'.$mobile.'</td><td>'.$email.'</td><td>'.$dob.'</td></tr>';
				}
				$details.='</tbody></table>';
			}
			if(!empty( $row->address) )$details.='<p><strong>'.esc_html( __( 'Address','church-admin') ).':</strong> '.esc_html( $row->address).'</p>';
			if(!empty( $row->phone) )$details.='<p><strong>'.esc_html( __( 'Phone','church-admin') ).':</strong> '.esc_html( $row->phone).'</p>';
			if(!empty( $details) )$message=str_replace('[HOUSEHOLD_DETAILS]',$details,$message);

			$message.='<p><a href="'.site_url().'?confirm_email='.md5( $row->email).'&amp;people_id='.md5( $row->people_id).'" style="display: inline-block;padding: 6px 12px;margin-bottom: 0;font-size: 14px;font-weight: 400;line-height: 1.42857143;text-align: center;white-space: nowrap;vertical-align: middle;-ms-touch-action: manipulation;touch-action: manipulation;cursor: pointer;-webkit-user-select: none;-moz-user-select: none;-ms-user-select: none; user-select: none;background-image: none;border: 1px solid transparent;border-radius: 4px;color: #fff;background-color: #5bc0de;border-color: #46b8da;">'.esc_html( __( 'Click here to confirm','church-admin') ).'</a></p>';
				if(get_option('church_admin_cron')!='immediate')
                {
					$emails[]=$row->email;
					if(QueueEmail( $row->email, esc_html( __('Please confirm you are happy to receive communications','church-admin') ) ,$message)  )
					{
						if( $echo)echo'<p>'.esc_html( $row->email).' queued</p>';
					}
					
				}
				else
				{

						add_filter('wp_mail_content_type','church_admin_email_type');
						add_filter( 'wp_mail_from_name', 'church_admin_from_name');
						add_filter( 'wp_mail_from', 'church_admin_from_email');


						if(wp_mail( $row->email,esc_html( __( 'Please confirm you are happy to receive communications','church-admin') ),$message)  )
						{
							if( $echo)
							{
								echo'<div class="notice notice-sucess"><h2>'.esc_html( sprintf(  __( 'Confirmation email sent immediately to %1s','church-admin'),  $row->email) ).'</h2></div>';
								echo'<a href="admin.php?page=church_admin/index.php" class="button-primary">'.esc_html( __( 'Back to address list filter','church-admin') ).'</a><p>';
								if(is_admin() )church_admin_new_household_display( $row->household_id);	
							}
							
						}
						else {echo $GLOBALS['phpmailer']->ErrorInfo;}

					remove_filter('wp_mail_content_type','church_admin_email_type');
				}

}

function church_admin_gdpr_pdf()
{
	if(!church_admin_level_check('Directory') ){
		wp_die(esc_html( __( 'You don\'t have permissions to do that','church-admin')  ) );
	}
	global $wpdb;
	require_once(plugin_dir_path(dirname(__FILE__) ).'includes/fpdf.php');
	//grab ID of church_admin_register shortcode
	$registerID=$wpdb->get_var('SELECT ID FROM '.$wpdb->posts.' WHERE post_content LIKE "%[church_admin_register]%" AND post_status="publish"');
	if(!empty( $registerID) )update_option('church_admin_register',$registerID);

	$sql=' SELECT a.last_name,a.people_id, a.email ,b.* FROM '.CA_PEO_TBL.' a, '.CA_HOU_TBL.' b  WHERE a.household_id=b.household_id AND  email!=""  AND (gdpr_reason IS NULL OR gdpr_reason="")  GROUP BY email ORDER BY a.last_name';

	$result=$wpdb->get_results( $sql);
	if(!empty( $result) )
	{

		$pdf = new FPDF();

		foreach( $result AS $row)
		{
			$pdf->AddPage('P',get_option('church_admin_pdf_size') );
			$pdf->SetFont('Arial','B',16);
			$pdf->Cell(0,10,urldecode(church_admin_encode(get_bloginfo('name').' '.esc_html( __( 'Data Protection Permission','church-admin') ).' - '.$row->last_name) ),0,2,'L');
			$pdf->Ln(10);
			$pdf->SetFont('Arial','',12);
			$text= esc_html( sprintf( __( 'The GDPR regulations protect how your personal data is used. We store your name, address and phone details so we can keep the church organised and would like to be able to continue to communicate by email, sms and mail with you. Your contact details are available on the website (%1$s) within a password protected area. Please check with other members of your household who are over 16, sign this form and return if you are happy for us to continue to hold your personal data and use it to communicate with you. If you are not happy or would like to discuss further then do get in touch with the church office.','church-admin'), site_url() ) );
			//$height=$pdf->GetMultiCellHeight(0,7,$text,'LTR','L');
			$pdf->MultiCell(0, 7, urldecode(church_admin_encode( $text) ),0,'L' );
			//$pdf->Ln( $height+10);
			//confirm online
			$text = esc_html( __( 'Click this link to confirm online','church-admin') );
			//$link=site_url().'?confirm='.urldecode(church_admin_encode( $row->last_name) ).'/'.(int)$row->people_id;
			//use new style link from 2021-04-30
			$link=site_url().'/?confirm_email='.md5( $row->email).'&people_id='.md5( $row->people_id);
			$pdf->SetFont('Arial','U',12);
			$pdf->Cell(0,7,$text,0,1,'L',NULL,$link);
			$pdf->Ln(5);

			//person's entry
			$people=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$row->household_id.'" ORDER BY people_order ASC');
			if(!empty( $people) )
			{
				$pdf->SetFont('Arial','B',12);
				$pdf->Cell(0,7,esc_html( __( 'People in your household', 'church-admin' ) ),0,1,'L');
				$pdf->Cell(50,7,esc_html( __( "Name",'church-admin') ),1,0,'L');
				$pdf->Cell(30,7,esc_html( __( "Mobile",'church-admin') ),1,0,'L');
				$pdf->Cell(75,7,esc_html( __( "Email",'church-admin') ),1,0,'L');
				$pdf->Cell(30,7,esc_html( __( "Date of Birth",'church-admin') ),1,1,'L');
				$pdf->SetFont('Arial','',12);
				$text='';
				foreach( $people AS $person)
				{
					$name=array_filter(array( $person->first_name,$person->middle_name,$person->last_name) );
					$mobile=!empty( $person->mobile)?esc_html( $person->mobile):"";
					$email=!empty( $person->email)?esc_html( $person->email):"";

					if(!empty( $person->date_of_birth)&&$person->date_of_birth!=NULL)
					{$dob=mysql2date(get_option('date_format'),$person->date_of_birth);}else{$dob="";}


					$pdf->Cell(50,7,urldecode(church_admin_encode(implode(' ',$name) )),1,0,'L');
					$pdf->Cell(30,7,$mobile,1,0,'L');
					$pdf->Cell(75,7,$email,1,0,'L');
					$pdf->Cell(30,7,$dob,1,1,'L');
				}

			}
			$pdf->Ln(5);
			$pdf->SetFont('Arial','B',12);
			$pdf->Cell(0,7,urldecode(church_admin_encode(esc_html( __( 'Address details','church-admin') ) )),0,1,'L');
			$pdf->SetFont('Arial','',12);
			if(!empty( $row->address) )$pdf->Cell(0,7,urldecode(church_admin_encode( $row->address) ),0,1,'L');
			if(!empty( $row->phone) )$pdf->Cell(0,7,esc_html( $row->phone),0,1,'L');

			//form confirmation...
			$pdf->Ln(10);
			$pdf->SetFont('Arial','B',12);
			$pdf->Cell(0,7,urldecode(church_admin_encode(esc_html( __( 'Confirmation of personal data use','church-admin') ) )),0,1,'L');
			$pdf->SetFont('Arial','',12);
			$pdf->Cell(7,7,'',1);
			$text=urldecode(church_admin_encode(esc_html( __( 'Please send email','church-admin')  )));
			$pdf->Cell(0,7,$text,0,1,'L');
			$pdf->Ln(2);
			$pdf->Cell(7,7,'',1);
			$text=urldecode(church_admin_encode(esc_html( __( 'Please send SMS','church-admin') )));
			$pdf->Cell(0,7,$text,0,1,'L');
			$pdf->Ln(2);
			$pdf->Cell(7,7,'',1);
			$text=urldecode(church_admin_encode(esc_html( __( 'Please send mail','church-admin') )) ) ;
			$pdf->Cell(0,7,$text,0,1,'L');
			$pdf->Ln(2);
			$pdf->Cell(7,7,'',1);
			$text=urldecode(church_admin_encode(esc_html( __( "Please don't publish my address details on the password protected website",'church-admin') ) ));
			$pdf->Cell(0,7,$text,0,1,'L');
			$pdf->Ln(5);
			$pdf->Cell(75,7,'','B');
			$pdf->Cell(0,7,urldecode(church_admin_encode(esc_html( __( 'Signature','church-admin') ))),0,1,'L');
			$pdf->Ln(10);
			$pdf->Cell(75,7,'','B');
			$pdf->Cell(0,7,urldecode(church_admin_encode(esc_html( __( 'Date','church-admin') )) ),0,1,'L');


		}
			$pdf->Output();
	}else{echo'no people';}
}

function gdpr_confirm_everyone()
{
	if(!church_admin_level_check('Directory') ){
		wp_die(esc_html( __( 'You don\'t have permissions to do that','church-admin') ) );
	}
	global $wpdb;
	$wpdb->show_errors();
	$wpdb->query('UPDATE '.CA_PEO_TBL.' SET mail_send=1,email_send=1,news_send=1,sms_send=1,gdpr_reason="'.esc_html( __( 'GDPR Confirmed by admin','church-admin') ).'" WHERE gdpr_reason IS NULL OR gdpr_reason=""');
	//add in people meta for news_send

	echo'<h2>GDPR</h2>';
	echo'<p>'.esc_html( __( 'That was very naughty. You have confirmed that your entire directory are happy to have personal data stored and be communicated with','church-admin') ).'</p>';
	//reset app address list cache
	delete_option('church_admin_app_address_cache');
	delete_option('church_admin_app_admin_address_cache');
	update_option('church_admin_modified_app_content',time() );
}



function church_admin_bulk_geocode()
{
		global $wpdb;
	$wpdb->show_errors;
    echo'<h2>'.esc_html( __( 'Batch geocoding','church-admin') ).'</h2>';
    $googleApi=get_option('church_admin_google_api_key');
    if ( empty( $googleApi) )
	{
		echo '<div class="notice notice-danger"><h2>'.esc_html( __( "Please get a Google Maps API key first",'church-admin') ).'</h2>';
		echo'<p><a href="https://www.churchadminplugin.com/tutorials/google-api-key/">'.esc_html( __( 'Tutorial on getting an API key','church-admin') ).'</a></p>';
		echo'</div>';

		return;
	}
		$results=$wpdb->get_results('SELECT * FROM '.CA_HOU_TBL.' WHERE address!=", , , ," AND address!=", , ," AND address!="" AND (geocoded=0 OR lat="" OR lng="") LIMIT 10');
		if(!empty( $_POST['batch_geocode'] ) )
		{
		
			if(!empty( $results) )
			{
				foreach( $results AS $row)
				{
						
					
						if(isset( $_POST['lat'.(int)$row->household_id] )&&isset( $_POST['lng'.(int)$row->household_id] ) )
						{
							if(!empty( $_POST['lat'.(int)$row->household_id] ) )$lat=$_POST['lat'.(int)$row->household_id];
							if(!empty( $_POST['lng'.(int)$row->household_id] ) )$lng=$_POST['lng'.(int)$row->household_id];
							$wpdb->query('UPDATE '.CA_HOU_TBL.' SET lat="'.esc_sql( $_POST['lat'.(int)$row->household_id] ).'", lng="'.esc_sql( $_POST['lng'.(int)$row->household_id] ).'" , geocoded=1 WHERE household_id="'.(int)$row->household_id.'"');
							
						}
				}
				echo'<div class="notice notice-success inline"><h2>'.esc_html( __( 'Address geocodes updated','church-admin') ).'</h2></div>';
				
			}
			//redo query to get next 10
			$results=$wpdb->get_results('SELECT * FROM '.CA_HOU_TBL.' WHERE address!=", , , ," AND address!=", , ," AND address!="" AND (geocoded=0 OR lat="" OR lng="") LIMIT 10');
		}
		

            


			if(!empty( $results) )
			{
                echo'<h2>'.esc_html( __( 'We can only batch geocode 10 addresses at a time, so this will keep going through the cycle until finished!','church-admin') ).'</h2>';
			echo'<form action="" method="post">';
			echo'<p><button class="button-primary btn btn-info" id="geocode_address">'.esc_html( __( 'Step 1 Click to batch geocode household addresses','church-admin') ).'</button></p>';
			echo '<p><input type="hidden" name="batch_geocode" value="TRUE"/><input type="submit" id="submit_batch_geocode" disabled="disabled" value="'.esc_html( __( 'Step 2 - Save batched geocode','church-admin') ).'"/></p>';
			echo'<div id="map" style="width:500px;height:500px"></div>';
            $site=$wpdb->get_row('SELECT * FROM '.CA_SIT_TBL.' LIMIT 1');
            if(!empty( $site) )
            {
                echo'<script>var beginLat = '.esc_html( $site->lat).';var beginLng = '.esc_html( $site->lng).';</script>';
            }
            else echo'<script>var beginLat = 51.50351129583287;var beginLng = -0.148193359375;</script>';
				foreach( $results AS $row)
				{
					echo '<p >'.esc_html( $row->address).'<input type="hidden" id="'.(int)$row->household_id.'" class="address" value="'.esc_html( $row->address).'"/></p>';
					echo esc_html( __( 'Latitude','church-admin') ).'<input type="text" id="lat'.(int)$row->household_id.'"   value="'.esc_html( $row->lat).'" name="lat'.(int)$row->household_id.'"/> '. esc_html( __( 'Longitude','church-admin') ).'<input type="text" value="'.esc_html( $row->lng).'" name="lng'.(int)$row->household_id.'" id="lng'.(int)$row->household_id.'"/>';
				}
			}else{echo'<p>'.esc_html( __( 'No  households need geocoding','church-admin') ).'</p>';}
			echo'</form>';
    
}


function church_admin_bulk_not_private()
{
    global $wpdb;

	echo'<h2>'.esc_html( __( 'Make Everyone visible on the address list','church-admin') ).'</h2>';
	if(!current_user_can('manage_options') )return '<p>'.esc_html( __( 'Only site admins can do this','church-admin') ).'</p>';
	if(!empty( $_POST['sure'] ) )
	{
    	$wpdb->query('UPDATE '.CA_HOU_TBL.' SET privacy=0');
    	echo'<div class="notice notice-success notice-inline"><h2>'.esc_html( __( 'Everyone now set to show on the directory','church-admin') ).'</h2></div>';
	}
	else
	{
		echo'<form action="" method="post"><p><strong>'.esc_html( __( "Are you sure you want to override people's privacy choice?",'church-admin') ).'</strong><br /><input type="hidden" name="sure" value="yes"/><input type="submit"  class="button-secondary" value="'.esc_html( __( 'Yes, make everyone visible','church-admin') ).'"/></p></form>';
	}
}


function church_admin_potential_duplicates()
{
    global $wpdb;
    $nameResults=$wpdb->get_results('SELECT CONCAT_WS(" ",first_name,last_name) AS name, COUNT(CONCAT_WS(" ",first_name,last_name) ) AS count FROM '.CA_PEO_TBL.' GROUP BY CONCAT_WS(" ",first_name,last_name) HAVING COUNT(name)>1');
    if(!empty( $nameResults) )
    {
        echo'<h1>'.esc_html( __( 'Here are some potential duplicate entries','church-admin') ).'</h1>';
        echo '<p><strong>'.esc_html( sprintf( __( '%1$s people duplicated', 'church-admin' ), $wpdb->num_rows) ).'</strong></p>';
        echo'<p>'.esc_html( __( 'Carefully check the results to see which one to keep!','church-admin') ).'</p>';
        foreach( $nameResults AS $nameRow)
        {
            echo'<h1>'.esc_html( $nameRow->name).' x'.intval( $nameRow->count).'</h1>';
            $householdResults=$wpdb->get_results('SELECT household_id FROM '.CA_PEO_TBL.' WHERE CONCAT_WS(" ",first_name,last_name)="'.esc_sql( $nameRow->name).'"');
            if(!empty( $householdResults) )
            foreach( $householdResults AS $householdRow)
            {
                
                 echo church_admin_new_household_display( $householdRow->household_id);
            }
            echo'<hr style="border:10px solid #CCC;border-radius:5px"/>';
        }
        
    }
    
    
}




function church_admin_new_household_display( $household_id)
{

	/******************************************************
	* 2022-10-29 
	* This function also used by subscriber level household 
	* members for their household, so added in some level 
	* checking where needed
    ********************************************************/
	
	global $wpdb,$people_type;
	/*************************
	 * Handle head of household
	 ***************************/
	if(!empty( $_POST['head_of_household'] ) && ctype_digit( $_POST['head_of_household'] ) )
	{
		$wpdb->query('UPDATE '.CA_PEO_TBL.' SET head_of_household=0 WHERE household_id="'.(int)$household_id.'"');
		$wpdb->query('UPDATE '.CA_PEO_TBL.' SET head_of_household=1 WHERE people_id="'.(int)$_POST['head_of_household'].'" AND household_id="'.(int)$household_id.'"');
		$person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$_POST['head_of_household'].'"');
		echo '<div class="notice notice-success"><h2>'.esc_html( sprintf( __( 'Head of household updated to %1$s','church-admin'),church_admin_formatted_name( $person) ) ).'</h2></div>';
	}
	/*****************************************
	 * 
	 * Handle add person from this screen
	 * 
	 * ***************************************/
	if(!empty( $_POST['add-person'] ) )
	{
		$sqlsafe=array();
		foreach( $_POST AS $key=>$value)$sqlsafe[$key]=esc_sql(stripslashes( $value) );
		$people_id=$wpdb->get_var('SELECT people_id FROM '.CA_PEO_TBL.' WHERE first_name="'.$sqlsafe['first_name'].'" AND last_name="'.$sqlsafe['last_name'].'" AND email="'.$sqlsafe['email_address'].'" AND household_id="'.(int)$household_id.'" AND sex="'.$sqlsafe['sex'].'" AND people_type_id="'.$sqlsafe['people_type_id'].'"');
		if ( empty( $people_id) )
		{
			$wpdb->query('INSERT INTO '.CA_PEO_TBL.' (first_name,last_name,mobile,email,household_id,people_type_id,sex,member_type_id,show_me,gdpr_reason)VALUES("'.$sqlsafe['first_name'].'","'.$sqlsafe['last_name'].'","'.$sqlsafe['mobile'].'","'.$sqlsafe['email_address'].'","'.(int)$household_id.'","'.$sqlsafe['people_type_id'].'","'.$sqlsafe['sex'].'","'.$sqlsafe['member_type_id'].'",0,"'.esc_html( __( 'Admin added','church-admin') ).'")');
			$people_id=$wpdb->insert_id;
		}
		$person=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$people_id.'"');
		//reset app address list cache
		delete_option('church_admin_app_address_cache');
		delete_option('church_admin_app_admin_address_cache');

		/********************************************
		*
		* MailChimp Add
		*
		*********************************************/
		$email_method=get_option('church_admin_email_method');
		if(!empty( $email_method) && $email_method=='mailchimp')
		{
			
			if(!empty( $person) )church_admin_update_mailchimp_member( $person, NULL, FALSE );
		}
		echo'<div class="notice notice-success"><h2>'.esc_html( sprintf( __(  '%1$s added', 'church-admin' ),  church_admin_formatted_name( $person )  ) ).'</h2></div>';
	}

    /**************************************************
     * Grab household data and abort if none found
     *************************************************/
    if ( empty( $household_id) )return esc_html( __( 'No household to display','church-admin') );
    $household=$wpdb->get_row('SELECT * FROM '.CA_HOU_TBL.' WHERE household_id="'.(int)$household_id.'"');
    if ( empty( $household) )return esc_html( __( 'No household found from household_id','church-admin') );
    $people=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$household_id.'" ORDER BY head_of_household DESC');
    if ( empty( $people) )
    {
        $wpdb->query('DELETE FROM '.CA_HOU_TBL.' WHERE household_id="'.(int)$household_id.'"');
        return esc_html( __( 'household deleted as no-one in it!','church-admin') );
    }
	
    echo'<div class="church-admin-household">';
    /************************************************
     * Output Household Address details
     ***********************************************/
    echo'<div class="church-admin-household-title"><h1>'.esc_html( church_admin_directory_title_name( $people ) ).'</h1></div>';

	
	if(church_admin_level_check('Directory') )
	{
		/***********************************
		 * move people to same member type
		 * ********************************/
		$member_type=church_admin_member_type_array();
		echo'<div class="church-admin-household-move"><form action="admin.php?page=church_admin/index.php&amp;action=display_household&household_id='.(int)$household_id.'&section=people" method="POST"/>';
		echo'<input type="hidden" name="move_household_id" value="'.(int)$household_id.'"/>';
		echo'<p>'.esc_html( __( 'Change member type of whole household','church-admin') ).'<select name="member_type_id">';
		foreach( $member_type AS $key=>$value)
		{

			echo '<option value="'.esc_html( $key ).'" >'.esc_html( $value ).'</option>';
		}
		echo'</select>';
		echo'<input type="submit" class="button-secondary" value="'.esc_html( __( 'Move','church-admin') ).'"></p></form></div>';
		
		//move people to site
		$sites=$wpdb->get_results('SELECT venue,site_id FROM '.CA_SIT_TBL.' ORDER BY venue ASC');
		if( $wpdb->num_rows>1)
		{
			echo '<div class="church-admin-household-site"><form action="admin.php?page=church_admin/index.php&amp;section=people&amp;action=display_household&household_id='.(int)$household_id.'&section=people" method="POST"/>';
			echo '<input type="hidden" name="move_site_id" value="'.(int)$household_id.'"/>';
			echo '<p>'.esc_html( __( 'Move household to site','church-admin') ).'</label> <select name="site_id" data-name="site_id" >';
			$first=$option='';
			foreach( $sites AS $site)
			{
				if(!empty( $data->site_id)&& $data->site_id==$site->site_id)
				{
					$first.='<option value="'.(int)$site->site_id .'" selected="selected">'.esc_html( $site->venue).'<option>';
				}
				else
				{
					$option.='<option value="'.(int)$site->site_id .'">'.esc_html( $site->venue).'<option>';
				}
			}
			echo $first.$option.'</select>';
			echo'<input type="submit" class="button-secondary" value="'.esc_html( __( 'Move','church-admin') ).'"></p></form></div>';
		}
	
		/*************************************
		 * Head of household
		 *************************************/
		echo'<div class="church-admin-household-move"><form action="admin.php?page=church_admin/index.php&amp;action=display_household&household_id='.(int)$household_id.'&section=people" method="POST"/>';
		echo'<p>'.esc_html( __( 'Update head of household','church-admin') ).'</label><select name="head_of_household">';
		foreach( $people AS $person)
		{
			echo'<option value="'.(int)$person->people_id.'" '.selected( $person->head_of_household,1,FALSE).'>' .esc_html( church_admin_formatted_name( $person ) ) .'</option>';
		}
		echo'</select>';
		echo'<input type="submit" class="button-secondary" value="'.esc_html( __( 'Save','church-admin') ).'"></p></form></div>';
	}
	/************************************************
     * Output Image
     ***********************************************/
    echo'<div class="church-admin-household-image ca-upload-area" data-nonce="'.wp_create_nonce("household-image-upload").'" data-which="household" data-id="'.(int)$household->household_id.'" id="uploadfile"><h3>'.esc_html( __( 'Household image','church-admin') ).'</h3>';
    if(!empty( $household->attachment_id) )
    {
        $household_image_attributes=wp_get_attachment_image_src( $household->attachment_id,'medium','' );
        if ( $household_image_attributes )
        {
            echo'<img id="household-image" src="'.esc_url( $household_image_attributes[0] ).'" width="'.(int)$household_image_attributes[1].'" height="'.(int)$household_image_attributes[2].'" class="rounded" alt="'.esc_html( __( 'Household image','church-admin') ).'"/>';
        }
    }
    else
    {
        echo'<img id="household-image"  src="'.esc_url( plugins_url( '/', dirname(__FILE__) ) . 'images/household.svg' ) .'" width="300" height="200" class="rounded" alt="'.esc_html( __( 'Household image','church-admin') ).'"/>';
    }
    echo '<br />'.esc_html( __( 'Drag and drop new image for household','church-admin') );
    echo '<span id="household-upload-message"></span>';

    echo'</div>';
    /************************************************
     * Output Household Address details
     ***********************************************/
    echo'<div class="church-admin-address-details">';
    echo '<h3>'.esc_html( __( 'Household address','church-admin') ).'</h3>';
    echo'<div class="church-admin-address church-admin-form-group" ><label>'.esc_html( __( 'Phone','church-admin') ).'</label><input type="phone" class="church-admin-form-control church-admin-editable" data-what="phone" data-id="'.(int)$household_id.'" id="phone" value="'.esc_html( $household->phone).'"/></div>';  
    echo'<div class="church-admin-address church-admin-form-group"><label>'.esc_html( __( 'Street Address','church-admin') ).'</label><input data-ID="'.(int)$household_id.'"  data-what="address" data-id="'.(int)$household_id.'"  id="address" class="church-admin-form-control church-admin-editable" type="text" value="'.esc_html( $household->address).'" data-ID="0" data-what="address" data-household-id="'.(int)$household_id.'"></div>';   
	echo'<div class="church-admin-address church-admin-form-group"><label>'.esc_html( __( 'Mailing Address','church-admin') ).'</label><input data-ID="'.(int)$household_id.'"  data-what="mailing-address" data-id="'.(int)$household_id.'"  id="mailing-address" class="church-admin-form-control church-admin-editable" type="text" value="'.esc_html( $household->mailing_address).'" data-ID="0" data-what="mailing_address" data-household-id="'.(int)$household_id.'"></div>'; 
	echo'<p><a style="text:decoration:none" title="'.esc_html( __( 'Download Vcard','church-admin') ).'" href="'.wp_nonce_url(home_url().'/?ca_download=vcf&amp;id='.(int)$person->household_id,$person->household_id).'"><span class="dashicons dashicons-index-card"></span>'.esc_html( __( 'Household VCF','church-admin') ).'</a></p>';
    $key=get_option('church_admin_google_api_key');
    
    
    
    if(!empty( $key) )
    {
        echo'<div id="map" style="width:500px;height:300px;margin-bottom:20px"></div>';
		echo'<p><button id="geocode_address" class="button-primary btn btn-info">'.esc_html( __( 'Update map','church-admin') ).'</button></p>';
		echo'<script >var ca_method="update-directory";var ID='.(int)$household_id.'; var nonce="'.wp_create_nonce('update-directory').'";var beginLat=';
		if(!empty( $household->lat) ) {echo esc_html($household->lat).';';}else {echo '0;';}
		if(!empty( $household->lng) ) 
		{
			echo 'var beginLng='.esc_html( $household->lng ).';var zoom=17;';
		}else 
		{
			echo'var beginLng=0;var zoom=0;';
		}
		echo 'console.log("ID "+ ID)';
		echo';</script>';
    }
    else
    {
        echo'<p><a href="admin.php?page=church_admin/index.php&action=settings#directory-settings">'.esc_html( __( 'To use mapping features, please set up a Google Maps API key','church-admin') ).'</a></p>';
    }
    //custom fields in address section
	$custom_fields=church_admin_get_custom_fields();
	if(!empty( $custom_fields) )
	{
		
		foreach( $custom_fields AS $id=>$field)
		{
			if( $field['section']!='household')continue;
			$thisHouseholdCustomData=$wpdb->get_row('SELECT * FROM '.CA_CUST_MET_TBL.' WHERE household_id="'.(int)$household->household_id.'" AND custom_id="'.(int)$id.'"');
			
			echo'<div class="church-admin-address church-admin-form-group" ><label>'.esc_html( $field['name'] ).'</label>';
			switch( $field['type'] )
			{
				case 'boolean':
					echo'<input type="radio" data-what="household-custom" data-custom-id="'.(int)$household->household_id.'" data-id="'.(int)$id.'" class="church-admin-form-control church-admin-editable" name="custom-'.(int)$id.'" value="1" ';
					if (isset( $thisHouseholdCustomData->data)&&$thisHouseholdCustomData->data==1)echo 'checked="checked" ';
					echo '>'.esc_html( __( 'Yes','church-admin') ).'<br /> <input type="radio"  data-custom-id="'.(int)$household->household_id.'"  data-what="household-custom" data-ID="'.(int)$household->household_id.'" data-id="'.(int)$id.'" class="church-admin-form-control church-admin-editable" value="0" name="custom-'.(int)$id.'" ';
					if (isset( $thisHouseholdCustomData->data)&& $thisHouseholdCustomData->data==0) echo  'checked="checked" ';
					echo '>'.esc_html( __( 'No','church-admin') );
					break;
				case'text':
					echo '<input type="text"  data-what="household-custom" data-custom-id="'.(int)$household->household_id.'"  data-id="'.(int)$id.'" class="church-admin-form-control church-admin-editable"  name="custom-'.(int)$id.'" ';
					if(!empty( $thisHouseholdCustomData->data) || isset( $field['default'] ) )echo ' value="'.esc_html( $thisHouseholdCustomData->data).'"';
					echo '/>';
				break;
				case'date':
					if(!empty( $thisHouseholdCustomData->data) )  {$currentData=$thisHouseholdCustomData->data;}else{$currentData='';}
					echo church_admin_date_picker( $currentData,'custom-'.(int)$id,FALSE,1910,date('Y'),'custom-'.(int)$id,'custom-'.(int)$id,FALSE,'household-custom',(int)$household->household_id,(int)$id);
				
				break;
			}
			echo '</div>';
			
		}

	}
    
    echo'</div>';
    /*************************************
     * People
     ************************************/
	$member_type=church_admin_member_type_array();
    foreach ( $people as $person) 
	{
        echo'<div class="church-admin-person-details">';
      
        $name=church_admin_formatted_name( $person);
        echo '<h3>'.esc_html( $name ).'</h3>';
        /************************************************
         * Output Image
         ***********************************************/
        echo'<div class="church-admin-people-image ca-upload-area" data-which="people" data-id="'.(int)$person->people_id.'" data-nonce="'.wp_create_nonce("people-image-upload").'" id="uploadfile">';
        if(!empty( $person->attachment_id) )
        {
            $person_image_attributes=wp_get_attachment_image_src( $person->attachment_id,'medium','' );
            if ( $person_image_attributes )
            {
                echo'<img id="people-image'.(int)$person->people_id.'" src="'.esc_url( $person_image_attributes[0] ).'" width="'.(int)$person_image_attributes[1].'" height="'.(int)$person_image_attributes[2].'" class="rounded" alt="'.esc_html( $name).'"/>';
            }else
            {
                //image not available although attachment id is saved.
                if(isset( $person->sex) &&$person->sex==1)  {$image='man.svg';}else{$image='woman.svg';}
                echo'<img id="people-image'.(int)$person->people_id.'"  src="'.esc_url( plugins_url('/', dirname(__FILE__) ) . 'images/'.$image ).'" width="300" height="200" class="rounded" alt="'.esc_html( $name).'"/>';
            }
			echo'<input class="attachment_id" type="hidden" name="attachment_id" value="'.(int)$person->attachment_id.'"/>';
        }
        else
        {
            if(isset( $person->sex) &&$person->sex==1)  {$image='man.svg';}else{$image='woman.svg';}
            
            echo'<img id="people-image'.(int)$person->people_id.'"  src="'.esc_url( plugins_url('/', dirname(__FILE__) ) . 'images/'.$image ).'" width="300" height="200" class="rounded" alt="'.esc_html( $name).'"/>';
			echo'<input class="attachment_id" type="hidden" name="attachment_id"/>';
        }
        echo '<br />'.esc_html( sprintf( __( 'Drag and drop new image for %1$s','church-admin'),$name) );
        echo '<span id="person-upload-message"></span>';
        echo'</div>';
       	//other details
        echo'<div class="church-admin-form-group"><label>'.esc_html( __( 'Email', 'church-admin' ) ).'</label><input type="email" name="email" id="email'.(int)$person->people_id.'" class="church-admin-form-control church-admin-editable" data-what="email" data-ID="'.(int)$person->people_id.'" data-id="'.(int)$person->people_id.'" value="'.esc_html( $person->email).'"/></div>';
        echo'<div class="church-admin-form-group"><label>'.esc_html( __( 'Cell', 'church-admin' ) ).'</label><input type="phone" id="cell'.(int)$person->people_id.'" name="cell" class="church-admin-form-control church-admin-editable" id="cell" data-what="cell" data-ID="'.(int)$person->people_id.'" data-id="'.(int)$person->people_id.'" value="'.esc_html( $person->mobile).'"/></div>';
		//people type
		echo'<div class="church-admin-form-group"><label for="people_type_id">'.esc_html( __( 'Person type','church-admin') ).'</label><select class="people_type_id church-admin-form-control church-admin-editable" data-id="'.(int)$person->people_id.'" data-what="people_type_id" name="people_type_id" id="mt'.(int)$person->people_id.'">';
		foreach( $people_type AS $id => $type ){
			echo '<option value="'.(int)$id.'" '.selected( $person->people_type_id,$id,FALSE).'>'.esc_html( $type ).'</option>'."\r\n";
		}
		echo'</select></div>';
		//member type
		if(church_admin_level_check('Directory') )
		{
			if(!empty( $member_type) )
			{
				$current=!empty( $person->member_type_id)?(int)$person->member_type_id:NULL;
				echo '<div class="church-admin-form-group"><label for="member_type_id">'.esc_html( __( 'Member Type','church-admin') ).'</label><select class="church-admin-form-control church-admin-editable" data-id="'.(int)$person->people_id.'" data-what="member_type_id" name="member_type_id" id="mt'.(int)$person->people_id.'">';
				foreach( $member_type AS $id=>$membertype)
				{
					echo '<option value="'.(int)$id.'" '.selected( $id,$current,FALSE).'>'.esc_html( $membertype ).'</option>';
				}
				echo'</select></div>';
			}


			echo '<p>'.esc_html( __( 'User account','church-admin') ).': '.church_admin_user_check( $person,FALSE).'</p>';
			echo'<p><a style="text-decoration:none" title="'.esc_html( __( 'Download Vcard','church-admin') ).'" href="'.wp_nonce_url(home_url().'/?ca_download=vcf-person&amp;id='.(int)$person->people_id,(int)$person->people_id).'"><span class="dashicons dashicons-index-card"></span>'.esc_html( __( 'Personal VCF','church-admin') ).'</a></p>';
			//edit button
			echo'<p><a class="button-primary" href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit_people&amp;people_id='.(int)$person->people_id.'&amp;household_id='.(int)$household_id,'edit_people').'">'.esc_html( __( 'View and edit other attributes','church-admin') ).'</a></p>';
			//move person
			echo'<p><a class="button-secondary" onclick="return confirm(\''.esc_html(sprintf( __( 'Are you sure you want to move %1$s','church-admin'),church_admin_formatted_name( $person) ) ) .'\')" href="'.esc_url( wp_nonce_url( 'admin.php?page=church_admin/index.php&amp;action=church_admin_move_person&amp;people_id='.(int)$person->people_id,'move_person' ) ).'">'.esc_html( __( 'Move to different household','church-admin') ).'</a></p>';
		}
		//delete person
		echo'<a  class="button-secondary"   onclick="return confirm(\''.esc_html(sprintf(__( 'Are you sure you want to delete %1$s','church-admin'),church_admin_formatted_name( $person) )).'\')"  href="'.esc_url( wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete_people&amp;household_id='.(int)$household_id.'&amp;people_id='.(int)$person->people_id.'&amp;household_id='.(int)$household_id,'delete_people' ) ).'">'.esc_html( __( 'Delete','church-admin') ).'</a>';
        
		echo'</div><!--Person-->';
    }
	//new person
	echo'<div class="church-admin-person-details">';
       echo'<form action="admin.php?page=church_admin/index.php&amp;action=display_household&amp;household_id='.(int)$household_id.'" method="post">';
        echo'<h3>'.esc_html( __( 'Add person','church-admin') ).'</h3>';
		echo'<div class="church-admin-form-group"><label>'.esc_html( __( 'First name','church-admin') ).'</label><input type="text" name="first_name"  class="church-admin-form-control"/></div>';
		echo'<div class="church-admin-form-group"><label>'.esc_html( __( 'Last name','church-admin') ).'</label><input type="text" name="last_name"  class="church-admin-form-control"/></div>';
       
        echo'<div class="church-admin-form-group"><label>'.esc_html( __( 'Email', 'church-admin') ).'</label><input type="email" name="email_address"  class="church-admin-form-control"/></div>';
        echo'<div class="church-admin-form-group"><label>'.esc_html( __( 'Cell','church-admin') ).'</label><input type="phone"  name="mobile" class="church-admin-form-control" id="cell"/></div>';
        
		//people type
		echo'<div class="church-admin-form-group"><label for="people_type_id">'.esc_html( __( 'Person type','church-admin') ).'</label><select name="people_type_id"  class="people_type_id church-admin-form-control">';
		foreach( $people_type AS $id => $type ) {echo '<option value="'.(int)$id.'">'.esc_html( $type ).'</option>'."\r\n";}
		echo '</select></div>'."\r\n";
		//member type
		if(church_admin_level_check('Directory') )
		{
			$member_type=church_admin_member_type_array();
			if(!empty( $member_type) )
			{
				echo '<div class="church-admin-form-group"><label for="member_type_id">'.esc_html( __( 'Member Type','church-admin') ).'</label><select class="church-admin-form-control" name="member_type_id">';
				foreach( $member_type AS $id=>$membertype)
				{
					echo '<option value="'.(int)$id.'">'.esc_html( $membertype ).'</option>';
				}
				echo'</select></div>';
			}
		}else{echo '<input type="hidden" name="member_type_id" value=1/>';}
		//sex
		$gender=get_option('church_admin_gender');
		echo'<div class="church-admin-form-group"><label >'.esc_html( __( 'Gender','church-admin') ).'</label><select name="sex" class="sex church-admin-form-control" >';
		foreach( $gender AS $key => $value )  { echo '<option value="'.esc_html( $key).'" >'.esc_html( $value).'</option>';}
		echo'</select></div>'."\r\n";
		//edit button
		echo'<p><input type=hidden name="add-person" value="y"/><input class="button-primary" type="submit" value="'.esc_html( __( 'Add person','church-admin') ).'"/></p></form>';
		echo'</div><!--Person-->';


    //end of household details...
    echo '</div>';
    echo '<script>
    
        jQuery(document).ready(function( $)  {
            $("body").on("change",".church-admin-editable",function()  {
				console.log("editable fired");
                var what=$(this).data("what");
				
                var id=$(this).data("id");
                var div = $(this).attr("id");
                var value=$(this).val();
				if(what==="member_type_id") value=$("option:selected", this).val();
                var customID=$(this).data("custom-id");
				
               var data= {"action":"church_admin","method":"update-directory","what":what,"id":id,"custom-id":customID,"nonce":"'.wp_create_nonce('update-directory').'","value":value,"div":div};
                console.log(data);
                $.getJSON({
                    url: ajaxurl,
                    type: "post",
                    data:  data,
                    success: function(response) {
                        console.log(response);
							if(response.div)
							{
								$("#"+response.div).val();
								$("#"+response.div).append("'.esc_html( __( 'Updated','church-admin') ).'");
							}
							if(response.mtout)
							{	
								$("#mt"+response.div).html(response.mtout);
							}
                        }
                });
                
            });
			$(".ca_connect_user").click(function() {
				var people_id=$(this).attr("data-peopleid");
				var data = {
				"action": "church_admin",
				"method": "connect_user",
				"people_id": people_id,
				"user_id": $(this).attr("data-userid"),
				"nonce": "'.wp_create_nonce("connect_user").'",
				dataType: "json"
				};console.log(data);
				// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
				jQuery.post(ajaxurl, data, function(response)
				{
					var data=JSON.parse(response);
					console.log("body .userinfo"+data.people_id + " "+data.login)
					$(".userinfo"+data.people_id).replaceWith(data.login);
				});
	
			});
			$(".ca_create_user").click(function() {
				var people_id=$(this).attr("data-peopleid");
				var data = {
				"action": "church_admin",
				"method": "create_user",
				"people_id": $(this).attr("data-peopleid"),
				"nonce": "'.wp_create_nonce("create_user").'",
				dataType:"json"
				};
				console.log(data);
				// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
				jQuery.post(ajaxurl, data, function(response)
				{
					var data=JSON.parse(response);
					console.log("body .userinfo"+data.people_id + " "+data.login)
					$(".userinfo"+data.people_id).replaceWith(data.login);
				});
			});
        });
    </script>';
}

function church_admin_merge_people( $person1_id,$person2_id)
{
	global $wpdb;
	$data1=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$person1_id.'"');
	if ( empty( $data1) )return esc_html( __( 'No data for first person','church-admin') );
	$data2=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$person2_id.'"');
	if ( empty( $data2) )return esc_html( __( 'No data for second person','church-admin') );
	$user=wp_get_current_user();
	$member_type=church_admin_member_type_array();
	$people_type=get_option('church_admin_people_type');
	$marital_status=get_option('church_admin_marital_status');
	$personFields=array(
						'attachment_id'=>array('type'=>'attachment_id','display'=>esc_html( __( "Photo",'church-admin') ) ),	
						'first_name'=>array('type'=>'text','display'=>esc_html( __( "First name",'church-admin') ) ),
						'middle_name'=>array('type'=>'text','display'=>esc_html( __( "Middle name",'church-admin') )),
						'last_name'=>array('type'=>'text','display'=>esc_html( __( "Last name",'church-admin') )),
						'head_of_household'=>array('type'=>'boolean','display'=>esc_html( __( "Head of household ",'church-admin') )),
						'date_of_birth'=>array('type'=>'date','display'=>esc_html( __( "Date of birth",'church-admin') ) ),
						'member_type_id'=>array('type'=>'member_type','display'=>esc_html( __( 'Member type') ) ),
						'people_type_id'=>array('type'=>'people_type','display'=>esc_html( __( 'Person type') ) ),
						'sex'=>array('type'=>'sex','display'=>esc_html( __( 'Gender','church-admin') ) ),
						'mobile'=>array('type'=>'text','display'=>esc_html( __( "Cellphone",'church-admin') ) ),
						'email'=>array('type'=>'text','display'=>esc_html( __( 'Email','church-admin') ) ),
						'marital_status'=>array('type'=>'marital_status','display'=>esc_html( __( 'Marital status','church-admin') ) ),
						'active'=>array('type'=>'boolean','display'=>esc_html( __( 'Active','church-admin') ) ),
						'site_id'=>array('type'=>'site','display'=>esc_html( __( 'Site','church-admin') ) ),
						'email_send'=>array('type'=>'boolean','display'=>esc_html( __( 'Email send?','church-admin') ) ),
						'news_send'=>array('type'=>'boolean','display'=>esc_html( __( 'Blog posts emails send?','church-admin') ) ),
						'sms_send'=>array('type'=>'boolean','display'=>esc_html( __( 'SMS send','church-admin') ) ),
						'mail_send'=>array('type'=>'boolean','display'=>esc_html( __( 'Mail send','church-admin') ) ),
						'gdpr_reason'=>array('type'=>'boolean','display'=>esc_html( __( 'GDPR reason','church-admin') ) ),
						'rota_email'=>array('type'=>'boolean','display'=>esc_html( __( 'Send schedule emails','church-admin') ) ),
						'photo_permission'=>array('type'=>'boolean','display'=>esc_html( __( 'Photo permission?','church-admin') ) ),
						'phone_calls'=>array('type'=>'boolean','display'=>esc_html( __( 'Phone calls?','church-admin') ) ),
						'gift_aid'=>array('type'=>'boolean','display'=>esc_html( __( 'UK gift Aid','church-admin') ) ),
						'show_me'=>array('type'=>'boolean','display'=>esc_html( __( 'Show in directory','church-admin') ) )
						
					);
	
	if ( empty( $_POST['merge-people-submitted'] ) )
	{
		$data1=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$person1_id.'"');
		if ( empty( $data1) )return esc_html( __( 'No data for first person','church-admin') );
		$data2=$wpdb->get_row('SELECT * FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$person2_id.'"');
		if ( empty( $data2) )return esc_html( __( 'No data for second person','church-admin') );

		//form
		echo'<h2>'.esc_html( __( "Merge two people's records",'church-admin') ).'</h2>'."\r\n";
		
		echo'<p>'.esc_html( __( 'The second person will be deleted, so for each row choose which column to keep, or click cancel','church-admin') ).'</p>'."\r\n";
		echo'<form action="" method="POST">'."\r\n";
		$theader='<tr><th>'.esc_html( __( 'Field','church-admin') ).'</th><th>'.esc_html( __( 'First person','church-admin') ).' - '. esc_html( church_admin_formatted_name( $data1 ) ).'</th><th>'.esc_html( __( 'Second person','church-admin') ).' - '. esc_html( church_admin_formatted_name( $data2 ) ).'</th></tr>'."\r\n";
		echo'<table class="form-table bordered striped">'."\r\n";
		echo'<thead>'.$theader.'</thead>'."\r\n";
		echo'<tbody>'."\r\n";
		foreach( $personFields AS $fieldName=>$fieldData)
		{
			
			switch( $fieldData['type'] )
			{
				case 'attachment_id':
					if(!empty( $data1->attachment_id) )
					{
						$first= esc_url( wp_get_attachment_image( $data1->attachment_id,'medium',NULL ) );
					}else
					{
						if(isset( $data1->sex) &&$data1->sex==1)  {$image='man.svg';}else{$image='woman.svg';}
                		$first='<img  src="'.esc_url( plugins_url( '/', dirname(__FILE__) ) . 'images/'.$image ) .'" width="300" height="200" class="rounded" />';
					}
					if(!empty( $data2->attachment_id) )
					{
						$second= esc_url( wp_get_attachment_image( $data2->attachment_id,'medium',NULL ) );
					}else
					{
						if(isset( $data2->sex) &&$data2->sex==1)  {$image='man.svg';}else{$image='woman.svg';}
                		$second='<img   src="'.plugins_url('/', dirname(__FILE__) ) . 'images/'.$image.'" width="300" height="200" class="rounded" />';
					}
				break;
				case 'text':
					$first=esc_html( $data1->$fieldName);
					$second=esc_html( $data2->$fieldName);
				break;
				case 'boolean':
					if(!empty( $data1->$fieldName) )  {$first=esc_html( __( "Yes",'church-admin') );}else{$first=esc_html( __( "No",'church-admin') );}
					if(!empty( $data2->$fieldName) )  {$second=esc_html( __( "Yes",'church-admin') );}else{$second=esc_html( __( "No",'church-admin') );}
				break;
				case 'sex':
					if(!empty( $data1->$fieldName) )  {$first=esc_html( __( "Male",'church-admin') );}else{$first=esc_html( __( "Female",'church-admin') );}
					if(!empty( $data2->$fieldName) )  {$second=esc_html( __( "Male",'church-admin') );}else{$second=esc_html( __( "Female",'church-admin') );}
				break;
				case 'marital_status':
					if(!empty( $data1->$fieldName)&&$data1->$fieldName=='N/A')$data1->$fieldName=0;
					if(!empty( $data2->$fieldName)&&$data2->$fieldName=='N/A')$data2->$fieldName=0;
					$first=esc_html( $marital_status[$data1->$fieldName] );
					$second=esc_html( $marital_status[$data2->$fieldName] );
				break;
				case 'site':
					if( $data1->$fieldName!=0)  {$first=$wpdb->get_var('SELECT venue FROM '.CA_SIT_TBL.' WHERE site_id="'.esc_sql( $data1->$fieldName).'"');}else{$first='';}
					if( $data2->$fieldName!=0)  {$second=$wpdb->get_var('SELECT venue FROM '.CA_SIT_TBL.' WHERE site_id="'.esc_sql( $data2->$fieldName).'"');}else{$secnd='';}
				break;
				case 'member_type':
					$first=esc_html( $member_type[$data1->$fieldName] );
					$second=esc_html( $member_type[$data2->$fieldName] );
				break;
				case 'people_type':
					$first=esc_html( $people_type[$data1->$fieldName] );
					$second=esc_html( $people_type[$data2->$fieldName] );
				break;
				case 'date':
					if(!empty( $data1->$fieldName)&& $data1->$fieldName!="0000-00-00")$first=mysql2date(get_option('date_format'),$data1->$fieldName);
					if(!empty( $data2->$fieldName)&& $data2->$fieldName!="0000-00-00")$second=mysql2date(get_option('date_format'),$data2->$fieldName);
				break;
			}
			echo'<tr><th scope="row">'.esc_html( $fieldData['display'] ).'</th>';
			echo'<td><input type="radio" name="'.esc_html( $fieldName).'" checked="checked" value="'.esc_html( $data1->$fieldName).'"/>'.$first.'</td>';
			echo'<td><input type="radio" name="'.esc_html( $fieldName).'" value="'.esc_html( $data2->$fieldName).'"/>'.$second.'</td>';
			echo'</tr>'."\r\n";
		}
			//household - other people
			echo'<tr><th scope="row">'._('Other people in household').'</th>';
			$first=$second=array();
			$firstHousehold=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$data1->household_id.'" AND people_id!="'.(int)$data1->people_id.'"');
			if(!empty( $firstHousehold) )
			{
				foreach( $firstHousehold AS $fh)$first[]=church_admin_formatted_name( $fh);
			}
			$secondHousehold=$wpdb->get_results('SELECT * FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$data2->household_id.'" AND people_id!="'.(int)$data2->people_id.'"');
			if(!empty( $secondHousehold) )
			{
				foreach( $secondHousehold AS $sh)$second[]=church_admin_formatted_name( $sh);
			}
			echo'<td><input type="radio" name="household_id" value="'.(int)$data1->household_id.'"/>'.implode(", ",$first).'</td>';
			echo'<td><input type="radio" name="household_id" value="'.(int)$data2->household_id.'"/>'.implode(", ",$second).'</td>';
			echo'</tr>'."\r\n";
			/**************************
			 * Other household data
			 * ************************/

			$household1=$wpdb->get_row('SELECT * FROM '.CA_HOU_TBL.' WHERE household_id="'.(int)$data1->household_id.'"');
			$household2=$wpdb->get_row('SELECT * FROM '.CA_HOU_TBL.' WHERE household_id="'.(int)$data2->household_id.'"');
			//Houehold Photo
			//Address
			echo'<tr><th scope="row">'.esc_html( __( 'Address','church-admin') ).'</th>';
			echo'<td><input type="radio" name="address" checked="checked" value="'.esc_html( $household1->address).'"/>'.esc_html( $household1->address).'</td>';
			echo'<td><input type="radio" name="address" value="'.esc_html( $household2->address).'"/>'.esc_html( $household2->address).'</td>';
			echo'</tr>'."\r\n";
			//Phone
			echo'<tr><th scope="row">'.esc_html( __( 'Phone','church-admin') ).'</th>';
			echo'<td><input type="radio" name="phone" checked="checked" value="'.esc_html( $household1->phone).'"/>'.esc_html( $household1->phone).'</td>';
			echo'<td><input type="radio" name="phone" value="'.esc_html( $household2->phone).'"/>'.esc_html( $household2->phone).'</td>';
			echo'</tr>'."\r\n";

		echo'<tfoot>'.$theader.'</tfoot>'."\r\n";
		echo'</tbody></table>';
		echo'<p><input type="hidden" name="merge-people-submitted" value="'.wp_create_nonce("merge-people-submitted").'"/><input type="submit" value="'.esc_html( __( 'Merge','church-admin') ) .'" class="button-primary"/>&nbsp;<a href="admin.php?page=church_admin/index.php" class="button-secondary">'.esc_html( __( 'Cancel','church-admin') ).'</a></p></form>'."\r\n";


	}
	else
	{
		church_admin_debug(print_r( $_POST,TRUE) );
		//delete USER for person2_id
		$user_id2=$wpdb->get_var('SELECT user_id FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$person2_id.'"');
		if(!empty( $user_id)&&$user_id!=$user->ID)
		{
			require_once(ABSPATH.'wp-admin/includes/user.php' );
			wp_delete_user( $user_id );
		}
		//delete CA_HOU_TBL record for person2_id if only one person in household
		$numberOfPeople=$wpdb->get_var('SELECT COUNT(*) FROM '.CA_PEO_TBL.' WHERE household_id="'.(int)$data2->household_id.'"');
		if( $numberOfPeople==1)$wpdb->query('DELETE FROM '.CA_HOU_TBL.' WHERE household_id="'.(int)$data2->household_id.'"');
		//delete CA_PEO_TBL record for person2_id
		$wpdb->query('DELETE FROM '.CA_PEO_TBL.' WHERE people_id="'.(int)$person2_id.'"');
		//delete CA_MET_TBL records for person2_id
		$wpdb->query('DELETE FROM '.CA_MET_TBL.' WHERE people_id="'.(int)$person2_id.'"');
		$fieldQuery=array();
		
		
		foreach( $personFields AS $key=>$data)
		{
				if(isset( $_POST[$key] ) )
				{
					$fieldQuery[$key]=' '.esc_sql( $key).'="'.esc_sql( $_POST[$key] ).'"';
				}
				else $fieldQuery[$key]=' '.esc_sql( $key).'=""';
				
		}
		if(defined('CA_DEBUG') )church_admin_debug(print_r( $fieldQuery,TRUE) );
		$wpdb->query('UPDATE '.CA_PEO_TBL.' SET '.implode(",",$fieldQuery).' WHERE people_id="'.(int)$person1_id.'"');
		if(defined('CA_DEBUG') )church_admin_debug( $wpdb->last_query);
		$wpdb->query('UPDATE '.CA_HOU_TBL.' SET address="'.esc_sql(stripslashes( $_POST['address'] ) ).'",phone="'.esc_sql(stripslashes( $_POST['address'] ) ).'" WHERE household_id="'.(int)$data1->household_id.'"');

		echo '<div class="notice notice-success"><h2>'.esc_html( __( 'People records merged','church-admin') ).'</h2></div>';

	}

}