<?php
if ( ! defined( 'ABSPATH' ) ) exit('You need Jesus!'); // Exit if accessed directly

/**
 *
 * Custom fields
 *
 * @param
 *
 *
 * @author andy_moyle
 *
 */
function church_admin_list_custom_fields()
{

	global $wpdb;
	$wpdb->show_errors;
    $out='<h2>'.__('Custom fields','church-admin').'</h2>';
	
	$out.='<p><a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit-custom-field&amp;section=people','edit-custom-field').'">'.__('Add a custom field','church-admin').'</a></p>';
	$custom_fields=$wpdb->get_results('SELECT * FROM '.CA_CUST_TBL.' ORDER BY type,name');
	if(!empty( $custom_fields) )
	{

		$thead='<tr><th>'.__('Edit','church-admin').'</th><th>'.__('Delete','church-admin').'</th><th>'.__('Custom field name','church-admin').'</th><th>'.__('Section','church-admin').'</th><th>'.__('Custom field type','church-admin').'</th><th>'.__('Default','church-admin').'</th></tr>';
		$out.='<table class="widefat striped"><thead>'.$thead.'</thead><tbody>';
		foreach( $custom_fields AS $custom_field)
		{
			if(!empty( $custom_field->default_value) )  {$default=$custom_field->default_value;}else{$default="";}
			$edit='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=edit-custom-field&amp;section=people&amp;id='.(int)$custom_field->ID,'edit-custom-field').'">'.__('Edit','church-admin').'</a>';
			$delete='<a href="'.wp_nonce_url('admin.php?page=church_admin/index.php&amp;action=delete-custom-field&amp;section=people&amp;id='.(int)$custom_field->ID,'delete-custom-field').'">'.__('Delete','church-admin').'</a>';
			$out.='<tr><td>'.$edit.'</td><td>'.$delete.'</td><td>'.esc_html( $custom_field->name).'</td><td>'.esc_html( $custom_field->section).'</td><td>'.esc_html( $custom_field->type).'</td><td>'.esc_html( $default).'</td></tr>';
		}
		$out.='</tbody><tfoot>'.$thead.'</tfoot></table>';
	}
	return $out;
}


/**
 * Edit Custom Field
 *
 * @param
 * @param
 *
 * @author andy_moyle
 *
 */
 function church_admin_edit_custom_field( $ID)
 {
	 global $wpdb;
	 $wpdb->show_errors;
	$data= new stdClass();
	if(!empty( $ID) )$data=$wpdb->get_row('SELECT * FROM '.CA_CUST_TBL.' WHERE ID="'.(int)$ID.'"');
 	$out='';

 	if(!empty( $_POST['save_custom_field'] ) )
 	{
		
	
		$sqlsafe=array();
		foreach( $_POST AS $key=>$value)$sqlsafe[$key]=esc_sql(stripslashes( $value) );
		if ( empty( $sqlsafe['custom-field-default'] ) )$sqlsafe['custom-field-default']="";
		if(!empty( $_POST['show-me'] ) )  {$show_me=1;}else{$show_me=0;}
 		if ( empty( $ID) )$ID=$wpdb->get_var('SELECT ID FROM '.CA_CUST_TBL.' WHERE name="'.$sqlsafe['custom-field-name'].'" AND type="'.$sqlsafe['custom-field-type'].'" AND section="'.$sqlsafe['custom-field-section'].'" AND default_value="'.$sqlsafe['custom-field-default'].'" AND show_me="'.$show_me.'"');
		if ( empty( $ID) )
		{
			//insert
			$wpdb->query('INSERT INTO '.CA_CUST_TBL.' (name,type,section,default_value,show_me) VALUES("'.$sqlsafe['custom-field-name'].'" ,"'.$sqlsafe['custom-field-type'].'","'.$sqlsafe['custom-field-section'].'","'.$sqlsafe['custom-field-default'].'","'.$show_me.'")');
		}
		else
		{
			//update
			$wpdb->query('UPDATE '.CA_CUST_TBL.' SET name="'.$sqlsafe['custom-field-name'].'" , type="'.$sqlsafe['custom-field-type'].'" , section="'.$sqlsafe['custom-field-section'].'" , default_value="'.$sqlsafe['custom-field-default'].'", show_me="'.$show_me.'" WHERE ID = "'.(int)$ID.'"');
		}
		
		if(!empty( $_POST['custom-all'] ) )
		{
			if ( empty( $_POST['custom-field-default'] ) )  {$default="";}else{$default=esc_sql(stripslashes( $_POST['custom-field-default'] ) );}
			$people=$wpdb->get_results('SELECT people_id FROM '.CA_PEO_TBL);
			if(!empty( $people) )
			{
					foreach( $people AS $peep)
					{
							$check=$wpdb->get_var('SELECT ID FROM '.CA_CUST_MET_TBL.' WHERE people_id="'.(int)$peep->people_id.'" AND custom_id="'.(int)$ID.'" ');
							$sql='INSERT INTO '.CA_CUST_MET_TBL.' (people_id,custom_id,data) VALUES("'.(int)$peep->people_id.'","'.(int)$ID.'","'.$default.'")';

							if ( empty( $check) )$wpdb->query( $sql);
					}
			}
		}
 		$out.='<div class="notice notice-success"><h2>'.__('Custom field saved','church-admin').'</h2></div>';
 		$out.=church_admin_list_custom_fields();
  	}
 	else
 	{
 		$out='<h2>'.__('Edit custom field','church-admin').'</h2>';
 		$out.='<form action="" method="POST">';
 		$out.='<table class="form-table">';
 		$out.='<tr><th scope="row">'.__('Custom field name','church-admin').'</th><td><input type="text" name="custom-field-name" ';
 		if(!empty( $data->name) )$out.=' value="'.esc_html( $data->name).'" ';
 		$out.='/>';

		//TYPE
		if ( empty( $data->section) )$data->section='';
		if ( empty( $data->default_value) )$data->default_value='';
 		if ( empty( $data->type) )$data->type='';
 		$out.='<tr><th scope="row">'.__('Custom field type','church-admin').'</th><td><select name="custom-field-type" class="custom-type"><option value="boolean" '.selected('boolean',$data->type,FALSE).'>'.__('Yes/No','church-admin').'</option><option value="date" '.selected('date',$data->type,FALSE).'>'.__('Date','church-admin').'</option><option value="text" '.selected('text',$data->type,FALSE).'>'.__('Text field','church-admin').'</option></select></td></tr>';
		//SECTION
		if(!empty( $data) )$out.='<tr><th scope="row" colspan=2>'.__('Changing from Household to People will require editing people entries for which person in a household the data applies to.','church-admin').'</th></tr>';
		$out.='<tr><th scope="row">'.__('Custom field section','church-admin').'</th><td><select name="custom-field-section" class="custom-section"><option value="people" '.selected('people',$data->section,FALSE).'>'.__('People','church-admin').'</option><option value="household" '.selected('household',$data->section,FALSE).'>'.__('Household','church-admin').'</option><option value="giving" '.selected('giving',$data->section,FALSE).'>'.__('Giving','church-admin').'</option></select></td></tr>';
		if(!empty( $data->type) )
		{
			switch( $data->type)
			{
				case 'text':
					$text='style="display:table-row"';
					$boolean='style="display:none"';
					$booleanField=' disabled="disabled"';
					$textField='';
				break;
				case 'boolean':
					$text='style="display:none"';
					$textField=' disabled="disabled"';
					$boolean='style="display:table-row"';
					$booleanField=' disabled="disabled"';
				break;
				
				default:
					$text='style="display:none"';
				
					$boolean='style="display:none"';
					$textField=$booleanField=' disabled="disabled"';
				break;
			}
			
			$out.='<tr class="boolean" '.$boolean.'><th scope="row">'.__('Default','church-admin').'</th>';
			$out.='<td><select name="custom-field-default" '.$booleanField.' class="boolean-default"><option value="1" ';
			if(!empty( $data->default_value) )$out.=' selected="selected" ';
			$out.='>'.__('Yes','church-admin').'</option><option value="0" ';
			if(isset( $data->default_value)&& $data->default_value=="0")$out.=' selected="selected" ';
			$out.='>'.__('No','church-admin').'</option></select></td></tr>';

			$out.='<tr class="text"'.$text.'><th scope="row">'.__('Default','church-admin').'</th>';
			$out.='<td ><input type="text" class="text-default" '.$textField.' name="custom-field-default" ';
			if(!empty( $data->default_value) )$out.=' value="'.esc_html( $data->default_value).'" ';
			$out.='/></td></tr>';
			
		}
		else {
			$out.='<tr class="boolean" style="display:table-row"><th scope="row">'.__('Default','church-admin').'</th><td><select  class="boolean-default" name="custom-field-default"><option value="1" ';
			if(!empty( $data->default_value) )$out.=' selected="selected" ';
			$out.='>'.__('Yes','church-admin').'</option><option value="0" ';
			if(isset( $data->default_value)&& $data->default_value=="0")$out.=' selected="selected" ';
			$out.='>'.__('No','church-admin').'</option></select></td></tr>';

			$out.='<tr class="text"  style="display:none"><th scope="row">'.__('Default','church-admin').'</th><td><input disabled="disabled" type="text" class="text-default" name="custom-field-default" ';
			if(!empty( $data->default_value) )$out.=' value="'.esc_html( $data->default_value).'" ';
			$out.='/></td></tr>';
			
		}
		$out.='<tr class="all"><th scope="row">'.__('Apply to everyone','church-admin').'</th>';
			$out.='<td><input type="checkbox" name="custom-all" ';
			if(!empty( $data->all) ) $out.=' checked="checked" ';
			$out.='/></td></tr>';
		$out.='<tr class="show_me"><th scope="row">'.__('Show on address list etc','church-admin').'</th>';
		$out.='<td><input type="checkbox" name="show-me" ';
		if(!empty( $data->show_me) ) $out.=' checked="checked" ';
		$out.='/></td></tr>';
		$out.='<script>
				jQuery(document).ready(function( $)  {
					$(".custom-type").change(function()  {
							var val=$(this).val();
							console.log("type changed to " +val);
							switch(val)
							{
								case "boolean":
									$(".boolean").show();
									$(".text").hide();
									$(".text-boolean").prop("disabled", true);
									$(".text-boolean").prop("disabled", false);
								break;
								case "text":
									$(".boolean").hide();
									$(".text").show();
									$(".text-default").prop("disabled", false);
									$("..boolean-default").prop("disabled", true);
									break;
								case "date":
									$(".boolean").hide();
									$(".text").hide();
									$(".all").hide();
									$(".text-default").prop("disabled", true);
									$(".boolean-default").prop("disabled", true);
								break;
							}
						});
					$(".custom-section").change(function()  {
							console.log("Change of section");
							var val=$(".custom-section option:selected").val();
							switch(val)
							{
								case "giving":
									$(".all").hide();
									$(".show_me").hide();
								break;
								default:
									$(".all").show();
									$(".show_me").show();
								break;
							}
					});
				
				
			});
		</script>';
 		$out.='<tr><td>&nbsp;</td><td><input type="hidden" name="save_custom_field" value="yes"/><input type="submit" class="button-primary" value="'.__('Save','church-admin').'"/></td></tr></table></form>';
 	}
 	return $out;


}
/**
 * Delete Custom Field
 *
 * @param
 * @param
 *
 * @author andy_moyle
 *
 */
 function church_admin_delete_custom_field( $ID)
 {
	 global $wpdb;
	$wpdb->query('DELETE FROM '.CA_CUST_MET_TBL.' WHERE custom_id="'.(int)$ID.'"');
	$wpdb->query('DELETE FROM '.CA_CUST_TBL.' WHERE ID="'.(int)$ID.'"');
	$out='<div class="notice notice-success"><h2>'.__('Custom field deleted','church-admin').'</h2></div>';


 	$out.=church_admin_list_custom_fields();
 	return $out;
 }
