<?php
if ( ! defined( 'ABSPATH' ) ) exit('You need Jesus!'); // Exit if accessed directly
function church_admin_calendar_list( $days=28,$category=NULL,$fac_ids=NULL)
{

	global $wpdb,$wp_locale;
	$out='';
	$categories=church_admin_calendar_categories_array();
	//process categories
	$catsql=array();
  	if ( empty( $category) )  {$cat_sql="";}
  	else
  	{
  		
  		$cats=explode(',',$category);
      	foreach( $cats AS $key=>$value)  {if(ctype_digit( $value) )  $catsql[]='a.cat_id='.(int)$value;}
      	if(!empty( $catsql) ) {$cat_sql=' AND ('.implode(' || ',$catsql).')';}
	}
	//process facilities
	$facsql=array();
	$fac_sql='';
	if ( empty( $fac_ids) )  {$fac_sql="";}
	else
	{
		$facs=explode(",",$fac_ids);
		foreach( $facs AS $key=>$value)  {if(ctype_digit( $value) )  $facsql[]='a.facilities_id='.(int)$value;}
      	if(!empty( $facsql) ) {$fac_sql='  ('.implode(' || ',$facsql).') AND ';}
	}

	//work out dates
	if(!empty( $_POST['date'] )&&church_admin_checkdate( $_POST['date'] ) )  {$date=new ChurchAdminDateTime( $_POST['date'] );}else{$date=new ChurchAdminDateTime();}
	
	$sqlstart=$date->format('Y-m-d');
	$nowDisplayDate=$date->format(get_option('date_format') );
	$end=$date->returnAdd(new DateInterval('P'.$days.'D') );
	$nextDisplay=$sqlend=$end->format('Y-m-d');
	$next=$sqlend;
	$prevDate=$date->returnSub(new DateInterval('P'.$days.'D') );
	$prevDisplay=$prevDate->format('Y-m-d');
	
	$sql='SELECT a.*, b.* FROM '.CA_DATE_TBL.' a LEFT JOIN '.CA_CAT_TBL.' b ON a.cat_id=b.cat_id  WHERE '.$fac_sql.' a.start_date BETWEEN CAST("'.esc_sql($sqlstart).'" AS DATE) AND CAST("'.$sqlend.'" AS DATE) '.$cat_sql.' ORDER BY a.start_date,a.start_time';
	church_admin_debug( $sql);
	$results=$wpdb->get_results( $sql);
	
	$data=array();
	if(!empty( $results) )
	{
		//build $data for outputing
		foreach( $results AS $row)
		{
			if( $row->start_time=='00:00:00' && $row->end_time=='23:59:00')
    		{//all day
				$data[]=array(
								'date'=>esc_html(mysql2date(get_option('date_format'),$row->start_date)),
								'time'=>__('All Day','church-admin'),
								'title'=>sanitize_text_field( $row->title ),
								'description'=>sanitize_text_field( $row->description) ,
                                'link'=>$row->link,
                                'link_title'=>$row->link_title,
								'location'=>$row->location
							);
			}
			{//timed
				$data[]=array(
								'date'=>mysql2date(get_option('date_format'),$row->start_date),
								'time'=>mysql2date(get_option('time_format'),$row->start_time)." - ".mysql2date(get_option('time_format'),$row->end_time),
								'title'=>esc_html(stripslashes( $row->title) ),
								'description'=>esc_html(stripslashes( $row->description) ),
                                'link'=>$row->link,
                                'link_title'=>$row->link_title,
								'location'=>$row->location
							);
			}
		}
	}//got results
	if(!is_admin() )
	{//Chooser
		$out.='<table class="ca-calendar-list-chooser widefat striped bordered"><tr><td class="ca-calendar-list-prev">';
		$out.='<form action="'.get_permalink().'"  method="post"><input type="hidden" name="date" value="'.$prevDisplay.'"/><input class="calendar-date-switcher" type="submit" value="'.__('Previous','church-admin').'" /></form></td>';
		if ( empty( $fac_ids ) && empty( $category ) )
		{
			$title=sprintf(__( 'Events for the next %1$s days from %2$s','church-admin'),(int)$days,$nowDisplayDate);
		}
		elseif(!empty($category)){
			$categoryOP=array();
			$categoryArray=explode(",",$category);
			foreach($categoryArray AS $key=>$id){
				if(!empty($categories[$id])){$categoryOP[]=$categories[$id];}
			}
			$title= sprintf(__( '%2$s Events for the next %1$s days ','church-admin'),(int)$days,implode(", ",$categoryOP));
		}
		elseif(!empty( $fac_ids) )
		{
			if(!empty( $facs['0'] ) )  $facility=$wpdb->get_var('SELECT facility_name FROM '.CA_FAC_TBL.' WHERE facilities_id="'.(int)$facs[0].'"');
			if ( empty( $facility) )$facility=__('N/A','church-admin');
			$title=sprintf(__( 'Bookings for %1$s the next %2$s days from %3$s','church-admin'),$facility,(int)$days,$nowDisplayDate);
		}
		$out.='<td class="ca-calendar-list-chooser">'.esc_html( $title ).'</td>';
		$out.='<td class="ca-calendar-list-next"><form action="'.esc_url( get_permalink() ).'"  method="post"><input type="hidden" name="date" value="'.esc_attr($nextDisplay).'"/><input class="calendar-date-switcher" type="submit" value="'.__('Next','church-admin').'" /></form></td>';
		$out.='</tr></table>';
	}
	//build output
	if ( empty( $data) )
	{	
		$out.='<p>'.__('No events to display','church-admin').'</p>';
	}
	else
	{
		$out.='<table class="ca-calendar-list  widefat striped bordered"><thead><tr><th class="ca-list-date">'.__('Date','church-admin').'</th><th class="ca-list-time">'.__('Time','church-admin').'</th><th class="ca-list-event">'.__('Event','church-admin').'</th></tr></thead></tbody>';
		foreach( $data AS $key=>$event)
		{
			$out.=	'<tr>
						<td class="ca-list-date">'.esc_html($event['date']).'</td>
						<td class="ca-list-time">'.esc_html($event['time']).'</td>
						<td class="ca-list-event"><strong>'.esc_html($event['title']).'</strong>';
			if(!empty($row->description)){
				 $out.='<br />'.$event['description'];
			}
			if(!empty( $event['location'] ) )$out.='<br />'.sprintf(__('Location: %1$s','church-admin'),esc_html( $event['location'] ) );
            if(!empty( $event['link'] ) )
            {
                if(!empty( $event['link_title'] ) )  {$title=esc_html( $event['link_title'] );}else{$title=__('More information...','church-admin');}
                $out.='<br/><a href="'.esc_url( $event['link'] ).'">'.$title.'</a>';
            }
			$out.= '<br/><a class="vcf-link" href="'.site_url().'?ca_download=ical&date_id='.(int)$row->date_id.'"><span class="dashicons dashicons-download"></span></a>';
            $out.='</td></tr>';
		}
		$out.='</tbody></table>';
	}
	
	
	
	return $out;
}
	
?>